/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.sfc.mservice.upgrade.utils;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.UnitConvertHelper;
import kd.bos.thread.ThreadLifeCycleManager;
import kd.bos.threads.ThreadPools;
import kd.mmc.sfc.common.utils.UnitRateConvertUtil;

public class BaseQytUtils {
    public static BigDecimal getBaseQty(Map<String, Object> object, BigDecimal qty) {
        BigDecimal bigDecimal;
        if (object == null || qty == null || BigDecimal.ZERO.compareTo(qty) == 0) {
            return BigDecimal.ZERO;
        }
        BigDecimal operationQty = (BigDecimal)object.get("foperationqty");
        BigDecimal headQty = ((BigDecimal)object.get("fheadqty")).multiply(qty);
        try {
            bigDecimal = UnitConvertHelper.calculateNewQty((BigDecimal)headQty, (Long)((Long)object.get("fbaseunit")), (Long)((Long)object.get("fheadunitid")), (Long)((Long)object.get("fmaterialid")), (StringBuilder)new StringBuilder());
        }
        catch (Throwable throwable) {
            return BigDecimal.ZERO;
        }
        DynamicObject baseUnitObj = BusinessDataServiceHelper.loadSingleFromCache((Object)object.get("fbaseunit"), (String)"bd_measureunits");
        if (baseUnitObj == null || bigDecimal == null) {
            return BigDecimal.ZERO;
        }
        return bigDecimal.divide(operationQty, baseUnitObj.getInt("precision"), UnitRateConvertUtil.getUnitPrecisionAccount((String)baseUnitObj.getString("precisionaccount")));
    }

    public static BigDecimal getOprQty(Map<String, Object> oprEntry, BigDecimal baseQty) {
        BigDecimal bigDecimal;
        if (oprEntry == null || baseQty == null || BigDecimal.ZERO.compareTo(baseQty) == 0) {
            return BigDecimal.ZERO;
        }
        try {
            bigDecimal = UnitConvertHelper.calculateNewQty((BigDecimal)baseQty, (Long)((Long)oprEntry.get("fheadunitid")), (Long)((Long)oprEntry.get("fbaseunit")), (Long)((Long)oprEntry.get("fmaterialid")), (StringBuilder)new StringBuilder());
        }
        catch (Throwable throwable) {
            return BigDecimal.ZERO;
        }
        BigDecimal operationQty = (BigDecimal)oprEntry.get("foperationqty");
        operationQty = bigDecimal.multiply(operationQty);
        BigDecimal headQty = (BigDecimal)oprEntry.get("fheadqty");
        DynamicObject oprUnitObj = BusinessDataServiceHelper.loadSingleFromCache((Object)oprEntry.get("foprunitid"), (String)"bd_measureunits");
        if (oprUnitObj == null || bigDecimal == null) {
            return BigDecimal.ZERO;
        }
        return operationQty.divide(headQty, oprUnitObj.getInt("precision"), UnitRateConvertUtil.getUnitPrecisionAccount((String)oprUnitObj.getString("precisionaccount")));
    }

    public static void batchUpdate(DBRoute scmRoute, List<Object[]> objects, String updateInvTypeSql) {
        ThreadPools.executeOnceIncludeRequestContext((String)"UpgradeServiceImpl", (Runnable)ThreadLifeCycleManager.wrapRunnable(() -> DB.executeBatch((DBRoute)scmRoute, (String)updateInvTypeSql, (List)objects)));
    }
}

