/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.opvalidate.validator;

import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.mpscmm.msbd.business.helper.OperatorGroupHelper;
import kd.mpscmm.msbd.business.helper.OrgHelper;
import kd.mpscmm.msbd.business.helper.SysParamHelper;
import kd.mpscmm.msbd.common.enums.OperatorGrpTypeEnum;
import kd.mpscmm.msbd.common.utils.CommonUtils;
import kd.mpscmm.msbd.common.utils.MethodParameterUtil;

public class BillCoreInfoValidator
extends AbstractValidator {
    public static String PARA_ORGFUNCTION = "orgfunction";
    public static String PARA_ISCHECKDEPT = "ischeckdept";
    private static final Log LOG = LogFactory.getLog(BillCoreInfoValidator.class);

    public Set<String> preparePropertys() {
        HashSet<String> preparePropertys = super.preparePropertys();
        if (CommonUtils.isNull((Object)preparePropertys)) {
            preparePropertys = new HashSet<String>();
        }
        preparePropertys.add("billno");
        preparePropertys.add("org");
        preparePropertys.add("dept");
        preparePropertys.add("operatorgroup");
        preparePropertys.add("operator");
        return preparePropertys;
    }

    public void validate() {
        if (this.getDataEntities() == null || this.getDataEntities().length == 0) {
            return;
        }
        String customparameter = (String)this.getValidation().get("customparameter");
        for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
            Long operatorOperatorGroup;
            Long operatorgroupId;
            DynamicObject bill = dataEntity.getDataEntity();
            DynamicObject org = bill.getDynamicObject("org");
            if (org == null) continue;
            DynamicObject dept = bill.getDynamicObject("dept");
            DynamicObject operatorgroup = bill.getDynamicObject("operatorgroup");
            DynamicObject operator = bill.getDynamicObject("operator");
            if (operator != null) {
                operator = BusinessDataServiceHelper.loadSingleFromCache((Object)operator.getPkValue(), (String)"bd_operator");
            }
            DynamicObject operatorUser = operator == null ? null : operator.getDynamicObject("operatorid");
            String entityName = bill.getDataEntityType().getName();
            DynamicObject entityobj = BusinessDataServiceHelper.loadSingleFromCache((Object)entityName, (String)"bos_entityobject");
            DynamicObject bizapp = entityobj.getDynamicObject("bizappid");
            String operatorGrpType = OperatorGrpTypeEnum.PURCHASEGRP.getValue();
            String orgViewType = "15";
            long userId = UserServiceHelper.getCurrentUserId();
            Long orgId = (Long)org.getPkValue();
            String orgNumber = org.getString("number");
            Long deptId = dept == null ? null : (Long)dept.getPkValue();
            Long operatorUserId = operatorUser == null ? null : (Long)operatorUser.getPkValue();
            Long l = operatorgroupId = operatorgroup == null ? null : (Long)operatorgroup.getPkValue();
            if ("pur".equalsIgnoreCase(MethodParameterUtil.getValue((Object)customparameter, (String)PARA_ORGFUNCTION))) {
                operatorGrpType = OperatorGrpTypeEnum.PURCHASEGRP.getValue();
                orgViewType = "02";
            } else if ("sal".equalsIgnoreCase(MethodParameterUtil.getValue((Object)customparameter, (String)PARA_ORGFUNCTION))) {
                operatorGrpType = OperatorGrpTypeEnum.SALEGRP.getValue();
                orgViewType = "03";
            } else if ((org = BusinessDataServiceHelper.loadSingleFromCache((Object)org.getPkValue(), (String)"bos_org", (String)"id,fispurchase,fissale")) != null && org.getBoolean("fispurchase")) {
                operatorGrpType = OperatorGrpTypeEnum.PURCHASEGRP.getValue();
                orgViewType = "02";
            } else if (org != null && org.getBoolean("fissale")) {
                operatorGrpType = OperatorGrpTypeEnum.SALEGRP.getValue();
                orgViewType = "03";
            }
            boolean hasPermission = OrgHelper.checkHasPermissionOrg((String)entityName, (String)orgViewType, (Long)orgId, (Long)userId);
            if (!hasPermission) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u4e1a\u52a1\u7ec4\u7ec7\u6ca1\u6709\u4f7f\u7528\u6743\u9650\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BillCoreInfoValidator_0", (String)"mpscmm-msbd-opvalidate", (Object[])new Object[0]), ErrorLevel.Error);
                continue;
            }
            Object operatorGroupIsolate = SysParamHelper.getSysParam((String)((String)bizapp.getPkValue()), (String)orgViewType, (Long)orgId, (String)"foperatorgroupisolate");
            if (operatorGroupIsolate instanceof Boolean && ((Boolean)operatorGroupIsolate).booleanValue() && (operator == null || operatorgroup == null)) {
                if ("02".equals(orgViewType)) {
                    this.addMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u91c7\u8d2d\u7ec4\u7ec7\u5df2\u542f\u7528\u4e1a\u52a1\u7ec4\u9694\u79bb\uff0c\u8bf7\u586b\u5199\u91c7\u8d2d\u5458\u3002", (String)"BillCoreInfoValidator_1", (String)"mpscmm-msbd-opvalidate", (Object[])new Object[0]), ErrorLevel.Error);
                    continue;
                }
                if (!"03".equals(orgViewType)) continue;
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u9500\u552e\u7ec4\u7ec7\u5df2\u542f\u7528\u4e1a\u52a1\u7ec4\u9694\u79bb\uff0c\u8bf7\u586b\u5199\u9500\u552e\u5458\u3002", (String)"BillCoreInfoValidator_2", (String)"mpscmm-msbd-opvalidate", (Object[])new Object[0]), ErrorLevel.Error);
                continue;
            }
            String isCheckDept = MethodParameterUtil.getValue((Object)customparameter, (String)PARA_ISCHECKDEPT);
            boolean checkOperatorGroup = false;
            checkOperatorGroup = operatorGroupIsolate instanceof Boolean && (Boolean)operatorGroupIsolate != false ? OperatorGroupHelper.checkOperatorGroupByOrgAndUser((Long)orgId, (String)operatorGrpType, (Long)UserServiceHelper.getCurrentUserId(), (Long)operatorgroupId) : OperatorGroupHelper.checkOperatorGroupByOrg((Long)orgId, (String)operatorGrpType, (Long)operatorgroupId);
            if (operatorgroup != null && !checkOperatorGroup) {
                if ("02".equals(orgViewType)) {
                    this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u91c7\u8d2d\u7ec4\u201c%1$s\u201d\u4e0d\u662f\u91c7\u8d2d\u7ec4\u7ec7\u53ef\u7528\u7684\u91c7\u8d2d\u7ec4\u3002", (String)"BillCoreInfoValidator_3", (String)"mpscmm-msbd-opvalidate", (Object[])new Object[0]), operatorgroup.getString("number")), ErrorLevel.Error);
                    continue;
                }
                if (!"03".equals(orgViewType)) continue;
                this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u9500\u552e\u7ec4\u201c%1$s\u201d\u4e0d\u662f\u9500\u552e\u7ec4\u7ec7\u53ef\u7528\u7684\u9500\u552e\u7ec4\u3002", (String)"BillCoreInfoValidator_4", (String)"mpscmm-msbd-opvalidate", (Object[])new Object[0]), operatorgroup.getString("number")), ErrorLevel.Error);
                continue;
            }
            boolean checkOperator = false;
            Long l2 = operatorOperatorGroup = operator == null ? null : Long.valueOf(operator.getLong("operatorgrpid"));
            if (operatorOperatorGroup != null && operatorOperatorGroup.equals(operatorgroupId) && OperatorGroupHelper.checkOperator((DynamicObject)operator)) {
                checkOperator = true;
            }
            if (operator != null && operatorgroup != null && !checkOperator) {
                if ("02".equals(orgViewType)) {
                    this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u91c7\u8d2d\u5458\u201c%1$s\u201d\u4e0d\u662f\u91c7\u8d2d\u7ec4\u201c%2$s\u201d\u4e0b\u53ef\u7528\u7684\u91c7\u8d2d\u5458\u3002", (String)"BillCoreInfoValidator_5", (String)"mpscmm-msbd-opvalidate", (Object[])new Object[0]), operator.getString("operatornumber"), operatorgroup.getString("number")), ErrorLevel.Error);
                    continue;
                }
                if (!"03".equals(orgViewType)) continue;
                this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u9500\u552e\u5458\u201c%1$s\u201d\u4e0d\u662f\u9500\u552e\u7ec4\u201c%2$s\u201d\u4e0b\u53ef\u7528\u7684\u9500\u552e\u5458\u3002", (String)"BillCoreInfoValidator_6", (String)"mpscmm-msbd-opvalidate", (Object[])new Object[0]), operator.getString("operatornumber"), operatorgroup.getString("number")), ErrorLevel.Error);
                continue;
            }
            if (isCheckDept != null && !"true".equalsIgnoreCase(isCheckDept) || dept == null || OrgHelper.checkDepartment((Long)orgId, (Long)operatorUserId, (Long)deptId)) continue;
            if ("02".equals(orgViewType)) {
                this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u91c7\u8d2d\u90e8\u95e8\u201c%1$s\u201d\u4e0d\u662f\u91c7\u8d2d\u7ec4\u7ec7\u201c%2$s\u201d\u4e0b\u53ef\u7528\u7684\u91c7\u8d2d\u90e8\u95e8\u3002", (String)"BillCoreInfoValidator_7", (String)"mpscmm-msbd-opvalidate", (Object[])new Object[0]), dept.getString("number"), orgNumber), ErrorLevel.Error);
                continue;
            }
            if (!"03".equals(orgViewType)) continue;
            this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u9500\u552e\u90e8\u95e8\u201c%1$s\u201d\u4e0d\u662f\u9500\u552e\u7ec4\u7ec7\u201c%2$s\u201d\u4e0b\u53ef\u7528\u7684\u9500\u552e\u90e8\u95e8\u3002", (String)"BillCoreInfoValidator_8", (String)"mpscmm-msbd-opvalidate", (Object[])new Object[0]), dept.getString("number"), orgNumber), ErrorLevel.Error);
        }
    }
}

