/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.opvalidate.validator;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.mpscmm.msbd.business.helper.BillQuantityHelper;
import kd.mpscmm.msbd.business.helper.MaterialHelper;
import kd.mpscmm.msbd.common.enums.UnitConvertDirEnum;
import kd.mpscmm.msbd.common.utils.BigDecimalUtil;
import kd.mpscmm.msbd.common.utils.CommonUtils;
import kd.mpscmm.msbd.common.utils.MethodParameterUtil;

public class BillQuantityValidator
extends AbstractValidator {
    public static String PARA_ISCHECKQTYNULL = "ischeckqtynull";
    public static String PARA_ISCHECKBASEUNITNULL = "ischeckbaseunitnull";
    public static String PARA_ISCHECKBASEUNITERROR = "ischeckbaseuniterror";
    public static String PARA_ISCHECKBASEQTYERROR = "ischeckbaseqtyerror";
    public static String PARA_ISCHECKAUXUNITERROR = "ischeckauxuniterror";
    public static String PARA_ISCHECKAUXQTYERROR = "ischeckauxqtyerror";

    public Set<String> preparePropertys() {
        HashSet<String> preparePropertys = super.preparePropertys();
        if (CommonUtils.isNull((Object)preparePropertys)) {
            preparePropertys = new HashSet<String>(32);
        }
        String customparameter = (String)this.getValidation().get("customparameter");
        String BILLNO = MethodParameterUtil.getProperytMappingValue((Object)customparameter, (String)"billno");
        preparePropertys.add(BILLNO);
        preparePropertys.add("material");
        preparePropertys.add("qty");
        preparePropertys.add("unit");
        preparePropertys.add("baseqty");
        preparePropertys.add("baseunit");
        preparePropertys.add("auxqty");
        preparePropertys.add("auxunit");
        preparePropertys.add("billcretype");
        return preparePropertys;
    }

    public void validate() {
        if (this.getDataEntities() == null || this.getDataEntities().length == 0) {
            return;
        }
        String customparameter = (String)this.getValidation().get("customparameter");
        String BILLENTRY = MethodParameterUtil.getProperytMappingValue((Object)customparameter, (String)"billentry");
        String MATERIAL = MethodParameterUtil.getProperytMappingValue((Object)customparameter, (String)"material");
        String BILLNO = MethodParameterUtil.getProperytMappingValue((Object)customparameter, (String)"billno");
        for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
            DynamicObject bill = dataEntity.getDataEntity();
            if (bill == null) continue;
            String billcretype = bill.getString("billcretype");
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection(BILLENTRY);
            if (entrys == null || entrys.size() <= 0) continue;
            for (int i = 0; i < entrys.size(); ++i) {
                BigDecimal desQty;
                DynamicObject entry = (DynamicObject)entrys.get(i);
                DynamicObject material = entry.getDynamicObject(MATERIAL);
                if (CommonUtils.isNull((Object)material)) {
                    String tipMsg = String.format(ResManager.loadKDString((String)"%1$s\uff0c\u201c\u7269\u6599\u660e\u7ec6\u201d\u7b2c%2$s\u884c\uff1a\u201c\u7269\u6599\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BillQuantityValidator_0", (String)"mpscmm-msbd-opvalidate", (Object[])new Object[0]), bill.get(BILLNO), i + 1);
                    this.addMessage(dataEntity, tipMsg, ErrorLevel.Error);
                    continue;
                }
                DynamicObject materialmasterid = null;
                materialmasterid = "bd_material".equals(material.getDataEntityType().getName()) ? material : material.getDynamicObject("masterid");
                if (materialmasterid == null) continue;
                DynamicObject materialBaseUnit = materialmasterid.getDynamicObject("baseunit");
                DynamicObject materialAuxUnit = materialmasterid.getDynamicObject("auxptyunit");
                DynamicObject unit = entry.getDynamicObject("unit");
                BigDecimal qty = entry.getBigDecimal("qty");
                DynamicObject baseUnit = entry.getDynamicObject("baseunit");
                BigDecimal baseQty = entry.getBigDecimal("baseqty");
                DynamicObject auxUnit = entry.getDynamicObject("auxunit");
                BigDecimal auxQty = entry.getBigDecimal("auxqty");
                if ("true".equalsIgnoreCase(MethodParameterUtil.getValue((Object)customparameter, (String)PARA_ISCHECKQTYNULL)) && BigDecimalUtil.isBlank((BigDecimal)qty)) {
                    this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"%1$s\uff0c\u201c\u7269\u6599\u660e\u7ec6\u201d\u7b2c%2$s\u884c\uff1a\u7269\u6599\u201c%3$s(%4$s)\u201d,\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a\u62160\u3002", (String)"BillQuantityValidator_1", (String)"mpscmm-msbd-opvalidate", (Object[])new Object[0]), bill.get(BILLNO), i + 1, materialmasterid.get("name"), materialmasterid.get("number")), ErrorLevel.Error);
                    continue;
                }
                if ("true".equalsIgnoreCase(MethodParameterUtil.getValue((Object)customparameter, (String)PARA_ISCHECKBASEUNITERROR)) && materialBaseUnit != null && baseUnit != null && !materialBaseUnit.getPkValue().equals(baseUnit.getPkValue())) {
                    this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"%1$s\uff0c\u201c\u7269\u6599\u660e\u7ec6\u201d\u7b2c%2$s\u884c\uff1a\u7269\u6599\u201c%3$s(%4$s)\u201d\uff0c\u201c\u57fa\u672c\u5355\u4f4d\u201d\u4e0d\u662f\u7269\u6599\u4e2d\u8bbe\u7f6e\u7684\u57fa\u672c\u5355\u4f4d\u3002", (String)"BillQuantityValidator_2", (String)"mpscmm-msbd-opvalidate", (Object[])new Object[0]), bill.get(BILLNO), i + 1, materialmasterid.get("name"), materialmasterid.get("number")), ErrorLevel.Error);
                    continue;
                }
                if ("true".equalsIgnoreCase(MethodParameterUtil.getValue((Object)customparameter, (String)PARA_ISCHECKBASEUNITNULL)) && qty != null && !BigDecimalUtil.isZero((BigDecimal)qty) && unit != null && (baseUnit == null || baseQty == null || BigDecimalUtil.isZero((BigDecimal)baseQty))) {
                    this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"%1$s\uff0c\u201c\u7269\u6599\u660e\u7ec6\u201d\u7b2c%2$s\u884c\uff1a\u7269\u6599\u201c%3$s(%4$s)\u201d\uff0c\u201c\u57fa\u672c\u5355\u4f4d\u201d\u548c\u201c\u57fa\u672c\u6570\u91cf\u201d\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"BillQuantityValidator_3", (String)"mpscmm-msbd-opvalidate", (Object[])new Object[0]), bill.get(BILLNO), i + 1, materialmasterid.get("name"), materialmasterid.get("number")), ErrorLevel.Error);
                    continue;
                }
                if ("true".equalsIgnoreCase(MethodParameterUtil.getValue((Object)customparameter, (String)PARA_ISCHECKBASEQTYERROR))) {
                    if (materialmasterid != null && unit != null && baseUnit != null && unit.getPkValue().equals(baseUnit.getPkValue()) && (qty == null || baseQty == null || !BigDecimalUtil.equals((BigDecimal)qty, (BigDecimal)baseQty))) {
                        this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"%1$s\uff0c\u201c\u7269\u6599\u660e\u7ec6\u201d\u7b2c%2$s\u884c\uff1a\u7269\u6599\u201c%3$s(%4$s)\u201d\uff0c\u201c\u8ba1\u91cf\u5355\u4f4d\u201d\u4e0e\u201c\u57fa\u672c\u5355\u4f4d\u201d\u76f8\u7b49\u4f46\u201c\u6570\u91cf\u201d\u4e0e\u201c\u57fa\u672c\u6570\u91cf\u201d\u4e0d\u7b49\u3002", (String)"BillQuantityValidator_4", (String)"mpscmm-msbd-opvalidate", (Object[])new Object[0]), bill.get(BILLNO), i + 1, materialmasterid.get("name"), materialmasterid.get("number")), ErrorLevel.Error);
                        continue;
                    }
                    if (materialmasterid != null && unit != null && baseUnit != null && !unit.getPkValue().equals(baseUnit.getPkValue())) {
                        boolean checkUnit = MaterialHelper.checkUnit((Long)materialmasterid.getLong("id"), (Long)((Long)baseUnit.getPkValue()), (Long)((Long)unit.getPkValue()));
                        if (!checkUnit) {
                            this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"%1$s\uff0c\u201c\u7269\u6599\u660e\u7ec6\u201d\u7b2c%2$s\u884c\uff1a\u7269\u6599\u201c%3$s(%4$s)\u201d\uff0c\u201c\u8ba1\u91cf\u5355\u4f4d\u201d\u4e0d\u5728\u53ef\u7528\u7684\u8ba1\u91cf\u5355\u4f4d\u8303\u56f4\u5185\u3002", (String)"BillQuantityValidator_5", (String)"mpscmm-msbd-opvalidate", (Object[])new Object[0]), bill.get(BILLNO), i + 1, materialmasterid.get("name"), materialmasterid.get("number")), ErrorLevel.Error);
                            continue;
                        }
                        desQty = BillQuantityHelper.getDesQtyConv((Long)materialmasterid.getLong("id"), (DynamicObject)baseUnit, (BigDecimal)baseQty, (DynamicObject)unit);
                        BigDecimal desBaseQty = BillQuantityHelper.getDesQtyConv((Long)materialmasterid.getLong("id"), (DynamicObject)unit, (BigDecimal)qty, (DynamicObject)baseUnit);
                        if (!BigDecimalUtil.equals((BigDecimal)qty, (BigDecimal)desQty) && !BigDecimalUtil.equals((BigDecimal)baseQty, (BigDecimal)desBaseQty)) {
                            this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"%1$s\uff0c\u201c\u7269\u6599\u660e\u7ec6\u201d\u7b2c%2$s\u884c\uff1a\u7269\u6599\u201c%3$s(%4$s)\u201d\uff0c\u201c\u8ba1\u91cf\u5355\u4f4d\u201d\u4e0e\u201c\u57fa\u672c\u5355\u4f4d\u201d\u6362\u7b97\u7ed3\u679c\u4e0d\u4e00\u81f4\u3002", (String)"BillQuantityValidator_6", (String)"mpscmm-msbd-opvalidate", (Object[])new Object[0]), bill.get(BILLNO), i + 1, materialmasterid.get("name"), materialmasterid.get("number")), ErrorLevel.Error);
                            continue;
                        }
                    }
                }
                if ("true".equalsIgnoreCase(MethodParameterUtil.getValue((Object)customparameter, (String)PARA_ISCHECKAUXUNITERROR)) && materialAuxUnit != null && auxUnit != null && !materialAuxUnit.getPkValue().equals(auxUnit.getPkValue())) {
                    this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"%1$s\uff0c\u201c\u7269\u6599\u660e\u7ec6\u201d\u7b2c%2$s\u884c\uff1a\u7269\u6599\u201c%3$s(%4$s)\u201d\uff0c\u201c\u8f85\u52a9\u5355\u4f4d\u201d\u4e0d\u662f\u7269\u6599\u4e2d\u8bbe\u7f6e\u7684\u8f85\u52a9\u5355\u4f4d\u3002", (String)"BillQuantityValidator_7", (String)"mpscmm-msbd-opvalidate", (Object[])new Object[0]), bill.get(BILLNO), i + 1, materialmasterid.get("name"), materialmasterid.get("number")), ErrorLevel.Error);
                    continue;
                }
                if (!"true".equalsIgnoreCase(MethodParameterUtil.getValue((Object)customparameter, (String)PARA_ISCHECKAUXQTYERROR)) || auxUnit == null || !BigDecimalUtil.isNotBlank((BigDecimal)auxQty)) continue;
                String unitConvertDir = materialmasterid.getString("unitconvertdir");
                if (baseQty == null || baseUnit == null || auxUnit == null || auxQty == null || !UnitConvertDirEnum.UINVANDU2ND.getValue().equals(unitConvertDir)) continue;
                desQty = BillQuantityHelper.getDesQtyConv((Long)materialmasterid.getLong("id"), (DynamicObject)baseUnit, (BigDecimal)baseQty, (DynamicObject)auxUnit);
                if (auxQty == null || BigDecimalUtil.equals((BigDecimal)auxQty, (BigDecimal)desQty)) continue;
                this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"%1$s\uff0c\u201c\u7269\u6599\u660e\u7ec6\u201d\u7b2c%2$s\u884c\uff1a\u7269\u6599\u201c%3$s(%4$s)\u201d\uff0c\u201c\u8ba1\u91cf\u5355\u4f4d\u201d\u4e0e\u201c\u8f85\u52a9\u5355\u4f4d\u201d\u6362\u7b97\u7ed3\u679c\u4e0d\u4e00\u81f4\u3002", (String)"BillQuantityValidator_8", (String)"mpscmm-msbd-opvalidate", (Object[])new Object[0]), bill.get(BILLNO), i + 1, materialmasterid.get("name"), materialmasterid.get("number")), ErrorLevel.Error);
            }
        }
    }
}

