/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.opvalidate.validator;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.BillEntity;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mpscmm.msbd.business.helper.BillTypeHelper;
import kd.mpscmm.msbd.business.helper.BizTypeHelper;
import kd.mpscmm.msbd.common.enums.StatusEnum;
import kd.mpscmm.msbd.common.utils.CommonUtils;
import kd.mpscmm.msbd.common.utils.MetadataUtils;
import kd.mpscmm.msbd.common.utils.MethodParameterUtil;

public class BizTypeValidator
extends AbstractValidator {
    public static String PARA_ISCHECKMATEMATCHLINETYPE = "ischeckmatematchlinetype";

    public Set<String> preparePropertys() {
        HashSet<String> preparePropertys = super.preparePropertys();
        if (CommonUtils.isNull((Object)preparePropertys)) {
            preparePropertys = new HashSet<String>();
        }
        preparePropertys.add("billstatus");
        preparePropertys.add("billtype");
        preparePropertys.add("biztype");
        preparePropertys.add("linetype");
        preparePropertys.add("material");
        preparePropertys.add("materialmasterid");
        return preparePropertys;
    }

    public void validate() {
        if (this.getDataEntities() == null || this.getDataEntities().length == 0) {
            return;
        }
        String customparameter = (String)this.getValidation().get("customparameter");
        for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
            DynamicObject bill = dataEntity.getDataEntity();
            String formId = bill.getDataEntityType().getName();
            String billStatus = bill.getString("billstatus");
            DynamicObject billtype = bill.getDynamicObject("billtype");
            DynamicObject biztype = bill.getDynamicObject("biztype");
            DynamicObjectCollection billentry = bill.getDynamicObjectCollection("billentry");
            String paramFormId = null;
            if (CommonUtils.isNull((Object)billtype)) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u5355\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BizTypeValidator_0", (String)"mpscmm-msbd-opvalidate", (Object[])new Object[0]), ErrorLevel.Error);
                continue;
            }
            if (CommonUtils.isNull((Object)biztype)) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u4e1a\u52a1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BizTypeValidator_1", (String)"mpscmm-msbd-opvalidate", (Object[])new Object[0]), ErrorLevel.Error);
                continue;
            }
            if (!BillTypeHelper.checkBillType((String)formId, (Long)billtype.getLong("id"))) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u5355\u636e\u7c7b\u578b\u4e0e\u5355\u636e\u5b9e\u4f53\u4e0d\u5339\u914d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"BizTypeValidator_2", (String)"mpscmm-msbd-opvalidate", (Object[])new Object[0]), ErrorLevel.Error);
                continue;
            }
            if (formId.startsWith("pm_") || formId.startsWith("mspur_") || formId.startsWith("vmi_") || formId.startsWith("sctm_")) {
                paramFormId = "pm_billtypeparameter";
            } else if (formId.startsWith("sm_")) {
                paramFormId = "sm_billtypeparam";
            } else {
                DynamicObject entityobj = BusinessDataServiceHelper.loadSingleFromCache((Object)formId, (String)"bos_entityobject");
                EntityMetadata meta = (EntityMetadata)MetadataDao.readMeta((String)entityobj.getString("dentityid"), (MetaCategory)MetaCategory.Entity);
                if (meta.getRootEntity() instanceof BillEntity) {
                    paramFormId = ((BillEntity)meta.getRootEntity()).getBillTypePara();
                }
            }
            if (!BizTypeHelper.checkBizTypeInBillType((Long)biztype.getLong("id"), (String)formId, (Long)billtype.getLong("id"), (String)paramFormId)) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u4e1a\u52a1\u7c7b\u578b\u4e0e\u5355\u636e\u7c7b\u578b\u4e0d\u5339\u914d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"BizTypeValidator_3", (String)"mpscmm-msbd-opvalidate", (Object[])new Object[0]), ErrorLevel.Error);
                continue;
            }
            if (CommonUtils.isNull((Object)billentry)) continue;
            int row = 0;
            for (DynamicObject entry : billentry) {
                String tipMsg;
                String tipMsg2;
                String tipMsg3;
                ++row;
                DynamicObject linetype = entry.getDynamicObject("linetype");
                if (CommonUtils.isNull((Object)linetype)) {
                    tipMsg3 = String.format(ResManager.loadKDString((String)"\u201c\u7269\u6599\u660e\u7ec6\u201d\u7b2c%1$s\u884c\uff1a\u884c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BizTypeValidator_4", (String)"mpscmm-msbd-opvalidate", (Object[])new Object[0]), row);
                    this.addMessage(dataEntity, tipMsg3, ErrorLevel.Error);
                    continue;
                }
                if (!MetadataUtils.checkProperty((DynamicObject)linetype, (String)"serviceattribute")) {
                    tipMsg3 = String.format(ResManager.loadKDString((String)"\u201c\u7269\u6599\u660e\u7ec6\u201d\u7b2c%1$s\u884c\uff1a\u884c\u7c7b\u578b\u7684\u4e1a\u52a1\u5c5e\u6027\u6ca1\u6709\u88ab\u5f15\u7528\u3002", (String)"BizTypeValidator_5", (String)"mpscmm-msbd-opvalidate", (Object[])new Object[0]), row);
                    this.addMessage(dataEntity, tipMsg3, ErrorLevel.Error);
                    continue;
                }
                DynamicObject serviceattribute = linetype.getDynamicObject("serviceattribute");
                if (CommonUtils.isNull((Object)serviceattribute)) {
                    tipMsg2 = String.format(ResManager.loadKDString((String)"\u201c\u7269\u6599\u660e\u7ec6\u201d\u7b2c%1$s\u884c\uff1a\u884c\u7c7b\u578b\u7684\u4e1a\u52a1\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BizTypeValidator_6", (String)"mpscmm-msbd-opvalidate", (Object[])new Object[0]), row);
                    this.addMessage(dataEntity, tipMsg2, ErrorLevel.Error);
                    continue;
                }
                if (!BizTypeHelper.checkLineTypeInBizType((Long)linetype.getLong("id"), (Long)biztype.getLong("id"))) {
                    tipMsg2 = String.format(ResManager.loadKDString((String)"\u201c\u7269\u6599\u660e\u7ec6\u201d\u7b2c%1$s\u884c\uff1a\u884c\u7c7b\u578b\u4e0e\u5f53\u524d\u5355\u636e\u7684\u4e1a\u52a1\u7c7b\u578b\u4e0d\u5339\u914d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"BizTypeValidator_7", (String)"mpscmm-msbd-opvalidate", (Object[])new Object[0]), row);
                    this.addMessage(dataEntity, tipMsg2, ErrorLevel.Error);
                    continue;
                }
                DynamicObject material = entry.getDynamicObject("material");
                if (CommonUtils.isNull((Object)material)) {
                    String tipMsg4 = String.format(ResManager.loadKDString((String)"\u201c\u7269\u6599\u660e\u7ec6\u201d\u7b2c%1$s\u884c\uff1a\u7269\u6599\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BizTypeValidator_8", (String)"mpscmm-msbd-opvalidate", (Object[])new Object[0]), row);
                    this.addMessage(dataEntity, tipMsg4, ErrorLevel.Error);
                    continue;
                }
                DynamicObject materialmasterid = null;
                if ("bd_material".equals(material.getDataEntityType().getName())) {
                    materialmasterid = material;
                }
                if (CommonUtils.isNull((Object)(materialmasterid = material.getDynamicObject("masterid")))) {
                    tipMsg = String.format(ResManager.loadKDString((String)"\u201c\u7269\u6599\u660e\u7ec6\u201d\u7b2c%1$s\u884c\uff1a\u7269\u6599\u7684masterid\u6ca1\u6709\u88ab\u5f15\u7528\u3002", (String)"BizTypeValidator_13", (String)"mpscmm-msbd-opvalidate", (Object[])new Object[0]), row);
                    this.addMessage(dataEntity, tipMsg, ErrorLevel.Error);
                    continue;
                }
                if (!MetadataUtils.checkProperty((DynamicObject)materialmasterid, (String)"serviceattribute")) {
                    tipMsg = String.format(ResManager.loadKDString((String)"\u201c\u7269\u6599\u660e\u7ec6\u201d\u7b2c%1$s\u884c\uff1a\u7269\u6599\u7684\u4e1a\u52a1\u5c5e\u6027\u6ca1\u6709\u88ab\u5f15\u7528\u3002", (String)"BizTypeValidator_9", (String)"mpscmm-msbd-opvalidate", (Object[])new Object[0]), row);
                    this.addMessage(dataEntity, tipMsg, ErrorLevel.Error);
                    continue;
                }
                DynamicObjectCollection serviceattributes = materialmasterid.getDynamicObjectCollection("serviceattribute");
                if (CommonUtils.isNull((Object)serviceattributes)) {
                    String tipMsg5 = String.format(ResManager.loadKDString((String)"\u201c\u7269\u6599\u660e\u7ec6\u201d\u7b2c%1$s\u884c\uff1a\u7269\u6599\u7684\u4e1a\u52a1\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BizTypeValidator_10", (String)"mpscmm-msbd-opvalidate", (Object[])new Object[0]), row);
                    this.addMessage(dataEntity, tipMsg5, ErrorLevel.Error);
                    continue;
                }
                String isChecklineTypeMatch = MethodParameterUtil.getValue((Object)customparameter, (String)PARA_ISCHECKMATEMATCHLINETYPE);
                if (isChecklineTypeMatch == null || "true".equalsIgnoreCase(isChecklineTypeMatch)) {
                    List ls = serviceattributes.stream().map(dym -> dym.getLong("fbasedataid_id")).collect(Collectors.toList());
                    if (!this.isExpenseItemLineType(linetype) && !ls.contains(serviceattribute.getLong("id"))) {
                        String tipMsg6 = String.format(ResManager.loadKDString((String)"\u201c\u7269\u6599\u660e\u7ec6\u201d\u7b2c%1$s\u884c\uff1a\u884c\u7c7b\u578b\u4e0e\u7269\u6599\u7684\u4e1a\u52a1\u5c5e\u6027\u4e0d\u5339\u914d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"BizTypeValidator_11", (String)"mpscmm-msbd-opvalidate", (Object[])new Object[0]), row);
                        this.addMessage(dataEntity, tipMsg6, ErrorLevel.Error);
                        continue;
                    }
                }
                if (!StatusEnum.AUDIT.getValue().equals(billStatus) && !StatusEnum.SUBMIT.getValue().equals(billStatus)) continue;
                if (!MetadataUtils.checkProperty((DynamicObject)linetype, (String)"controlcriterion")) {
                    linetype = BusinessDataServiceHelper.loadSingleFromCache((Object)linetype.getPkValue(), (String)"bd_linetype", (String)"controlcriterion");
                }
                if (linetype == null || !"1".equals(linetype.getString("controlcriterion")) || entry.getBigDecimal("amountandtax").compareTo(BigDecimal.ZERO) > 0) continue;
                String tipMsg7 = String.format(ResManager.loadKDString((String)"\u201c\u7269\u6599\u660e\u7ec6\u201d\u7b2c%1$s\u884c\uff1a\u884c\u7c7b\u578b\u4e3a\u91d1\u989d\u57fa\u51c6\u65f6\u4ef7\u7a0e\u5408\u8ba1\u5fc5\u987b\u5927\u4e8e0\u3002", (String)"BizTypeValidator_12", (String)"mpscmm-msbd-opvalidate", (Object[])new Object[0]), row);
                this.addMessage(dataEntity, tipMsg7, ErrorLevel.Error);
            }
        }
    }

    private boolean isExpenseItemLineType(DynamicObject lineType) {
        if (lineType == null) {
            return false;
        }
        DynamicObject attr = lineType.getDynamicObject("serviceattribute");
        if (attr == null) {
            return false;
        }
        return "3001".equals(attr.getString("number"));
    }
}

