/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.workbench.formplugin;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.util.StringUtils;

public class CustomCardConfigPlugin
extends AbstractFormPlugin {
    public static final String TEXT_CARDFORMNAME = "cardformname";
    public static final String CUSTOM_PARAM = "customparam";
    public static final String TEXT_CARDFORMNUM = "cardformnum";
    public static final String TEXT_CARDTITLE = "cardtitle";
    public static final String FORM_CUSTCARDFORMLIST = "msbd_card_custformlist";
    public static final String CLOSECALLBACK_CARDFORMLIST = "cardformlist";
    public static final String BTN_OK = "btn_ok";
    public static final String BTN_PRE = "btn_pre";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{TEXT_CARDFORMNAME, BTN_OK, BTN_PRE, CUSTOM_PARAM});
    }

    public void click(EventObject evt) {
        String key;
        Control source = (Control)evt.getSource();
        switch (key = source.getKey()) {
            case "cardformname": {
                this.showFormList();
                break;
            }
            case "btn_ok": {
                this.actionConfirm();
                break;
            }
            case "btn_pre": {
                this.actionPre();
                break;
            }
            case "customparam": {
                this.showCusParamPage();
            }
        }
    }

    private void showCusParamPage() {
        String formNum = (String)this.getModel().getValue(TEXT_CARDFORMNUM);
        if (StringUtils.isEmpty((String)formNum)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u81ea\u5b9a\u4e49\u8868\u5355", (String)"CustomCardConfigPlugin_0", (String)"mpscmm-msbd-workbench", (Object[])new Object[0]));
        }
        String paramForm = formNum + "conf";
        Boolean exist = (Boolean)DB.query((DBRoute)DBRoute.meta, (String)"SELECT FID FROM T_META_FORMDESIGN WHERE FNUMBER = ?", (Object[])new String[]{paramForm}, rs -> rs.next());
        if (!exist.booleanValue()) {
            paramForm = "msbd_default_custom_param";
        }
        Object value = this.getModel().getValue(CUSTOM_PARAM);
        FormShowParameter param = new FormShowParameter();
        param.setCustomParam("params", value);
        param.setFormId(paramForm);
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CUSTOM_PARAM));
        this.getView().showForm(param);
    }

    private void actionPre() {
        HashMap<String, String> returnMapPre = new HashMap<String, String>();
        returnMapPre.put("event_rtn_addcard", "7");
        this.getView().returnDataToParent(returnMapPre);
        this.getView().close();
    }

    private void actionConfirm() {
        if (this.validateValue()) {
            HashMap<String, Object> returnMap = new HashMap<String, Object>();
            returnMap.put("cardType", "bos_card_custom");
            returnMap.put(TEXT_CARDFORMNAME, this.getModel().getValue(TEXT_CARDFORMNAME));
            returnMap.put(TEXT_CARDFORMNUM, this.getModel().getValue(TEXT_CARDFORMNUM));
            returnMap.put(TEXT_CARDTITLE, ((OrmLocaleValue)this.getModel().getValue(TEXT_CARDTITLE)).entrySet().toString());
            String paramJson = (String)this.getModel().getValue(CUSTOM_PARAM);
            if (!StringUtils.isEmpty((String)paramJson)) {
                Map customParam = (Map)SerializationUtils.fromJsonString((String)paramJson, Map.class);
                returnMap.putAll(customParam);
            }
            this.getView().returnDataToParent(returnMap);
            this.getView().close();
        }
    }

    private boolean validateValue() {
        OrmLocaleValue cardTitle = (OrmLocaleValue)this.getModel().getValue(TEXT_CARDTITLE);
        String cardFormName = (String)this.getModel().getValue(TEXT_CARDFORMNAME);
        if (cardTitle == null || StringUtils.isEmpty((String)cardTitle.toString())) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5361\u7247\u6807\u9898\u4e0d\u80fd\u7a7a\u3002", (String)"CustomCardConfigPlugin_1", (String)"mpscmm-msbd-workbench", (Object[])new Object[0]));
            return false;
        }
        if (StringUtils.isEmpty((String)cardFormName)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5361\u7247\u8868\u5355\u4e0d\u80fd\u7a7a\u3002", (String)"CustomCardConfigPlugin_2", (String)"mpscmm-msbd-workbench", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void showFormList() {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId(FORM_CUSTCARDFORMLIST);
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CLOSECALLBACK_CARDFORMLIST));
        this.getView().showForm(fsp);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        Map returnMap;
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if (CLOSECALLBACK_CARDFORMLIST.equals(actionId)) {
            Map returnMap2 = (Map)e.getReturnData();
            if (returnMap2 == null) {
                return;
            }
            String formNum = (String)returnMap2.get("formNum");
            String formName = (String)returnMap2.get("formName");
            this.getModel().setValue(TEXT_CARDFORMNUM, (Object)formNum);
            this.getModel().setValue(TEXT_CARDFORMNAME, (Object)formName);
            this.getModel().setValue(TEXT_CARDTITLE, (Object)new LocaleString(formName));
        } else if (CUSTOM_PARAM.equals(actionId) && (returnMap = (Map)e.getReturnData()) != null) {
            String paramJson = SerializationUtils.toJsonString((Object)returnMap);
            this.getModel().setValue(CUSTOM_PARAM, (Object)paramJson);
        }
    }
}

