/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.workbench.formplugin;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;
import kd.mpscmm.msbd.workbench.util.PortalUsableFuncUtil;

public class CustomCardFormListPlugin
extends AbstractFormPlugin
implements SearchEnterListener {
    private static Log logger = LogFactory.getLog(CustomCardFormListPlugin.class);
    public static final String BILLLIST = "billlistap";
    public static final String BTN_OK = "btn_ok";
    public static final String FSP_NOAPPFILTER = "FormShowParam_NoAppFilter";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.refreshBilllist(null);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Button btnOk = (Button)this.getControl(BTN_OK);
        btnOk.addClickListener((ClickListener)this);
        Search search = (Search)this.getView().getControl("searchap");
        search.getItems();
        if (search != null) {
            search.addEnterListener((SearchEnterListener)this);
        }
    }

    public void initialize() {
        Long userId;
        boolean isAdmin;
        BillList billList = (BillList)this.getControl(BILLLIST);
        Object customParam = this.getView().getFormShowParameter().getCustomParam(FSP_NOAPPFILTER);
        if (customParam == null && !(isAdmin = PermissionServiceHelper.isAdminUser((long)(userId = Long.valueOf(RequestContext.get().getUserId()))))) {
            PortalUsableFuncUtil portalUsableFuncUtil = new PortalUsableFuncUtil(logger);
            Set<String> hasPermAppIds = portalUsableFuncUtil.getUserHasPerAppIds();
            QFilter appUserTypeFilter = new QFilter("bizappid", "in", hasPermAppIds);
            billList.getFilterParameter().getQFilters().add(appUserTypeFilter);
        }
        QFilter specFormFilter = new QFilter("inheritpath", "like", (Object)"3UG=3CWH7BPC%");
        billList.getFilterParameter().getQFilters().add(specFormFilter);
        QFilter notShowExtFormFilter = new QFilter("type", "!=", (Object)"2");
        billList.getFilterParameter().getQFilters().add(notShowExtFormFilter);
    }

    public void search(SearchEnterEvent event) {
        this.refreshBilllist(event);
    }

    private void refreshBilllist(SearchEnterEvent event) {
        BillList billList = (BillList)this.getControl(BILLLIST);
        if (event != null && StringUtils.isNotEmpty((String)event.getText())) {
            String searchStr = event.getText();
            QFilter searchFilter = new QFilter("number", "like", (Object)("%" + searchStr + "%")).or(new QFilter("name", "like", (Object)("%" + searchStr + "%")));
            billList.getFilterParameter().getQFilters().add(searchFilter);
        }
        billList.refresh();
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if (key.equals(BTN_OK)) {
            BillList billList = (BillList)this.getControl(BILLLIST);
            ListSelectedRow lsr = billList.getCurrentSelectedRowInfo();
            if (lsr == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8868\u5355\uff01", (String)"CustomCardFormListPlugin_0", (String)"mpscmm-msbd-workbench", (Object[])new Object[0]), Integer.valueOf(2000));
                return;
            }
            String formNum = lsr.getNumber();
            String formName = lsr.getName();
            HashMap<String, String> returnMap = new HashMap<String, String>();
            returnMap.put("formNum", formNum);
            returnMap.put("formName", formName);
            this.getView().returnDataToParent(returnMap);
            this.getView().close();
        }
    }
}

