/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.workbench.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dlock.DLock;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.mpscmm.msbd.workbench.pojo.CardEntityInfo;
import kd.mpscmm.msbd.workbench.pojo.CardParams;
import kd.mpscmm.msbd.workbench.pojo.CardResult;
import kd.mpscmm.msbd.workbench.util.CardUtils;

public class GridCardPlugin
extends AbstractFormPlugin {
    public static final String CONFIGKEY_CARDTITLE = "cardtitle";
    public static final String PGCACHE_CARDTITLE_MAPENTRY = "cardTitleMapEntry";
    public static final String LBL_CARD_TITLE = "title";
    public static final String CACHE_REGISTER_EVENTS = "cache_register_events";
    public static final String CACHE_EVENT_PARAMS = "cache_event_params";
    public static final String EVENTID = "eventid";
    public static final String HANDLEEVENT = "handleevent";
    protected String TITLE_MAPENTRYSTR_DEFAULT = "";
    protected String TITLE_DEFAULT = "";
    public static final String CLSBCK_MODIFYCARDCAPTION = "ModifyCardCaption";
    protected LocaleString lstrDefaultTitle = null;
    public static final String VECTOR_MODIFY_CARDTITLE = "vectorap";
    public static final String CONFIGKEY_CARDTYPE = "cardType";
    private static Log logger = LogFactory.getLog(GridCardPlugin.class);

    public void initialize() {
        super.initialize();
        this.registerEventListener();
    }

    protected void registerEventListener() {
    }

    protected IPageCache getParentPageCache() {
        IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        if (parentView != null) {
            return (IPageCache)parentView.getService(IPageCache.class);
        }
        return null;
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map<String, String> cardConfigMap = this.getCurCardConfigMap();
        try {
            this.filterCardConfig(this.getAllPermCardInfo(), this.getCardId(), cardConfigMap);
        }
        catch (Exception ex) {
            logger.error("filterCardConfig error", (Throwable)ex);
        }
        this.refreshCard(cardConfigMap);
    }

    public void filterCardConfig(Map<String, CardResult> cardResultMap, String cardId, Map<String, String> configMap) {
        if (cardResultMap == null || configMap == null) {
            return;
        }
        CardResult cardResult = cardResultMap.get(cardId);
        if (cardResult == null) {
            return;
        }
        boolean isNeedHandle = cardResult.isNeedHandle();
        if (!isNeedHandle) {
            return;
        }
        CardParams cardParams = cardResult.getCardParams();
        List<CardEntityInfo> cardEntityInfos = cardParams != null ? cardParams.getCardEntityInfos() : new ArrayList<CardEntityInfo>();
        Set<String> hasPermMenuIds = cardEntityInfos.stream().map(CardEntityInfo::getMenuId).collect(Collectors.toSet());
        this.doFilterCardConfig(configMap, hasPermMenuIds);
    }

    public void doFilterCardConfig(Map<String, String> configMap, Set<String> hasPermMenuIds) {
    }

    private Map<String, CardResult> getAllPermCardInfo() {
        String allPermCardInfoStr;
        IPageCache parentPageCache = this.getParentPageCache();
        Map<String, CardResult> allPermCardInfoMap = new HashMap<String, CardResult>();
        if (parentPageCache != null && StringUtils.isNotEmpty((String)(allPermCardInfoStr = parentPageCache.get("pgCache_permFilterCardInfo")))) {
            allPermCardInfoMap = (Map)SerializationUtils.deSerializeFromBase64((String)allPermCardInfoStr);
        }
        return allPermCardInfoMap;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{VECTOR_MODIFY_CARDTITLE});
    }

    protected void refreshCard(Map<String, String> cardConfigMap) {
        if (this.getControl(VECTOR_MODIFY_CARDTITLE) != null) {
            this.getView().setVisible(Boolean.valueOf(this.isDesignMode()), new String[]{VECTOR_MODIFY_CARDTITLE});
        }
    }

    public String getCardId() {
        Map custParam = this.getView().getFormShowParameter().getOpenStyle().getCustParam();
        if (custParam == null) {
            return null;
        }
        return (String)custParam.get("cardId");
    }

    public boolean isDesignMode() {
        Map custParam = this.getView().getFormShowParameter().getOpenStyle().getCustParam();
        if (custParam == null) {
            return false;
        }
        custParam.get("ifDesignMode");
        String strIfDesignMode = (String)custParam.get("ifDesignMode");
        if ("1".equals(strIfDesignMode)) {
            return true;
        }
        if ("0".equals(strIfDesignMode)) {
            return false;
        }
        return false;
    }

    public Map<String, String> getAllCardConfigMap() {
        String allCardConfigStr;
        IPageCache parentPageCache = this.getParentPageCache();
        Map<String, String> allCardConfigMap = new HashMap<String, String>();
        if (parentPageCache != null && StringUtils.isNotEmpty((String)(allCardConfigStr = parentPageCache.get("cache_allCardConfig")))) {
            allCardConfigMap = (Map)SerializationUtils.fromJsonString((String)allCardConfigStr, Map.class);
        }
        return allCardConfigMap;
    }

    public Map<String, String> getCardPageMap() {
        Map<String, String> result = new HashMap<String, String>();
        String cardPageMapStr = this.getParentPageCache().get("cache_CardId_PageId_Map");
        if (!StringUtils.isEmpty((String)cardPageMapStr)) {
            result = (Map)SerializationUtils.fromJsonString((String)cardPageMapStr, Map.class);
        }
        return result;
    }

    public Map<String, String> getCurCardConfigMap() {
        String cardId = this.getCardId();
        if (StringUtils.isEmpty((String)cardId)) {
            return null;
        }
        Map<String, String> allCardConfigMap = this.getAllCardConfigMap();
        Map<String, String> cardConfigMap = new HashMap<String, String>();
        String curCardConfigMap = allCardConfigMap.get(cardId);
        if (StringUtils.isNotEmpty((String)curCardConfigMap)) {
            cardConfigMap = (Map)SerializationUtils.fromJsonString((String)curCardConfigMap, Map.class);
        }
        return cardConfigMap;
    }

    public void updateCurCardConfigMap(Map<String, String> cardConfigMap) {
        if (cardConfigMap == null) {
            cardConfigMap = new HashMap<String, String>();
        }
        String cardId = this.getCardId();
        Map<String, String> allCardConfigMap = this.getAllCardConfigMap();
        allCardConfigMap.put(cardId, SerializationUtils.toJsonString(cardConfigMap));
        IPageCache parentPageCache = this.getParentPageCache();
        parentPageCache.put("cache_allCardConfig", SerializationUtils.toJsonString(allCardConfigMap));
        parentPageCache.saveChanges();
    }

    protected void showModifyCaptionForm() {
        String cardTitleMapEntry = this.getPageCache().get(PGCACHE_CARDTITLE_MAPENTRY);
        if (StringUtils.isEmpty((String)cardTitleMapEntry)) {
            cardTitleMapEntry = this.TITLE_MAPENTRYSTR_DEFAULT;
        }
        CardUtils.showModifyCaptionForm(this.getView(), (IFormPlugin)this, cardTitleMapEntry);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Map<String, String> cardConfigMap = this.getCurCardConfigMap();
        if (cardConfigMap == null || cardConfigMap.isEmpty()) {
            return;
        }
        String cardTitleMapEntryStr = cardConfigMap.get(CONFIGKEY_CARDTITLE);
        String cardType = cardConfigMap.get(CONFIGKEY_CARDTYPE);
        LocaleString ls = CardUtils.getLocaleStrFromMapEntryStr(cardTitleMapEntryStr);
        Label lblTitle = (Label)this.getControl(LBL_CARD_TITLE);
        if (lblTitle == null) {
            return;
        }
        if (ls != null && ls.size() > 0) {
            String titleStr = ls.getLocaleValue();
            this.getPageCache().put(PGCACHE_CARDTITLE_MAPENTRY, cardTitleMapEntryStr);
            lblTitle.setText(titleStr);
        } else {
            if (StringUtils.isNotEmpty((String)cardTitleMapEntryStr) && !"[]".equals(cardTitleMapEntryStr)) {
                lblTitle.setText(cardTitleMapEntryStr);
                cardTitleMapEntryStr = "[zh_CN=" + cardTitleMapEntryStr + "]";
                cardConfigMap.put(CONFIGKEY_CARDTITLE, cardTitleMapEntryStr);
            } else if (StringUtils.isNotEmpty((String)this.TITLE_DEFAULT)) {
                lblTitle.setText(this.TITLE_DEFAULT);
                cardConfigMap.put(CONFIGKEY_CARDTITLE, this.TITLE_MAPENTRYSTR_DEFAULT);
            }
            this.getPageCache().put(PGCACHE_CARDTITLE_MAPENTRY, this.TITLE_MAPENTRYSTR_DEFAULT);
            this.updateCurCardConfigMap(cardConfigMap);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if (CLSBCK_MODIFYCARDCAPTION.equals(actionId) && e.getReturnData() != null) {
            String titleMapEntryStr = e.getReturnData().toString();
            LocaleString lsTitle = CardUtils.getLocaleStrFromMapEntryStr(titleMapEntryStr);
            Label title = (Label)this.getControl(LBL_CARD_TITLE);
            title.setText(lsTitle.getLocaleValue());
            Map<String, String> cardInfo = this.getCurCardConfigMap();
            cardInfo.put(CONFIGKEY_CARDTITLE, titleMapEntryStr);
            this.getPageCache().put(PGCACHE_CARDTITLE_MAPENTRY, titleMapEntryStr);
            this.updateCurCardConfigMap(cardInfo);
        }
    }

    public void click(EventObject e) {
        super.click(e);
        String key = "";
        Object source = e.getSource();
        if (source instanceof Control) {
            key = ((Control)source).getKey();
        }
        if (key.equals(VECTOR_MODIFY_CARDTITLE)) {
            this.showModifyCaptionForm();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireEvent(String eventId, Map<String, Object> params) {
        Map registerEventMap;
        List cardIds;
        IPageCache parentPageCache = this.getParentPageCache();
        String cacheRegisterEvents = parentPageCache.get(CACHE_REGISTER_EVENTS);
        if (StringUtils.isNotEmpty((String)cacheRegisterEvents) && (cardIds = (List)(registerEventMap = (Map)SerializationUtils.fromJsonString((String)cacheRegisterEvents, Map.class)).get(eventId)) != null && !cardIds.isEmpty()) {
            try (DLock dLock = DLock.create((String)this.getView().getFormShowParameter().getParentPageId());){
                dLock.lock();
                String cacheEventParams = parentPageCache.get(CACHE_EVENT_PARAMS);
                Map<String, Map<String, Object>> eventParamMap = new HashMap<String, Map<String, Object>>();
                if (StringUtils.isNotEmpty((String)cacheEventParams)) {
                    eventParamMap = (Map)SerializationUtils.fromJsonString((String)cacheEventParams, Map.class);
                }
                eventParamMap.put(eventId, params);
                parentPageCache.put(CACHE_EVENT_PARAMS, SerializationUtils.toJsonString(eventParamMap));
            }
            Map<String, String> cardPageMap = this.getCardPageMap();
            for (String cardId : cardIds) {
                String pageId = cardPageMap.get(cardId);
                IFormView view = this.getView().getView(pageId);
                if (view == null) continue;
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue(EVENTID, eventId);
                view.invokeOperation(HANDLEEVENT, operateOption);
                this.getView().sendFormAction(view);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addEventListener(String ... eventIds) {
        try (DLock dLock = DLock.create((String)this.getView().getFormShowParameter().getParentPageId());){
            dLock.lock();
            IPageCache parentPageCache = this.getParentPageCache();
            String cacheRegisterEvents = parentPageCache.get(CACHE_REGISTER_EVENTS);
            Map<String, List> cardEventMap = new HashMap();
            if (!StringUtils.isEmpty((String)cacheRegisterEvents)) {
                cardEventMap = (Map)SerializationUtils.fromJsonString((String)cacheRegisterEvents, Map.class);
            }
            String cardId = this.getCardId();
            for (String eventId : eventIds) {
                List cardIds = cardEventMap.computeIfAbsent(eventId, key -> new ArrayList());
                if (cardIds.contains(cardId)) continue;
                cardIds.add(cardId);
            }
            parentPageCache.put(CACHE_REGISTER_EVENTS, SerializationUtils.toJsonString(cardEventMap));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (HANDLEEVENT.equals(operateKey)) {
            Map cacheEventParams;
            FormOperate operate = (FormOperate)afterDoOperationEventArgs.getSource();
            String eventId = operate.getOption().getVariableValue(EVENTID);
            IPageCache parentPageCache = this.getParentPageCache();
            String eventParamStr = parentPageCache.get(CACHE_EVENT_PARAMS);
            Map<String, Object> eventParams = new HashMap<String, Object>();
            if (StringUtils.isNotEmpty((String)eventParamStr) && (cacheEventParams = (Map)SerializationUtils.fromJsonString((String)eventParamStr, Map.class)).containsKey(eventId)) {
                eventParams = (Map)cacheEventParams.get(eventId);
            }
            this.handleEvent(eventId, eventParams);
        }
    }

    protected void handleEvent(String eventId, Map<String, Object> eventParams) {
    }
}

