/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.workbench.formplugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Base64;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.mpscmm.msbd.workbench.pojo.IdentifyResultInfo;

public class ImageScannerFormPlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(ImageScannerFormPlugin.class);
    public static final String BASE64PREFIX = "data:image/png;base64,";
    public static final String ID = "id";
    public static final String CONFIRM = "confirm";
    public static final String ATTACHMENTPANELAP = "attachmentpanelap";
    public static final String URL = "url";
    public static final String MPSCMM_MSBD_WORKBENCH = "mpscmm-msbd-workbench";
    public static final long PROMPT_ID = 1924707637841124352L;

    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        try {
            String operateKey;
            OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
            if (operationResult.isSuccess() && CONFIRM.equals(operateKey = afterDoOperationEventArgs.getOperateKey())) {
                this.confirmIdentifyBills();
            }
        }
        catch (KDBizException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u51fa\u73b0\u672a\u77e5\u5f02\u5e38\uff0c\u8bf7\u4e0e\u7ba1\u7406\u5458\u8054\u7cfb\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a{0}\u3002", (String)"MpscmmCommonMsg_0", (String)MPSCMM_MSBD_WORKBENCH, (Object[])new Object[]{e.getMessage()}));
        }
    }

    private void confirmIdentifyBills() {
        this.checkAttachment();
        List<IdentifyResultInfo> identifyResultInfos = this.identifyImages();
        this.getView().returnDataToParent(identifyResultInfos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<IdentifyResultInfo> identifyImages() {
        AttachmentPanel picturePanel = (AttachmentPanel)this.getControl(ATTACHMENTPANELAP);
        List attachmentDataList = picturePanel.getAttachmentData();
        ArrayList<IdentifyResultInfo> resultInfos = new ArrayList<IdentifyResultInfo>();
        int rate = 0;
        int upRate = 100 / attachmentDataList.size();
        try {
            for (int i = 0; i < attachmentDataList.size(); ++i) {
                this.getView().showProgressLoading(new LocaleString(ResManager.loadKDString((String)"\u6b63\u5728\u8bc6\u522b\u7b2c{0}\u5f20\u56fe\u7247...", (String)"ImageScannerFormPlugin_12", (String)MPSCMM_MSBD_WORKBENCH, (Object[])new Object[]{i + 1})), rate);
                Map attachmentData = (Map)attachmentDataList.get(i);
                resultInfos.add(this.identifyImage((String)attachmentData.get(URL)));
                rate += upRate;
            }
            this.getView().showProgressLoading(new LocaleString(ResManager.loadKDString((String)"\u8bc6\u522b\u5b8c\u6210\u3002", (String)"ImageScannerFormPlugin_15", (String)MPSCMM_MSBD_WORKBENCH, (Object[])new Object[0])), 100);
        }
        finally {
            this.getView().hideLoading();
        }
        return resultInfos;
    }

    private IdentifyResultInfo identifyImage(String imageUrl) {
        ResultInfo originResult = this.getOcrResult(imageUrl);
        String ocrResult = originResult.getIdentifyResult();
        String errorMsg = originResult.getErrorMsg();
        String gptResult = null;
        if (StringUtils.isBlank((CharSequence)errorMsg) && StringUtils.isNotBlank((CharSequence)ocrResult)) {
            ResultInfo gptResultInfo = this.getGptResult(ocrResult);
            gptResult = gptResultInfo.getIdentifyResult();
            errorMsg = gptResultInfo.getErrorMsg();
        }
        if (StringUtils.isBlank((CharSequence)errorMsg) && StringUtils.isNotBlank(gptResult)) {
            return new IdentifyResultInfo(imageUrl, ocrResult, gptResult, errorMsg, true);
        }
        return new IdentifyResultInfo(imageUrl, ocrResult, gptResult, errorMsg, false);
    }

    private ResultInfo getGptResult(String ocrResult) {
        String gptResult = null;
        StringBuilder errorBuilder = new StringBuilder();
        Map<String, Object> result = this.invokeGptService(ocrResult);
        if (result != null && !result.isEmpty()) {
            boolean status;
            boolean bl = status = result.get("status") != null && (Boolean)result.get("status") != false;
            if (status) {
                gptResult = (String)((Map)result.get("data")).get("llmValue");
                gptResult = gptResult.replace("```json", "").replace("```", "");
            } else {
                errorBuilder.append(ResManager.loadKDString((String)"\u8c03\u7528gpt\u670d\u52a1\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{0}", (String)"ImageScannerFormPlugin_2", (String)MPSCMM_MSBD_WORKBENCH, (Object[])new Object[]{result.get("errMsg")}));
                return new ResultInfo(null, errorBuilder.toString());
            }
        }
        if (StringUtils.isBlank(gptResult)) {
            errorBuilder.append(ResManager.loadKDString((String)"gpt\u8fd4\u56de\u5185\u5bb9\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5gpt\u63d0\u793a\u914d\u7f6e\u3002", (String)"ImageScannerFormPlugin_8", (String)MPSCMM_MSBD_WORKBENCH, (Object[])new Object[0]));
            return new ResultInfo(gptResult, errorBuilder.toString());
        }
        JSONArray jsonArray = new JSONArray();
        try {
            jsonArray = JSON.parseArray(gptResult);
        }
        catch (Exception e) {
            try {
                JSONObject jsonObject = JSON.parseObject(gptResult);
                jsonArray.add((Object)jsonObject);
            }
            catch (Exception ex) {
                logger.error("gpt\u8fd4\u56dejson\u89e3\u6790\u9519\u8bef", (Throwable)ex);
                errorBuilder.append(ResManager.loadKDString((String)"gpt\u8fd4\u56de\u4fe1\u606f\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\u56fe\u7247\u5185\u5bb9\u548cgpt\u63d0\u793a\u914d\u7f6e\u3002", (String)"ImageScannerFormPlugin_9", (String)MPSCMM_MSBD_WORKBENCH, (Object[])new Object[0]));
                return new ResultInfo(gptResult, errorBuilder.toString());
            }
        }
        if (jsonArray != null && jsonArray.isEmpty()) {
            errorBuilder.append(ResManager.loadKDString((String)"gpt\u672a\u8bc6\u522b\u5230\u6536\u8d27\u5355\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u56fe\u7247\u5185\u5bb9\u662f\u5426\u4e3a\u6536\u8d27\u5355\u3002", (String)"ImageScannerFormPlugin_10", (String)MPSCMM_MSBD_WORKBENCH, (Object[])new Object[0]));
        }
        return new ResultInfo(gptResult, errorBuilder.toString());
    }

    private Map<String, Object> invokeGptService(String ocrResult) {
        HashMap varMap = new HashMap(0);
        return (Map)DispatchServiceHelper.invokeBizService((String)"ai", (String)"gai", (String)"GaiPromptService", (String)"syncCall", (Object[])new Object[]{1924707637841124352L, ocrResult, varMap});
    }

    private ResultInfo getOcrResult(String imageUrl) {
        String imgBase64 = this.getImgBase64(imageUrl);
        String result = this.invokeOcrService(imgBase64);
        String ocrResult = null;
        StringBuilder errorBuilder = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)result)) {
            Map resultMap = (Map)JSON.parseObject((String)result, Map.class);
            if (resultMap.get("errorCode") != null && !"0".equals(resultMap.get("errorCode").toString())) {
                String errorInfo = "";
                if (resultMap.get("message") != null) {
                    errorInfo = resultMap.get("message").toString();
                } else if (resultMap.get("description") != null) {
                    errorInfo = resultMap.get("description").toString();
                } else if (resultMap.get("error_desc") != null) {
                    errorInfo = resultMap.get("error_desc").toString();
                }
                errorBuilder.append(ResManager.loadKDString((String)"\u56fe\u7247\u8bc6\u522b\u5931\u8d25\uff0c\u5931\u8d25\u4fe1\u606f\uff1a{0}", (String)"ImageScannerFormPlugin_3", (String)MPSCMM_MSBD_WORKBENCH, (Object[])new Object[]{errorInfo}));
            } else {
                ocrResult = (String)((Map)resultMap.get("data")).get("combined_result");
                if (StringUtils.isBlank((CharSequence)ocrResult)) {
                    errorBuilder.append(ResManager.loadKDString((String)"\u56fe\u7247\u8bc6\u522b\u7ed3\u679c\u4e3a\u7a7a\uff0c\u6362\u4e2a\u56fe\u7247\u8bd5\u8bd5\u3002", (String)"ImageScannerFormPlugin_17", (String)MPSCMM_MSBD_WORKBENCH, (Object[])new Object[0]));
                } else {
                    ocrResult = ocrResult.replace(",", "");
                }
            }
        }
        return new ResultInfo(ocrResult, errorBuilder.toString());
    }

    private String invokeOcrService(String imgBase64) {
        return (String)DispatchServiceHelper.invokeBizService((String)"ai", (String)"cvp", (String)"OcrService", (String)"distinguishOcrImage", (Object[])new Object[]{"msbd_ocr_createbill", "OPM-GeneralSpotting", imgBase64});
    }

    private String getImgBase64(String imageUrl) {
        String imgBase64;
        TempFileCache tempFileCache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        try (InputStream inputStream = tempFileCache.getInputStream(imageUrl);
             ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            int bytesRead;
            byte[] buffer = new byte[1024];
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                bos.write(buffer, 0, bytesRead);
            }
            byte[] imageBytes = bos.toByteArray();
            imgBase64 = BASE64PREFIX + Base64.getEncoder().encodeToString(imageBytes);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u56fe\u7247\u5931\u8d25", (Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u56fe\u7247\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20\u540e\u91cd\u8bd5\u3002", (String)"ImageScannerFormPlugin_11", (String)MPSCMM_MSBD_WORKBENCH, (Object[])new Object[0]));
        }
        return imgBase64;
    }

    private void checkAttachment() {
        boolean pictureEmpty;
        AttachmentPanel picturePanel = (AttachmentPanel)this.getControl(ATTACHMENTPANELAP);
        List attachmentData = picturePanel.getAttachmentData();
        boolean bl = pictureEmpty = attachmentData == null || attachmentData.isEmpty();
        if (pictureEmpty) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u4e0a\u4f20\u56fe\u7247\u3002", (String)"ImageScannerFormPlugin_0", (String)MPSCMM_MSBD_WORKBENCH, (Object[])new Object[0]));
        }
    }

    static class ResultInfo {
        private String identifyResult;
        private String errorMsg;

        public ResultInfo(String identifyResult, String errorMsg) {
            this.identifyResult = identifyResult;
            this.errorMsg = errorMsg;
        }

        public String getIdentifyResult() {
            return this.identifyResult;
        }

        public String getErrorMsg() {
            return this.errorMsg;
        }
    }
}

