/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.workbench.formplugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.botp.runtime.SourceBillReport;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageTypes;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Image;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.UnitConvertHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mpscmm.msbd.algorithm.business.helper.AlgorithmHelper;
import kd.mpscmm.msbd.workbench.pojo.IdentifyResultInfo;
import kd.mpscmm.msbd.workbench.util.IdentifyUtils;

public class OcrCreateBillPlugin
extends AbstractFormPlugin
implements RowClickEventListener,
BeforeF7SelectListener {
    public static final String ID = "id";
    public static final String MPSCMM_MSBD_WORKBENCH = "mpscmm-msbd-workbench";
    public static final String BILLENTRY = "billentry";
    public static final String BILLNO = "billno";
    public static final String QTY = "qty";
    public static final String IM_PURRECEIVEBILL = "im_purreceivebill";
    public static final String PM_PURORDERBILL = "pm_purorderbill";
    private static final Log logger = LogFactory.getLog(OcrCreateBillPlugin.class);
    public static final String SUFFIX = "_ocr";
    public static final String MATERIAL = "material";
    public static final String WAREHOUSE = "warehouse";
    public static final String NUMBER = "number";
    public static final String SEQ = "seq";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entry = (EntryGrid)this.getControl("entryentity");
        entry.addRowClickListener((RowClickEventListener)this);
        BasedataEdit unit = (BasedataEdit)this.getControl("unit");
        unit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String propName = evt.getProperty().getName();
        IdentifyUtils.executeWithCatchException(() -> {
            if ("unit".equals(propName)) {
                this.beforeUnitSelect(evt);
            }
        });
    }

    private void beforeUnitSelect(BeforeF7SelectEvent evt) {
        int row = evt.getRow();
        FormShowParameter formParam = evt.getFormShowParameter();
        Object material = this.getModel().getValue(MATERIAL, row);
        if (material instanceof DynamicObject && formParam instanceof ListShowParameter) {
            long materialId = ((DynamicObject)material).getLong(ID);
            long baseUnitId = ((DynamicObject)material).getLong("baseunit.id");
            List unitIds = BaseDataServiceHelper.getAssistMUListResult((Long)materialId, (Long)baseUnitId, (String)"1", (Boolean)Boolean.TRUE);
            QFilter qFilter = new QFilter(ID, "in", (Object)unitIds);
            ((ListShowParameter)formParam).getListFilterParameter().setFilter(qFilter);
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        IdentifyUtils.executeWithCatchException(() -> {
            String key;
            Object source = evt.getSource();
            if (source instanceof Control && "entryentity".equals(key = ((Control)source).getKey())) {
                int index = evt.getRow();
                this.showImage(index);
            }
        });
    }

    private void showImage(int index) {
        String picture;
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"imageap"});
        if (index >= 0 && StringUtils.isNotBlank((CharSequence)(picture = (String)this.getModel().getValue("picture", index)))) {
            Image image = (Image)this.getControl("imageap");
            image.setUrl(picture);
        }
    }

    public void afterCreateNewData(EventObject e) {
        IdentifyUtils.executeWithCatchException(() -> {
            this.buildEntry();
            DynamicObjectCollection entries = this.getModel().getEntryEntity("entryentity");
            if (entries != null && !entries.isEmpty()) {
                this.showImage(0);
            }
        });
    }

    private void buildEntry() {
        JSONArray jsonResult = (JSONArray)this.getView().getFormShowParameter().getCustomParam("identifyresult");
        IdentifyResultInfo[] identifyResultInfos = (IdentifyResultInfo[])JSON.toJavaObject((JSON)jsonResult, IdentifyResultInfo[].class);
        if (identifyResultInfos == null) {
            return;
        }
        this.getModel().deleteEntryData("entryentity");
        for (IdentifyResultInfo identifyResult : identifyResultInfos) {
            String resultJson = identifyResult.getGptResult();
            boolean success = identifyResult.isSuccess();
            if (!success) {
                int index = this.getModel().createNewEntryRow("entryentity");
                this.getModel().setValue("picture", (Object)identifyResult.getImgUrl(), index);
                this.getModel().setValue("ocrresult", (Object)identifyResult.getOcrResult(), index);
                this.getModel().setValue("gptresult", (Object)identifyResult.getGptResult(), index);
                this.getModel().setValue("erromsg", (Object)identifyResult.getErrMsg(), index);
                continue;
            }
            JSONArray jsonArray = new JSONArray();
            try {
                jsonArray = JSON.parseArray((String)resultJson);
            }
            catch (Exception e) {
                JSONObject jsonObject = JSON.parseObject((String)resultJson);
                jsonArray.add((Object)jsonObject);
            }
            int[] indexes = this.getModel().batchCreateNewEntryRow("entryentity", jsonArray.size());
            EntityType dataEntityType = (EntityType)this.getModel().getDataEntityType().getAllEntities().get("entryentity");
            Map allFields = dataEntityType.getFields();
            for (int i = 0; i < jsonArray.size(); ++i) {
                int index = indexes[i];
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                this.getModel().setValue("picture", (Object)identifyResult.getImgUrl(), index);
                this.getModel().setValue("ocrresult", (Object)identifyResult.getOcrResult(), index);
                this.getModel().setValue("gptresult", (Object)identifyResult.getGptResult(), index);
                for (Map.Entry jsonEntry : jsonObject.entrySet()) {
                    try {
                        String fieldKey = (String)jsonEntry.getKey();
                        Object fieldValue = jsonEntry.getValue();
                        if (!allFields.containsKey(fieldKey) || fieldValue == null) continue;
                        IDataEntityProperty property = (IDataEntityProperty)allFields.get(fieldKey);
                        if (property instanceof DecimalProp) {
                            try {
                                fieldValue = new BigDecimal(fieldValue.toString());
                            }
                            catch (Exception ex) {
                                fieldValue = BigDecimal.ZERO;
                            }
                        }
                        if (allFields.containsKey(fieldKey + SUFFIX)) {
                            this.getModel().setValue(fieldKey + SUFFIX, fieldValue, index);
                        }
                        if (property instanceof BasedataProp) {
                            String baseEntityId = ((BasedataProp)property).getBaseEntityId();
                            fieldValue = this.getMostMatchValue(baseEntityId, fieldValue);
                        }
                        this.getModel().setValue(fieldKey, fieldValue, index);
                    }
                    catch (Exception ex) {
                        logger.error((Throwable)ex);
                    }
                }
            }
        }
    }

    private long getMostMatchValue(String baseEntityId, Object fieldValue) {
        QFilter statusFilter;
        if (StringUtils.isBlank((Object)fieldValue)) {
            return 0L;
        }
        QFilter filter = new QFilter("groupkey", "=", (Object)baseEntityId).and("ocrresult", "=", (Object)fieldValue.toString());
        DynamicObject ocrResultMapInfo = QueryServiceHelper.queryOne((String)"msbd_ocr_resultmap", (String)"finalresult", (QFilter[])filter.toArray());
        if (ocrResultMapInfo != null && ocrResultMapInfo.getLong("finalresult") != 0L) {
            return ocrResultMapInfo.getLong("finalresult");
        }
        filter = new QFilter("name", "=", fieldValue).or(NUMBER, "=", fieldValue);
        DynamicObject materialInfo = QueryServiceHelper.queryOne((String)baseEntityId, (String)ID, (QFilter[])new QFilter[]{filter, statusFilter = new QFilter("enable", "=", (Object)"1")});
        if (materialInfo != null) {
            return materialInfo.getLong(ID);
        }
        return 0L;
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if (operationResult != null && !operationResult.isSuccess()) {
            return;
        }
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        IdentifyUtils.executeWithCatchException(() -> {
            if ("confirmgen".equals(operateKey)) {
                this.confirmGenBill();
            }
        });
    }

    private void confirmGenBill() {
        this.checkEntryEmpty();
        HashMap<String, List<DynamicObject>> billMap = new HashMap<String, List<DynamicObject>>(16);
        DynamicObjectCollection purOrders = this.getOrderCollection(billMap);
        if (purOrders.isEmpty()) {
            return;
        }
        List<DynamicObject> purReceiveBills = this.genPurReceive(purOrders);
        this.saveOcrMap();
        Map<Long, DynamicObject> entryMap = this.handleAfterTrans(billMap, purReceiveBills);
        String errorMsg = this.checkPurReceiveBills(entryMap, purReceiveBills);
        if (!StringUtils.isBlank((CharSequence)errorMsg)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u6570\u636e\u6821\u9a8c\u4e0d\u901a\u8fc7\u3002", (String)"OcrCreateBillPlugin_3", (String)MPSCMM_MSBD_WORKBENCH, (Object[])new Object[0]), errorMsg, MessageTypes.Default);
            return;
        }
        this.getView().returnDataToParent(purReceiveBills);
        this.getView().close();
    }

    private String checkPurReceiveBills(Map<Long, DynamicObject> entryMap, List<DynamicObject> purReceiveBills) {
        StringBuilder errorBuilder = new StringBuilder(100);
        Map<Long, Set<Long>> orgWarehouseMap = this.getOrgWarehouseMap(purReceiveBills);
        HashMap<Long, Set> matUnitMap = new HashMap<Long, Set>(16);
        for (DynamicObject purReceiveBill : purReceiveBills) {
            DynamicObjectCollection entries = purReceiveBill.getDynamicObjectCollection(BILLENTRY);
            for (DynamicObject entry : entries) {
                Set<Long> warehouseSet;
                DynamicObject warehouse;
                DynamicObject ocrEntryInfo = entryMap.get(entry.getLong(ID));
                if (ocrEntryInfo == null) continue;
                long materialId = entry.getLong("material.masterid.id");
                long baseUnitId = entry.getLong("material.masterid.baseunit.id");
                long unitId = entry.getLong("unit.id");
                Set unitIds = matUnitMap.computeIfAbsent(materialId, k -> new HashSet(BaseDataServiceHelper.getAssistMUListResult((Long)materialId, (Long)baseUnitId, (String)"1", (Boolean)Boolean.TRUE)));
                if (!unitIds.contains(unitId)) {
                    if (errorBuilder.length() > 0) {
                        errorBuilder.append("\n");
                    }
                    errorBuilder.append(ResManager.loadKDString((String)"\u7b2c{0}\u884c\u5206\u5f55\uff0c\u8ba1\u91cf\u5355\u4f4d\u4e0e\u7269\u6599\u57fa\u672c\u8ba1\u91cf\u5355\u4f4d\u4e0d\u5b58\u5728\u56fa\u5b9a\u6362\u7b97\u7387\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"OcrCreateBillPlugin_4", (String)MPSCMM_MSBD_WORKBENCH, (Object[])new Object[]{ocrEntryInfo.get(SEQ)}));
                }
                if ((warehouse = entry.getDynamicObject(WAREHOUSE)) == null || (warehouseSet = orgWarehouseMap.get(purReceiveBill.getLong("org.id"))) != null && warehouseSet.contains(warehouse.getLong(ID))) continue;
                if (errorBuilder.length() > 0) {
                    errorBuilder.append("\n");
                }
                errorBuilder.append(ResManager.loadKDString((String)"\u7b2c{0}\u884c\u5206\u5f55\uff0c\u4ed3\u5e93\u5728\u5f53\u524d\u5e93\u5b58\u7ec4\u7ec7\u4e0b\u4e0d\u53ef\u7528\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"OcrCreateBillPlugin_2", (String)MPSCMM_MSBD_WORKBENCH, (Object[])new Object[]{ocrEntryInfo.get(SEQ)}));
            }
        }
        return errorBuilder.toString();
    }

    private List<DynamicObject> getOcrEntryInfo(Map<String, List<DynamicObject>> billMap, DynamicObject entry) {
        String orderBillNumber = entry.getString("srcbillnumber");
        String materialNumber = entry.getDynamicObject(MATERIAL).getDynamicObject("masterid").getString(NUMBER);
        if (StringUtils.isBlank((CharSequence)orderBillNumber) || StringUtils.isBlank((CharSequence)materialNumber)) {
            return null;
        }
        return billMap.get(orderBillNumber + materialNumber);
    }

    private Map<Long, Set<Long>> getOrgWarehouseMap(List<DynamicObject> purReceiveBills) {
        HashSet<Long> orgIds = new HashSet<Long>();
        HashSet<Long> warehouseIds = new HashSet<Long>();
        for (DynamicObject purReceiveBill : purReceiveBills) {
            DynamicObject org = purReceiveBill.getDynamicObject("org");
            if (org != null) {
                orgIds.add(org.getLong(ID));
            }
            DynamicObjectCollection entries = purReceiveBill.getDynamicObjectCollection(BILLENTRY);
            for (DynamicObject entry : entries) {
                DynamicObject warehouse = entry.getDynamicObject(WAREHOUSE);
                if (warehouse == null) continue;
                warehouseIds.add(warehouse.getLong(ID));
            }
        }
        HashMap<Long, Set<Long>> orgWarehouseMap = new HashMap<Long, Set<Long>>(8);
        if (!warehouseIds.isEmpty() && !orgIds.isEmpty()) {
            QFilter filter = new QFilter("org", "in", (Object)orgIds.toArray()).and("startstatus", "=", (Object)"B").and(WAREHOUSE, "in", warehouseIds);
            String selects = "org,warehouse";
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)OcrCreateBillPlugin.class.getName(), (String)"im_warehousesetup", (String)selects, (QFilter[])new QFilter[]{filter}, (String)"");
            Object object = null;
            try {
                for (Row row : dataSet) {
                    Long orgId = row.getLong("org");
                    orgWarehouseMap.computeIfAbsent(orgId, k -> new HashSet()).add(row.getLong(WAREHOUSE));
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (dataSet != null) {
                    if (object != null) {
                        try {
                            dataSet.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        dataSet.close();
                    }
                }
            }
        }
        return orgWarehouseMap;
    }

    private Map<Long, DynamicObject> handleAfterTrans(Map<String, List<DynamicObject>> billMap, List<DynamicObject> purReceiveBills) {
        EntityType entryEntity = (EntityType)this.getModel().getDataEntityType().getAllEntities().get("entryentity");
        Map fields = entryEntity.getFields();
        Map allEntities = MetadataServiceHelper.getDataEntityType((String)IM_PURRECEIVEBILL).getAllEntities();
        Map headFields = ((EntityType)allEntities.get(IM_PURRECEIVEBILL)).getFields();
        Map entryFields = ((EntityType)allEntities.get(BILLENTRY)).getFields();
        HashSet<String> headKeys = new HashSet<String>();
        HashSet<String> entryKeys = new HashSet<String>();
        for (String field : fields.keySet()) {
            if (headFields.containsKey(field)) {
                headKeys.add(field);
                continue;
            }
            if (!entryFields.containsKey(field)) continue;
            entryKeys.add(field);
        }
        entryKeys.remove(MATERIAL);
        StringBuilder errBuilder = new StringBuilder();
        CloneUtils cloneUtils = new CloneUtils(false, true);
        HashMap<Long, DynamicObject> entryMap = new HashMap<Long, DynamicObject>();
        for (DynamicObject purReceiveBill : purReceiveBills) {
            DynamicObjectCollection billEntries = purReceiveBill.getDynamicObjectCollection(BILLENTRY);
            int size = billEntries.size();
            for (int index = 0; index < size; ++index) {
                DynamicObject billEntry = (DynamicObject)billEntries.get(index);
                List<DynamicObject> ocrEntryInfos = this.getOcrEntryInfo(billMap, billEntry);
                if (ocrEntryInfos == null || ocrEntryInfos.isEmpty()) continue;
                Iterator<DynamicObject> iterator = ocrEntryInfos.iterator();
                int i = 0;
                while (iterator.hasNext()) {
                    if (i > 0) {
                        billEntry = (DynamicObject)cloneUtils.clone((IDataEntityBase)billEntry);
                        long newEntryId = DB.genGlobalLongId();
                        billEntry.set(ID, (Object)newEntryId);
                        billEntries.add((Object)billEntry);
                    }
                    DynamicObject ocrEntryInfo = iterator.next();
                    ++i;
                    entryMap.put(billEntry.getLong(ID), ocrEntryInfo);
                    for (String headKey : headKeys) {
                        purReceiveBill.set(headKey, ocrEntryInfo.get(headKey));
                    }
                    for (String entryKey : entryKeys) {
                        boolean enableLot;
                        billEntry.set(entryKey, ocrEntryInfo.get(entryKey));
                        if (!"lotnumber".equals(entryKey) || (enableLot = billEntry.getBoolean("material.enablelot"))) continue;
                        billEntry.set("lotnumber", null);
                    }
                    this.reCalEntry(errBuilder, billEntry);
                    iterator.remove();
                }
            }
        }
        if (errBuilder.length() > 0) {
            throw new KDBizException(errBuilder.toString());
        }
        return entryMap;
    }

    private void reCalEntry(StringBuilder errBuilder, DynamicObject billEntry) {
        Map changePropMaps = AlgorithmHelper.entryCalculate((String)IM_PURRECEIVEBILL, (DynamicObject)billEntry, (String)QTY);
        if (changePropMaps != null && !changePropMaps.isEmpty()) {
            for (Map.Entry changePropEntry : changePropMaps.entrySet()) {
                String key = (String)changePropEntry.getKey();
                Object value = changePropEntry.getValue();
                billEntry.set(key, value);
            }
        }
        BigDecimal qty = billEntry.getBigDecimal(QTY);
        long materialId = billEntry.getLong("material.masterid.id");
        long unitId = billEntry.getLong("unit.id");
        long baseUnitId = billEntry.getLong("baseunit.id");
        long unit2ndId = billEntry.getLong("unit2nd.id");
        if (qty != null && materialId != 0L && unitId != 0L && baseUnitId != 0L) {
            BigDecimal baseQty = UnitConvertHelper.calculateNewQty((BigDecimal)qty, (Long)baseUnitId, (Long)unitId, (Long)materialId, (StringBuilder)errBuilder);
            billEntry.set("baseqty", (Object)baseQty);
            if (unit2ndId != 0L) {
                BigDecimal qty2nd = UnitConvertHelper.calculateNewQty((BigDecimal)baseQty, (Long)unit2ndId, (Long)baseUnitId, (Long)materialId, (StringBuilder)errBuilder);
                billEntry.set("qtyunit2nd", (Object)qty2nd);
            }
        }
    }

    private List<DynamicObject> genPurReceive(DynamicObjectCollection purOrders) {
        ConvertOperationResult convertResult;
        ArrayList<ListSelectedRow> rows = new ArrayList<ListSelectedRow>();
        for (DynamicObject purOrder : purOrders) {
            ListSelectedRow row = new ListSelectedRow();
            row.setPrimaryKeyValue((Object)purOrder.getLong(ID));
            long entryId = purOrder.getLong("billentry.id");
            row.setEntryPrimaryKeyValue((Object)entryId);
            row.setEntryEntityKey(BILLENTRY);
            rows.add(row);
        }
        String botpRule = (String)this.getView().getFormShowParameter().getCustomParam("botprule");
        PushArgs args = new PushArgs();
        args.setSelectedRows(rows);
        args.setSourceEntityNumber(PM_PURORDERBILL);
        args.setTargetEntityNumber(IM_PURRECEIVEBILL);
        if (StringUtils.isNotBlank((CharSequence)botpRule)) {
            args.setRuleId(botpRule);
        }
        if (!(convertResult = ConvertServiceHelper.push((PushArgs)args)).isSuccess()) {
            StringBuilder errorMsgBuilder = new StringBuilder();
            if (!StringUtils.isEmpty((CharSequence)convertResult.getMessage())) {
                errorMsgBuilder.append(convertResult.getMessage()).append("\n");
            }
            if (convertResult.getBillReports() != null && !convertResult.getBillReports().isEmpty()) {
                for (SourceBillReport billReport : convertResult.getBillReports()) {
                    errorMsgBuilder.append(billReport.getRowInfo());
                    errorMsgBuilder.append(billReport.getFailMessage()).append("\n");
                }
            }
            throw new KDBizException(errorMsgBuilder.toString());
        }
        MainEntityType purReceiveType = MetadataServiceHelper.getDataEntityType((String)IM_PURRECEIVEBILL);
        return convertResult.loadTargetDataObjects(BusinessDataReader::loadRefence, purReceiveType);
    }

    private void checkEntryEmpty() {
        DynamicObject bill = this.getModel().getDataEntity();
        DynamicObjectCollection entries = bill.getDynamicObjectCollection("entryentity");
        if (entries == null || entries.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5206\u5f55\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u4e0a\u4f20\u56fe\u7247\u5e76\u70b9\u51fb\u667a\u80fd\u8bc6\u522b\u540e\u518d\u8bd5\u3002", (String)"OcrCreateBillPlugin_5", (String)MPSCMM_MSBD_WORKBENCH, (Object[])new Object[0]));
        }
    }

    private DynamicObjectCollection getOrderCollection(Map<String, List<DynamicObject>> billMap) {
        DynamicObject bill = this.getModel().getDataEntity();
        DynamicObjectCollection entries = bill.getDynamicObjectCollection("entryentity");
        HashSet<String> orderNums = new HashSet<String>();
        HashSet<String> materialNums = new HashSet<String>();
        for (DynamicObject entry : entries) {
            String orderNum = entry.getString("ordernum");
            String materialNum = entry.getDynamicObject(MATERIAL).getString(NUMBER);
            orderNums.add(orderNum);
            materialNums.add(materialNum);
            billMap.computeIfAbsent(orderNum + (String)materialNum, k -> new ArrayList()).add(entry);
        }
        QFilter filter = new QFilter(BILLNO, "in", orderNums).and("billentry.material.masterid.number", "in", materialNums);
        DynamicObjectCollection purOrders = QueryServiceHelper.query((String)PM_PURORDERBILL, (String)"id,billentry.id,billno,billentry.material.masterid.number", (QFilter[])filter.toArray());
        HashMap<String, DynamicObject> orderInfoMap = new HashMap<String, DynamicObject>(purOrders.size());
        for (DynamicObject purOrder : purOrders) {
            orderInfoMap.put(purOrder.getString(BILLNO) + purOrder.getString("billentry.material.masterid.number"), purOrder);
        }
        DynamicObjectCollection result = new DynamicObjectCollection();
        StringBuilder errorInfo = new StringBuilder();
        for (Map.Entry<String, List<DynamicObject>> mapEntry : billMap.entrySet()) {
            String key = mapEntry.getKey();
            DynamicObject purOrder = (DynamicObject)orderInfoMap.get(key);
            if (purOrder == null) {
                if (errorInfo.length() > 0) {
                    errorInfo.append("\n");
                }
                List<DynamicObject> entrys = mapEntry.getValue();
                for (DynamicObject entry : entrys) {
                    String orderNum = entry.getString("ordernum");
                    String materialNum = entry.getDynamicObject(MATERIAL).getString(NUMBER);
                    String materialName = entry.getDynamicObject(MATERIAL).getString("name");
                    errorInfo.append(ResManager.loadKDString((String)"\u7b2c{0}\u884c\u5206\u5f55\uff0c\u6839\u636e\u8ba2\u5355\u7f16\u53f7\uff1a{1}\uff0c\u7269\u6599\uff1a{2}\uff08{3}\uff09\uff0c\u65e0\u6cd5\u83b7\u53d6\u5230\u91c7\u8d2d\u8ba2\u5355\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"OcrCreateBillPlugin_6", (String)MPSCMM_MSBD_WORKBENCH, (Object[])new Object[]{entry.get(SEQ), orderNum, materialNum, materialName}));
                }
                continue;
            }
            result.add((Object)purOrder);
        }
        if (errorInfo.length() > 0) {
            this.getView().showMessage(errorInfo.toString());
            return new DynamicObjectCollection();
        }
        return result;
    }

    private void saveOcrMap() {
        DynamicObject bill = this.getModel().getDataEntity();
        DynamicObjectCollection entries = bill.getDynamicObjectCollection("entryentity");
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)"msbd_ocr_resultmap");
        EntityType entryEntity = (EntityType)this.getModel().getDataEntityType().getAllEntities().get("entryentity");
        Map fields = entryEntity.getFields();
        HashMap<String, String> mapFields = new HashMap<String, String>(16);
        for (Map.Entry fieldEntry : fields.entrySet()) {
            String field = (String)fieldEntry.getKey();
            if (!fields.containsKey(field + SUFFIX) || !(fieldEntry.getValue() instanceof BasedataProp)) continue;
            mapFields.put(field, ((BasedataProp)fieldEntry.getValue()).getBaseEntityId());
        }
        HashSet<String> orcResultSet = new HashSet<String>();
        for (DynamicObject entry : entries) {
            for (Object field : mapFields.keySet()) {
                String ocrResult = entry.getString((String)field + SUFFIX);
                DynamicObject dynamicObject = entry.getDynamicObject((String)field);
                if (!StringUtils.isNotBlank((CharSequence)ocrResult) || dynamicObject == null) continue;
                orcResultSet.add(ocrResult);
            }
        }
        HashMap<String, Long> existResult = new HashMap<String, Long>(16);
        if (!orcResultSet.isEmpty()) {
            Object field;
            QFilter filter = new QFilter("ocrresult", "in", orcResultSet);
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"msbd_ocr_resultmap", (String)"id,groupkey,ocrresult", (QFilter[])filter.toArray(), (String)"");
            field = null;
            try {
                for (Row row : dataSet) {
                    existResult.put(row.getString("groupkey") + row.getString("ocrresult"), row.getLong(ID));
                }
            }
            catch (Throwable throwable) {
                field = throwable;
                throw throwable;
            }
            finally {
                if (dataSet != null) {
                    if (field != null) {
                        try {
                            dataSet.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)field).addSuppressed(throwable);
                        }
                    } else {
                        dataSet.close();
                    }
                }
            }
        }
        String updateSql = "UPDATE T_MSBD_OCR_RESULTMAP SET FFINALRESULT = ? WHERE FID = ?";
        ArrayList<Object[]> updateParamList = new ArrayList<Object[]>();
        ArrayList<DynamicObject> ocrMapInfoList = new ArrayList<DynamicObject>();
        for (DynamicObject entry : entries) {
            for (Map.Entry fieldEntry : mapFields.entrySet()) {
                String field = (String)fieldEntry.getKey();
                String entity = (String)fieldEntry.getValue();
                String ocrResult = entry.getString(field + SUFFIX);
                DynamicObject dynamicObject = entry.getDynamicObject(field);
                if (!StringUtils.isNotBlank((CharSequence)ocrResult) || dynamicObject == null) continue;
                Long resultId = (Long)existResult.get(entity + ocrResult);
                if (resultId != null) {
                    Object[] param = new Object[]{dynamicObject.getString(ID), resultId};
                    updateParamList.add(param);
                    continue;
                }
                DynamicObject ocrMapInfo = new DynamicObject((DynamicObjectType)entityType);
                ocrMapInfo.set("groupkey", (Object)entity);
                ocrMapInfo.set("ocrresult", (Object)ocrResult);
                ocrMapInfo.set("finalresult", (Object)dynamicObject.getString(ID));
                ocrMapInfoList.add(ocrMapInfo);
            }
        }
        IdentifyUtils.executeWithTxNew(() -> {
            if (!updateParamList.isEmpty()) {
                DB.executeBatch((DBRoute)DBRoute.of((String)entityType.getDBRouteKey()), (String)updateSql, (List)updateParamList);
            }
            if (!ocrMapInfoList.isEmpty()) {
                SaveServiceHelper.save((DynamicObject[])ocrMapInfoList.toArray(new DynamicObject[0]));
            }
        });
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.removeTempImages();
    }

    private void removeTempImages() {
        DynamicObject bill = this.getModel().getDataEntity();
        DynamicObjectCollection entries = bill.getDynamicObjectCollection("entryentity");
        Set urls = entries.stream().map(entry -> entry.getString("picture")).filter(url -> StringUtils.isNotBlank((CharSequence)url)).collect(Collectors.toSet());
        TempFileCache tempFileCache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        for (String url2 : urls) {
            tempFileCache.remove(url2);
        }
    }
}

