/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.workbench.formplugin;

import com.alibaba.fastjson.JSONArray;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.AppMenuInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.ListboxItem;
import kd.bos.entity.tree.TreeNode;
import kd.bos.ext.form.control.Listbox;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.Icon;
import kd.bos.form.control.Label;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.Vector;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ListboxClickListener;
import kd.bos.form.control.events.ListboxEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Padding;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.IconAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.metadata.form.control.VectorAp;
import kd.bos.util.JSONUtils;
import kd.mpscmm.msbd.workbench.enums.MenuTypeEnum;
import kd.mpscmm.msbd.workbench.service.PortalMenuService;
import kd.mpscmm.msbd.workbench.service.TreeService;
import kd.mpscmm.msbd.workbench.service.impl.TreeServiceImpl;
import kd.mpscmm.msbd.workbench.util.CardUtils;
import kd.mpscmm.msbd.workbench.util.LeftTreeSearchUtil;
import kd.mpscmm.msbd.workbench.util.PortalUsableFuncUtil;
import org.apache.commons.lang.StringUtils;

public class QuickLaunchConfigPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener,
ListboxClickListener,
SearchEnterListener {
    public static final String PARENT_ID = "parentId";
    public static final String MENU_ID = "menuId";
    public static final String FORM_ID = "formId";
    public static final String PX = "600px";
    public static final String CENTER = "center";
    private static Log log = LogFactory.getLog(QuickLaunchConfigPlugin.class);
    public static final String SUFFIX_MENU = "|menu";
    public static final String MENU_PREFIX = "menu#";
    public static final String APP_PREFIX = "app#";
    public static final String CLOUD_PREFIX = "cloud#";
    public static final String ICON_PREFIX = "iconap";
    public static final String PANEL_PREFIX = "panelap";
    public static final String LABEL_PREFIX = "labelap";
    public static final String CARD_PREFIX = "cardap";
    public static final String VECTOR_PREFIX = "vectorap";
    public static final String PANEL_CONTAINER = "flexpanel_menucards";
    public static final String COUNT_LABEL = "label_count";
    public static final String DEFAULT_ICONURL = "/icons/pc/entrance/default_48_48.png";
    public static final String UNSELECT_FONT = "kdfont kdfont-fuxuankuangweixuanzhong_yuan";
    public static final String SELECTED_FONT = "kdfont kdfont-fuxuankuangxuanzhong_yuan";
    public static final String CLOUD_APP_TREE = "tree_cloudappmenu";
    public static final String SELECTED_NODE = "cache_selectedNode";
    private PortalMenuService menuService;
    private TreeService treeService = new TreeServiceImpl();

    public void initialize() {
        super.initialize();
        Listbox listbox = (Listbox)this.getControl("listboxap");
        ArrayList<ListboxItem> ListboxItems = new ArrayList<ListboxItem>();
        ListboxItem listboxItem = new ListboxItem("appfunc", ResManager.loadKDString((String)"\u5e94\u7528\u529f\u80fd", (String)"QuickLaunchConfigPlugin_0", (String)"mpscmm-msbd-workbench", (Object[])new Object[0]));
        ListboxItems.add(listboxItem);
        listboxItem = new ListboxItem("link", ResManager.loadKDString((String)"\u5916\u90e8\u94fe\u63a5", (String)"QuickLaunchConfigPlugin_1", (String)"mpscmm-msbd-workbench", (Object[])new Object[0]));
        ListboxItems.add(listboxItem);
        listbox.addItems(ListboxItems);
        this.menuService = new PortalMenuService(this.getPageCache());
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok", "btncancel", "icon_menu", "icon_link"});
        TreeView treeCloudAppMenu = (TreeView)this.getView().getControl(CLOUD_APP_TREE);
        treeCloudAppMenu.addTreeNodeClickListener((TreeNodeClickListener)this);
        Listbox listbox = (Listbox)this.getControl("listboxap");
        listbox.addListboxClickListener((ListboxClickListener)this);
        Search searchTreeNode = (Search)this.getControl("treenodesearch");
        searchTreeNode.addEnterListener((SearchEnterListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String menuStr = (String)this.getView().getFormShowParameter().getCustomParam("menuMap");
        if (kd.bos.util.StringUtils.isNotEmpty((String)menuStr)) {
            Map cacheMenuMap = (Map)SerializationUtils.fromJsonString((String)menuStr, Map.class);
            this.getPageCache().put(SELECTED_NODE, menuStr);
            Label count = (Label)this.getControl(COUNT_LABEL);
            count.setText(String.valueOf(cacheMenuMap.size()));
            this.getView().updateView(COUNT_LABEL);
        }
        this.initCloudAppTree();
    }

    private void initCloudAppTree() {
        PortalUsableFuncUtil portalUtil = new PortalUsableFuncUtil(log, this.getView());
        JSONArray resultApps = portalUtil.getUserHasPerApp();
        if (resultApps == null || resultApps.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u83b7\u53d6\u5230\u5e94\u7528\u3002", (String)"QuickLaunchConfigPlugin_2", (String)"mpscmm-msbd-workbench", (Object[])new Object[0]));
            return;
        }
        TreeNode rootNode = this.treeService.buildTree(resultApps);
        TreeView tree = (TreeView)this.getView().getControl(CLOUD_APP_TREE);
        tree.addNodes(rootNode.getChildren());
        String json = SerializationUtils.toJsonString((Object)rootNode);
        this.getPageCache().putBigObject("nodes", json);
        this.treeService.clickCurrentAppNode(this.getView(), CLOUD_APP_TREE, rootNode, this);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        Map map = (Map)e.getReturnData();
        if (map == null) {
            return;
        }
        String iconKey = (String)map.get("value");
        if ("callback_menu".equals(actionId)) {
            Icon iconMenu = (Icon)this.getControl("icon_menu");
            iconMenu.setIconKey(iconKey);
            this.getPageCache().put("cache_menuicon", iconKey);
        } else if ("callback_link".equals(actionId)) {
            if (kd.bos.util.StringUtils.isBlank((String)iconKey)) {
                return;
            }
            Icon iconLink = (Icon)this.getControl("icon_link");
            iconLink.setIconKey(iconKey);
            this.getPageCache().put("cache_linkIcon", iconKey);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = null;
        Object source = evt.getSource();
        if (source instanceof Control) {
            key = ((Control)source).getKey();
        }
        if (key == null) {
            return;
        }
        switch (key) {
            case "btnok": {
                Tab tab = (Tab)this.getControl("tabap");
                String curTabId = tab.getCurrentTab();
                ArrayList returnData = new ArrayList();
                if ("tabpage_appfunc".equals(curTabId)) {
                    String selStr = this.getPageCache().get(SELECTED_NODE);
                    if (kd.bos.util.StringUtils.isNotEmpty((String)selStr)) {
                        Map selMap = (Map)SerializationUtils.fromJsonString((String)selStr, Map.class);
                        for (Map.Entry entry : selMap.entrySet()) {
                            HashMap<String, String> returnMap = new HashMap<String, String>();
                            String menuId = this.getPageCache().get((String)entry.getKey());
                            if (kd.bos.util.StringUtils.isBlank((String)menuId)) {
                                menuId = (String)entry.getKey();
                            }
                            String appId = (String)entry.getValue();
                            returnMap.put("cache_sel_appId", appId);
                            returnMap.put("cache_sel_menuId", menuId);
                            returnMap.put("launchType", "launchType_menu");
                            returnData.add(returnMap);
                        }
                    }
                } else if ("tabpage_link".equals(curTabId)) {
                    Object value;
                    if (this.getModel().getValue("url") == null || kd.bos.util.StringUtils.isBlank((String)this.getModel().getValue("url").toString())) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u7f51\u5740\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"QuickLaunchConfigPlugin_3", (String)"mpscmm-msbd-workbench", (Object[])new Object[0]));
                        return;
                    }
                    String url = (String)this.getModel().getValue("url");
                    if (url.indexOf(".") < 0) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u7f51\u5740\u201d\u4e0d\u5408\u6cd5\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"QuickLaunchConfigPlugin_4", (String)"mpscmm-msbd-workbench", (Object[])new Object[0]));
                        return;
                    }
                    if (url.toLowerCase().indexOf("http://") < 0 && url.toLowerCase().indexOf("https://") < 0) {
                        this.getView().showTipNotification("\u201c\u7f51\u5740\u201d\u5fc5\u987b\u4ee5http://\u6216  https:// \u5f00\u5934\u3002");
                        return;
                    }
                    Object textValue = value = this.getModel().getValue("title");
                    if (value instanceof OrmLocaleValue) {
                        OrmLocaleValue ormLocaleValue = (OrmLocaleValue)value;
                        textValue = ormLocaleValue.getLocaleValue();
                    }
                    if (textValue == null) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u6807\u9898\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"QuickLaunchConfigPlugin_5", (String)"mpscmm-msbd-workbench", (Object[])new Object[0]));
                        return;
                    }
                    String s = null;
                    try {
                        s = JSONUtils.toString((Object)value);
                    }
                    catch (IOException e) {
                        log.error("JSONUtils toString error", (Throwable)e);
                    }
                    HashMap<String, String> returnMap = new HashMap<String, String>();
                    returnMap.put("launchType", "launchType_link");
                    returnMap.put("cache_linkUrl", url);
                    returnMap.put("cache_linkTitle", s);
                    returnMap.put("cache_linkIcon", this.getPageCache().get("cache_linkIcon"));
                    returnData.add(returnMap);
                }
                this.getView().returnDataToParent(returnData);
                this.getView().close();
                break;
            }
            case "icon_menu": {
                this.showImageSelForm("callback_menu");
                break;
            }
            case "icon_link": {
                this.showImageSelForm("callback_link");
                break;
            }
        }
        if (key.startsWith(VECTOR_PREFIX)) {
            Vector vectorIcon = (Vector)this.getView().getControl(key);
            String vectorUrl = this.getPageCache().get(key);
            String selStr = this.getPageCache().get(SELECTED_NODE);
            Map<String, String> selMap = null;
            if (kd.bos.util.StringUtils.isNotEmpty((String)selStr)) {
                selMap = (Map)SerializationUtils.fromJsonString((String)selStr, Map.class);
                if (selMap == null) {
                    selMap = new HashMap();
                }
            } else {
                selMap = new HashMap();
            }
            Label countLabel = (Label)this.getControl(COUNT_LABEL);
            if (kd.bos.util.StringUtils.isBlank((String)vectorUrl) || UNSELECT_FONT.equals(vectorUrl)) {
                vectorIcon.setFontClass(SELECTED_FONT);
                this.getPageCache().put(key, SELECTED_FONT);
                TreeView cloudAppTree = (TreeView)this.getControl(CLOUD_APP_TREE);
                Map focusNode = cloudAppTree.getTreeState().getFocusNode();
                if (focusNode == null) {
                    log.error("QuickLaunchConfigPlugin click focusNode is null");
                    return;
                }
                String appId = focusNode.get("id").toString();
                selMap.put(key.substring(VECTOR_PREFIX.length()), appId);
                countLabel.setText(String.valueOf(selMap.size()));
                this.getView().updateView(COUNT_LABEL);
            } else {
                vectorIcon.setFontClass(UNSELECT_FONT);
                this.getPageCache().put(key, UNSELECT_FONT);
                selMap.remove(key.substring(VECTOR_PREFIX.length()));
                countLabel.setText(String.valueOf(selMap.size()));
                this.getView().updateView(COUNT_LABEL);
            }
            this.getPageCache().put(SELECTED_NODE, SerializationUtils.toJsonString(selMap));
        }
    }

    private Map<String, Map<String, String>> getMenuInfoMap(String appID, Map<String, List<String>> menuRelationMap) {
        List<AppMenuInfo> menus = this.menuService.getHasPermMenuByAppId(RequestContext.get().getCurrUserId(), appID, true);
        HashMap<String, Map<String, String>> menuInfos = new HashMap<String, Map<String, String>>(menus.size());
        Map<String, String> menuInfo = null;
        if (menuRelationMap == null) {
            menuRelationMap = new HashMap<String, List<String>>();
        }
        for (AppMenuInfo menu : menus) {
            String menuId = menu.getId();
            this.getPageCache().put(menuId.toLowerCase(), menuId);
            if (menuId.endsWith("#hpce")) continue;
            menuInfo = new HashMap(6);
            String parentId = menu.getParentId();
            menuInfo.put(MENU_ID, menuId);
            menuInfo.put(PARENT_ID, parentId);
            menuInfo.put("text", menu.getName().getLocaleValue());
            menuInfo.put(FORM_ID, menu.getFormId());
            menuInfo.put("linkUrl", menu.getLinkUrl());
            menuInfo.put("seq", menu.getSeq() == null ? "0" : menu.getSeq().toString());
            menuInfo.put("icon", menu.getShortcutIcon());
            menuInfo.put("menuType", menu.getMenuType());
            menuInfos.put(menuId, menuInfo);
            menuRelationMap.computeIfAbsent(parentId, k -> new ArrayList()).add(menuId);
        }
        HashSet<String> needDel = new HashSet<String>();
        String key = null;
        for (Map.Entry entry : menuInfos.entrySet()) {
            key = (String)entry.getKey();
            menuInfo = (Map)entry.getValue();
            String formId = (String)menuInfo.get(FORM_ID);
            String linkUrl = (String)menuInfo.get("linkUrl");
            List<String> children = menuRelationMap.get(entry.getKey());
            if (!kd.bos.util.StringUtils.isBlank((String)formId) || !kd.bos.util.StringUtils.isBlank((String)linkUrl) || children != null && !children.isEmpty()) continue;
            needDel.add(key);
        }
        if (needDel.isEmpty()) {
            return menuInfos;
        }
        for (String id : needDel) {
            menuInfos.remove(id);
        }
        return menuInfos;
    }

    public void treeNodeClick(TreeNodeEvent e) {
        TreeView srcTreeView = (TreeView)e.getSource();
        Map focusNodeMap = srcTreeView.getTreeState().getFocusNode();
        String treeKey = srcTreeView.getKey();
        String nodeId = (String)focusNodeMap.get("id");
        if (CLOUD_APP_TREE.equals(treeKey)) {
            String parentId = (String)focusNodeMap.get("parentid");
            if (kd.bos.util.StringUtils.isBlank((String)parentId)) {
                srcTreeView.expand(nodeId);
                return;
            }
            if (nodeId.startsWith(MENU_PREFIX)) {
                this.refreshMenuCardPanel(nodeId);
            } else {
                this.refreshMenuCardPanel(nodeId);
            }
        }
    }

    private void refreshMenuCardPanel(String nodeId) {
        List<String> controlKey = new ArrayList();
        String controlKeyJsonStr = this.getPageCache().get("controlKey");
        Container c = (Container)this.getControl(PANEL_CONTAINER);
        if (kd.bos.util.StringUtils.isNotEmpty((String)controlKeyJsonStr)) {
            controlKey = SerializationUtils.fromJsonStringToList((String)controlKeyJsonStr, String.class);
            for (String key : controlKey) {
                c.deleteControls(new String[]{key});
            }
            this.getView().updateView(PANEL_CONTAINER);
            controlKey.clear();
        }
        String selStr = this.getPageCache().get(SELECTED_NODE);
        Map selMap = new HashMap();
        if (kd.bos.util.StringUtils.isNotEmpty((String)selStr)) {
            selMap = (Map)SerializationUtils.fromJsonString((String)selStr, Map.class);
        }
        if (nodeId.startsWith(MENU_PREFIX)) {
            String appNum = this.getView().getFormShowParameter().getAppId();
            if (kd.bos.util.StringUtils.isBlank((String)appNum)) {
                return;
            }
            String appId = AppMetadataCache.getAppInfo((String)appNum).getId();
            HashMap<String, List<String>> menuRelationMap = new HashMap<String, List<String>>();
            Map<String, Map<String, String>> menuInfoMap = this.getMenuInfoMap(appId, menuRelationMap);
            List<String> menuBlackList = CardUtils.getProductBlackMenus(appNum);
            for (Map.Entry<String, Map<String, String>> entry : menuInfoMap.entrySet()) {
                String id = entry.getKey();
                if (kd.bos.util.StringUtils.isBlank((String)id) || !nodeId.substring(MENU_PREFIX.length()).equals(id) || menuBlackList.contains(id)) continue;
                ArrayList<Map> list = new ArrayList<Map>();
                FlexPanelAp outerPanel = new FlexPanelAp();
                outerPanel.setKey(PANEL_PREFIX + id.toLowerCase());
                controlKey.add(PANEL_PREFIX + id.toLowerCase());
                outerPanel.setDirection("row");
                outerPanel.setGrow(1);
                outerPanel.setShrink(0);
                outerPanel.setWidth(new LocaleString(PX));
                outerPanel.setOverflow("auto");
                Style style = outerPanel.getStyle();
                if (style == null) {
                    style = new Style();
                }
                Padding padding = new Padding();
                padding.setTop("15px");
                style.setPadding(padding);
                outerPanel.setStyle(style);
                List<Map<String, String>> curAndSubMenus = this.getCurAndSubMenus(id, menuInfoMap, menuRelationMap);
                if (curAndSubMenus == null || curAndSubMenus.isEmpty()) {
                    return;
                }
                for (Map<String, String> menuInfo : curAndSubMenus) {
                    String menuId = menuInfo.get(MENU_ID);
                    if (menuBlackList.contains(menuId)) continue;
                    FlexPanelAp itemPanel = new FlexPanelAp();
                    itemPanel.setKey("panelap_item_" + menuId.toLowerCase());
                    itemPanel.setDirection("row");
                    itemPanel.setAlignItems(CENTER);
                    itemPanel.setGrow(0);
                    itemPanel.setJustifyContent(CENTER);
                    itemPanel.setAlignItems(CENTER);
                    itemPanel.setShrink(0);
                    itemPanel.setOverflow("hidden");
                    itemPanel.setWidth(new LocaleString("100px"));
                    style = itemPanel.getStyle();
                    if (style == null) {
                        style = new Style();
                    }
                    padding = new Padding();
                    padding.setLeft("5px");
                    padding.setTop("5px");
                    padding.setBottom("5px");
                    style.setPadding(padding);
                    itemPanel.setStyle(style);
                    String name = menuInfo.get("text");
                    String iconUrl = menuInfo.get("icon");
                    IconAp icon = new IconAp();
                    icon.setKey(ICON_PREFIX + menuId.toLowerCase());
                    icon.setName(new LocaleString(name));
                    if (kd.bos.util.StringUtils.isBlank((String)iconUrl)) {
                        icon.setImageKey(DEFAULT_ICONURL);
                    } else {
                        icon.setImageKey(iconUrl);
                    }
                    icon.setHeight(new LocaleString("48px"));
                    icon.setWidth(new LocaleString("48px"));
                    icon.setRadius("6px");
                    style = new Style();
                    Margin margin = new Margin();
                    margin.setBottom("3px");
                    style.setMargin(margin);
                    icon.setStyle(style);
                    VectorAp selector = new VectorAp();
                    selector.setKey(VECTOR_PREFIX + menuId.toLowerCase());
                    selector.setName(new LocaleString());
                    if (selMap.containsKey(menuId.toLowerCase())) {
                        selector.setfontClass(SELECTED_FONT);
                        this.getPageCache().put(selector.getKey(), SELECTED_FONT);
                    } else {
                        selector.setfontClass(UNSELECT_FONT);
                    }
                    selector.setFontSize(13);
                    selector.setForeColor("#007fff");
                    style = selector.getStyle();
                    if (style == null) {
                        style = new Style();
                    }
                    Margin selectorMargin = new Margin();
                    selectorMargin.setTop("-45px");
                    selectorMargin.setLeft("2px");
                    style.setMargin(selectorMargin);
                    selector.setStyle(style);
                    selector.setAlignSelf(CENTER);
                    LabelAp labelMenu = new LabelAp();
                    labelMenu.setKey(LABEL_PREFIX + menuId.toLowerCase());
                    labelMenu.setName(new LocaleString(name));
                    labelMenu.setWidth(new LocaleString("90px"));
                    labelMenu.setHeight(new LocaleString("31px"));
                    labelMenu.setTextAlign(CENTER);
                    labelMenu.setAutoTextWrap(true);
                    labelMenu.setShrink(0);
                    labelMenu.setLineHeight("15px");
                    style = labelMenu.getStyle();
                    if (style == null) {
                        style = new Style();
                    }
                    Margin labelMargin = new Margin();
                    labelMargin.setLeft("-15px");
                    labelMargin.setTop("5px");
                    style.setMargin(labelMargin);
                    labelMenu.setStyle(style);
                    itemPanel.getItems().add(icon);
                    itemPanel.getItems().add(selector);
                    itemPanel.getItems().add(labelMenu);
                    outerPanel.getItems().add(itemPanel);
                }
                list.add(outerPanel.createControl());
                c.addControls(list);
            }
        } else {
            String appNum = AppMetadataCache.getAppNumberById((String)nodeId);
            HashMap<String, List<String>> menuRelationMap = new HashMap<String, List<String>>();
            Map<String, Map<String, String>> menuInfoMap = this.getMenuInfoMap(nodeId, menuRelationMap);
            ArrayList<Map<String, String>> firstMenu = new ArrayList<Map<String, String>>();
            for (Map.Entry<String, Map<String, String>> entry : menuInfoMap.entrySet()) {
                Map<String, String> map = entry.getValue();
                String parentId = map.get(PARENT_ID);
                if (!nodeId.equals(parentId)) continue;
                firstMenu.add(map);
            }
            if (firstMenu.isEmpty()) {
                return;
            }
            Collections.sort(firstMenu, new Comparator<Map<String, String>>(){

                @Override
                public int compare(Map<String, String> map1, Map<String, String> map2) {
                    short seq1 = Short.parseShort(map1.get("seq"));
                    short seq2 = Short.parseShort(map2.get("seq"));
                    return seq1 - seq2;
                }
            });
            List<String> menuBlackList = CardUtils.getProductBlackMenus(appNum);
            for (Map map : firstMenu) {
                String id = (String)map.get(MENU_ID);
                if (menuBlackList.contains(id)) continue;
                String text = (String)map.get("text");
                ArrayList<Map> list = new ArrayList<Map>();
                LabelAp labelTitle = new LabelAp();
                labelTitle.setKey(id.toLowerCase());
                controlKey.add(id.toLowerCase());
                labelTitle.setName(new LocaleString(text));
                labelTitle.setFontSize(18);
                labelTitle.setHeight(new LocaleString("30px"));
                labelTitle.setWidth(new LocaleString(PX));
                labelTitle.setShrink(0);
                Style style = labelTitle.getStyle();
                if (style == null) {
                    style = new Style();
                }
                Margin margin = new Margin();
                margin.setTop("20px");
                margin.setLeft("20px");
                style.setMargin(margin);
                labelTitle.setStyle(style);
                FlexPanelAp outerPanel = new FlexPanelAp();
                outerPanel.setKey(PANEL_PREFIX + id.toLowerCase());
                controlKey.add(PANEL_PREFIX + id.toLowerCase());
                outerPanel.setDirection("row");
                outerPanel.setGrow(0);
                outerPanel.setShrink(0);
                outerPanel.setWidth(new LocaleString(PX));
                outerPanel.setOverflow("auto");
                style = outerPanel.getStyle();
                if (style == null) {
                    style = new Style();
                }
                Padding padding = new Padding();
                padding.setTop("15px");
                style.setPadding(padding);
                outerPanel.setStyle(style);
                List<Map<String, String>> curAndSubMenus = this.getCurAndSubMenus(id, menuInfoMap, menuRelationMap);
                if (curAndSubMenus == null || curAndSubMenus.isEmpty()) continue;
                for (Map<String, String> menuInfo : curAndSubMenus) {
                    String menuId = menuInfo.get(MENU_ID);
                    if (menuBlackList.contains(menuId)) continue;
                    FlexPanelAp itemPanel = new FlexPanelAp();
                    itemPanel.setKey("panelap_item_" + menuId.toLowerCase());
                    itemPanel.setDirection("row");
                    itemPanel.setAlignItems(CENTER);
                    itemPanel.setGrow(0);
                    itemPanel.setJustifyContent(CENTER);
                    itemPanel.setAlignItems(CENTER);
                    itemPanel.setShrink(0);
                    itemPanel.setOverflow("hidden");
                    itemPanel.setWidth(new LocaleString("100px"));
                    style = itemPanel.getStyle();
                    if (style == null) {
                        style = new Style();
                    }
                    padding = new Padding();
                    padding.setLeft("5px");
                    padding.setTop("5px");
                    padding.setBottom("5px");
                    style.setPadding(padding);
                    itemPanel.setStyle(style);
                    String name = menuInfo.get("text");
                    String iconUrl = menuInfo.get("icon");
                    IconAp icon = new IconAp();
                    icon.setKey(ICON_PREFIX + menuId.toLowerCase());
                    icon.setName(new LocaleString(name));
                    if (kd.bos.util.StringUtils.isBlank((String)iconUrl)) {
                        icon.setImageKey(DEFAULT_ICONURL);
                    } else {
                        icon.setImageKey(iconUrl);
                    }
                    icon.setHeight(new LocaleString("48px"));
                    icon.setWidth(new LocaleString("48px"));
                    icon.setRadius("6px");
                    style = new Style();
                    margin = new Margin();
                    margin.setBottom("3px");
                    style.setMargin(margin);
                    icon.setStyle(style);
                    VectorAp selector = new VectorAp();
                    selector.setKey(VECTOR_PREFIX + menuId.toLowerCase());
                    selector.setName(new LocaleString());
                    if (selMap.containsKey(menuId.toLowerCase())) {
                        selector.setfontClass(SELECTED_FONT);
                        this.getPageCache().put(selector.getKey(), SELECTED_FONT);
                    } else {
                        selector.setfontClass(UNSELECT_FONT);
                    }
                    selector.setFontSize(13);
                    selector.setForeColor("#007fff");
                    style = selector.getStyle();
                    if (style == null) {
                        style = new Style();
                    }
                    Margin selectorMargin = new Margin();
                    selectorMargin.setTop("-45px");
                    selectorMargin.setLeft("2px");
                    style.setMargin(selectorMargin);
                    selector.setStyle(style);
                    selector.setAlignSelf(CENTER);
                    LabelAp labelMenu = new LabelAp();
                    labelMenu.setKey(LABEL_PREFIX + menuId.toLowerCase());
                    labelMenu.setName(new LocaleString(name));
                    labelMenu.setWidth(new LocaleString("90px"));
                    labelMenu.setTextAlign(CENTER);
                    labelMenu.setAutoTextWrap(true);
                    labelMenu.setShrink(0);
                    labelMenu.setLineHeight("15px");
                    style = labelMenu.getStyle();
                    if (style == null) {
                        style = new Style();
                    }
                    Margin labelMargin = new Margin();
                    labelMargin.setLeft("-15px");
                    labelMargin.setTop("5px");
                    style.setMargin(labelMargin);
                    labelMenu.setStyle(style);
                    itemPanel.getItems().add(icon);
                    itemPanel.getItems().add(selector);
                    itemPanel.getItems().add(labelMenu);
                    outerPanel.getItems().add(itemPanel);
                }
                list.add(labelTitle.createControl());
                list.add(outerPanel.createControl());
                c.addControls(list);
            }
        }
        this.getPageCache().put("controlKey", SerializationUtils.toJsonString(controlKey));
    }

    private List<Map<String, String>> getCurAndSubMenus(String id, Map<String, Map<String, String>> menuInfoMap, Map<String, List<String>> menuRelationMap) {
        List<String> subMenus;
        ArrayList<Map<String, String>> menuItems = new ArrayList<Map<String, String>>();
        Map<String, String> menuInfo = menuInfoMap.get(id);
        if (menuInfo == null || menuInfo.isEmpty()) {
            return menuItems;
        }
        if (this.menuConfigValid(menuInfo)) {
            menuItems.add(menuInfo);
        }
        if ((subMenus = menuRelationMap.get(id)) == null || subMenus.isEmpty()) {
            return menuItems;
        }
        for (String subMenuId : subMenus) {
            List<Map<String, String>> subMenuInfos = this.getCurAndSubMenus(subMenuId, menuInfoMap, menuRelationMap);
            menuItems.addAll(subMenuInfos);
        }
        return menuItems;
    }

    private boolean menuConfigValid(Map<String, String> menuInfo) {
        String menuType = menuInfo.get("menuType");
        return MenuTypeEnum.PAGE.getCode().equals(menuType) && kd.bos.util.StringUtils.isNotEmpty((String)menuInfo.get(FORM_ID)) || MenuTypeEnum.LINK.getCode().equals(menuType) && kd.bos.util.StringUtils.isNotEmpty((String)menuInfo.get("linkUrl"));
    }

    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        String key = e.getKey();
        if (key.startsWith(VECTOR_PREFIX)) {
            Vector vector = new Vector();
            vector.setKey(key);
            vector.setView(this.getView());
            vector.addClickListener((ClickListener)this);
            e.setControl((Control)vector);
        } else if (key.startsWith(ICON_PREFIX)) {
            Vector vector = new Vector();
            vector.setKey(VECTOR_PREFIX + key.substring(ICON_PREFIX.length()));
            vector.setView(this.getView());
            vector.addClickListener((ClickListener)this);
            e.setControl((Control)vector);
        }
    }

    private void showImageSelForm(String callBackId) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("ide_pictureselector");
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, callBackId));
        this.getView().showForm(parameter);
    }

    public void listboxClick(ListboxEvent e) {
        String itemId;
        switch (itemId = e.getItemId()) {
            case "appfunc": {
                this.showTab("tabpage_appfunc");
                break;
            }
            case "link": {
                this.showTab("tabpage_link");
                break;
            }
        }
    }

    private void showTab(String key) {
        Tab tab = (Tab)this.getControl("tabap");
        tab.activeTab(key);
    }

    public void search(SearchEnterEvent e) {
        Search search = (Search)e.getSource();
        if (StringUtils.equals((String)"treenodesearch", (String)search.getKey())) {
            String searchText = e.getText();
            String json = this.getPageCache().getBigObject("nodes");
            TreeNode rootNode = (TreeNode)SerializationUtils.fromJsonString((String)json, TreeNode.class);
            LeftTreeSearchUtil.searchNodeByTextInTree(CLOUD_APP_TREE, rootNode, searchText, this.getView());
        }
    }
}

