/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.workbench.formplugin;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.ext.form.container.MessageCarouselContainer;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.mpscmm.msbd.workbench.formplugin.GridCardPlugin;
import kd.mpscmm.msbd.workbench.util.UserCenterCardUtil;

public class UserCenterPlugin
extends GridCardPlugin {
    private static Log log = LogFactory.getLog(UserCenterPlugin.class);
    private static final String LBT_KEY = "lbtap";
    private static final String CARD_TITLE = "title";
    public static final int CARD_MAX_MSGCOUNT = 5;
    private static final String LABEL_KEY = "caption";
    private static final String IMAGE_KEY = "imageap";
    private static final String URL_KEY = "urlap";

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        MessageCarouselContainer lbtAp = (MessageCarouselContainer)this.getControl(LBT_KEY);
        lbtAp.addItemClickListener((ItemClickListener)this);
    }

    @Override
    protected void refreshCard(Map<String, String> allConfigMap) {
        super.refreshCard(allConfigMap);
        String pubAcctId = allConfigMap.get("pubid");
        String pubName = allConfigMap.get("pubname");
        String cardType = allConfigMap.get("pucardtype");
        this.showSubscribe(pubAcctId, pubName, cardType);
    }

    public void showSubscribe(String subId, String pubName, String cardType) {
        Map<String, Object> msgListMap;
        if (kd.bos.util.StringUtils.isNotEmpty((String)pubName)) {
            Label title = (Label)this.getControl(CARD_TITLE);
            title.setText(pubName);
        }
        if ((msgListMap = UserCenterCardUtil.getUsercenterMsgList(cardType)) == null || msgListMap.size() <= 0) {
            return;
        }
        if (Objects.isNull(msgListMap.get("errcode")) || !(msgListMap.get("errcode") instanceof Integer)) {
            return;
        }
        if (200 != (Integer)msgListMap.get("errcode")) {
            return;
        }
        Map items = (Map)msgListMap.get("data");
        if (items == null || items.size() == 0) {
            return;
        }
        List list = (List)items.get("list");
        if (list.size() <= 0) {
            return;
        }
        list.sort((arg0, arg1) -> {
            SimpleDateFormat fmtDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                Date d1 = fmtDate.parse(arg0.get("sendTime").toString());
                Date d2 = fmtDate.parse(arg1.get("sendTime").toString());
                if (d1.getTime() < d2.getTime()) {
                    return 1;
                }
                if (d1.getTime() > d2.getTime()) {
                    return -1;
                }
            }
            catch (Exception exception) {
                log.error((Throwable)exception);
            }
            return 0;
        });
        HashMap<String, String> labelPropMap = null;
        HashMap<String, String> imagePropMap = null;
        HashMap controlMap = null;
        ArrayList msgList = new ArrayList();
        for (Map msgMap : list) {
            if (msgList.size() >= 5) break;
            controlMap = new HashMap();
            labelPropMap = new HashMap<String, String>();
            String title = (String)msgMap.get(CARD_TITLE);
            String image = (String)msgMap.get("image");
            labelPropMap.put("text", title);
            controlMap.put(LABEL_KEY, labelPropMap);
            imagePropMap = new HashMap<String, String>();
            imagePropMap.put("imageKey", "/private/subscribe_pic1.png");
            controlMap.put(IMAGE_KEY, imagePropMap);
            Map urlParam = (Map)msgMap.get("url");
            if (urlParam == null || urlParam.size() == 0) continue;
            String msgUrl = (String)urlParam.get("value");
            labelPropMap = new HashMap();
            labelPropMap.put("text", msgUrl);
            controlMap.put(URL_KEY, labelPropMap);
            msgList.add(controlMap);
        }
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("data", msgList);
        dataMap.put("k", LBT_KEY);
        this.getPageCache().put("data", SerializationUtils.toJsonString(msgList));
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.addAction("u", dataMap);
    }

    public void itemClick(ItemClickEvent evt) {
        super.click((EventObject)evt);
        Control ctrl = (Control)evt.getSource();
        String key = ctrl.getKey();
        if (LBT_KEY.equals(key)) {
            if (this.isDesignMode()) {
                return;
            }
            int index = (Integer)evt.getParamsMap().get("rowKey");
            String data = this.getPageCache().get("data");
            if (StringUtils.isEmpty((CharSequence)data)) {
                return;
            }
            List msgList = (List)SerializationUtils.fromJsonString((String)data, List.class);
            Map dataMap = (Map)msgList.get(index);
            Map propMap = (Map)dataMap.get(URL_KEY);
            if (propMap == null || propMap.get("text") == null || kd.bos.util.StringUtils.isEmpty((String)propMap.get("text").toString())) {
                return;
            }
            this.getView().openUrl(propMap.get("text").toString());
        }
    }
}

