/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.workbench.formplugin;

import com.alibaba.fastjson.JSONArray;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.ShaSignUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.portal.util.AppUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.FileUtils;
import kd.mpscmm.msbd.workbench.constant.SchemeType;
import kd.mpscmm.msbd.workbench.util.AppPackageUtil;
import kd.mpscmm.msbd.workbench.util.CardUtils;
import kd.mpscmm.msbd.workbench.util.WorkBenchSchemeUtil;

public class WorkBenchSchemeListPlugin
extends AbstractListPlugin {
    private static final String USER_LIST = "billlistap";
    private static final String LOCALPATH = System.getProperty("java.io.tmpdir") + File.separator + "KINGDEEDOWNLOAD";
    private static final String DATAMODEL = "datamodel";
    private static final String FILELIST_TXT = "filelist.txt";
    private static final String TBLENABLE = "tblenable";
    private static final String ENABLE_STATUS = "2";
    private static Log logger = LogFactory.getLog(WorkBenchSchemeListPlugin.class);
    private static final String IMPORTSCHEME = "importscheme";
    private static final String EXPORT_SCHEME = "exportscheme";
    private static final String SUCCESS_MSG = "success";
    private static final String IMPORT_SCHEME = "msbd_importscheme";

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if (TBLENABLE.equals(itemKey)) {
            BillList billList = (BillList)this.getView().getControl(USER_LIST);
            ListSelectedRowCollection rows = billList.getSelectedRows();
            if (rows.size() == 0) {
                return;
            }
            Object[] rowPKKeyArr = rows.getPrimaryKeyValues();
            boolean checkSysSchemeEnable = this.checkSysSchemeEnable(rowPKKeyArr, SchemeType.SysDefScheme.getValue());
            if (!checkSysSchemeEnable) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u5141\u8bb8\u542f\u7528\u4e00\u4e2a\u5168\u5c40\u65b9\u6848\u3002", (String)"WorkBenchSchemeListPlugin_0", (String)"mpscmm-msbd-workbench", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            boolean checkUserSchemeEnable = this.checkUserSchemeEnable(rowPKKeyArr, SchemeType.UserScheme.getValue());
            if (!checkUserSchemeEnable) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u540c\u4e00\u7528\u6237\uff0c\u53ea\u5141\u8bb8\u542f\u7528\u4e00\u4e2a\u4e2a\u6027\u65b9\u6848\u3002", (String)"WorkBenchSchemeListPlugin_1", (String)"mpscmm-msbd-workbench", (Object[])new Object[0]));
                evt.setCancel(true);
            }
        }
    }

    private boolean checkSysSchemeEnable(Object[] rowPKKeyArr, String schemeType) {
        DynamicObject[] schemaObject = this.getSchemeByIds(rowPKKeyArr, schemeType);
        if (schemaObject == null || schemaObject.length == 0) {
            return true;
        }
        boolean hasMultiEnableBizScheme = this.hasMultiEnableBizScheme(schemaObject, schemeType);
        return !hasMultiEnableBizScheme;
    }

    private boolean checkUserSchemeEnable(Object[] rowPKKeyArr, String schemeType) {
        DynamicObject[] schemaObject = this.getSchemeByIds(rowPKKeyArr, schemeType);
        if (schemaObject == null || schemaObject.length == 0) {
            return true;
        }
        boolean hasMultiEnableBizScheme = this.hasMultiEnableUserBizScheme(schemaObject, schemeType);
        return !hasMultiEnableBizScheme;
    }

    private boolean hasMultiEnableBizScheme(DynamicObject[] schemaObject, String schemeType) {
        Map<String, List<DynamicObject>> schemeGroup = Arrays.stream(schemaObject).collect(Collectors.groupingBy(scheme -> {
            DynamicObject form = scheme.getDynamicObject("formnum");
            if (form != null) {
                return form.get("number").toString();
            }
            return "";
        }));
        long count = schemeGroup.values().stream().filter(datas -> datas.size() > 1).count();
        if (count > 0L) {
            return true;
        }
        for (Map.Entry<String, List<DynamicObject>> entry : schemeGroup.entrySet()) {
            String formNum = entry.getKey();
            List<DynamicObject> schemes = entry.getValue();
            DynamicObject scheme2 = schemes.get(0);
            Long id = scheme2.getLong("id");
            boolean exist = this.hasSameTypeScheme(id, formNum, schemeType, null);
            if (!exist) continue;
            return true;
        }
        return false;
    }

    private boolean hasMultiEnableUserBizScheme(DynamicObject[] schemaObjects, String schemeType) {
        Map<String, List<DynamicObject>> bizUserSchemeGroup = Arrays.stream(schemaObjects).collect(Collectors.groupingBy(scheme -> {
            DynamicObject form = scheme.getDynamicObject("formnum");
            String formNum = "";
            if (form != null) {
                formNum = form.get("number").toString();
            }
            DynamicObject creator = scheme.getDynamicObject("creator");
            Long creatorid = 0L;
            if (creator != null) {
                creatorid = creator.getLong("id");
            }
            return formNum + "," + creatorid;
        }));
        long count = bizUserSchemeGroup.values().stream().filter(datas -> datas.size() > 1).count();
        if (count > 0L) {
            return true;
        }
        for (Map.Entry<String, List<DynamicObject>> entry : bizUserSchemeGroup.entrySet()) {
            String key = entry.getKey();
            String[] appAndUser = key.split(",");
            String formNum = appAndUser[0];
            Long creator = Long.valueOf(appAndUser[1]);
            List<DynamicObject> schemes = entry.getValue();
            DynamicObject scheme2 = schemes.get(0);
            Long id = scheme2.getLong("id");
            boolean exist = this.hasSameTypeScheme(id, formNum, schemeType, creator);
            if (!exist) continue;
            return true;
        }
        return false;
    }

    private DynamicObject[] getSchemeByIds(Object[] rowPKKeyArr, String schemeType) {
        String selectFields = "id,number,name,schemetype,bizapp,creator,formnum";
        QFilter qId = new QFilter("id", "in", (Object)rowPKKeyArr);
        QFilter schemeTypeFilter = new QFilter("schemetype", "=", (Object)schemeType);
        QFilter ismultiorg = new QFilter("ismultiorg", "=", (Object)CardUtils.convertModeType());
        QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.FALSE);
        QFilter[] filters = new QFilter[]{qId.and(schemeTypeFilter).and(ismultiorg).and(enableFilter)};
        return BusinessDataServiceHelper.load((String)"msbd_wrokbench_scheme", (String)selectFields, (QFilter[])filters);
    }

    private boolean hasSameTypeScheme(Long id, String formNum, String schemeType, Long creatorId) {
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        filterList.add(new QFilter("id", "!=", (Object)id));
        filterList.add(new QFilter("schemetype", "=", (Object)schemeType));
        filterList.add(new QFilter("ismultiorg", "=", (Object)CardUtils.convertModeType()));
        filterList.add(new QFilter("enable", "=", (Object)Boolean.TRUE));
        if (StringUtils.isNotBlank((CharSequence)formNum)) {
            filterList.add(new QFilter("formnum.number", "=", (Object)formNum));
        }
        if (SchemeType.UserScheme.getValue().equals(schemeType)) {
            filterList.add(new QFilter("creator", "=", (Object)creatorId));
        }
        return QueryServiceHelper.exists((String)"msbd_wrokbench_scheme", (QFilter[])filterList.toArray(new QFilter[0]));
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        String itemkey = evt.getOperateKey();
        OperationResult opResult = evt.getOperationResult();
        if (opResult != null && !opResult.isSuccess()) {
            return;
        }
        switch (itemkey.toLowerCase(Locale.ENGLISH)) {
            case "importscheme": {
                FormShowParameter fsp = new FormShowParameter();
                fsp.setFormId(IMPORT_SCHEME);
                fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, IMPORT_SCHEME));
                fsp.getOpenStyle().setShowType(ShowType.Modal);
                this.getView().showForm(fsp);
                break;
            }
            case "exportscheme": {
                BillList billList = (BillList)this.getView().getControl(USER_LIST);
                ListSelectedRowCollection rows = billList.getSelectedRows();
                Object[] rowPKKeyArr = rows.getPrimaryKeyValues();
                if (rowPKKeyArr.length == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e", (String)"WorkBenchSchemeListPlugin_2", (String)"mpscmm-msbd-workbench", (Object[])new Object[0]));
                }
                for (Object rowPKKey : rowPKKeyArr) {
                    this.exportScheme((Long)rowPKKey);
                }
                break;
            }
            case "disable": 
            case "enable": {
                this.removeShareSchemeCache();
                break;
            }
        }
    }

    private void removeShareSchemeCache() {
        try {
            BillList billList = (BillList)this.getView().getControl(USER_LIST);
            ListSelectedRowCollection rows = billList.getSelectedRows();
            Object[] rowPKKeyArr = rows.getPrimaryKeyValues();
            QFilter typeFilter = new QFilter("schemetype", "=", (Object)SchemeType.GroupScheme.getValue());
            QFilter idFilter = new QFilter("id", "in", Stream.of(rowPKKeyArr).collect(Collectors.toList()));
            DynamicObjectCollection datas = QueryServiceHelper.query((String)"msbd_wrokbench_scheme", (String)"formnum.number", (QFilter[])new QFilter[]{idFilter, typeFilter});
            Set<String> appIds = datas.stream().map(dyObj -> dyObj.getString("formnum.number")).collect(Collectors.toSet());
            appIds.forEach(CardUtils::removeShareIdsCache);
            if (appIds.contains("")) {
                CardUtils.removeShareIdsCache(null);
            }
        }
        catch (Exception e) {
            logger.error("removeShareIdsCache error", (Throwable)e);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        List errorlist;
        List repeatsqllist;
        Map retData = (Map)e.getReturnData();
        if (Objects.isNull(retData)) {
            return;
        }
        Map installmsgMap = (Map)retData.get("installmsg");
        if (Objects.isNull(installmsgMap)) {
            return;
        }
        List successlist = (List)installmsgMap.get("successlist");
        StringBuilder sbSuccess = new StringBuilder(ResManager.loadKDString((String)"\u65b9\u6848\uff1a", (String)"WorkBenchSchemeListPlugin_3", (String)"mpscmm-msbd-workbench", (Object[])new Object[0]));
        if (Objects.nonNull(successlist) && successlist.size() > 0) {
            for (Object success : successlist) {
                for (Object key : success.keySet()) {
                    sbSuccess.append((String)key).append(",");
                }
            }
            sbSuccess.append(ResManager.loadKDString((String)"\u5df2\u88ab\u6210\u529f\u6267\u884c\uff0c\u5df2\u751f\u6548\u3002", (String)"WorkBenchSchemeListPlugin_4", (String)"mpscmm-msbd-workbench", (Object[])new Object[0]));
        }
        if (Objects.nonNull(repeatsqllist = (List)installmsgMap.get("repeatsqllist")) && repeatsqllist.size() > 0) {
            for (Map repeatsql : repeatsqllist) {
                for (String key : repeatsql.keySet()) {
                    sbSuccess.append(key).append(",");
                }
            }
            sbSuccess.append(ResManager.loadKDString((String)"\u8be5\u65b9\u6848\u811a\u672c\u5df2\u6267\u884c\u8fc7\uff0c\u4e0d\u80fd\u91cd\u590d\u6267\u884c\u3002", (String)"WorkBenchSchemeListPlugin_5", (String)"mpscmm-msbd-workbench", (Object[])new Object[0]));
        }
        if (Objects.nonNull(errorlist = (List)installmsgMap.get("errorlist")) && errorlist.size() > 0) {
            for (Map error : errorlist) {
                for (String key : error.keySet()) {
                    sbSuccess.append(key).append(",");
                }
            }
            sbSuccess.append(ResManager.loadKDString((String)"\u53d1\u751f\u9519\u8bef\uff0c\u672a\u751f\u6548\u3002", (String)"WorkBenchSchemeListPlugin_6", (String)"mpscmm-msbd-workbench", (Object[])new Object[0]));
        }
        this.getView().showTipNotification(sbSuccess.toString());
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if (WorkBenchSchemeUtil.isIgnoreSql().booleanValue()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{IMPORTSCHEME});
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        String modeType = CardUtils.convertModeType();
        List qFilters = e.getQFilters();
        qFilters.add(new QFilter("ismultiorg", "=", (Object)modeType));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportScheme(Long pKkEY) {
        String selectFields = "id,number,name,schemetype,bizapp";
        QFilter qId = new QFilter("id", "=", (Object)pKkEY);
        QFilter[] filters = new QFilter[]{qId};
        DynamicObject schemaObject = BusinessDataServiceHelper.loadSingle((String)"msbd_wrokbench_scheme", (String)selectFields, (QFilter[])filters);
        String zipName = schemaObject.getString("name");
        String defaultAppVersion = "1.5.0";
        String defaultAppPackageName = "defaultAppPackage-dm";
        String defaultZipPath = LOCALPATH + File.separator + defaultAppPackageName + File.separator + ShaSignUtils.getSHA256StrJava1((String)UUID.randomUUID().toString());
        String defaultAppPath = defaultZipPath + File.separator + DATAMODEL + File.separator + defaultAppVersion + File.separator + "main";
        String selectCloudNum = "cloudNum";
        String selectAppNum = "selectAppNum";
        String selectAppPath = defaultAppPath + File.separator + "package";
        ArrayList<String> sqlNameList = new ArrayList<String>();
        ArrayList<Long> listIds = new ArrayList<Long>(3);
        listIds.add(pKkEY);
        boolean hasXmlFlag = false;
        if (!listIds.isEmpty()) {
            hasXmlFlag = AppPackageUtil.exportPageScheme(listIds, selectAppPath, sqlNameList);
        }
        JSONArray dbschemaMsg = new JSONArray();
        JSONArray preinsdataMsg = new JSONArray();
        AppPackageUtil.createDataModelXML("", selectAppNum, selectCloudNum, defaultAppVersion, defaultZipPath);
        AppPackageUtil.createAppXML("", selectAppNum, selectAppPath, dbschemaMsg, preinsdataMsg, sqlNameList, hasXmlFlag);
        ArrayList<String> fileList = new ArrayList<String>();
        String datamodelPath = defaultZipPath + File.separator + DATAMODEL;
        List<String> appSourceList = WorkBenchSchemeUtil.recursiveFiles(datamodelPath, fileList);
        StringBuilder appRelPathBuilder = new StringBuilder();
        appSourceList.forEach(appSource -> {
            int datamodelIndex = appSource.indexOf(DATAMODEL);
            String appRelPath = appSource.substring(datamodelIndex + DATAMODEL.length());
            if (!appRelPath.endsWith(FILELIST_TXT)) {
                appRelPathBuilder.append(appRelPath).append(System.lineSeparator());
            }
        });
        String appInfoPath = datamodelPath + File.separator + FILELIST_TXT;
        File packageFile = new File(FileUtils.checkFileUrl((String)appInfoPath));
        FileOutputStream fos = null;
        try {
            if (!packageFile.exists() || !packageFile.delete()) {
                // empty if block
            }
            if (!packageFile.createNewFile()) {
                // empty if block
            }
            fos = new FileOutputStream(packageFile);
            fos.write(appRelPathBuilder.toString().getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            AppUtils.addLog((String)"bos_devportal_bizapp", (String)"createLogInfo", (String)e.getMessage());
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception exception) {
                    AppUtils.addLog((String)"bos_devportal_bizapp", (String)"createLogInfo", (String)exception.getMessage());
                }
            }
        }
        String appPackageName = "appPackageName-dm";
        AppPackageUtil.zipDMFile(defaultZipPath, appPackageName);
        ArrayList<String> appZipNames = new ArrayList<String>();
        appZipNames.add(appPackageName);
        selectAppPath = FileUtils.checkFileUrl((String)selectAppPath);
        File selectAppFile = new File(selectAppPath);
        try {
            if (!selectAppFile.exists()) {
                selectAppFile.mkdirs();
            }
            if (selectAppFile.exists()) {
                AppUtils.deleteKd((File)selectAppFile);
            }
        }
        catch (Exception e) {
            this.getView().showErrorNotification(e.getMessage());
            return;
        }
        WorkBenchSchemeUtil.zipFiles(appZipNames, defaultZipPath, defaultAppPackageName);
        this.createFileDownloadUrl(defaultZipPath, defaultAppPackageName, zipName);
        this.getView().returnDataToParent((Object)SUCCESS_MSG);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void createFileDownloadUrl(String defaultZipPath, String defaultAppPackageName, String zipName) {
        FileInputStream zipInput = null;
        FileInputStream input = null;
        try {
            String downloadPath = defaultZipPath + File.separator + defaultAppPackageName + ".zip";
            downloadPath = FileUtils.checkFileUrl((String)downloadPath);
            File downloadFile = new File(downloadPath);
            if (downloadFile.exists()) {
                input = new FileInputStream(downloadFile);
                byte[] b = new byte[((InputStream)input).available()];
                int len = ((InputStream)input).read(b);
                BigDecimal zipBigDecimal = new BigDecimal(len);
                BigDecimal kbBigDecimal = new BigDecimal(1024);
                BigDecimal bigDecimal = zipBigDecimal.divide(kbBigDecimal);
            }
            zipInput = new FileInputStream(downloadPath);
            Date date = new Date();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
            String dataFormat = sdf.format(date);
            String url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(zipName + "-" + dataFormat + ".zip", (InputStream)zipInput, 5000);
            url = this.appendAppIdAndFormId(url);
            this.getView().openUrl(url);
            return;
        }
        catch (FileNotFoundException e) {
            this.getView().showErrorNotification(e.getMessage());
            return;
        }
        catch (IOException e) {
            this.getView().showErrorNotification(e.getMessage());
            return;
        }
        finally {
            this.getPageCache().remove("schemaarray");
            this.getPageCache().remove("selecttreenodes");
            this.getPageCache().remove("leftroot");
            this.getPageCache().remove("detailerrorinfo");
            this.getPageCache().remove("appidsvalue");
            this.getPageCache().remove("selectappids");
            try {
                defaultZipPath = FileUtils.checkFileUrl((String)defaultZipPath);
                File zipFile = new File(defaultZipPath);
                if (zipFile.exists()) {
                    AppUtils.deleteKd((File)zipFile);
                    String appNumberStr = LOCALPATH + File.separator + defaultAppPackageName;
                    appNumberStr = FileUtils.checkFileUrl((String)appNumberStr);
                    File appNumberPath = new File(appNumberStr);
                    if (appNumberPath.listFiles().length == 0 && !appNumberPath.delete()) {
                        // empty if block
                    }
                }
            }
            catch (Exception ioExp) {
                AppUtils.addLog((String)"bos_devportalexportPageScheme_bizapp", (String)"io", (String)ioExp.getMessage());
            }
            finally {
                if (zipInput != null) {
                    try {
                        ((InputStream)zipInput).close();
                    }
                    catch (IOException e) {
                        logger.error("zipInput\u5173\u95ed\u5f02\u5e38");
                    }
                }
                if (input != null) {
                    try {
                        ((InputStream)input).close();
                    }
                    catch (IOException e) {
                        logger.error("input\u5173\u95ed\u5f02\u5e38");
                    }
                }
            }
        }
    }

    private String appendAppIdAndFormId(String url) {
        if (StringUtils.isEmpty((CharSequence)url)) {
            return url;
        }
        String splitStr = "&";
        if (!url.contains("?")) {
            splitStr = "?";
        }
        try {
            FormShowParameter fsp = this.getView().getFormShowParameter();
            String appId = fsp.getAppId();
            String fId = ((ListShowParameter)fsp).getBillFormId();
            String result = url + splitStr + String.format("appId=%s&fId=%s", appId, fId);
            return result;
        }
        catch (Exception e) {
            logger.error("appendAppIdAndFormId error", (Throwable)e);
            return url;
        }
    }
}

