/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.workbench.formplugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.ext.form.container.GridContainer;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.SystemPropertyUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.CodeRuleServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.StringUtils;
import kd.mpscmm.msbd.workbench.constant.SchemeType;
import kd.mpscmm.msbd.workbench.util.CardUtils;

public class WorkBenchSchemeSaveAsPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static Log logger = LogFactory.getLog(WorkBenchSchemeSaveAsPlugin.class);
    private static final String BTN_CANCEL = "cancel";
    private static final String BTN_OK = "ok";
    private static final String CTRL_GRIDCONTAINER = "gridcontainerap";
    private static final String SCHEME_ADMIN_USER = "1,2,3,10";
    private String userType = "in";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        MulBasedataEdit group = (MulBasedataEdit)this.getControl("groupids");
        group.setQFilter(new QFilter("id", "<>", (Object)641718110033824768L));
        BasedataEdit userIds = (BasedataEdit)this.getControl("userids");
        userIds.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.setUserFilter(userIds);
        this.addClickListeners(new String[]{BTN_OK, BTN_CANCEL});
    }

    private void setUserFilter(BasedataEdit userids) {
        String currUserId = RequestContext.get().getUserId();
        QFilter qFilter = null;
        if ("200".equals(String.valueOf(this.getCurrentUserType()))) {
            this.userType = "out";
            List partnerByUserId = UserServiceHelper.getBizPartnerByUserId((long)Long.parseLong(currUserId));
            DynamicObjectCollection query = QueryServiceHelper.query((String)"bos_bizpartneruser", (String)"usertype", (QFilter[])new QFilter[]{new QFilter("user", "=", (Object)Long.parseLong(currUserId))});
            String userType = null;
            if (query != null) {
                userType = ((DynamicObject)query.get(0)).getString("usertype");
            }
            List<Long> users = this.getUserIdByPartner(partnerByUserId, userType);
            qFilter = new QFilter("id", "in", users);
            userids.setQFilter(qFilter);
            return;
        }
        String adminUser = SystemPropertyUtils.getProptyByTenant((String)"scheme_admin_user", (String)RequestContext.get().getTenantId());
        if (StringUtils.isEmpty((String)adminUser)) {
            adminUser = SCHEME_ADMIN_USER;
        }
        boolean adminFlag = false;
        for (String s : adminUser.split(",")) {
            if (!s.equals(currUserId)) continue;
            adminFlag = true;
            break;
        }
        if (StringUtils.isNotEmpty((String)currUserId) && !adminFlag) {
            this.userType = "in";
            DynamicObjectCollection query = QueryServiceHelper.query((String)"bos_user", (String)"id,name,entryentity.dpt", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(currUserId))}, null);
            List orgIds = query.stream().map(v -> v.getLong("entryentity.dpt")).collect(Collectors.toList());
            List subOrgIds = OrgUnitServiceHelper.getAllSubordinateOrgs((String)"01", orgIds, (boolean)true);
            orgIds.addAll(subOrgIds);
            if (orgIds.size() > 0) {
                if (qFilter == null) {
                    qFilter = new QFilter("entryentity.dpt", "in", orgIds);
                } else {
                    qFilter.or(new QFilter("entryentity.dpt", "in", orgIds));
                }
                qFilter.or(new QFilter("entryentity.dpt", "is null", null));
                userids.setQFilter(qFilter);
            }
        }
    }

    private List<Long> getUserIdByPartner(List<Long> partnerByUserId, String userType) {
        QFilter qFilter = null;
        if (userType != null) {
            String[] types;
            for (String type : types = userType.split(",")) {
                if (qFilter == null) {
                    qFilter = new QFilter("usertype", "=", (Object)type);
                    qFilter.or("usertype", "like", (Object)(type + ",%")).or("usertype", "like", (Object)("%," + type));
                    continue;
                }
                qFilter.or("usertype", "=", (Object)type).or("usertype", "like", (Object)(type + ",%")).or("usertype", "like", (Object)("%," + type));
            }
        }
        if (qFilter == null) {
            qFilter = new QFilter("bizpartner", "in", partnerByUserId);
        } else {
            qFilter.and("bizpartner", "in", partnerByUserId);
        }
        DynamicObjectCollection query = QueryServiceHelper.query((String)"bos_bizpartneruser", (String)"user", (QFilter[])new QFilter[]{qFilter});
        List<Long> user = query.stream().map(v -> v.getLong("user")).collect(Collectors.toList());
        return user;
    }

    public void click(EventObject evt) {
        Control ctrl = (Control)evt.getSource();
        String ctrlKey = ctrl.getKey();
        this.getPageCache();
        switch (ctrlKey) {
            case "ok": {
                this.saveSchemeConfig();
                break;
            }
            case "cancel": {
                this.getView().close();
                break;
            }
        }
    }

    public boolean checkSaveable() {
        DynamicObject scheme = this.getModel().getDataEntity();
        String number = scheme.getString("number");
        if (StringUtils.isEmpty((String)number)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65b9\u6848\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WorkBenchSchemeSaveAsPlugin_0", (String)"mpscmm-msbd-workbench", (Object[])new Object[0]));
            return false;
        }
        ILocaleString name = scheme.getLocaleString("name");
        if (name == null || name.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65b9\u6848\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WorkBenchSchemeSaveAsPlugin_1", (String)"mpscmm-msbd-workbench", (Object[])new Object[0]));
            return false;
        }
        boolean saveScope = this.checkSaveScope(scheme);
        if (saveScope) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u65b9\u6848\u7684\u5171\u4eab\u8303\u56f4\u3002", (String)"WorkBenchSchemeSaveAsPlugin_2", (String)"mpscmm-msbd-workbench", (Object[])new Object[0]));
            return false;
        }
        QFilter[] qf = new QFilter[]{QFilter.of((String)"name = ?", (Object[])new Object[]{scheme.getString("name")})};
        DynamicObject schemeObj = BusinessDataServiceHelper.loadSingle((String)"msbd_wrokbench_scheme", (String)"id", (QFilter[])qf);
        if (schemeObj != null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"WorkBenchSchemeSaveAsPlugin_3", (String)"mpscmm-msbd-workbench", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean checkSaveScope(DynamicObject scheme) {
        DynamicObjectCollection groupIds = scheme.getDynamicObjectCollection("groupids");
        DynamicObjectCollection orgIds = scheme.getDynamicObjectCollection("orgids");
        DynamicObjectCollection users = scheme.getDynamicObjectCollection("userids");
        DynamicObjectCollection roles = scheme.getDynamicObjectCollection("roleids");
        DynamicObjectCollection userTypes = scheme.getDynamicObjectCollection("usertypeids");
        boolean flag = CollectionUtils.isEmpty((Collection)groupIds) && CollectionUtils.isEmpty((Collection)orgIds) && CollectionUtils.isEmpty((Collection)users) && CollectionUtils.isEmpty((Collection)roles) && CollectionUtils.isEmpty((Collection)userTypes);
        return flag;
    }

    public void saveSchemeConfig() {
        String cacheStr;
        Map allCardConfigMap;
        String newLayout;
        if (!this.checkSaveable()) {
            return;
        }
        IFormView parentView = this.getView().getParentView();
        IDataModel parentDataModel = parentView.getModel();
        IPageCache parentPageCache = (IPageCache)parentView.getService(IPageCache.class);
        CardUtils cardUtils = new CardUtils(parentView, parentPageCache, parentDataModel, logger);
        if (cardUtils.saveWorkBenchInfo(SchemeType.GroupScheme, newLayout = CardUtils.getNewLayout(parentView, CTRL_GRIDCONTAINER), allCardConfigMap = (Map)Optional.ofNullable(cacheStr = parentPageCache.get("cache_allCardConfig")).map(s -> SerializationUtils.fromJsonString((String)cacheStr, Map.class)).orElseGet(HashMap::new), null, this.getModel().getDataEntity())) {
            this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"WorkBenchSchemeSaveAsPlugin_4", (String)"mpscmm-msbd-workbench", (Object[])new Object[0]));
            GridContainer gc = (GridContainer)this.getView().getParentView().getControl(CTRL_GRIDCONTAINER);
            gc.triggerContainer();
        }
        this.getView().sendFormAction(this.getView().getParentView());
        this.getView().close();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Label labelap = (Label)this.getView().getControl("labelap");
        labelap.setText(ResManager.loadKDString((String)"\u8bbe\u7f6e\u65b9\u6848\u7684\u5171\u4eab\u8303\u56f4\uff1a", (String)"WorkBenchSchemeSaveAsPlugin_5", (String)"mpscmm-msbd-workbench", (Object[])new Object[0]));
        String number = CodeRuleServiceHelper.getNumber((String)"msbd_wrokbench_scheme", (DynamicObject)BusinessDataServiceHelper.newDynamicObject((String)"msbd_wrokbench_scheme"), null);
        if (StringUtils.isNotEmpty((String)number)) {
            this.getModel().setValue("number", (Object)number);
        }
        if ("200".equals(String.valueOf(this.getCurrentUserType()))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"orgids"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"groupids"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"roleids"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"usertypeids"});
        }
    }

    private Integer getCurrentUserType() {
        Long userId = RequestContext.get().getCurrUserId();
        ArrayList<Long> userIds = new ArrayList<Long>();
        userIds.add(userId);
        Map types = UserServiceHelper.getUserBaseTypeByIds(userIds);
        if (types != null && types.size() > 0) {
            Integer type = (Integer)types.get(userId);
            return type;
        }
        return null;
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        if ("in".equals(this.userType)) {
            showParameter.setF7Style(3);
            showParameter.setCustomParam("externalUserType", (Object)"all");
        } else if ("out".equals(this.userType)) {
            showParameter.setF7Style(3);
            showParameter.setCustomParam("isOnlyShowExternalUser", (Object)true);
        }
    }
}

