/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.workbench.formplugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMenuInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.tree.TreeMenuNode;
import kd.bos.ext.form.container.GridContainer;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.FloatMenu;
import kd.bos.form.control.TreeMenu;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.TreeMenuClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.model.AdminType;
import kd.bos.portal.util.OpenPageUtils;
import kd.bos.service.ServiceFactory;
import kd.bos.service.metadata.MetadataService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.mpscmm.msbd.workbench.constant.SchemeType;
import kd.mpscmm.msbd.workbench.service.PortalMenuService;
import kd.mpscmm.msbd.workbench.util.CardUtils;

public class WorkBenchTplFormPlugin
extends AbstractFormPlugin
implements ClickListener,
TreeMenuClickListener,
ItemClickListener {
    private static Log logger = LogFactory.getLog(WorkBenchTplFormPlugin.class);
    private static List<String> schemeTypes = Arrays.asList(SchemeType.SysDefScheme.getValue(), SchemeType.UserScheme.getValue(), SchemeType.GroupScheme.getValue());
    private PortalMenuService menuService;

    public void initialize() {
        this.menuService = new PortalMenuService(this.getPageCache());
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    private boolean isNewPortal() {
        IFormView mainView = this.getView().getMainView();
        if (mainView == null) {
            String rootPageId = this.getView().getFormShowParameter().getRootPageId();
            IFormView rootView = SessionManager.getCurrent().getView(rootPageId);
            mainView = rootView.getParentView();
            if (mainView == null) {
                mainView = rootView;
            }
        }
        String formId = mainView.getFormShowParameter().getFormId();
        return "home_page".equals(formId);
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String callBackId = e.getCallBackId();
        String layout = this.getPageCache().get("pgCache_grid_layout");
        String curSchemeType = this.getPageCache().get("pgCache_currentSchemeType");
        String curSchemeId = this.getPageCache().get("pgCache_currentScheme");
        if (curSchemeType == null || curSchemeId == null) {
            logger.info("confirmCallBack curSchemeType or curSchemeId is null");
            return;
        }
        if ("confirm_reset".equals(callBackId)) {
            if (e.getResult().equals((Object)MessageBoxResult.Yes)) {
                this.reset();
            }
        } else if ("confirm_setDefault".equals(callBackId)) {
            if (e.getResult().equals((Object)MessageBoxResult.Yes)) {
                this.editEnd(SchemeType.SysDefScheme, layout, null);
            }
        } else if ("confirm_modifyOrNewCustom".equals(callBackId)) {
            if (e.getResult().equals((Object)MessageBoxResult.Yes)) {
                this.editEnd(SchemeType.getSchemeType(curSchemeType), layout, Long.valueOf(curSchemeId));
            } else if (e.getResult().equals((Object)MessageBoxResult.No) && CardUtils.checkCurSchemeCustomizable(curSchemeId, this.getView())) {
                this.editEnd(SchemeType.UserScheme, layout, null);
            }
        } else if ("confirmcallbackid_modify_custom".equals(callBackId) && e.getResult().equals((Object)MessageBoxResult.Yes)) {
            this.editEnd(SchemeType.UserScheme, layout, null);
        } else if ("confirmcallbackid_modify_sys".equals(callBackId) && e.getResult().equals((Object)MessageBoxResult.Yes)) {
            this.editEnd(SchemeType.SysDefScheme, layout, null);
        } else if ("confirmcallbackid_delete_user".equals(callBackId) && e.getResult().equals((Object)MessageBoxResult.Yes)) {
            this.deleteScheme();
        } else if ("confirmcallbackid_disable_allsys".equals(callBackId) && e.getResult().equals((Object)MessageBoxResult.Yes)) {
            this.saveAsSchemeWithDisable(SchemeType.SysDefScheme, layout);
        } else if ("confirmcallbackid_disable_allcustom".equals(callBackId) && e.getResult().equals((Object)MessageBoxResult.Yes)) {
            this.saveAsSchemeWithDisable(SchemeType.UserScheme, layout);
        }
    }

    private void saveAsSchemeWithDisable(SchemeType schemeType, String layout) {
        List<DynamicObject> schemeDatas = this.getCurrentUserScheme(schemeType);
        if (schemeDatas != null && schemeDatas.size() > 1) {
            this.disableScheme(schemeDatas);
        }
        this.editEnd(schemeType, layout, null);
    }

    public boolean checkCanEdit() {
        String curSchemeId = this.getPageCache().get("pgCache_currentScheme");
        return CardUtils.checkCurSchemeCustomizable(curSchemeId, this.getView());
    }

    private boolean checkCanEditAndShowTip(boolean showTip) {
        String curSchemeId = this.getPageCache().get("pgCache_currentScheme");
        return CardUtils.checkCurSchemeCustomizable(curSchemeId, this.getView(), showTip);
    }

    private void showSchemeSwitchList() {
        ListShowParameter lsp = ShowFormHelper.createShowListForm((String)"msbd_wrokbench_scheme", (boolean)false);
        List<QFilter> rangeFilterList = this.getCurrentUserSchemeFilters();
        lsp.setListFilterParameter(new ListFilterParameter(rangeFilterList, null));
        lsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "CallBack_getScheme"));
        lsp.setCustomParam("schemeSwitchF7", (Object)"true");
        String curSchemeId = this.getPageCache().get("pgCache_currentScheme");
        if (kd.bos.util.StringUtils.isNotEmpty((String)curSchemeId)) {
            lsp.setSelectedRow((Object)Long.valueOf(curSchemeId));
        }
        this.getView().showForm((FormShowParameter)lsp);
    }

    public void showItemControl(Boolean isShowDesignAdjust) {
        this.getView().setVisible(isShowDesignAdjust, new String[]{"adjustlayout"});
        String schemeType = this.getPageCache().get("pgCache_currentSchemeType");
        if (SchemeType.UserScheme.getValue().equals(schemeType)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"reset"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"reset"});
        }
        Long userId = RequestContext.get().getCurrUserId();
        boolean hasRight = false;
        if (!isShowDesignAdjust.booleanValue()) {
            hasRight = CardUtils.checkHasModifySchemeRight(userId);
            if (this.isOutAdmin()) {
                hasRight = true;
            }
        }
        this.getView().setVisible(Boolean.valueOf(hasRight), new String[]{"saveas"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"switch", "refresh", "setdefault"});
    }

    public void showItemOnlyModify() {
        this.getView().setVisible(Boolean.TRUE, new String[]{"adjustlayout"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"reset"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"saveas"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"switch"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"refresh"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"setdefault"});
    }

    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        Map paramMap = evt.getParamsMap();
        switch (key) {
            case "adjustlayout": {
                this.changeToDesignMode();
                break;
            }
            case "addCard": {
                if (paramMap.get("layout") != null) {
                    this.getPageCache().put("layout", paramMap.get("layout").toString());
                }
                this.showNewCardTypeForm(null);
                break;
            }
            case "editEnd": {
                String layout = (String)paramMap.get("layout");
                boolean isSetDefault = (Boolean)paramMap.get("isSetDefault");
                this.doFinish(layout, isSetDefault);
                break;
            }
            case "editCancel": {
                this.editCancel();
                break;
            }
            case "deleteCard": {
                String cardId = (String)paramMap.get("cardId");
                this.deleteCard(cardId);
                break;
            }
            case "reset": {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5f53\u524d\u5e03\u5c40\u5c06\u91cd\u7f6e\u4e3a\u9ed8\u8ba4\u5e03\u5c40\uff0c\u786e\u5b9a\u91cd\u7f6e\uff1f", (String)"WorkBenchTplFormPlugin_0", (String)"mpscmm-msbd-workbench", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("confirm_reset", (IFormPlugin)this));
                break;
            }
            case "saveas": {
                FormShowParameter fsp = new FormShowParameter();
                fsp.setFormId("msbd_scheme_saveas");
                fsp.getOpenStyle().setShowType(ShowType.Modal);
                this.getView().showForm(fsp);
                break;
            }
            case "switch": {
                this.showSchemeSwitchList();
                break;
            }
            case "refresh": {
                this.clickFreshGridContainer();
                break;
            }
            case "setdefault": {
                String schemeId = this.getPageCache().get("pgCache_currentScheme");
                this.setDefaultScheme(schemeId);
                break;
            }
            case "trigger": {
                this.trigger();
                break;
            }
            case "edit": {
                this.toDesignMode();
                break;
            }
            case "switchScheme": {
                this.switchScheme((String)paramMap.get("schemeId"));
                break;
            }
            case "setDefaultScheme": {
                this.setDefaultScheme((String)paramMap.get("schemeId"));
                break;
            }
            case "saveAsSchemeType": {
                String schemeLayout = (String)paramMap.get("layout");
                String type = (String)paramMap.get("type");
                this.saveAsSchemeType(type, schemeLayout);
                break;
            }
            case "deleteScheme": {
                this.deleteScheme((String)paramMap.get("schemeId"));
                break;
            }
            case "save": {
                this.saveCurrentScheme((String)paramMap.get("layout"));
                break;
            }
        }
    }

    private void reset() {
        try (TXHandle txHandle = TX.required();){
            try {
                Long userId = RequestContext.get().getCurrUserId();
                DynamicObject userMainPageLayout = CardUtils.loadScheme(SchemeType.UserScheme, userId, "id", this.getView());
                if (userMainPageLayout != null) {
                    DeleteServiceHelper.delete((String)"msbd_workbenchcardconf", (QFilter[])new QFilter[]{new QFilter("scheme", "=", userMainPageLayout.get("id"))});
                    DeleteServiceHelper.delete((String)"msbd_wrokbench_scheme", (QFilter[])new QFilter[]{new QFilter("id", "=", userMainPageLayout.get("id"))});
                }
                this.updateTempDelIds(new ArrayList<String>());
                this.getPageCache().remove("pgCache_currentScheme");
                this.getPageCache().remove("pgCache_currentSchemeType");
                this.refreshGridContainer();
            }
            catch (Exception e) {
                txHandle.markRollback();
                logger.error((Throwable)e);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5220\u9664\u7528\u6237\u7684\u5e03\u5c40\u4fe1\u606f\u5931\u8d25,\u51fa\u73b0\u672a\u77e5\u9519\u8bef\uff0c\u8bf7\u4e0e\u7ba1\u7406\u5458\u8054\u7cfb\u3002", (String)"WorkBenchTplFormPlugin_1", (String)"mpscmm-msbd-workbench", (Object[])new Object[0]));
            }
        }
    }

    public void registerListener(EventObject e) {
        TreeMenu navigationBar;
        GridContainer gc;
        super.registerListener(e);
        FloatMenu floatMenu = (FloatMenu)this.getControl("floatmenu");
        if (floatMenu != null) {
            floatMenu.addItemClickListener((ItemClickListener)this);
        }
        if ((gc = (GridContainer)this.getControl("gridcontainerap")) != null) {
            gc.addItemClickListener((ItemClickListener)this);
        }
        if ((navigationBar = (TreeMenu)this.getControl("favoritemenu")) != null) {
            navigationBar.addTreeMenuClickListener((TreeMenuClickListener)this);
        }
        this.addClickListeners(new String[]{"favoritemenu"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.refreshGridContainer();
        this.initNewPortalScheme();
    }

    public void showNewCardTypeForm(String cardTypeIndex) {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("msbd_card_addnew");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "CallBack_showAddCardForm"));
        if (kd.bos.util.StringUtils.isNotEmpty((String)cardTypeIndex)) {
            fsp.setCustomParam("event_rtn_addcard", (Object)cardTypeIndex);
        }
        this.getView().showForm(fsp);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        Object retDataObj = e.getReturnData();
        String actionId = e.getActionId();
        if (actionId.equals("CallBack_showAddCardForm")) {
            if (retDataObj == null) {
                return;
            }
            List<Map<String, Object>> list = new ArrayList<Map<String, Object>>(20);
            if (retDataObj instanceof Map) {
                Object rtnCardIndex = ((Map)retDataObj).get("event_rtn_addcard");
                if (rtnCardIndex != null) {
                    String cardTypeIndex = (String)rtnCardIndex;
                    this.showNewCardTypeForm(cardTypeIndex);
                    return;
                }
                list.add((Map)retDataObj);
            } else if (retDataObj instanceof List) {
                list = (List)retDataObj;
            }
            this.showNewCardForms(list);
        } else if (actionId.equals("CallBack_getScheme") && retDataObj instanceof ListSelectedRowCollection) {
            Long schemeId = Long.parseLong(((ListSelectedRowCollection)retDataObj).getPrimaryKeyValues()[0].toString());
            DynamicObject schemeObj = BusinessDataServiceHelper.loadSingle((Object)schemeId, (String)"msbd_wrokbench_scheme");
            this.refreshGridContainer(schemeObj);
        }
    }

    private void setFormId(FormShowParameter fsp, Map<String, Object> pReturnMap) {
        String cardType = (String)pReturnMap.get("cardType");
        if (cardType.equals("bos_card_custom")) {
            String formNum = (String)pReturnMap.get("cardformnum");
            fsp.setFormId(formNum);
        } else {
            fsp.setFormId(cardType);
        }
    }

    private void buildNewCardFormParam(List<FormShowParameter> fspList, Map<String, Object> pReturnMap, List<Map<String, Object>> cardInfoMaps, Map<String, String> newCardIdPageIdMap) {
        String cardType = (String)pReturnMap.get("cardType");
        if (kd.bos.util.StringUtils.isEmpty((String)cardType)) {
            return;
        }
        FormShowParameter fsp = new FormShowParameter();
        this.setFormId(fsp, pReturnMap);
        String cardId = this.setShowType(fsp, cardType, null, true);
        this.setCustomParam(fsp, cardType);
        if (kd.bos.util.StringUtils.isNotEmpty((String)cardId)) {
            Map<String, String> allCardConfigMap = this.getAllCardConfigMap();
            allCardConfigMap.put(cardId, SerializationUtils.toJsonString(pReturnMap));
            this.setAllCardConfigCache(allCardConfigMap);
            HashMap<Object, Object> config = new HashMap(16);
            if (this.getPageCache().get("layout") != null) {
                String layout = this.getPageCache().get("layout");
                int cols = this.getGridCols();
                config = CardUtils.getLayoutForNewCard(layout, 4, 4, cols);
                JSONArray jsonArr = JSONArray.parseArray((String)layout);
                JSONObject jsonObj = new JSONObject();
                jsonObj.put("w", config.get("w"));
                jsonObj.put("h", config.get("h"));
                jsonObj.put("x", config.get("x"));
                jsonObj.put("y", config.get("y"));
                jsonObj.put("i", (Object)cardId);
                jsonObj.put("moved", (Object)Boolean.FALSE);
                jsonObj.put("static", (Object)Boolean.FALSE);
                jsonArr.add((Object)jsonObj);
                String newLayout = jsonArr.toJSONString();
                this.getPageCache().put("layout", newLayout);
            }
            HashMap<String, Object> dataMap = new HashMap<String, Object>(16);
            dataMap.put("formId", "");
            dataMap.put("cardId", cardId);
            dataMap.put("config", config);
            cardInfoMaps.add(dataMap);
            newCardIdPageIdMap.put(cardId, fsp.getPageId());
        }
        fspList.add(fsp);
    }

    private int getGridCols() {
        String defaultGridCols = "12";
        String formId = this.getView().getFormShowParameter().getFormId();
        String cols = this.getPageCache().get(formId + "_gridcontainerap_cols");
        if (kd.bos.util.StringUtils.isEmpty((String)cols)) {
            try {
                MetadataService metadataService = (MetadataService)ServiceFactory.getService(MetadataService.class);
                String meta = metadataService.loadClientFormMeta(formId);
                Map<String, Object> data = this.getGridRuntimeMeta("gridcontainerap", (Map)SerializationUtils.fromJsonString((String)meta, Map.class));
                cols = data != null ? data.get("cols").toString() : defaultGridCols;
            }
            catch (Exception e) {
                logger.error("getGridCols error", (Throwable)e);
                cols = defaultGridCols;
            }
            this.getPageCache().put(formId + "_gridcontainerap_cols", cols);
        }
        return Integer.parseInt(cols);
    }

    private Map<String, Object> getGridRuntimeMeta(String gridId, Map<String, Object> meta) {
        List items;
        if (meta != null && meta.containsKey("items") && meta.get("items") instanceof List && (items = (List)meta.get("items")) != null && !items.isEmpty()) {
            for (Map item : items) {
                if (item.containsKey("id") && item.containsKey("cols") && Objects.equals(gridId, item.get("id"))) {
                    return item;
                }
                Map<String, Object> metadata = this.getGridRuntimeMeta(gridId, item);
                if (metadata == null) continue;
                return metadata;
            }
        }
        return null;
    }

    private void showNewCardForms(List<Map<String, Object>> pListReturnMap) {
        ArrayList<FormShowParameter> fspList = new ArrayList<FormShowParameter>();
        ArrayList<Map<String, Object>> cardInfoMaps = new ArrayList<Map<String, Object>>();
        HashMap<String, String> newCardIdPageIdMap = new HashMap<String, String>(16);
        for (Map<String, Object> map : pListReturnMap) {
            this.buildNewCardFormParam(fspList, map, cardInfoMaps, newCardIdPageIdMap);
        }
        this.updateCardPageMap(newCardIdPageIdMap);
        GridContainer gc = (GridContainer)this.getView().getControl("gridcontainerap");
        gc.addCards(cardInfoMaps);
        for (FormShowParameter fsp : fspList) {
            this.getView().showForm(fsp);
        }
    }

    private String setShowType(FormShowParameter fsp, String cardType, String cardId, boolean ifDesignMode) {
        HashMap custParam = fsp.getOpenStyle().getCustParam();
        if (custParam == null) {
            custParam = new HashMap(16);
            fsp.getOpenStyle().setCustParam(custParam);
        }
        String newCardId = cardId;
        switch (cardType) {
            case "msbd_card_billstatsconfig": 
            case "msbd_card_workflowconfig": 
            case "msbd_card_qingconfig": 
            case "msbd_card_custom_config": 
            case "msbd_card_yzjconifg": 
            case "msb_card_usercenterconfig": {
                fsp.getOpenStyle().setShowType(ShowType.Modal);
                fsp.setCloseCallBack(new CloseCallBack(((Object)((Object)this)).getClass().getName(), "CallBack_showAddCardForm"));
                break;
            }
            case "bos_card_custom": 
            case "msbd_card_quicklaunch": 
            case "msbd_card_billstats": 
            case "msbd_card_billstats_list": 
            case "msbd_card_workflow": 
            case "msbd_card_msgcenter": 
            case "msbd_card_qing": 
            case "msbd_card_yzj_subscribe": 
            case "msbd_card_usercenter": {
                fsp.getOpenStyle().setShowType(ShowType.InContainer);
                if (newCardId == null) {
                    newCardId = this.getNewCardId();
                }
                fsp.getOpenStyle().setTargetKey("gridcontainerap");
                fsp.getOpenStyle().getCustParam().put("cardId", newCardId);
                String strIfDesignMode = null;
                strIfDesignMode = ifDesignMode ? "1" : "0";
                fsp.getOpenStyle().getCustParam().put("ifDesignMode", strIfDesignMode);
                break;
            }
        }
        return newCardId;
    }

    private void setCustomParam(FormShowParameter fsp, String cardType) {
        Object isFreshClick = this.getView().getFormShowParameter().getCustomParam("isFreshClick");
        boolean isFreshClickFlag = false;
        if (isFreshClick != null && Boolean.parseBoolean(isFreshClick.toString())) {
            isFreshClickFlag = true;
        }
        switch (cardType) {
            case "msbd_card_quicklaunch": {
                fsp.getOpenStyle().getCustParam().put("cardRefresh", "false");
                break;
            }
            case "msbd_card_billstats": {
                fsp.setCustomParam("isFreshClick", (Object)isFreshClickFlag);
                break;
            }
            case "msbd_card_billstats_list": {
                fsp.setCustomParam("isFreshClick", (Object)isFreshClickFlag);
                break;
            }
        }
    }

    public void showAllCardForm(Map<String, String> allCardConfigMap, boolean isDesignMode) {
        HashMap<String, String> newCardPageMap = new HashMap<String, String>(16);
        String hideCardIdStr = this.getPageCache().get("pgCache_hideCardIds");
        Set hideCardIds = null;
        if (kd.bos.util.StringUtils.isNotEmpty((String)hideCardIdStr)) {
            hideCardIds = (Set)SerializationUtils.fromJsonString((String)hideCardIdStr, Set.class);
        }
        Map<String, Set<String>> noPermMenuMap = this.getUserNoPermMenuByAppIds(allCardConfigMap);
        for (Map.Entry<String, String> entry : allCardConfigMap.entrySet()) {
            String cardId = entry.getKey();
            if (hideCardIds != null && hideCardIds.contains(cardId)) continue;
            String strConfigMap = entry.getValue();
            Map configMap = (Map)SerializationUtils.fromJsonString((String)strConfigMap, Map.class);
            String cardType = (String)configMap.get("cardType");
            FormShowParameter fsp = new FormShowParameter();
            fsp.setSendToClient(true);
            this.setFormId(fsp, configMap);
            this.setShowType(fsp, cardType, cardId, isDesignMode);
            this.setCustomParam(fsp, cardType);
            if ("msbd_card_billstats".equals(cardType) || "msbd_card_billstats_list".equals(cardType)) {
                fsp.setCustomParam("noPermMenuMap", noPermMenuMap);
            }
            try {
                this.getView().showForm(fsp);
            }
            catch (Exception e) {
                logger.error("\u663e\u793a\u8868\u5355\u51fa\u73b0\u5f02\u5e38\uff01", (Throwable)e);
            }
            newCardPageMap.put(cardId, fsp.getPageId());
        }
        this.updateCardPageMap(newCardPageMap);
    }

    private Map<String, Set<String>> getUserNoPermMenuByAppIds(Map<String, String> allCardConfigMap) {
        HashSet appNums = new HashSet(10);
        allCardConfigMap.values().forEach(cardInfo -> {
            Map cardConfigMap = (Map)SerializationUtils.fromJsonString((String)cardInfo, Map.class);
            if ("msbd_card_billstats".equals(cardConfigMap.get("cardType"))) {
                String appNum = (String)cardConfigMap.get("appnum");
                appNums.add(appNum);
            } else if ("msbd_card_billstats_list".equals(cardConfigMap.get("cardType"))) {
                Map<String, Object> configMap = CardUtils.getDetailConfigMap(cardConfigMap);
                if (configMap == null) {
                    return;
                }
                Set cardAppNums = configMap.values().stream().map(cardInfoObj -> {
                    Map cardInfoMap = (Map)cardInfoObj;
                    return (String)cardInfoMap.get("appnum");
                }).collect(Collectors.toSet());
                appNums.addAll(cardAppNums);
            }
        });
        long userId = RequestContext.get().getCurrUserId();
        logger.info("getUserNoPermMenuByAppIds appNums size:" + appNums.size());
        if (appNums.isEmpty()) {
            return null;
        }
        Set appIds = appNums.stream().map(BizAppServiceHelp::getAppIdByAppNumber).collect(Collectors.toSet());
        Map userNoPermMenus = PermissionServiceHelper.getUserNoPermMenuByBatchApp((Long)userId, appIds);
        logger.info("getUserNoPermMenuByAppIds end");
        return userNoPermMenus;
    }

    public void resetGridContainerLayout(String layout) {
        GridContainer gc = (GridContainer)this.getView().getControl("gridcontainerap");
        gc.reset(layout);
    }

    private DynamicObject getCurUserSuitableScheme(Long userId) {
        String entityId;
        DynamicObject schemeObj = null;
        String selFields = "id,layout,schemetype,ismultiorg";
        boolean isMainPage = CardUtils.isMainPage(this.getView());
        this.getPageCache().put("IS_MainPage_Type", Boolean.toString(isMainPage));
        String strSchemeId = this.getPageCache().get("pgCache_currentScheme");
        if (kd.bos.util.StringUtils.isNotEmpty((String)strSchemeId) && QueryServiceHelper.exists((String)"msbd_wrokbench_scheme", (Object)Long.parseLong(strSchemeId))) {
            return BusinessDataServiceHelper.loadSingleFromCache((Object)Long.parseLong(strSchemeId), (String)"msbd_wrokbench_scheme", (String)selFields);
        }
        String bizAppId = CardUtils.getAppIdFromView(this.getView());
        Long defaultSchemeId = CardUtils.getDefaultSchemeId(bizAppId, entityId = this.getView().getEntityId(), this.getView());
        if (defaultSchemeId != null) {
            return BusinessDataServiceHelper.loadSingleFromCache((Object)defaultSchemeId, (String)"msbd_wrokbench_scheme", (String)selFields);
        }
        String modeType = CardUtils.convertModeType();
        List<QFilter> modeTypeFilter = Collections.singletonList(new QFilter("ismultiorg", "=", (Object)modeType));
        schemeObj = CardUtils.loadScheme(SchemeType.UserScheme, userId, selFields, modeTypeFilter, this.getView());
        if (schemeObj != null) {
            return schemeObj;
        }
        Long schemeId = CardUtils.getGroupSchemeId(userId, this.getView());
        if (schemeId != null) {
            return BusinessDataServiceHelper.loadSingleFromCache((Object)schemeId, (String)"msbd_wrokbench_scheme", (String)selFields);
        }
        schemeObj = CardUtils.loadScheme(SchemeType.SysDefScheme, userId, selFields, modeTypeFilter, this.getView());
        if (schemeObj == null && "2".equals(modeType)) {
            List<QFilter> ccsFilter = Collections.singletonList(new QFilter("ismultiorg", "=", (Object)"1"));
            schemeObj = CardUtils.loadScheme(SchemeType.SysDefScheme, userId, selFields, ccsFilter, this.getView());
        }
        return schemeObj;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void clickFreshGridContainer() {
        this.getView().getFormShowParameter().setCustomParam("isFreshClick", (Object)Boolean.TRUE);
        String curSchemeId = this.getPageCache().get("pgCache_currentScheme");
        if (kd.bos.util.StringUtils.isNotEmpty((String)curSchemeId)) {
            DynamicObject schemeObj = BusinessDataServiceHelper.loadSingle((String)"msbd_wrokbench_scheme", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(curSchemeId))});
            if (schemeObj != null) {
                boolean enable = schemeObj.getBoolean("enable");
                if (enable) {
                    this.refreshGridContainer(schemeObj);
                    return;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u8bfb\u53d6\u7684\u5de5\u4f5c\u53f0\u65b9\u6848\u5df2\u88ab\u7981\u7528\uff0c\u5df2\u4e3a\u60a8\u8df3\u8f6c\u5176\u4ed6\u65b9\u6848\u3002", (String)"WorkBenchTplFormPlugin_2", (String)"mpscmm-msbd-workbench", (Object[])new Object[0]));
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u8bfb\u53d6\u7684\u5de5\u4f5c\u53f0\u65b9\u6848\u5df2\u88ab\u5220\u9664\uff0c\u5df2\u4e3a\u60a8\u8df3\u8f6c\u5176\u4ed6\u65b9\u6848\u3002", (String)"WorkBenchTplFormPlugin_3", (String)"mpscmm-msbd-workbench", (Object[])new Object[0]));
            }
        }
        this.refreshGridContainer();
        this.updateNewPortalScheme();
    }

    public void refreshGridContainer(DynamicObject schemeObj) {
        DynamicObject[] arrDObj;
        String layout = null;
        Long schemeId = 0L;
        String schemeType = "";
        if (schemeObj != null) {
            layout = schemeObj.getString("layout");
            schemeId = schemeObj.getLong("id");
            schemeType = schemeObj.getString("schemetype");
        }
        this.getPageCache().put("pgCache_currentScheme", String.valueOf(schemeId));
        this.getPageCache().put("pgCache_currentSchemeType", schemeType);
        this.showItemControl(Boolean.TRUE);
        if (kd.bos.util.StringUtils.isEmpty((String)layout)) {
            return;
        }
        layout = CardUtils.replaceBackSlach(layout);
        this.resetGridContainerLayout(layout);
        this.getPageCache().put("pgCache_grid_layout", layout);
        HashMap<String, String> allCardConfig = new HashMap<String, String>(16);
        for (DynamicObject cardObj : arrDObj = CardUtils.loadAllMainPageCardConfig(schemeId)) {
            String cardId = cardObj.getString("cardid");
            String configStr = cardObj.getString("config");
            configStr = CardUtils.convertToPureJson(configStr);
            Map configMap = null;
            try {
                configMap = (Map)SerializationUtils.fromJsonString((String)configStr, Map.class);
            }
            catch (Exception e) {
                logger.error("\u5361\u7247\u914d\u7f6e\u5b58\u5728\u95ee\u9898\uff0c\u5bfc\u81f4\u52a0\u8f7d\u4e3a\u7a7a\uff1a", (Throwable)e);
                continue;
            }
            String mapEntryStr = "";
            String cardTitleInCfgStr = (String)configMap.get("cardtitle");
            if (kd.bos.util.StringUtils.isNotEmpty((String)cardTitleInCfgStr) && !"[]".equals(cardTitleInCfgStr)) {
                mapEntryStr = "[zh_CN=" + cardTitleInCfgStr + "]";
            } else {
                OrmLocaleValue ormLocaleValue = (OrmLocaleValue)cardObj.get("cardtitle");
                mapEntryStr = CardUtils.getMapEntryStrFromOrmLocaleValue(ormLocaleValue);
            }
            configMap.put("cardtitle", mapEntryStr);
            configStr = SerializationUtils.toJsonString((Object)configMap);
            allCardConfig.put(cardId, configStr);
        }
        this.setAllCardConfigCache(allCardConfig);
        this.getView().addClientCallBack("showAllCardForm");
    }

    public void clientCallBack(ClientCallBackEvent e) {
        if ("showAllCardForm".equals(e.getName())) {
            Map<String, String> allCardConfig = this.getAllCardConfigMap();
            this.showAllCardForm(allCardConfig, false);
        }
    }

    public void refreshGridContainer() {
        Long userId = RequestContext.get().getCurrUserId();
        DynamicObject schemeObj = this.getCurUserSuitableScheme(userId);
        try {
            if (schemeObj == null) {
                this.resetGridContainerLayout(null);
                this.showItemOnlyModify();
                return;
            }
        }
        catch (Exception exception) {
            logger.info("\u6ca1\u6709\u5de5\u4f5c\u53f0\u65b9\u6848\uff0c\u91cd\u7f6e\u4e3a\u7a7a\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + exception.getMessage());
        }
        this.refreshGridContainer(schemeObj);
    }

    private void setAllCardConfigCache(Map<String, String> allCardConfigMap) {
        String jsonStr = SerializationUtils.toJsonString(allCardConfigMap);
        this.getPageCache().put("cache_allCardConfig", jsonStr);
    }

    private String getNewCardId() {
        long lNewCardId = ORM.create().genLongId("msbd_workbenchcardconf");
        String newCardId = String.valueOf(lNewCardId);
        return newCardId;
    }

    public Map<String, String> getAllCardConfigMap() {
        HashMap<String, String> allCardConfigMap = null;
        String cacheStr = this.getPageCache().get("cache_allCardConfig");
        if (kd.bos.util.StringUtils.isNotEmpty((String)cacheStr)) {
            allCardConfigMap = (HashMap<String, String>)SerializationUtils.fromJsonString((String)cacheStr, Map.class);
        } else {
            allCardConfigMap = new HashMap<String, String>(16);
            this.setAllCardConfigCache(allCardConfigMap);
        }
        return allCardConfigMap;
    }

    public void deleteCard(String cardId) {
        List<String> tempDelIds = this.getTempDelIds();
        tempDelIds.add(cardId);
        this.updateTempDelIds(tempDelIds);
    }

    public List<String> getTempDelIds() {
        ArrayList<String> result = null;
        String tempDelStr = this.getPageCache().get("cache_TempDel");
        if (kd.bos.util.StringUtils.isEmpty((String)tempDelStr)) {
            result = new ArrayList();
            this.getPageCache().put("cache_TempDel", SerializationUtils.toJsonString(result));
        } else {
            result = (List)SerializationUtils.fromJsonString((String)tempDelStr, List.class);
        }
        return result;
    }

    public void updateTempDelIds(List<String> tempDelIds) {
        this.getPageCache().put("cache_TempDel", SerializationUtils.toJsonString(tempDelIds));
    }

    public Map<String, String> getCardPageMap() {
        HashMap<String, String> result = null;
        String cardPageMapStr = this.getPageCache().get("cache_CardId_PageId_Map");
        if (kd.bos.util.StringUtils.isEmpty((String)cardPageMapStr)) {
            result = new HashMap(16);
            this.getPageCache().put("cache_CardId_PageId_Map", SerializationUtils.toJsonString(result));
        } else {
            result = (Map)SerializationUtils.fromJsonString((String)cardPageMapStr, Map.class);
        }
        return result;
    }

    public void setCardPageMap(Map<String, String> pCardPageMap) {
        this.getPageCache().put("cache_CardId_PageId_Map", SerializationUtils.toJsonString(pCardPageMap));
    }

    public static void updateCardIdPageIdMap(IFormView pMainFormView, String cardId, String pageId) {
        IPageCache pageCache = (IPageCache)pMainFormView.getService(IPageCache.class);
        String cardPageMapStr = pageCache.get("cache_CardId_PageId_Map");
        Map<String, String> cardPageMap = null;
        if (kd.bos.util.StringUtils.isEmpty((String)cardPageMapStr)) {
            cardPageMap = new HashMap(16);
            pageCache.put("cache_CardId_PageId_Map", SerializationUtils.toJsonString(cardPageMap));
        } else {
            cardPageMap = (Map)SerializationUtils.fromJsonString((String)cardPageMapStr, Map.class);
        }
        cardPageMap.put(cardId, pageId);
        pageCache.put("cache_CardId_PageId_Map", SerializationUtils.toJsonString(cardPageMap));
    }

    public void updateCardPageMap(Map<String, String> newCardIdPageIdMap) {
        Map<String, String> cardPageMap = this.getCardPageMap();
        cardPageMap.putAll(newCardIdPageIdMap);
        this.setCardPageMap(cardPageMap);
    }

    public void changeToDesignMode() {
        if (!this.checkCanEditAndShowTip(true)) {
            return;
        }
        GridContainer gridContainer = (GridContainer)this.getView().getControl("gridcontainerap");
        gridContainer.setDesignMode(true);
        this.showItemControl(Boolean.FALSE);
        this.showAllCardForm(this.getAllCardConfigMap(), true);
        Long userId = RequestContext.get().getCurrUserId();
        boolean hasPerm = CardUtils.checkHasModifySchemeRight(userId);
        if (!hasPerm) {
            hasPerm = PermissionServiceHelper.isAdminUser((long)userId, (AdminType)AdminType.Administrator);
        }
        if (hasPerm) {
            String curSchemeType = this.getPageCache().get("pgCache_currentSchemeType");
            if (kd.bos.util.StringUtils.isNotEmpty((String)curSchemeType) && SchemeType.SysDefScheme.getValue().equals(curSchemeType)) {
                gridContainer.setIsDefaultVisible(false);
            } else {
                gridContainer.setIsDefaultVisible(true);
            }
        } else {
            gridContainer.setIsDefaultVisible(false);
        }
    }

    public void trigger() {
        this.refreshGridContainer();
        this.initNewPortalScheme();
    }

    public void editEnd(SchemeType schemeType, String layout, Long modifyCurSchemeId) {
        Map<String, String> allCardConfigMap = this.getAllCardConfigMap();
        HashMap<String, String> deletedCardConfigMap = new HashMap<String, String>(16);
        List<String> tempDelIds = this.getTempDelIds();
        Map<String, String> cardPageMap = this.getCardPageMap();
        for (String tempDelId : tempDelIds) {
            String cardConfig = allCardConfigMap.remove(tempDelId);
            deletedCardConfigMap.put(tempDelId, cardConfig);
            cardPageMap.remove(tempDelId);
        }
        this.setAllCardConfigCache(allCardConfigMap);
        this.setCardPageMap(cardPageMap);
        this.updateTempDelIds(new ArrayList<String>());
        CardUtils cardUtils = new CardUtils(this.getView(), this.getPageCache(), this.getModel(), logger);
        boolean result = cardUtils.saveWorkBenchInfo(schemeType, layout, allCardConfigMap, modifyCurSchemeId, null);
        if (result) {
            this.showAllCardForm(allCardConfigMap, false);
            GridContainer gridContainer = (GridContainer)this.getView().getControl("gridcontainerap");
            gridContainer.setDesignMode(false);
            this.showItemControl(Boolean.TRUE);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"WorkBenchTplFormPlugin_4", (String)"mpscmm-msbd-workbench", (Object[])new Object[0]));
        }
        this.onEndOfEditEnd(deletedCardConfigMap);
        this.initNewPortalScheme();
    }

    private void doFinish(String layout, boolean isSetDefault) {
        this.getPageCache().put("pgCache_grid_layout", layout);
        Long userId = RequestContext.get().getCurrUserId();
        String curSchemeType = this.getPageCache().get("pgCache_currentSchemeType");
        boolean hasModifyPerm = CardUtils.checkHasModifySchemeRight(userId);
        if (isSetDefault) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u5b9a\u8981\u5c06\u5f53\u524d\u5e03\u5c40\u8bbe\u4e3a\u5168\u5c40\u65b9\u6848\u5417\uff1f", (String)"WorkBenchTplFormPlugin_5", (String)"mpscmm-msbd-workbench", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("confirm_setDefault", (IFormPlugin)this));
        } else if (hasModifyPerm && (SchemeType.SysDefScheme.getValue().equals(curSchemeType) || SchemeType.GroupScheme.getValue().equals(curSchemeType))) {
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(16);
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u5f53\u524d\u65b9\u6848", (String)"WorkBenchTplFormPlugin_6", (String)"mpscmm-msbd-workbench", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.No.getValue(), ResManager.loadKDString((String)"\u4e2a\u6027\u65b9\u6848", (String)"WorkBenchTplFormPlugin_7", (String)"mpscmm-msbd-workbench", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"WorkBenchTplFormPlugin_8", (String)"mpscmm-msbd-workbench", (Object[])new Object[0]));
            MessageBoxOptions options = MessageBoxOptions.YesNoCancel;
            String msg = ResManager.loadKDString((String)"\u60a8\u6709\u6743\u8bbe\u7f6e\u5de5\u4f5c\u53f0\u5e03\u5c40\uff0c\u76f4\u63a5\u4fee\u6539\u5f53\u524d\u65b9\u6848\u8fd8\u662f\u4fee\u6539\u4e2a\u6027\u65b9\u6848\uff1f", (String)"WorkBenchTplFormPlugin_9", (String)"mpscmm-msbd-workbench", (Object[])new Object[0]);
            this.getView().showConfirm(msg, "", options, ConfirmTypes.Save, new ConfirmCallBackListener("confirm_modifyOrNewCustom", (IFormPlugin)this), btnNameMaps);
        } else if (this.isOutAdmin() && SchemeType.GroupScheme.getValue().equals(curSchemeType)) {
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(16);
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u5f53\u524d\u65b9\u6848", (String)"WorkBenchTplFormPlugin_6", (String)"mpscmm-msbd-workbench", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.No.getValue(), ResManager.loadKDString((String)"\u4e2a\u6027\u65b9\u6848", (String)"WorkBenchTplFormPlugin_7", (String)"mpscmm-msbd-workbench", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"WorkBenchTplFormPlugin_8", (String)"mpscmm-msbd-workbench", (Object[])new Object[0]));
            MessageBoxOptions options = MessageBoxOptions.YesNoCancel;
            String msg = ResManager.loadKDString((String)"\u60a8\u6709\u6743\u8bbe\u7f6e\u5de5\u4f5c\u53f0\u5e03\u5c40\uff0c\u76f4\u63a5\u4fee\u6539\u5f53\u524d\u65b9\u6848\u8fd8\u662f\u4fee\u6539\u4e2a\u6027\u65b9\u6848\uff1f", (String)"WorkBenchTplFormPlugin_9", (String)"mpscmm-msbd-workbench", (Object[])new Object[0]);
            this.getView().showConfirm(msg, "", options, ConfirmTypes.Save, new ConfirmCallBackListener("confirm_modifyOrNewCustom", (IFormPlugin)this), btnNameMaps);
        } else if (!hasModifyPerm && (SchemeType.SysDefScheme.getValue().equals(curSchemeType) || SchemeType.GroupScheme.getValue().equals(curSchemeType))) {
            List<DynamicObject> schemeDatas = this.getCurrentUserScheme(SchemeType.UserScheme);
            if (kd.bos.util.CollectionUtils.isEmpty(schemeDatas)) {
                this.editEnd(SchemeType.UserScheme, layout, null);
            } else {
                HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(16);
                btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u5b9a", (String)"WorkBenchTplFormPlugin_10", (String)"mpscmm-msbd-workbench", (Object[])new Object[0]));
                btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"WorkBenchTplFormPlugin_8", (String)"mpscmm-msbd-workbench", (Object[])new Object[0]));
                MessageBoxOptions options = MessageBoxOptions.OKCancel;
                String msg = ResManager.loadKDString((String)"\u6b64\u6b21\u4fee\u6539\u7684\u65b9\u6848\u5c06\u4f1a\u66ff\u6362\u4f60\u5df2\u6709\u7684\u4e2a\u6027\u65b9\u6848\uff0c\u662f\u5426\u7ee7\u7eed\u4fdd\u5b58\uff1f", (String)"WorkBenchTplFormPlugin_11", (String)"mpscmm-msbd-workbench", (Object[])new Object[0]);
                this.getView().showConfirm(msg, "", options, ConfirmTypes.Save, new ConfirmCallBackListener("confirmcallbackid_modify_custom", (IFormPlugin)this), btnNameMaps);
            }
        } else {
            this.editEnd(SchemeType.UserScheme, layout, null);
        }
    }

    private boolean isOutAdmin() {
        Long userId = RequestContext.get().getCurrUserId();
        ArrayList<Long> userIds = new ArrayList<Long>();
        userIds.add(userId);
        Map types = UserServiceHelper.getUserBaseTypeByIds(userIds);
        if (types != null && types.size() > 0) {
            List bizPartners;
            Integer type = (Integer)types.get(userId);
            logger.info("\u4eba\u5458\u7c7b\u578b\uff1a" + type);
            if ("200".equals(String.valueOf(type)) && (bizPartners = UserServiceHelper.getInChargeOfBizPartnerByUserId((long)userId)) != null && bizPartners.size() > 0) {
                logger.info("\u5916\u90e8\u7528\u6237\u7ba1\u7406\u4e2a\u6570\uff1a" + bizPartners.size());
                return true;
            }
        }
        return false;
    }

    private void onEndOfEditEnd(Map<String, String> deletedCardConfigMap) {
        this.doQingThing(deletedCardConfigMap);
    }

    private void doQingThing(Map<String, String> deletedCardConfigMap) {
        HashMap<String, String> deletedQingCardConfig = new HashMap<String, String>(16);
        for (Map.Entry<String, String> entry : deletedCardConfigMap.entrySet()) {
            Map oneCardConfigMap;
            String cardType;
            String cardConfigJson = entry.getValue();
            if (cardConfigJson == null || !"msbd_card_qing".equals(cardType = (String)(oneCardConfigMap = (Map)SerializationUtils.fromJsonString((String)cardConfigJson, Map.class)).get("cardType"))) continue;
            deletedQingCardConfig.put(entry.getKey(), cardConfigJson);
        }
        if (deletedQingCardConfig.size() > 0) {
            DispatchServiceHelper.invokeBOSService((String)"qing", (String)"QingService", (String)"removeCardFromHomepage", (Object[])new Object[]{deletedQingCardConfig});
        }
    }

    public void editCancel() {
        this.updateTempDelIds(new ArrayList<String>());
        this.showItemControl(Boolean.TRUE);
        this.refreshGridContainer();
    }

    private void initNewPortalScheme() {
        try {
            if (this.isNewPortal()) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"floatmenu", "floatmenupanelap"});
                HashMap<String, String> r = new HashMap<String, String>(16);
                r.put("r", "0px");
                HashMap<String, HashMap<String, String>> p = new HashMap<String, HashMap<String, String>>(16);
                p.put("p", r);
                HashMap<String, HashMap<String, HashMap<String, String>>> s = new HashMap<String, HashMap<String, HashMap<String, String>>>(16);
                s.put("s", p);
                this.getView().updateControlMetadata("gridcontainerap", s);
                IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
                proxy.setFieldProperty("gridcontainerap", "portalScheme", this.getWorkBenchSchemeInfo(false));
            }
        }
        catch (Exception e) {
            logger.error("initNewPortalScheme error", (Throwable)e);
        }
    }

    private void updateNewPortalScheme() {
        try {
            if (this.isNewPortal()) {
                IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
                proxy.setFieldProperty("gridcontainerap", "portalScheme", this.getWorkBenchSchemeInfo(false));
            }
        }
        catch (Exception e) {
            logger.error("updateNewPortalScheme error", (Throwable)e);
        }
    }

    private Map<String, Object> getWorkBenchSchemeInfo(boolean showTip) {
        HashMap<String, Object> schemeMap = new HashMap<String, Object>(16);
        String currentSchemeId = this.getPageCache().get("pgCache_currentScheme");
        schemeMap.put("schemeGroup", this.getUserAvailSchemesGroup());
        schemeMap.put("defaultSchemeId", this.getDefaultScheme() + "");
        schemeMap.put("selectedSchemeId", currentSchemeId);
        schemeMap.put("canSave", this.canSave());
        boolean editable = this.checkCanEditAndShowTip(showTip);
        schemeMap.put("editable", editable);
        Object saveList = null;
        if (editable) {
            saveList = this.getSaveList();
        }
        schemeMap.put("saveSTList", saveList);
        return schemeMap;
    }

    private boolean canSave() {
        String curSchemeId;
        Long useId = RequestContext.get().getCurrUserId();
        boolean hasPerm = CardUtils.checkHasModifySchemeRight(useId);
        if (!hasPerm && (curSchemeId = this.getPageCache().get("pgCache_currentScheme")) != null) {
            DynamicObject scheme = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.valueOf(curSchemeId), (String)"msbd_wrokbench_scheme");
            DynamicObject creator = scheme.getDynamicObject("creator");
            Long creatorId = creator.getLong("id");
            return useId.equals(creatorId);
        }
        return true;
    }

    private List<Map<String, Object>> getUserAvailSchemesGroup() {
        List<QFilter> filters = this.getCurrentUserSchemeFilters();
        DynamicObjectCollection schemeList = QueryServiceHelper.query((String)"msbd_wrokbench_scheme", (String)"id, number, name, schemetype, ispreset, creator", (QFilter[])filters.toArray(new QFilter[0]));
        if (schemeList == null) {
            return null;
        }
        Map<Integer, List<DynamicObject>> schemeDataGroup = schemeList.stream().collect(Collectors.groupingBy(data -> data.getInt("schemetype")));
        ArrayList<Map<String, Object>> schemeGroupList = new ArrayList<Map<String, Object>>();
        for (String schemeType : schemeTypes) {
            Integer type = Integer.valueOf(schemeType);
            List<DynamicObject> schemes = schemeDataGroup.get(type);
            if (kd.bos.util.CollectionUtils.isEmpty(schemes)) continue;
            HashMap<String, Object> schemeGroup = new HashMap<String, Object>(16);
            schemeGroup.put("type", type);
            schemeGroup.put("name", SchemeType.getSchemeType(type + "").getName());
            ArrayList schemeDataList = new ArrayList(schemes.size());
            for (DynamicObject dy : schemes) {
                HashMap<String, Object> schemeDataMap = new HashMap<String, Object>(16);
                schemeDataMap.put("name", dy.getString("name"));
                schemeDataMap.put("id", dy.getString("id"));
                schemeDataMap.put("canDelete", SchemeType.getSchemeType(type + "") == SchemeType.UserScheme);
                schemeDataMap.put("canSetAsDefault", true);
                schemeDataList.add(schemeDataMap);
            }
            schemeGroup.put("items", schemeDataList);
            schemeGroupList.add(schemeGroup);
        }
        return schemeGroupList;
    }

    private Long getDefaultScheme() {
        String bizAppId = CardUtils.getAppIdFromView(this.getView());
        String entityId = this.getView().getEntityId();
        return CardUtils.getDefaultSchemeId(bizAppId, entityId, this.getView());
    }

    private Object getSaveList() {
        ArrayList<Map<String, String>> saveList = new ArrayList<Map<String, String>>();
        long userId = RequestContext.get().getCurrUserId();
        boolean hasPerm = CardUtils.checkHasModifySchemeRight(userId);
        String currentSchemeType = this.getPageCache().get("pgCache_currentSchemeType");
        if (this.isOutAdmin()) {
            saveList.add(this.buildSaveMap(SchemeType.GroupScheme.getValue(), SchemeType.GroupScheme.getName()));
        } else if (hasPerm) {
            if (SchemeType.SysDefScheme.getValue().equals(currentSchemeType)) {
                saveList.add(this.buildSaveMap(SchemeType.GroupScheme.getValue(), SchemeType.GroupScheme.getName()));
                saveList.add(this.buildSaveMap(SchemeType.UserScheme.getValue(), SchemeType.UserScheme.getName()));
            } else if (SchemeType.UserScheme.getValue().equals(currentSchemeType)) {
                saveList.add(this.buildSaveMap(SchemeType.SysDefScheme.getValue(), SchemeType.SysDefScheme.getName()));
                saveList.add(this.buildSaveMap(SchemeType.GroupScheme.getValue(), SchemeType.GroupScheme.getName()));
            } else if (SchemeType.GroupScheme.getValue().equals(currentSchemeType)) {
                saveList.add(this.buildSaveMap(SchemeType.SysDefScheme.getValue(), SchemeType.SysDefScheme.getName()));
                saveList.add(this.buildSaveMap(SchemeType.GroupScheme.getValue(), SchemeType.GroupScheme.getName()));
                saveList.add(this.buildSaveMap(SchemeType.UserScheme.getValue(), SchemeType.UserScheme.getName()));
            }
        } else if (SchemeType.SysDefScheme.getValue().equals(currentSchemeType) || SchemeType.GroupScheme.getValue().equals(currentSchemeType)) {
            saveList.add(this.buildSaveMap(SchemeType.UserScheme.getValue(), SchemeType.UserScheme.getName()));
        }
        return saveList;
    }

    private Map<String, String> buildSaveMap(String type, String name) {
        HashMap<String, String> saveMap = new HashMap<String, String>(16);
        saveMap.put("type", type);
        saveMap.put("name", name);
        return saveMap;
    }

    private void toDesignMode() {
        if (!this.checkCanEditAndShowTip(true)) {
            return;
        }
        GridContainer gridContainer = (GridContainer)this.getView().getControl("gridcontainerap");
        gridContainer.setDesignMode(true);
        this.showItemControl(Boolean.FALSE);
        this.showAllCardForm(this.getAllCardConfigMap(), true);
    }

    private void switchScheme(String schemeId) {
        String curSchemeId = this.getPageCache().get("pgCache_currentScheme");
        if (curSchemeId.equals(schemeId)) {
            return;
        }
        DynamicObject schemeObj = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.valueOf(schemeId), (String)"msbd_wrokbench_scheme");
        if (schemeObj == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5de5\u4f5c\u53f0\u65b9\u6848\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u5207\u6362\u3002", (String)"WorkBenchTplFormPlugin_12", (String)"mpscmm-msbd-workbench", (Object[])new Object[0]));
            return;
        }
        boolean enable = schemeObj.getBoolean("enable");
        if (enable) {
            this.refreshGridContainer(schemeObj);
            this.initNewPortalScheme();
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5de5\u4f5c\u53f0\u65b9\u6848\u5df2\u88ab\u7981\u7528\uff0c\u65e0\u6cd5\u5207\u6362\u3002", (String)"WorkBenchTplFormPlugin_13", (String)"mpscmm-msbd-workbench", (Object[])new Object[0]));
        }
    }

    private void setDefaultScheme(String schemeId) {
        if (kd.bos.util.StringUtils.isEmpty((String)schemeId)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5de5\u4f5c\u53f0\u65b9\u6848\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u8bbe\u4e3a\u9ed8\u8ba4\u3002", (String)"WorkBenchTplFormPlugin_14", (String)"mpscmm-msbd-workbench", (Object[])new Object[0]));
            return;
        }
        String bizAppId = CardUtils.getAppIdFromView(this.getView());
        String entityId = this.getView().getEntityId();
        CardUtils.setDefaultScheme(Long.parseLong(schemeId), bizAppId, entityId);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8bbe\u7f6e\u9ed8\u8ba4\u65b9\u6848\u6210\u529f\u3002", (String)"WorkBenchTplFormPlugin_15", (String)"mpscmm-msbd-workbench", (Object[])new Object[0]));
        if (this.isNewPortal()) {
            this.updateNewPortalScheme();
        }
    }

    private void deleteScheme(String schemeId) {
        boolean canDelete;
        String schemeType;
        long userId = RequestContext.get().getCurrUserId();
        DynamicObject scheme = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.valueOf(schemeId), (String)"msbd_wrokbench_scheme");
        boolean ispreset = scheme.getBoolean("ispreset");
        DynamicObject creatorDy = scheme.getDynamicObject("creator");
        String creator = "";
        if (creatorDy != null) {
            creator = creatorDy.getString("id");
        }
        boolean isUserScheme = SchemeType.getSchemeType(schemeType = scheme.getString("schemetype")) == SchemeType.UserScheme;
        boolean bl = canDelete = isUserScheme && !ispreset && creator.equals(userId + "");
        if (canDelete) {
            String curSchemeId = this.getPageCache().get("pgCache_currentScheme");
            if (schemeId.equals(curSchemeId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e2a\u6027\u65b9\u6848\u6b63\u5728\u4f7f\u7528\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"WorkBenchTplFormPlugin_16", (String)"mpscmm-msbd-workbench", (Object[])new Object[0]));
                return;
            }
            this.getPageCache().put("delete_userSchemeId", schemeId);
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(16);
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u5b9a", (String)"WorkBenchTplFormPlugin_10", (String)"mpscmm-msbd-workbench", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"WorkBenchTplFormPlugin_8", (String)"mpscmm-msbd-workbench", (Object[])new Object[0]));
            MessageBoxOptions options = MessageBoxOptions.OKCancel;
            this.getView().showConfirm(ResManager.loadKDString((String)"\u4e2a\u6027\u65b9\u6848\u5220\u9664\u540e\u4e0d\u53ef\u6062\u590d\uff0c\u786e\u5b9a\u8981\u5220\u9664\u5417\uff1f", (String)"WorkBenchTplFormPlugin_17", (String)"mpscmm-msbd-workbench", (Object[])new Object[0]), "", options, ConfirmTypes.Save, new ConfirmCallBackListener("confirmcallbackid_delete_user", (IFormPlugin)this), btnNameMaps);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9875\u9762\u53ea\u80fd\u5220\u9664\u4e2a\u6027\u65b9\u6848\u3002", (String)"WorkBenchTplFormPlugin_18", (String)"mpscmm-msbd-workbench", (Object[])new Object[0]));
        }
    }

    private void deleteScheme() {
        String schemeId = this.getPageCache().get("delete_userSchemeId");
        DeleteServiceHelper.delete((String)"msbd_wrokbench_scheme", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(schemeId))});
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"WorkBenchTplFormPlugin_19", (String)"mpscmm-msbd-workbench", (Object[])new Object[0]));
        this.updateNewPortalScheme();
    }

    private void saveCurrentScheme(String layout) {
        boolean hasPerm = this.canSave();
        if (!hasPerm) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u5f53\u524d\u65b9\u6848\u4fee\u6539\u6743\u9650\u3002", (String)"WorkBenchTplFormPlugin_20", (String)"mpscmm-msbd-workbench", (Object[])new Object[0]));
            return;
        }
        boolean editable = this.checkCanEdit();
        if (editable) {
            String schemeId = this.getPageCache().get("pgCache_currentScheme");
            String schemeType = this.getPageCache().get("pgCache_currentSchemeType");
            if (schemeId != null && schemeType != null) {
                this.editEnd(SchemeType.getSchemeType(schemeType), layout, Long.valueOf(schemeId));
            } else {
                this.saveAsScheme(layout, SchemeType.UserScheme);
            }
        }
    }

    private void saveAsSchemeType(String schemeType, String layout) {
        String sysScheme = SchemeType.SysDefScheme.getValue();
        String groupScheme = SchemeType.GroupScheme.getValue();
        String userScheme = SchemeType.UserScheme.getValue();
        if (sysScheme.equals(schemeType) || userScheme.equals(schemeType)) {
            this.saveAsScheme(layout, SchemeType.getSchemeType(schemeType));
        } else if (groupScheme.equals(schemeType)) {
            this.showGroupSchemeSaveAs();
        }
    }

    private void showGroupSchemeSaveAs() {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("msbd_scheme_saveas");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(fsp);
    }

    private void saveAsScheme(String layout, SchemeType schemeType) {
        this.getPageCache().put("pgCache_grid_layout", layout);
        List<DynamicObject> schemeDatas = this.getCurrentUserScheme(schemeType);
        if (kd.bos.util.CollectionUtils.isEmpty(schemeDatas)) {
            this.editEnd(schemeType, layout, null);
        } else if (schemeDatas.size() == 1) {
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(16);
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u5b9a", (String)"WorkBenchTplFormPlugin_10", (String)"mpscmm-msbd-workbench", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"WorkBenchTplFormPlugin_8", (String)"mpscmm-msbd-workbench", (Object[])new Object[0]));
            MessageBoxOptions options = MessageBoxOptions.OKCancel;
            this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u60a8\u5df2\u6709{0}\uff0c\u786e\u5b9a\u8981\u8986\u76d6\u5b83\u5417\uff1f", (String)"WorkBenchTplFormPlugin_21", (String)"mpscmm-msbd-workbench", (Object[])new Object[0]), schemeType.getName()), "", options, ConfirmTypes.Save, new ConfirmCallBackListener(this.getSingleCallBackId(schemeType), (IFormPlugin)this), btnNameMaps);
        } else {
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(16);
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u5b9a", (String)"WorkBenchTplFormPlugin_10", (String)"mpscmm-msbd-workbench", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"WorkBenchTplFormPlugin_8", (String)"mpscmm-msbd-workbench", (Object[])new Object[0]));
            MessageBoxOptions options = MessageBoxOptions.OKCancel;
            String msg = String.format(ResManager.loadKDString((String)"\u60a8\u5df2\u6709\u591a\u4e2a{0}\uff0c\u53e6\u5b58\u540e\u5c06\u7981\u7528\u5176\u4ed6{1}\uff0c\u786e\u5b9a\u8981\u64cd\u4f5c\u5417\uff1f", (String)"WorkBenchTplFormPlugin_22", (String)"mpscmm-msbd-workbench", (Object[])new Object[0]), schemeType.getName(), schemeType.getName());
            this.getView().showConfirm(msg, "", options, ConfirmTypes.Save, new ConfirmCallBackListener(this.getMulitCallBackId(schemeType), (IFormPlugin)this), btnNameMaps);
        }
    }

    private void disableScheme(List<DynamicObject> schemeDatas) {
        if (kd.bos.util.CollectionUtils.isEmpty(schemeDatas)) {
            return;
        }
        schemeDatas.forEach(scheme -> scheme.set("enable", (Object)0));
        SaveServiceHelper.update((DynamicObject[])schemeDatas.toArray(new DynamicObject[0]));
    }

    private String getSingleCallBackId(SchemeType schemeType) {
        String callBackId = "";
        if (SchemeType.SysDefScheme == schemeType) {
            callBackId = "confirmcallbackid_modify_sys";
        } else if (SchemeType.UserScheme == schemeType) {
            callBackId = "confirmcallbackid_modify_custom";
        }
        return callBackId;
    }

    private String getMulitCallBackId(SchemeType schemeType) {
        String callBackId = "";
        if (SchemeType.SysDefScheme == schemeType) {
            callBackId = "confirmcallbackid_disable_allsys";
        } else if (SchemeType.UserScheme == schemeType) {
            callBackId = "confirmcallbackid_disable_allcustom";
        }
        return callBackId;
    }

    private List<DynamicObject> getCurrentUserScheme(SchemeType schemeType) {
        List<QFilter> filters = this.getCurrentUserSchemeFilters();
        QFilter customFilter = new QFilter("schemetype", "=", (Object)schemeType);
        filters.add(customFilter);
        Map schemeDatas = BusinessDataServiceHelper.loadFromCache((String)"msbd_wrokbench_scheme", (String)"id,enable", (QFilter[])filters.toArray(new QFilter[0]));
        return new ArrayList<DynamicObject>(schemeDatas.values());
    }

    private List<QFilter> getCurrentUserSchemeFilters() {
        long userId = RequestContext.get().getCurrUserId();
        ArrayList<QFilter> rangeFilterList = new ArrayList<QFilter>();
        QFilter filter = null;
        QFilter curSituationfilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        String formNum = this.getView().getEntityId();
        curSituationfilter = curSituationfilter.and(new QFilter("formnum", "=", (Object)formNum));
        QFilter curSituationfilter2 = curSituationfilter.copy();
        QFilter curUserScheme = new QFilter("creator", "=", (Object)userId).and(new QFilter("schemetype", "=", (Object)SchemeType.UserScheme.getValue()));
        QFilter sysDefScheme = new QFilter("schemetype", "=", (Object)SchemeType.SysDefScheme.getValue());
        filter = curSituationfilter2.and(curUserScheme.or(sysDefScheme));
        List<Long> groupSchemeIds = CardUtils.getShareSchemeIds(userId, this.getView());
        if (!kd.bos.util.CollectionUtils.isEmpty(groupSchemeIds)) {
            QFilter groupSchemeFilter = new QFilter("id", "in", groupSchemeIds);
            filter = filter.or(groupSchemeFilter);
        }
        QFilter curCreatorOrModifier = curSituationfilter.and(new QFilter("creator", "=", (Object)userId));
        filter = filter.or(curCreatorOrModifier);
        String modeType = CardUtils.convertModeType();
        filter.and("ismultiorg", "=", (Object)modeType);
        rangeFilterList.add(filter);
        return rangeFilterList;
    }

    private List<TreeMenuNode> loadUserMarkedMenus(String userId) {
        ArrayList<TreeMenuNode> markedMenuList = new ArrayList<TreeMenuNode>();
        try {
            DynamicObject[] userMarkedMenus = BusinessDataServiceHelper.load((String)"portal_usermarkedmenu", (String)"bizapp,menu", (QFilter[])new QFilter[]{new QFilter("user", "=", (Object)Long.parseLong(userId))});
            if (userMarkedMenus != null && userMarkedMenus.length > 0) {
                for (DynamicObject userMarkedMenu : userMarkedMenus) {
                    String menuId = userMarkedMenu.getString("menu");
                    String appId = userMarkedMenu.getString("bizapp");
                    AppInfo appInfo = AppMetadataCache.getAppInfo((String)appId);
                    AppMenuInfo appMenuInfo = AppMetadataCache.getAppMenuInfo((String)appId, (String)menuId);
                    TreeMenuNode node = new TreeMenuNode(appInfo.getId(), appMenuInfo.getId(), appMenuInfo.getName().getLocaleValue());
                    node.setIconUrl(appMenuInfo.getNaviVector());
                    markedMenuList.add(node);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u7528\u6237\u6536\u85cf\u83dc\u5355\u4fe1\u606f\u6709\u8bef", (Throwable)e);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u7528\u6237\u6536\u85cf\u83dc\u5355\u4fe1\u606f\u6709\u8bef\u3002", (String)"WorkBenchTplFormPlugin_23", (String)"mpscmm-msbd-workbench", (Object[])new Object[0]));
        }
        return markedMenuList;
    }

    public void treeMenuClick(TreeNodeEvent evt) {
        String appID = (String)evt.getParentNodeId();
        String menuId = evt.getNodeId().toString();
        this.openMenu(appID, menuId);
    }

    private void openMenu(String appId, String menuId) {
        List<AppMenuInfo> qingMenus = this.menuService.getQingMenuArray(appId);
        List<String> qingMenuIds = this.getQingMenuIds(qingMenus);
        if (qingMenus != null && qingMenuIds.contains(menuId)) {
            for (AppMenuInfo qingObj : qingMenus) {
                String qingMenuId = qingObj.getId();
                if (!menuId.equals(qingMenuId)) continue;
                String formNumber = qingObj.getFormId();
                LocaleString localeString = qingObj.getName();
                String qingMenuName = "";
                if (localeString != null) {
                    qingMenuName = localeString.getLocaleValue();
                }
                String formParams = qingObj.getParams();
                FormConfig formConfig = FormMetadataCache.getFormConfig((String)formNumber);
                if (formConfig == null) {
                    String message = ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230\u8f7b\u5206\u6790\u52a8\u6001\u7f16\u7801\u4e3a{0}\u7684\u52a8\u6001\u8868\u5355\uff0c\u8bf7\u524d\u5f80\u8f7b\u5206\u6790\u52a8\u6001\u8868\u5355\u7ba1\u7406\u4e2d\u7ef4\u62a4\u3002", (String)"WorkBenchTplFormPlugin_24", (String)"mpscmm-msbd-workbench", (Object[])new Object[]{formNumber});
                    this.getView().showTipNotification(message);
                    return;
                }
                if (StringUtils.isBlank((CharSequence)formNumber)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u8bbe\u7f6e\u8f7b\u5206\u6790\u83dc\u5355\u5bf9\u5e94\u7684\u9875\u9762\uff0c\u8bf7\u524d\u5f80\u8f7b\u5206\u6790\u83dc\u5355\u7ba1\u7406\u4e2d\u7ef4\u62a4", (String)"WorkBenchTplFormPlugin_25", (String)"mpscmm-msbd-workbench", (Object[])new Object[0]));
                    return;
                }
                AppInfo app = AppMetadataCache.getAppInfo((String)appId);
                if (app == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5bf9\u5e94\u7684\u5e94\u7528\u3002", (String)"WorkBenchTplFormPlugin_26", (String)"mpscmm-msbd-workbench", (Object[])new Object[0]));
                    return;
                }
                String appHomeNum = app.getHomeNum();
                String appName = app.getName().getLocaleValue();
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("view", this.getView());
                map.put("formnumber", formNumber);
                map.put("parameter", formParams);
                map.put("menuname", qingMenuName);
                map.put("parametertype", null);
                map.put("openType", null);
                map.put("permItem", null);
                map.put("appname", appName);
                map.put("appmainnumber", appHomeNum);
                OpenPageUtils.openApp((String)app.getNumber(), (String)menuId, map, (IFormView)this.getView());
            }
        } else {
            logger.info(String.format("treeMenuClick appId:%s, menuId:%s", appId, menuId));
            AppMenuInfo menu = AppMetadataCache.getAppMenuInfo((String)appId, (String)menuId);
            if (menu == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u83dc\u5355\u4fe1\u606f\u5931\u8d25", (String)"WorkBenchTplFormPlugin_27", (String)"mpscmm-msbd-workbench", (Object[])new Object[0]));
                return;
            }
            String formId = menu.getFormId();
            if ("page".equals(menu.getMenuType()) && StringUtils.isBlank((CharSequence)formId)) {
                logger.info(String.format("BizAppHomePlugin treeMenuClick MenuType is :%s", menu.getMenuType()));
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u83dc\u5355\u672a\u7ed1\u5b9a\u5bf9\u5e94\u7684\u9875\u9762\uff0c\u8bf7\u524d\u5f80\u5f00\u53d1\u8005\u95e8\u6237\u83dc\u5355\u7ba1\u7406\u4e2d\u8bbe\u7f6e\u3002", (String)"WorkBenchTplFormPlugin_28", (String)"mpscmm-msbd-workbench", (Object[])new Object[0]));
                return;
            }
            OpenPageUtils.openMenu((IFormView)this.getView(), (String)menuId, (String)appId);
        }
    }

    private List<String> getQingMenuIds(List<AppMenuInfo> qingMenus) {
        LinkedList<String> qingMenuIds = new LinkedList<String>();
        if (CollectionUtils.isEmpty(qingMenus)) {
            return qingMenuIds;
        }
        for (AppMenuInfo qingObj : qingMenus) {
            String qingMenuId = qingObj.getId();
            if (!StringUtils.isNotEmpty((CharSequence)qingMenuId)) continue;
            qingMenuIds.add(qingMenuId);
        }
        return qingMenuIds;
    }

    public void treeMenuDoubleClick(TreeNodeEvent evt) {
    }
}

