/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.workbench.formplugin.action;

import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.util.ReflectionUtils;

public class BizServiceSelectFormPlugin
extends AbstractFormPlugin {
    private static final String BTNOK = "btnok";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTNOK});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        JSONObject jsonObject = (JSONObject)this.getView().getFormShowParameter().getCustomParam("params");
        Map<String, String> serviceMap = this.getServiceMap(jsonObject);
        if (serviceMap == null || serviceMap.isEmpty()) {
            return;
        }
        String serviceName = (String)jsonObject.get((Object)"serviceName");
        TableValueSetter vs = new TableValueSetter(new String[0]);
        if (StringUtils.isNotBlank((CharSequence)serviceName)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"servicename"});
            Method[] methods = this.getServiceMethods(serviceMap.get(serviceName));
            if (methods == null) {
                return;
            }
            HashSet<String> methodNames = new HashSet<String>(methods.length);
            for (Method method : methods) {
                String methodName = method.getName();
                if (!methodNames.contains(methodName)) {
                    vs.addField("servicemethod", new Object[]{method.getName()});
                }
                methodNames.add(methodName);
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"servicemethod"});
            for (String service : serviceMap.keySet()) {
                vs.addField("servicename", new Object[]{service});
            }
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.batchCreateNewEntryRow("entryentity", vs);
        this.getView().updateView("entryentity");
    }

    private Method[] getServiceMethods(String serviceClazz) {
        Method[] methods = null;
        try {
            methods = Class.forName(serviceClazz).getDeclaredMethods();
        }
        catch (Exception e) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u670d\u52a1\u65b9\u6cd5\u5931\u8d25\u3002", (String)"BizServiceSelectFormPlugin_0", (String)"mpscmm-msbd-workbench", (Object[])new Object[0]));
        }
        return methods;
    }

    private Map<String, String> getServiceMap(JSONObject jsonObject) {
        String bizCloud = jsonObject.getString("bizCloud");
        String bizApp = jsonObject.getString("bizApp");
        String serviceFactory = String.format("kd.%s.%s.servicehelper.ServiceFactory", bizCloud.toLowerCase(), bizApp.toLowerCase());
        try {
            Class factory = TypesContainer.getOrRegister((String)serviceFactory);
            Field field = null;
            try {
                field = factory.getDeclaredField("serviceMap");
            }
            catch (NoSuchFieldException | SecurityException e) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u5fae\u670d\u52a1\u3002", (String)"BizServiceSelectFormPlugin_1", (String)"mpscmm-msbd-workbench", (Object[])new Object[0]));
                return Collections.emptyMap();
            }
            ReflectionUtils.makeAccessible((Field)field);
            return (Map)field.get(factory.newInstance());
        }
        catch (Exception ex) {
            String tips = String.format(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5e94\u7528\u7f16\u7801\u4e3a%s\u7684\u670d\u52a1\u5de5\u5382\u7c7b\u3002", (String)"BizServiceSelectFormPlugin_2", (String)"mpscmm-msbd-workbench", (Object[])new Object[0]), bizApp);
            this.getView().showTipNotification(tips);
            return Collections.emptyMap();
        }
    }

    public void click(EventObject e) {
        super.click(e);
        String key = ((Control)e.getSource()).getKey();
        if (BTNOK.equals(key)) {
            this.handleBtnOkEvent();
        }
    }

    private void handleBtnOkEvent() {
        JSONObject result = this.getSelectedRowsInfo();
        if (result.isEmpty()) {
            this.getView().close();
            return;
        }
        this.getView().returnDataToParent((Object)result.toJSONString());
        this.getView().close();
    }

    private JSONObject getSelectedRowsInfo() {
        JSONObject result = new JSONObject();
        EntryGrid grid = (EntryGrid)this.getView().getControl("entryentity");
        IDataModel model = this.getModel();
        int[] selectedRows = grid.getSelectRows();
        if (selectedRows.length == 0) {
            return result;
        }
        result.put("serviceName", model.getValue("serviceName", selectedRows[0]));
        result.put("serviceMethod", model.getValue("serviceMethod", selectedRows[0]));
        return result;
    }
}

