/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.workbench.formplugin.task;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.F7SelectedList;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class TaskManageListPlugin
extends AbstractListPlugin {
    private static final String ASSIGN_ACTION = "assign_action";
    private static final String WB_TASK_DOMAIN = "wbTaskDomain";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        F7SelectedList control = (F7SelectedList)this.getControl("f7selectedlistap");
        if (control != null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"f7selectedlistap"});
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String wbTaskDomain = customParams.getOrDefault(WB_TASK_DOMAIN, "");
        String[] wbTaskDomains = wbTaskDomain.split(",");
        e.getQFilters().add(new QFilter("tasktype.domain.number", "in", (Object)wbTaskDomains));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = ((AbstractOperate)args.getSource()).getOperateKey();
        if ("assign".equals(operateKey)) {
            IListView listView = (IListView)this.getView();
            ListSelectedRowCollection selectedRows = listView.getSelectedRows();
            Object[] primaryKeyValues = selectedRows.getPrimaryKeyValues();
            QFilter qFilter = new QFilter("id", "in", (Object)primaryKeyValues);
            DynamicObjectCollection selectedDy = QueryServiceHelper.query((String)listView.getListModel().getDataEntityType().getName(), (String)"org.id", (QFilter[])qFilter.toArray());
            HashSet<Long> orgSet = new HashSet<Long>(selectedDy.size());
            for (DynamicObject rowData : selectedDy) {
                orgSet.add(rowData.getLong("org.id"));
            }
            if (orgSet.size() > 1) {
                String msg = ResManager.loadKDString((String)"\u4e0d\u540c\u4e1a\u52a1\u5355\u5143\u7684\u4efb\u52a1\u5355\u4e0d\u5141\u8bb8\u540c\u65f6\u5206\u914d\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"TaskManageListPlugin_0", (String)"mpscmm-msbd-workbench", (Object[])new Object[0]);
                this.getView().showErrorNotification(msg);
                args.setCancel(true);
            }
        } else if ("taskclose".equals(operateKey)) {
            this.taskCloseCheck(args);
        } else if ("taskunclose".equals(operateKey)) {
            this.taskUnCloseCheck(args);
        }
    }

    private void taskCloseCheck(BeforeDoOperationEventArgs args) {
        IListView listView = (IListView)this.getView();
        ListSelectedRowCollection selectedRows = listView.getSelectedRows();
        Map<Object, Integer> idAndRowIndexMap = selectedRows.stream().collect(Collectors.toMap(ListSelectedRow::getPrimaryKeyValue, ListSelectedRow::getRowKey));
        Object[] primaryKeyValues = selectedRows.getPrimaryKeyValues();
        QFilter qFilter = new QFilter("id", "in", (Object)primaryKeyValues);
        DynamicObjectCollection selectedDy = QueryServiceHelper.query((String)listView.getListModel().getDataEntityType().getName(), (String)"id, taskstatus,srcbillno", (QFilter[])qFilter.toArray());
        String errorMsgTpl = ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff1a", (String)"TaskManageListPlugin_1", (String)"mpscmm-msbd-workbench", (Object[])new Object[0]);
        String errMsg = ResManager.loadKDString((String)"\u4ec5\u5f85\u5904\u7406\u72b6\u6001\u7684\u4efb\u52a1\u624d\u5141\u8bb8\u5173\u95ed\u3002", (String)"TaskManageListPlugin_2", (String)"mpscmm-msbd-workbench", (Object[])new Object[0]);
        List orderData = selectedDy.stream().sorted(Comparator.comparingInt(o -> (Integer)idAndRowIndexMap.get(o.get("id")))).collect(Collectors.toList());
        StringBuilder errorInfo = new StringBuilder();
        StringBuilder srcBillNoErrorInfo = new StringBuilder();
        for (DynamicObject dataEntity : orderData) {
            String taskStatus = dataEntity.getString("taskstatus");
            if ("A".equals(taskStatus)) continue;
            Object pkValue = dataEntity.get("id");
            String srcBillNo = dataEntity.getString("srcbillno");
            Integer rowIndex = idAndRowIndexMap.get(pkValue);
            if (rowIndex == -1) {
                srcBillNoErrorInfo.append(srcBillNo);
                srcBillNoErrorInfo.append("\uff1a");
                srcBillNoErrorInfo.append(errMsg);
                srcBillNoErrorInfo.append('\n');
                continue;
            }
            errorInfo.append(String.format(errorMsgTpl, rowIndex + 1));
            errorInfo.append(errMsg);
            errorInfo.append('\n');
        }
        errorInfo.append((CharSequence)srcBillNoErrorInfo);
        if (errorInfo.length() > 0) {
            args.setCancel(true);
            this.getView().showErrorNotification(errorInfo.toString());
        }
    }

    private void taskUnCloseCheck(BeforeDoOperationEventArgs args) {
        IListView listView = (IListView)this.getView();
        ListSelectedRowCollection selectedRows = listView.getSelectedRows();
        Map<Object, Integer> idAndRowIndexMap = selectedRows.stream().collect(Collectors.toMap(ListSelectedRow::getPrimaryKeyValue, ListSelectedRow::getRowKey));
        Object[] primaryKeyValues = selectedRows.getPrimaryKeyValues();
        QFilter qFilter = new QFilter("id", "in", (Object)primaryKeyValues);
        DynamicObjectCollection selectedDy = QueryServiceHelper.query((String)listView.getListModel().getDataEntityType().getName(), (String)"id, taskstatus,srcbillno", (QFilter[])qFilter.toArray());
        List orderData = selectedDy.stream().sorted(Comparator.comparingInt(o -> (Integer)idAndRowIndexMap.get(o.get("id")))).collect(Collectors.toList());
        String errorMsgTpl = ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff1a", (String)"TaskManageListPlugin_1", (String)"mpscmm-msbd-workbench", (Object[])new Object[0]);
        String errMsg = ResManager.loadKDString((String)"\u4ec5\u5df2\u5b8c\u6210\u3001\u5df2\u5173\u95ed\u72b6\u6001\u7684\u4efb\u52a1\u624d\u5141\u8bb8\u53cd\u5173\u95ed\u3002", (String)"TaskManageListPlugin_3", (String)"mpscmm-msbd-workbench", (Object[])new Object[0]);
        StringBuilder errorInfo = new StringBuilder();
        StringBuilder srcBillNoErrorInfo = new StringBuilder();
        for (DynamicObject dataEntity : orderData) {
            String taskStatus = dataEntity.getString("taskstatus");
            if ("B".equals(taskStatus) || "C".equals(taskStatus)) continue;
            Object pkValue = dataEntity.get("id");
            String srcBillNo = dataEntity.getString("srcbillno");
            Integer rowIndex = idAndRowIndexMap.get(pkValue);
            if (rowIndex == -1) {
                srcBillNoErrorInfo.append(srcBillNo);
                srcBillNoErrorInfo.append("\uff1a");
                srcBillNoErrorInfo.append(errMsg);
                srcBillNoErrorInfo.append('\n');
                continue;
            }
            errorInfo.append(String.format(errorMsgTpl, rowIndex + 1));
            errorInfo.append(errMsg);
            errorInfo.append('\n');
        }
        errorInfo.append((CharSequence)srcBillNoErrorInfo);
        if (errorInfo.length() > 0) {
            args.setCancel(true);
            this.getView().showErrorNotification(errorInfo.toString());
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("assign".equals(operateKey)) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("msbd_select_groupanduser");
            IListView listView = (IListView)this.getView();
            ListSelectedRowCollection selectedRows = listView.getSelectedRows();
            Object primaryKeyValue = selectedRows.get(0).getPrimaryKeyValue();
            QFilter qFilter = new QFilter("id", "=", primaryKeyValue);
            DynamicObject taskInfo = QueryServiceHelper.queryOne((String)listView.getListModel().getDataEntityType().getName(), (String)"org.id", (QFilter[])qFilter.toArray());
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            String wbTaskDomain = customParams.getOrDefault(WB_TASK_DOMAIN, "");
            formShowParameter.setCustomParam(WB_TASK_DOMAIN, (Object)wbTaskDomain);
            formShowParameter.setCustomParam("org", (Object)taskInfo.getString("org.id"));
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ASSIGN_ACTION));
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(formShowParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (ASSIGN_ACTION.equals(actionId)) {
            DynamicObject[] selectedTaskDy;
            String returnData = (String)closedCallBackEvent.getReturnData();
            JSONObject info = JSON.parseObject((String)returnData);
            if (info == null || info.isEmpty()) {
                return;
            }
            Long bizUser = info.getLong("bizuser");
            Long bizGroup = info.getLong("bizgroup");
            IListView listView = (IListView)this.getView();
            ListSelectedRowCollection selectedRows = listView.getSelectedRows();
            Object[] primaryKeyValues = selectedRows.getPrimaryKeyValues();
            for (DynamicObject rowData : selectedTaskDy = BusinessDataServiceHelper.load((Object[])primaryKeyValues, (DynamicObjectType)listView.getListModel().getDataEntityType())) {
                rowData.set("bizuser", (Object)bizUser);
                rowData.set("bizgroup", (Object)bizGroup);
            }
            try {
                SaveServiceHelper.save((DynamicObject[])selectedTaskDy);
            }
            catch (Exception e) {
                this.getView().showErrorNotification(e.getMessage());
            }
            listView.refresh();
        }
    }
}

