/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.workbench.formplugin.task;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.property.OrgProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.TextEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.Entity;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.EntryEntity;
import kd.bos.metadata.entity.SubEntryEntity;

public class TaskServiceConfEditPlugin
extends AbstractBasePlugIn {
    private static final String BILL_OBJ = "billobj";
    private static final String BILL_OPERATION = "billoperation";
    private static final String BIZ_ORG = "bizorg";
    private static final String BILL_OBJ_CB = "billobjCB";
    private static final String COMMON_FILTER = "commonfilter";
    private static final String COMMON_FILTER_FORMULA = "filterformula_tag";
    private static final String COMMON_FILTER_JSON = "filterjson_tag";
    private static final String OPERATION_NAME = "operationname";
    private static final String ENTRY_KEY = "entrykey";
    private static final String GEN_TASK_BY_ENTRY = "gentaskbyentry";
    private static final String TASK_SUBJECT_CFG = "tasksubjectcfg";
    private static final String TASK_SUBJECT = "tasksubject";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TextEdit taskSubject = (TextEdit)this.getControl(TASK_SUBJECT);
        taskSubject.addButtonClickListener((ClickListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.setOperationItems();
        this.setOrgItems();
        this.setEntryItems();
        this.updateCommonFilter();
        FilterGrid filterGrid = (FilterGrid)this.getControl(COMMON_FILTER);
        String commonFilterJson = this.getModel().getDataEntity().getString(COMMON_FILTER_JSON);
        FilterCondition condition = StringUtils.isBlank((CharSequence)commonFilterJson) ? new FilterCondition() : (FilterCondition)SerializationUtils.fromJsonString((String)commonFilterJson, FilterCondition.class);
        filterGrid.SetValue(condition);
    }

    public void click(EventObject evt) {
        super.click(evt);
        IDataModel model = this.getModel();
        Control c = (Control)evt.getSource();
        String key = c.getKey();
        if (TASK_SUBJECT.equals(key)) {
            DynamicObject billObj = (DynamicObject)model.getValue(BILL_OBJ);
            if (billObj == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5355\u636e\u5bf9\u8c61\u3002", (String)"TaskServiceConfEditPlugin_1", (String)"mpscmm-msbd-workbench", (Object[])new Object[0]));
                return;
            }
            boolean genTaskByEntry = (Boolean)this.getModel().getValue(GEN_TASK_BY_ENTRY);
            String entryKey = (String)this.getModel().getValue(ENTRY_KEY);
            if (genTaskByEntry && StringUtils.isEmpty((CharSequence)entryKey)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6309\u5206\u5f55\u751f\u6210\u4efb\u52a1\u65f6\u8bf7\u5148\u9009\u62e9\u5355\u636e\u4f53\u6807\u8bc6\u3002", (String)"TaskServiceConfEditPlugin_2", (String)"mpscmm-msbd-workbench", (Object[])new Object[0]));
                return;
            }
            String billObjNum = billObj.getString("number");
            this.showTaskSubject(billObjNum);
        }
    }

    private void showTaskSubject(String entryNumber) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("msbd_tasksubject_cfg");
        showParameter.setCustomParam("entryNumber", (Object)entryNumber);
        Object taskSubjectConf = this.getModel().getValue(TASK_SUBJECT_CFG);
        Object entryKey = this.getModel().getValue(ENTRY_KEY);
        Object genTaskByEntry = this.getModel().getValue(GEN_TASK_BY_ENTRY);
        showParameter.setCustomParam(TASK_SUBJECT_CFG, taskSubjectConf);
        showParameter.setCustomParam(ENTRY_KEY, entryKey);
        showParameter.setCustomParam(GEN_TASK_BY_ENTRY, genTaskByEntry);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "taskSubject");
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        Object newValue = changeSet[0].getNewValue();
        Object oldValue = changeSet[0].getOldValue();
        switch (propertyName) {
            case "group": {
                this.taskServiceChange(oldValue);
                break;
            }
            case "billobj": {
                this.billObjChange(oldValue);
                break;
            }
            case "billoperation": {
                this.operationChange(newValue);
                break;
            }
            case "entrykey": {
                this.entryChange(newValue);
                break;
            }
            case "gentaskbyentry": {
                this.genTaskByEntryChange(newValue);
                break;
            }
            case "tasksubject": {
                this.taskSubjectChange(newValue);
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        String key = ((AbstractOperate)e.getSource()).getOperateKey();
        if ("save".equals(key)) {
            this.beforeSave();
        }
    }

    private void beforeSave() {
        DynamicObject billObj = this.getModel().getDataEntity().getDynamicObject(BILL_OBJ);
        if (billObj == null) {
            return;
        }
        FilterGrid grid = (FilterGrid)this.getControl(COMMON_FILTER);
        FilterCondition condition = grid.getFilterGridState().getFilterCondition();
        String jsonStr = SerializationUtils.toJsonString((Object)condition);
        String billObjNum = billObj.getString("number");
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)billObjNum);
        FilterBuilder filterBuilder = new FilterBuilder(entityType, condition);
        filterBuilder.buildFilter(false);
        String[] scripts = filterBuilder.buildFilterScript();
        this.getModel().setValue(COMMON_FILTER_JSON, (Object)jsonStr);
        this.getModel().setValue(COMMON_FILTER_FORMULA, (Object)scripts[0]);
    }

    private void taskServiceChange(Object oldValue) {
        if (Objects.isNull(oldValue)) {
            return;
        }
        String serviceName = ((DynamicObject)oldValue).getString("number");
        if ("TaskCreate".equals(serviceName)) {
            this.getModel().setValue("taskservicegroup", null);
            this.getModel().setValue(BIZ_ORG, null);
            this.getModel().setValue(ENTRY_KEY, null);
            this.getModel().setValue(TASK_SUBJECT, null);
            this.getModel().setValue(TASK_SUBJECT_CFG, null);
        } else if ("TaskUnCreate".equals(serviceName)) {
            this.getModel().setValue("taskservicegroup", null);
        }
    }

    private void billObjChange(Object oldValue) {
        if (oldValue != null) {
            DynamicObject oldBillObj = (DynamicObject)oldValue;
            HashMap<String, Object> confirmInfo = new HashMap<String, Object>(16);
            confirmInfo.put(BILL_OBJ, oldBillObj.getPkValue());
            String msg = ResManager.loadKDString((String)"\u5207\u6362\u5355\u636e\u5bf9\u8c61\u5c06\u6e05\u9664\u9875\u9762\u5355\u636e\u5bf9\u8c61\u914d\u7f6e\u4fe1\u606f\uff0c\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\u64cd\u4f5c\uff1f", (String)"TaskServiceConfEditPlugin_0", (String)"mpscmm-msbd-workbench", (Object[])new Object[0]);
            ConfirmCallBackListener callBackListener = new ConfirmCallBackListener(BILL_OBJ_CB, (IFormPlugin)this);
            this.getView().showConfirm(msg, null, MessageBoxOptions.OKCancel, ConfirmTypes.Default, callBackListener, null, SerializationUtils.toJsonString(confirmInfo));
        } else {
            this.updateCommonFilter();
            this.setOperationItems();
            this.setOrgItems();
            this.setEntryItems();
            this.getModel().setValue(BILL_OPERATION, null);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        MessageBoxResult result = event.getResult();
        String customValue = event.getCustomVaule();
        if (BILL_OBJ_CB.equals(callBackId)) {
            this.billObjConfirmCB(result, customValue);
        }
    }

    private void billObjConfirmCB(MessageBoxResult result, String customValue) {
        if (StringUtils.isBlank((CharSequence)customValue)) {
            return;
        }
        Map confirmInfo = (Map)SerializationUtils.fromJsonString((String)customValue, Map.class);
        if (MessageBoxResult.Yes.equals((Object)result)) {
            this.getModel().setValue(BILL_OPERATION, null);
            this.getModel().setValue(BIZ_ORG, null);
            this.getModel().setValue(ENTRY_KEY, null);
            this.getModel().setValue(COMMON_FILTER_FORMULA, null);
            this.getModel().setValue(COMMON_FILTER_JSON, null);
            this.getModel().setValue(TASK_SUBJECT, null);
            this.getModel().setValue(TASK_SUBJECT_CFG, null);
            this.setOperationItems();
            this.setOrgItems();
            this.setEntryItems();
            this.updateCommonFilter();
        } else {
            Object billObj = confirmInfo.get(BILL_OBJ);
            this.getModel().beginInit();
            this.getModel().setValue(BILL_OBJ, billObj);
            this.getView().updateView(BILL_OBJ);
            this.getModel().endInit();
        }
    }

    private void operationChange(Object newValue) {
        if (newValue != null) {
            DynamicObject billObj = this.getModel().getDataEntity().getDynamicObject(BILL_OBJ);
            if (billObj == null) {
                return;
            }
            String billObjNum = billObj.getString("number");
            List operations = EntityMetadataCache.getDataEntityOperate((String)billObjNum);
            for (Map operation : operations) {
                String opKey = (String)operation.get("key");
                if (!opKey.equals(newValue)) continue;
                this.getModel().setValue(OPERATION_NAME, operation.get("name"));
            }
        } else {
            this.getModel().setValue(OPERATION_NAME, null);
        }
    }

    private void entryChange(Object newValue) {
        if (newValue != null) {
            this.setOrgItems();
            this.getModel().setValue(BIZ_ORG, null);
            this.getModel().setValue(TASK_SUBJECT, null);
            this.getModel().setValue(TASK_SUBJECT_CFG, null);
        }
    }

    private void genTaskByEntryChange(Object newValue) {
        if (newValue != null) {
            this.setOrgItems();
            this.getModel().setValue(BIZ_ORG, null);
            this.setEntryItems();
            this.getModel().setValue(ENTRY_KEY, null);
            this.getModel().setValue(TASK_SUBJECT, null);
            this.getModel().setValue(TASK_SUBJECT_CFG, null);
        }
    }

    private void taskSubjectChange(Object newValue) {
        if (StringUtils.isBlank((Object)newValue)) {
            this.getModel().setValue(TASK_SUBJECT_CFG, null);
        }
    }

    private void updateCommonFilter() {
        DynamicObject billObj = this.getModel().getDataEntity().getDynamicObject(BILL_OBJ);
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(COMMON_FILTER);
        if (billObj == null) {
            filterGrid.SetValue(new FilterCondition());
            filterGrid.setFilterColumns(new ArrayList());
            filterGrid.setEntityNumber(null);
        } else {
            String billObjNum = billObj.getString("number");
            EntityTypeUtil entityTypeUtil = new EntityTypeUtil();
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)billObjNum);
            List filterColumns = entityTypeUtil.getFilterColumns((IDataEntityType)entityType, true);
            filterGrid.SetValue(new FilterCondition());
            filterGrid.setFieldColumns(filterColumns);
            filterGrid.setEntityNumber(entityType.getName());
        }
        this.getView().updateView(COMMON_FILTER);
    }

    private void setOperationItems() {
        DynamicObject entity = this.getModel().getDataEntity().getDynamicObject(BILL_OBJ);
        ComboEdit opEdit = (ComboEdit)this.getView().getControl(BILL_OPERATION);
        if (entity == null) {
            opEdit.setComboItems(null);
            return;
        }
        String entityNum = entity.getString("number");
        List operations = EntityMetadataCache.getDataEntityOperate((String)entityNum);
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(16);
        for (Map operation : operations) {
            String opKey = (String)operation.get("key");
            Map opName = (Map)operation.get("name");
            comboItems.add(new ComboItem(LocaleString.fromMap((Map)opName), opKey));
        }
        opEdit.setComboItems(comboItems);
    }

    private void setOrgItems() {
        DynamicObject entity = this.getModel().getDataEntity().getDynamicObject(BILL_OBJ);
        ComboEdit orgEdit = (ComboEdit)this.getView().getControl(BIZ_ORG);
        if (entity == null) {
            orgEdit.setComboItems(null);
            return;
        }
        String entityNum = entity.getString("number");
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNum);
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(16);
        for (IDataEntityProperty property : properties) {
            if (!(property instanceof OrgProp)) continue;
            comboItems.add(new ComboItem(property.getDisplayName(), property.getName()));
        }
        boolean genTaskByEntry = (Boolean)this.getModel().getValue(GEN_TASK_BY_ENTRY);
        String entryKey = (String)this.getModel().getValue(ENTRY_KEY);
        if (genTaskByEntry && !StringUtils.isEmpty((CharSequence)entryKey)) {
            Map allEntities = dataEntityType.getAllEntities();
            EntityType entityType = (EntityType)allEntities.get(entryKey);
            LocaleString displayName = entityType.getDisplayName();
            String entryName = displayName.getLocaleValue();
            Map fields = entityType.getFields();
            for (IDataEntityProperty value : fields.values()) {
                if (!(value instanceof OrgProp)) continue;
                comboItems.add(new ComboItem(new LocaleString(entryName + '.' + value.getDisplayName().getLocaleValue()), entryKey + '.' + value.getName()));
            }
        }
        orgEdit.setComboItems(comboItems);
    }

    private void setEntryItems() {
        DynamicObject entityObj = this.getModel().getDataEntity().getDynamicObject(BILL_OBJ);
        ComboEdit entryEdit = (ComboEdit)this.getView().getControl(ENTRY_KEY);
        if (entityObj == null) {
            entryEdit.setComboItems(null);
            return;
        }
        String entityNum = entityObj.getString("number");
        ArrayList<ComboItem> entryComboItems = new ArrayList<ComboItem>(16);
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)entityNum, (MetaCategory)MetaCategory.Entity), (MetaCategory)MetaCategory.Entity);
        List entityList = entityMetadata.getEntitys();
        for (Entity entity : entityList) {
            String tableName = entity.getTableName();
            if (!(entity instanceof EntryEntity) || entity instanceof SubEntryEntity || !StringUtils.isNotBlank((CharSequence)tableName)) continue;
            entryComboItems.add(new ComboItem(new LocaleString(entity.getKey()), entity.getKey()));
        }
        entryEdit.setComboItems(entryComboItems);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData == null) {
            return;
        }
        if ("taskSubject".equals(closedCallBackEvent.getActionId())) {
            Map returnDataMap = (Map)returnData;
            String codingExample = returnDataMap.getOrDefault("ex", "");
            if (StringUtils.isNotEmpty((CharSequence)codingExample) && codingExample.length() > 255) {
                codingExample = codingExample.substring(0, 255);
            }
            returnDataMap.remove("ex");
            this.getModel().setValue(TASK_SUBJECT, (Object)codingExample);
            this.getModel().setValue(TASK_SUBJECT_CFG, (Object)SerializationUtils.toJsonString((Object)returnDataMap));
        }
    }
}

