/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.workbench.pojo;

import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.common.BaseAppParameterServiceHelper;
import kd.bos.dc.mc.LoginMCService;
import kd.bos.entity.AppMenuInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.portal.InitailVersionServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.mpscmm.msbd.workbench.util.CardUtils;

public class MenuFilterBuilder {
    private static Log logger = LogFactory.getLog(MenuFilterBuilder.class);
    private Long userId;
    private Boolean isAdmin;
    private List<String> hideMenuIds;
    private Map<String, List<String>> blackMenuIdMap = new HashMap<String, List<String>>();
    private Map<String, List<String>> noPermMenuIdMap = new HashMap<String, List<String>>();
    private Boolean isGray;
    private Boolean hideHelpMenu;

    public MenuFilterBuilder(Long userId) {
        this.userId = userId;
    }

    public Long getUserId() {
        return this.userId;
    }

    public boolean isAdmin() {
        if (this.isAdmin == null) {
            this.isAdmin = PermissionServiceHelper.isAdminUser((long)this.userId);
        }
        return this.isAdmin;
    }

    public List<String> getHideMenuIds() {
        if (this.hideMenuIds == null) {
            this.hideMenuIds = CardUtils.getHideMenus();
        }
        return this.hideMenuIds;
    }

    public List<String> getBlackMenuIds(String appId) {
        List<String> blackMenuIds = this.blackMenuIdMap.get(appId);
        if (!this.blackMenuIdMap.containsKey(appId)) {
            blackMenuIds = CardUtils.getProductBlackMenus(appId);
            this.blackMenuIdMap.put(appId, blackMenuIds);
        }
        return blackMenuIds;
    }

    public List<String> getNoPermMenuIds(String appId) {
        List noPermMenuIds = this.noPermMenuIdMap.get(appId);
        if (!this.noPermMenuIdMap.containsKey(appId)) {
            noPermMenuIds = PermissionServiceHelper.getAllNoPermMenuIdsByAppId((Long)this.userId, (String)appId);
            this.noPermMenuIdMap.put(appId, noPermMenuIds);
        }
        return noPermMenuIds;
    }

    public boolean isGray() {
        if (this.isGray == null) {
            try {
                this.isGray = LoginMCService.create().getGrayEnvironmentInfo();
            }
            catch (Exception e) {
                logger.error("check grayEnv error", (Throwable)e);
                return false;
            }
        }
        return this.isGray;
    }

    public boolean isHideHelpMenu() {
        if (this.hideHelpMenu == null) {
            Object showHelpMenu = BaseAppParameterServiceHelper.getParameterFromCache((String)"knowledge_search");
            this.hideHelpMenu = showHelpMenu != null && !Boolean.parseBoolean(showHelpMenu.toString());
        }
        return this.hideHelpMenu;
    }

    public static List<String> getBizAppHideMenuIds(String appId) {
        boolean isNewTenant;
        boolean enableLayoutScheme;
        if (("18XR3MJ0W0ET".equals(appId) || "cts".equals(appId)) && !(enableLayoutScheme = Boolean.parseBoolean(System.getProperty("layoutscheme.on")))) {
            ArrayList<String> hideMenuIds = new ArrayList<String>();
            hideMenuIds.add("1072471504165288960");
            return hideMenuIds;
        }
        if (("18XSXYEL8//U".equals(appId) || "sys".equals(appId)) && (isNewTenant = InitailVersionServiceHelper.isInitailVersion((int)6))) {
            ArrayList<String> hideMenuIds = new ArrayList<String>();
            hideMenuIds.add("1736897837687394304");
            return hideMenuIds;
        }
        return null;
    }

    public Map<String, Set<String>> getBlackMenuIdsByAppIds(Set<String> appIds) {
        HashMap<String, Set<String>> blackMenuIdSetMap = new HashMap<String, Set<String>>();
        appIds.forEach(appId -> {
            List<String> productBlackMenus = CardUtils.getProductBlackMenus(appId);
            blackMenuIdSetMap.put((String)appId, (Set<String>)new HashSet<String>(productBlackMenus));
        });
        return blackMenuIdSetMap;
    }

    public Map<String, Set<String>> getNoPermMenuIdsByAppIds(Set<String> appIds) {
        Map noPermMenus = PermissionServiceHelper.getUserNoPermMenuByBatchApp((Long)this.userId, appIds);
        logger.info("getNoPermMenuIdsByAppIds result:" + JSONArray.toJSONString((Object)noPermMenus));
        return noPermMenus;
    }

    public Map<String, Set<String>> getBizAppHideMenuIdsByAppIds(Set<String> appIds) {
        HashMap<String, Set<String>> hideMenuMap = new HashMap<String, Set<String>>();
        appIds.forEach(appId -> {
            List<String> bizAppHideMenuIds = MenuFilterBuilder.getBizAppHideMenuIds(appId);
            if (!CollectionUtils.isEmpty(bizAppHideMenuIds)) {
                hideMenuMap.put((String)appId, (Set<String>)new HashSet<String>(bizAppHideMenuIds));
            }
        });
        return hideMenuMap;
    }

    public Map<String, Set<String>> getHideHelpMenuAndGrayMenu(Set<String> appIds) {
        HashMap<String, Set<String>> hideHelpMenuAndGrayMenuMap = new HashMap<String, Set<String>>();
        appIds.forEach(appId -> {
            try {
                List menusInfos = AppMetadataCache.getAppMenusInfoByAppId((String)appId);
                Set hideHelpMenuAndGrayMenu = menusInfos.stream().filter(menuInfo -> {
                    String formId = menuInfo.getFormId();
                    if (this.isHideHelpMenu() && "bas_appstarted".equals(formId)) {
                        return true;
                    }
                    if ("gated_launch_user".equals(formId)) {
                        if (!this.isAdmin()) {
                            return true;
                        }
                        if (!this.isGray()) {
                            return true;
                        }
                    }
                    return false;
                }).map(AppMenuInfo::getId).collect(Collectors.toSet());
                hideHelpMenuAndGrayMenuMap.put((String)appId, hideHelpMenuAndGrayMenu);
            }
            catch (Exception e) {
                logger.error("getHideHelpMenuAndGrayMenu error", (Throwable)e);
            }
        });
        return hideHelpMenuAndGrayMenuMap;
    }

    public Map<String, Set<String>> getHideMenuMap() {
        HashMap<String, Set<String>> hideMenuMap = new HashMap<String, Set<String>>();
        HashSet<String> data = new HashSet<String>(CardUtils.getHideMenus());
        hideMenuMap.put("83bfebc8000037ac", data);
        hideMenuMap.put("18XSXYEL8//U", data);
        return hideMenuMap;
    }
}

