/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.workbench.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMenuInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.extplugin.PluginProxy;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.portal.service.IPortalAppMenuExtService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.JSONUtils;
import kd.mpscmm.msbd.workbench.pojo.MenuFilterBuilder;
import org.apache.commons.lang.reflect.MethodUtils;
import org.apache.commons.lang3.StringUtils;

public class PortalMenuService {
    private static Log logger = LogFactory.getLog(PortalMenuService.class);
    private IPageCache pageCache;

    public PortalMenuService(IPageCache pageCache) {
        this.pageCache = pageCache;
    }

    public PortalMenuService() {
    }

    private void processQingAppMenuInfos(List<AppMenuInfo> menusInfos, String appId) {
        List<AppMenuInfo> qingMenuInfos = this.getQingMenuArray(appId);
        if (CollectionUtils.isEmpty(qingMenuInfos)) {
            return;
        }
        List helpMenuInfos = menusInfos.stream().filter(menu -> menu.getId().endsWith("#hpce")).collect(Collectors.toList());
        menusInfos.removeAll(helpMenuInfos);
        menusInfos.addAll(qingMenuInfos);
        if (CollectionUtils.isNotEmpty(helpMenuInfos)) {
            menusInfos.addAll(helpMenuInfos);
        }
    }

    public List<AppMenuInfo> getQingMenuArray(String appId) {
        logger.info("getQingMenuArray, appid = " + appId);
        if (StringUtils.isBlank((CharSequence)appId)) {
            return null;
        }
        try {
            List qingMenus;
            AppInfo appInfo = AppMetadataCache.getAppInfo((String)appId);
            String appPkId = appInfo.getId();
            String result = "";
            if (this.pageCache != null) {
                result = this.pageCache.get(this.getQingMenuPageCacheKey(appPkId));
            }
            if (StringUtils.isBlank((CharSequence)result)) {
                Class<?> qingAppMenuUtil = Class.forName("kd.bos.qing.plugin.appmenu.PublishedAppMenuUtil");
                qingMenus = (List)MethodUtils.invokeStaticMethod(qingAppMenuUtil, (String)"getPublishedAppQingMenuList", (Object)appPkId);
                result = JSONUtils.toString((Object)qingMenus);
                logger.info("getQingMenuArray--getAppQingMenu\uff1a" + result);
                if (this.pageCache != null) {
                    this.pageCache.put(this.getQingMenuPageCacheKey(appPkId), result);
                }
            } else {
                qingMenus = JSONObject.parseArray((String)result, AppMenuInfo.class);
            }
            return qingMenus;
        }
        catch (Exception e) {
            logger.error("getQingMenuArray--error", (Throwable)e);
            return null;
        }
    }

    private String getQingMenuPageCacheKey(String appId) {
        return "qingmenus_" + appId;
    }

    public void addCurrentUseApp(String appId) {
        String currentAppStr;
        String result;
        logger.info("addCurrentUseApp,appId:" + appId);
        Long userId = RequestContext.get().getCurrUserId();
        QFilter userFilter = new QFilter("user", "=", (Object)userId);
        DynamicObject currentAppObj = BusinessDataServiceHelper.loadSingle((String)"bos_portal_current_app", (String)"currentapp", (QFilter[])new QFilter[]{userFilter});
        if (currentAppObj == null) {
            currentAppObj = BusinessDataServiceHelper.newDynamicObject((String)"bos_portal_current_app");
            currentAppObj.set("user", (Object)userId);
        }
        if ((result = this.addApp(currentAppStr = currentAppObj.getString("currentapp"), appId)) == null) {
            return;
        }
        currentAppObj.set("currentapp", (Object)result);
        try {
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{currentAppObj});
        }
        catch (Exception e) {
            logger.info("addCurrentUseApp error", (Object)e);
        }
    }

    private String addApp(String currentAppStr, String appId) {
        List<Object> myCurrentAppList = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)currentAppStr)) {
            String[] currentAppArr = currentAppStr.split(";");
            if (currentAppArr.length > 0 && currentAppArr[0].equals(appId)) {
                return null;
            }
            myCurrentAppList = Stream.of(currentAppArr).collect(Collectors.toList());
            myCurrentAppList.remove(appId);
            myCurrentAppList.add(0, appId);
        } else {
            myCurrentAppList.add(0, appId);
        }
        if (myCurrentAppList.size() > 7) {
            myCurrentAppList = myCurrentAppList.subList(0, 7);
        }
        String result = String.join((CharSequence)";", myCurrentAppList);
        return result;
    }

    public List<AppMenuInfo> getHasPermMenuByAppId(Long userId, String appId, boolean includeQingMenu) {
        List<AppMenuInfo> allMenuInfos = this.getAllMenuByAppId(appId, includeQingMenu);
        HashSet<String> appIds = new HashSet<String>();
        appIds.add(appId);
        Map<String, Set<String>> noPermMenuMap = this.getNoPermMenuByAppIds(userId, appIds);
        if (allMenuInfos != null && !allMenuInfos.isEmpty()) {
            Set<String> noPermMenuIds = noPermMenuMap.get(appId);
            return allMenuInfos.stream().filter(menusInfo -> !noPermMenuIds.contains(menusInfo.getId())).collect(Collectors.toList());
        }
        return new ArrayList<AppMenuInfo>();
    }

    private Map<String, Set<String>> getAllMenuByAppIds(Set<String> appIds, boolean includeQingMenu) {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        appIds.forEach(appId -> {
            List<AppMenuInfo> allMenuByAppId = this.getAllMenuByAppId((String)appId, includeQingMenu);
            if (CollectionUtils.isNotEmpty(allMenuByAppId)) {
                Set menuIds = allMenuByAppId.stream().map(AppMenuInfo::getId).collect(Collectors.toSet());
                result.put((String)appId, menuIds);
            } else {
                result.put((String)appId, new HashSet());
            }
        });
        return result;
    }

    private List<AppMenuInfo> getAllMenuByAppId(String appId, boolean includeQingMenu) {
        try {
            List menusInfos = AppMetadataCache.getAppMenusInfoByAppId((String)appId);
            if (menusInfos == null) {
                return null;
            }
            if (includeQingMenu) {
                this.processQingAppMenuInfos(menusInfos, appId);
            }
            return menusInfos;
        }
        catch (Exception e) {
            logger.error("getAllMenuByAppId error", (Throwable)e);
            return null;
        }
    }

    public Map<String, Set<String>> getNoPermMenuByAppIds(Long userId, Set<String> appIds) {
        MenuFilterBuilder builder = new MenuFilterBuilder(userId);
        Map<String, Set<String>> noPermMenuIds = builder.getNoPermMenuIdsByAppIds(appIds);
        Map<String, Set<String>> blackMenuIds = builder.getBlackMenuIdsByAppIds(appIds);
        Map<String, Set<String>> hideMenuMap = builder.getHideMenuMap();
        Map<String, Set<String>> hideHelpMenuAndGrayMenu = builder.getHideHelpMenuAndGrayMenu(appIds);
        Map<String, Set<String>> bizAppHideMenuIdsByAppIds = builder.getBizAppHideMenuIdsByAppIds(appIds);
        Map<String, Set<String>> hideMenuIdsByBizAppIds = this.getHideMenuIdsByBizAppIds(userId, appIds);
        HashMap<String, Set<String>> resultMap = new HashMap<String, Set<String>>();
        Stream.of(noPermMenuIds, blackMenuIds, hideMenuMap, hideHelpMenuAndGrayMenu, bizAppHideMenuIdsByAppIds, hideMenuIdsByBizAppIds).filter(Objects::nonNull).forEach(map -> map.forEach((k, v) -> resultMap.merge((String)k, (Set<String>)v, (v1, v2) -> {
            v1.addAll(v2);
            return v1;
        })));
        return resultMap;
    }

    public Map<String, Set<String>> getHideMenuIdsByBizAppIds(Long userId, Set<String> appIds) {
        List<IPortalAppMenuExtService> plugins = this.getPortalAppMenuExtService();
        if (plugins == null || plugins.isEmpty()) {
            return null;
        }
        HashMap<String, Set<String>> resultMap = new HashMap<String, Set<String>>();
        Map<String, Set<String>> allMenuByAppIds = this.getAllMenuByAppIds(appIds, true);
        plugins.forEach(plugin -> {
            Map data = plugin.getHideMenuIdsByBizAppIds(userId, allMenuByAppIds);
            logger.info(String.format("plugin:%s, result:%s", plugin.getClass().getName(), JSONArray.toJSONString((Object)data)));
            if (data != null && data.size() > 0) {
                data.forEach((k, v) -> resultMap.merge((String)k, (Set<String>)v, (v1, v2) -> {
                    v1.addAll(v2);
                    return v1;
                }));
            }
        });
        return resultMap;
    }

    private List<IPortalAppMenuExtService> getPortalAppMenuExtService() {
        List plugins = null;
        try {
            PluginProxy pluginProxy = PluginProxy.create(null, IPortalAppMenuExtService.class, (String)"BOS_SVC_PORTAL_MENU_PERM", null);
            plugins = pluginProxy.getPlugins();
        }
        catch (Exception e) {
            logger.error("getPortalSchemePermService error", (Throwable)e);
        }
        return plugins;
    }
}

