/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.workbench.service.impl;

import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.orm.util.CollectionUtils;
import kd.mpscmm.msbd.workbench.service.TreeService;
import org.apache.commons.lang3.StringUtils;

public class TreeServiceImpl
implements TreeService {
    @Override
    public void clickCurrentAppNode(IFormView formView, String controlKey, TreeNode rootNode, TreeNodeClickListener listener) {
        String appNum = formView.getFormShowParameter().getAppId();
        if (StringUtils.isBlank((CharSequence)appNum)) {
            return;
        }
        String appId = AppMetadataCache.getAppInfo((String)appNum).getId();
        TreeNode treeNode = rootNode.getTreeNode(appId);
        if (null != treeNode) {
            TreeView treeView = (TreeView)formView.getControl(controlKey);
            treeView.addTreeNodeClickListener(listener);
            treeView.focusNode(treeNode);
            treeView.treeNodeClick(treeNode.getParentid(), treeNode.getId());
        }
    }

    @Override
    public TreeNode buildTree(JSONArray resultApps) {
        LinkedHashMap<String, TreeNode> cloudNodeMap = new LinkedHashMap<String, TreeNode>(10);
        for (int i = 0; i < resultApps.size(); ++i) {
            JSONArray cloudAppItem = (JSONArray)resultApps.get(i);
            this.processCloudOrAppItem(cloudNodeMap, cloudAppItem);
        }
        ArrayList cloudNodeList = new ArrayList(cloudNodeMap.values());
        TreeNode rootNode = new TreeNode();
        rootNode.addChildren(cloudNodeList);
        return rootNode;
    }

    private void processCloudOrAppItem(Map<String, TreeNode> cloudNodeMap, JSONArray cloudAppItem) {
        for (int j = 0; j < cloudAppItem.size(); ++j) {
            Map<String, Object> itemMap = this.getItemMap(cloudAppItem, j);
            if (CollectionUtils.isEmpty(itemMap)) continue;
            Boolean isCloud = (Boolean)itemMap.get("iscloud");
            if (isCloud != null && isCloud.booleanValue()) {
                String cloudId = this.getId(itemMap);
                String cloudName = this.getName(itemMap);
                if (StringUtils.isBlank((CharSequence)cloudId) || StringUtils.isBlank((CharSequence)cloudName)) break;
                TreeNode cloudNode = this.createCloudNode(cloudId, cloudName);
                cloudNodeMap.put(cloudId, cloudNode);
                continue;
            }
            this.processAppNode(cloudNodeMap, itemMap);
        }
    }

    private Map<String, Object> getItemMap(JSONArray cloudAppItem, int index) {
        Object item = cloudAppItem.get(index);
        Map itemMap = null;
        if (item instanceof Map) {
            itemMap = (Map)item;
        }
        if (itemMap == null) {
            return Collections.emptyMap();
        }
        return itemMap;
    }

    private void processAppNode(Map<String, TreeNode> cloudNodeMap, Map<String, Object> itemMap) {
        String parentId = this.getCloudId(itemMap);
        String appNum = this.getNumber(itemMap);
        String appName = this.getName(itemMap);
        if (StringUtils.isBlank((CharSequence)parentId) || StringUtils.isBlank((CharSequence)appNum) || StringUtils.isBlank((CharSequence)appName)) {
            return;
        }
        String appId = this.getId(itemMap);
        TreeNode appNode = this.createAppNode(parentId, appNum, appId, appName);
        TreeNode currCloudNode = cloudNodeMap.get(parentId);
        currCloudNode.addChild(appNode);
        cloudNodeMap.put(parentId, currCloudNode);
    }

    private String getNumber(Map<String, Object> itemMap) {
        return itemMap.get("number") == null ? null : itemMap.get("number").toString();
    }

    private String getCloudId(Map<String, Object> itemMap) {
        return itemMap.get("cloudid") == null ? null : itemMap.get("cloudid").toString();
    }

    private String getId(Map<String, Object> itemMap) {
        return itemMap.get("id") == null ? null : itemMap.get("id").toString();
    }

    private String getName(Map<String, Object> itemMap) {
        String langName = RequestContext.get().getLang().name();
        Map nameMap = (Map)itemMap.get("name");
        String name = null;
        if (nameMap != null) {
            name = nameMap.get(langName) == null ? null : nameMap.get(langName).toString();
        }
        return name;
    }

    private TreeNode createCloudNode(String id, String name) {
        TreeNode cloudNode = new TreeNode();
        cloudNode.setId(id);
        cloudNode.setText(name);
        cloudNode.setParentid("");
        return cloudNode;
    }

    private TreeNode createAppNode(String parentId, String appNum, String id, String name) {
        TreeNode appNode = new TreeNode();
        appNode.setId(id);
        appNode.setText(name);
        appNode.setParentid(parentId);
        appNode.setIsOpened(false);
        appNode.setChildren(null);
        appNode.setData((Object)appNum);
        return appNode;
    }
}

