/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.workbench.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringTokenizer;
import java.util.zip.ZipOutputStream;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DBRoute;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.SecurityUtils;
import kd.bos.portal.util.AppUtils;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.sqlscript.PreInsDataScriptBuilder;
import kd.mpscmm.msbd.workbench.pojo.WorkBenchSchemeFile;
import kd.mpscmm.msbd.workbench.util.WorkBenchSchemeUtil;
import org.dom4j.Document;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class AppPackageUtil {
    public static final String UTF_8 = "UTF-8";
    public static final String BOS_DEVPORTAL_BIZAPP = "bos_devportal_bizapp";
    public static final String CREATE_NEW_FILE_FLAG_S = "createNewFileFlag:%s";
    public static final String FOUR = "\n    ";
    public static final String STRING = "string";
    public static final String SEPARATOR = "Separator";
    public static final String DBKEY = "dbkey";
    public static final String SQL_SCRIPT = "SqlScript";
    public static final String STR = ";\t\n";
    public static final String KSQLEXP_PLUGIN_ERROR_S = "KSQLExpPlugin error:%s.";
    private static Log logger = LogFactory.getLog(AppPackageUtil.class);
    private static final String SOURCE_NAME = "name";
    private static final String SOURCE_ID = "id";
    private static final String URL_NAME = "urlname";
    private static final String DATABASE = "databasetype";
    private static final String DATAMODEL = "datamodel";
    private static final String PREINSDATA = "preinsdata";

    public static void zipDMFile(String zipPath, String appPackageName) {
        JSONArray files = new JSONArray();
        File file = new File(SecurityUtils.normalize((String)zipPath));
        if (file.exists()) {
            files.add((Object)zipPath);
        }
        String checkzipPath = WorkBenchSchemeUtil.getCheckedFilePath(zipPath);
        logger.info("|zipDMFile.zipPath + File.separator:" + checkzipPath + File.separator + "dm");
        File dmFile = new File(SecurityUtils.normalize((String)(checkzipPath + File.separator + "dm")));
        if (!dmFile.exists()) {
            dmFile.mkdirs();
        }
        logger.info("|zipPath + File.separator + dm + File.separator + appPackageName + .zip" + zipPath + File.separator + "dm" + File.separator + appPackageName + ".zip");
        File zipFile = new File(SecurityUtils.normalize((String)(checkzipPath + File.separator + "dm" + File.separator + appPackageName + ".zip")));
        try (ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(zipFile)));){
            WorkBenchSchemeUtil.zipFile(files, out, "");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void createAppXML(String bizAppId, String bizAppNum, String appPath, JSONArray dbschemaArr, JSONArray preinsdataArr, List<String> sqlNameList, boolean hasXmlFlag) {
        String dbRouteKey = MetadataServiceHelper.getDataEntityType((String)"msbd_wrokbench_scheme").getDBRouteKey();
        String dbRoute = "999";
        String appXMLPath = appPath + File.separator + bizAppNum + ".xml";
        File appXMLFile = new File(SecurityUtils.normalize((String)appXMLPath));
        if (!appXMLFile.exists()) {
            try {
                boolean createNewFileFlag = appXMLFile.createNewFile();
                logger.info(String.format(CREATE_NEW_FILE_FLAG_S, createNewFileFlag));
            }
            catch (IOException exception) {
                logger.error(exception.getMessage());
            }
        }
        try (FileOutputStream fileOutputStream = new FileOutputStream(appXMLFile);){
            AttributesImpl attrImple;
            String dataBaseType;
            int i;
            TransformerHandler transformerHandle = AppPackageUtil.getTransformerHandler(fileOutputStream);
            String four = FOUR;
            AttributesImpl coderuleImple = new AttributesImpl();
            AttributesImpl rootImple = new AttributesImpl();
            transformerHandle.startDocument();
            transformerHandle.characters(four.toCharArray(), 0, 1);
            rootImple.addAttribute("", "", "dympath", STRING, "metadata");
            if (hasXmlFlag) {
                rootImple.addAttribute("", "", "xmlpath", STRING, "preinsdata/xml");
            }
            transformerHandle.startElement("", "", "DataModel", rootImple);
            coderuleImple.addAttribute("", "", "Type", STRING, "KSQL");
            coderuleImple.addAttribute("", "", SEPARATOR, STRING, ";");
            coderuleImple.addAttribute("", "", DBKEY, STRING, dbRouteKey);
            if (dbschemaArr != null && dbschemaArr.size() > 0) {
                for (i = 0; i < dbschemaArr.size(); ++i) {
                    JSONObject dbschemaObj = (JSONObject)dbschemaArr.get(i);
                    String dbschema = dbschemaObj.getString(URL_NAME);
                    dataBaseType = dbschemaObj.getString(DATABASE);
                    attrImple = new AttributesImpl();
                    attrImple.addAttribute("", "", "Type", STRING, dataBaseType);
                    attrImple.addAttribute("", "", SEPARATOR, STRING, ";");
                    attrImple.addAttribute("", "", DBKEY, STRING, dbRoute);
                    AppPackageUtil.createElementWithoutAttribute(transformerHandle, attrImple, four, "dbschema/" + dbschema, SQL_SCRIPT);
                }
            }
            if (preinsdataArr != null && preinsdataArr.size() > 0) {
                for (i = 0; i < preinsdataArr.size(); ++i) {
                    JSONObject preinsdataObj = (JSONObject)preinsdataArr.get(i);
                    String preinsdata = preinsdataObj.getString(URL_NAME);
                    dataBaseType = preinsdataObj.getString(DATABASE);
                    attrImple = new AttributesImpl();
                    attrImple.addAttribute("", "", "Type", STRING, dataBaseType);
                    attrImple.addAttribute("", "", SEPARATOR, STRING, ";");
                    attrImple.addAttribute("", "", DBKEY, STRING, dbRoute);
                    AppPackageUtil.createElementWithoutAttribute(transformerHandle, attrImple, four, "preinsdata/" + preinsdata, SQL_SCRIPT);
                }
            }
            for (String sqlName : sqlNameList) {
                AppPackageUtil.createElementWithoutAttribute(transformerHandle, coderuleImple, four, "preinsdata/" + sqlName, SQL_SCRIPT);
            }
            transformerHandle.endElement("", "", "DataModel");
            transformerHandle.endDocument();
        }
        catch (IOException | TransformerConfigurationException | SAXException e) {
            logger.error(e.getMessage());
            throw new KDBizException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean exportPageScheme(List<Long> wkBenchList, String mainPath, List<String> sqlNameList) {
        Map<Long, WorkBenchSchemeFile> pageSchemeMap = AppPackageUtil.exportWorkBenchSchemes(wkBenchList);
        boolean hasXml = false;
        for (Map.Entry<Long, WorkBenchSchemeFile> entry : pageSchemeMap.entrySet()) {
            Map<String, StringWriter> xmlMap;
            WorkBenchSchemeFile workBenchSchemeFile = entry.getValue();
            String portalSchemeSqlName = workBenchSchemeFile.getFileName();
            sqlNameList.add(portalSchemeSqlName);
            String portalSchemeSqlContent = workBenchSchemeFile.getSql();
            String checkMainPath = WorkBenchSchemeUtil.getCheckedFilePath(mainPath);
            String pageSchemeFilePath = checkMainPath + File.separator + PREINSDATA + File.separator + portalSchemeSqlName;
            String pageSchemeXmlPath = checkMainPath + File.separator + PREINSDATA + File.separator + "xml";
            String checkPageSchemeFilePath = WorkBenchSchemeUtil.getCheckedFilePath(pageSchemeFilePath);
            File pageSchemeFile = new File(SecurityUtils.normalize((String)checkPageSchemeFilePath));
            File pageSchemeParentFile = pageSchemeFile.getParentFile();
            if (!pageSchemeParentFile.exists()) {
                pageSchemeParentFile.mkdirs();
            }
            if (!pageSchemeFile.exists()) {
                OutputStreamWriter writer = null;
                FileOutputStream fileOutputStream = null;
                try {
                    if (!pageSchemeFile.createNewFile()) {
                        // empty if block
                    }
                    fileOutputStream = new FileOutputStream(pageSchemeFile);
                    writer = new OutputStreamWriter((OutputStream)fileOutputStream, UTF_8);
                    writer.write(portalSchemeSqlContent);
                }
                catch (Exception e) {
                    logger.error((Throwable)e);
                }
                finally {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (IOException ioException) {
                            AppUtils.addLog((String)BOS_DEVPORTAL_BIZAPP, (String)"exportCodeRuleSource", (String)ioException.getMessage());
                        }
                    }
                    if (fileOutputStream != null) {
                        try {
                            fileOutputStream.close();
                        }
                        catch (Exception exception) {
                            logger.error((Throwable)exception);
                        }
                    }
                }
            }
            if ((xmlMap = workBenchSchemeFile.getXmlMap()) != null && !xmlMap.isEmpty()) {
                hasXml = true;
            }
            if (Objects.isNull(xmlMap)) {
                return false;
            }
            for (Map.Entry<String, StringWriter> portalSchemeEntry : xmlMap.entrySet()) {
                String xmlName = portalSchemeEntry.getKey();
                StringWriter xmlContent = portalSchemeEntry.getValue();
                String xmlFilePath = pageSchemeXmlPath + File.separator + xmlName;
                XMLWriter writer = null;
                FileOutputStream fileOutputStream = null;
                try {
                    String checkXmlFilePath;
                    File xmlFile;
                    Document document = AppPackageUtil.parseText(xmlContent.toString());
                    OutputFormat format = OutputFormat.createPrettyPrint();
                    format.setEncoding("utf-8");
                    format.setTrimText(false);
                    String checkPageSchemeXmlPath = WorkBenchSchemeUtil.getCheckedFilePath(pageSchemeXmlPath);
                    File xmlPathFile = new File(SecurityUtils.normalize((String)checkPageSchemeXmlPath));
                    if (!xmlPathFile.exists()) {
                        xmlPathFile.mkdirs();
                    }
                    if ((xmlFile = new File(SecurityUtils.normalize((String)(checkXmlFilePath = WorkBenchSchemeUtil.getCheckedFilePath(xmlFilePath))))).exists() || !xmlFile.createNewFile()) {
                        // empty if block
                    }
                    fileOutputStream = new FileOutputStream(xmlFile);
                    writer = new XMLWriter((OutputStream)fileOutputStream, format);
                    writer.write(document);
                }
                catch (Exception e) {
                    logger.error(e.getMessage());
                }
                finally {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (IOException ioException) {
                            logger.error((Throwable)ioException);
                        }
                    }
                    if (fileOutputStream == null) continue;
                    try {
                        fileOutputStream.close();
                    }
                    catch (Exception exception) {
                        logger.error(exception.getMessage());
                    }
                }
            }
        }
        return hasXml;
    }

    public static void createDataModelXML(String bizAppId, String selectAppNum, String bizCloudNum, String appVersion, String zipPath) {
        String dataModelPath = zipPath + File.separator + DATAMODEL + File.separator + "datamodel.xml";
        File dataModelFile = new File(SecurityUtils.normalize((String)dataModelPath));
        if (!dataModelFile.exists()) {
            try {
                boolean createNewFileFlag = dataModelFile.createNewFile();
                logger.info(String.format(CREATE_NEW_FILE_FLAG_S, createNewFileFlag));
            }
            catch (IOException e) {
                logger.error(e.getMessage());
            }
        }
        try (FileOutputStream out = new FileOutputStream(dataModelFile);){
            TransformerHandler transformerHandle = AppPackageUtil.getTransformerHandler(out);
            String four = FOUR;
            String eight = "\n        ";
            AttributesImpl attrImple = new AttributesImpl();
            AttributesImpl rootImple = new AttributesImpl();
            transformerHandle.startDocument();
            transformerHandle.characters(four.toCharArray(), 0, 1);
            if (bizCloudNum.equalsIgnoreCase("dev") || bizCloudNum.equalsIgnoreCase("sys") || bizCloudNum.equalsIgnoreCase("wfs")) {
                bizCloudNum = "bos";
            }
            rootImple.addAttribute("", "", SOURCE_NAME, STRING, bizCloudNum);
            transformerHandle.startElement("", "", "Package", rootImple);
            AppPackageUtil.createElementWithoutAttribute(transformerHandle, null, four, appVersion, "ver");
            transformerHandle.characters(four.toCharArray(), 0, four.length());
            transformerHandle.startElement("", "", "app", attrImple);
            attrImple.addAttribute("", "", SOURCE_ID, STRING, selectAppNum);
            attrImple.addAttribute("", "", SOURCE_NAME, STRING, selectAppNum);
            attrImple.addAttribute("", "", "pkname", STRING, bizCloudNum + "-" + selectAppNum);
            attrImple.addAttribute("", "", "path", STRING, "main/" + selectAppNum);
            transformerHandle.characters(eight.toCharArray(), 0, eight.length());
            transformerHandle.startElement("", "", "item", attrImple);
            transformerHandle.endElement("", "", "item");
            transformerHandle.characters(four.toCharArray(), 0, four.length());
            transformerHandle.endElement("", "", "app");
            transformerHandle.endElement("", "", "Package");
            transformerHandle.endDocument();
        }
        catch (IOException | TransformerConfigurationException | SAXException e) {
            logger.error(e.getMessage());
            throw new KDBizException(e.getMessage());
        }
    }

    public static TransformerHandler getTransformerHandler(FileOutputStream fileOutputStream) throws TransformerConfigurationException {
        StreamResult reultXml = new StreamResult(fileOutputStream);
        SAXTransformerFactory factory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
        factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        TransformerHandler transformerHandle = factory.newTransformerHandler();
        transformerHandle.setResult(reultXml);
        return transformerHandle;
    }

    public static void createElementWithoutAttribute(TransformerHandler transformerHandle, AttributesImpl attributesImple, String blankLength, String endLength, String elementName) throws SAXException {
        AttributesImpl attriImple = null;
        attriImple = StringUtils.isBlank((Object)attributesImple) ? new AttributesImpl() : attributesImple;
        transformerHandle.characters(blankLength.toCharArray(), 0, blankLength.length());
        transformerHandle.startElement("", "", elementName, attriImple);
        if (StringUtils.isNotBlank((CharSequence)endLength)) {
            transformerHandle.characters(endLength.toCharArray(), 0, endLength.length());
        }
        transformerHandle.endElement("", "", elementName);
    }

    public static Map<Long, WorkBenchSchemeFile> exportWorkBenchSchemes(List<Long> mainPageIds) {
        HashMap<Long, WorkBenchSchemeFile> portalSchemeFileMap = new HashMap<Long, WorkBenchSchemeFile>(20);
        String dbRouteKey = MetadataServiceHelper.getDataEntityType((String)"msbd_wrokbench_scheme").getDBRouteKey();
        DBRoute dbRoute = DBRoute.of((String)dbRouteKey);
        for (long mainPageId : mainPageIds) {
            StringBuilder sqlBuilder = new StringBuilder();
            sqlBuilder.append("DELETE FROM T_MSBD_WORKBENCHCARDCONF_L WHERE FID IN (SELECT FID FROM T_MSBD_WORKBENCHCARDCONF WHERE FSCHEMEID = ").append(String.valueOf(mainPageId)).append(");\t\n");
            sqlBuilder.append("DELETE FROM T_MSBD_WORKBENCHCARDCONF WHERE FSCHEMEID = ").append(mainPageId).append(STR);
            sqlBuilder.append("DELETE FROM T_MSBD_WORKBENCHSCHEME_L WHERE FID = ").append(mainPageId).append(STR);
            sqlBuilder.append("DELETE FROM T_MSBD_WORKBENCHSCHEME WHERE FID = ").append(mainPageId).append(STR);
            WorkBenchSchemeFile workBenchSchemeFile = new WorkBenchSchemeFile();
            workBenchSchemeFile.setFileName("wb_workbench_scheme_" + mainPageId + "_" + new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()) + ".sql");
            PreInsDataScriptBuilder builder3 = new PreInsDataScriptBuilder();
            HashMap map3 = new HashMap();
            String selectField3 = "FPKID, FID, FLOCALEID, FCARDTITLE, FCUSTOMNAME  ";
            StringBuilder whereField3 = new StringBuilder();
            whereField3.append("fid in (select fid from t_msbd_workbenchcardconf where fschemeid = ").append(mainPageId).append(")");
            try {
                map3.putAll(builder3.genInsertSQLScript(dbRoute, "t_msbd_workbenchcardconf_l", selectField3, whereField3.toString(), null, null));
                if (StringUtils.isNotEmpty((CharSequence)((String)map3.get("sql")))) {
                    sqlBuilder.append((String)map3.get("sql"));
                }
                if (map3.get("xml") != null) {
                    workBenchSchemeFile.getXmlMap().putAll((Map)map3.get("xml"));
                }
            }
            catch (Exception e) {
                throw new KDBizException((Throwable)e, BosErrorCode.bOS, new Object[]{String.format(KSQLEXP_PLUGIN_ERROR_S, e.getMessage())});
            }
            PreInsDataScriptBuilder builder2 = new PreInsDataScriptBuilder();
            HashMap<String, Object> map2 = new HashMap<String, Object>();
            String selectField2 = "FID, FUSERID, FCONFIG, FSCHEMEID, FCARDID ";
            StringBuilder whereField2 = new StringBuilder();
            whereField2.append("FSCHEMEID = ").append(mainPageId);
            try {
                map2.putAll(builder2.genInsertSQLScript(dbRoute, "t_msbd_workbenchcardconf", selectField2, whereField2.toString(), null, null));
                if (StringUtils.isNotEmpty((CharSequence)((String)map2.get("sql")))) {
                    AppPackageUtil.processExportCardConfig(map2);
                    sqlBuilder.append((String)map2.get("sql"));
                }
                if (map2.get("xml") != null) {
                    workBenchSchemeFile.getXmlMap().putAll((Map)map2.get("xml"));
                }
            }
            catch (Exception e) {
                throw new KDBizException((Throwable)e, BosErrorCode.bOS, new Object[]{String.format(KSQLEXP_PLUGIN_ERROR_S, e.getMessage())});
            }
            PreInsDataScriptBuilder builder1 = new PreInsDataScriptBuilder();
            HashMap map1 = new HashMap();
            String selectField1 = "FPKID, FID, FLOCALEID, FNAME ";
            StringBuilder whereField1 = new StringBuilder();
            whereField1.append("FID = ").append(mainPageId);
            try {
                map1.putAll(builder1.genInsertSQLScript(dbRoute, "t_msbd_workbenchscheme_l", selectField1, whereField1.toString(), null, null));
                if (StringUtils.isNotEmpty((CharSequence)((String)map1.get("sql")))) {
                    sqlBuilder.append((String)map1.get("sql"));
                }
                if (map1.get("xml") != null) {
                    workBenchSchemeFile.getXmlMap().putAll((Map)map1.get("xml"));
                }
            }
            catch (Exception e) {
                throw new KDBizException((Throwable)e, BosErrorCode.bOS, new Object[]{String.format(KSQLEXP_PLUGIN_ERROR_S, e.getMessage())});
            }
            PreInsDataScriptBuilder builder = new PreInsDataScriptBuilder();
            HashMap map = new HashMap();
            String tableName = "t_msbd_workbenchscheme";
            String selectField = "FID, FUSERID, FBIZAPPID, FLAYOUT, FNUMBER, FENABLE, FCUSTOMABLE, FISMULTIORG, FISPRESET, FCREATORID, FCREATETIME, FMODIFIERID, FMODIFYTIME, FDISABLERID, FDISABLETIME, FSCHEMETYPE,FFORMNUM ";
            StringBuilder whereField = new StringBuilder();
            whereField.append("FID = ").append(mainPageId);
            try {
                map.putAll(builder.genInsertSQLScript(dbRoute, tableName, selectField, whereField.toString(), null, null));
                if (StringUtils.isNotEmpty((CharSequence)((String)map.get("sql")))) {
                    sqlBuilder.append((String)map.get("sql"));
                }
                if (map.get("xml") != null) {
                    workBenchSchemeFile.getXmlMap().putAll((Map)map.get("xml"));
                }
            }
            catch (Exception e) {
                throw new KDBizException((Throwable)e, BosErrorCode.bOS, new Object[]{String.format(KSQLEXP_PLUGIN_ERROR_S, e.getMessage())});
            }
            workBenchSchemeFile.setSql(sqlBuilder.toString());
            portalSchemeFileMap.put(mainPageId, workBenchSchemeFile);
        }
        return portalSchemeFileMap;
    }

    private static void processExportCardConfig(Map<String, Object> exportCardConfigSqlInfo) {
        AppPackageUtil.processExportQingCardConfig(exportCardConfigSqlInfo);
    }

    private static void processExportQingCardConfig(Map<String, Object> exportCardConfigSqlInfo) {
        String[] sqlArr;
        String allSql = (String)exportCardConfigSqlInfo.get("sql");
        if (StringUtils.isBlank((CharSequence)allSql)) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (String curSql : sqlArr = allSql.split(";")) {
            if (StringUtils.isBlank((CharSequence)curSql)) {
                sb.append("\r\n");
                continue;
            }
            StringBuilder curSqlSb = new StringBuilder(curSql);
            if (curSql.contains("INSERT INTO T_MSBD_WORKBENCHCARDCONF") && curSql.contains("'bos_card_qing'")) {
                int startIndex = curSql.indexOf("'{");
                int endIndex = curSql.lastIndexOf("}'");
                String configJsonStr = curSql.substring(startIndex + 1, endIndex + 1);
                String resultStr = AppPackageUtil.invokeBOSService(configJsonStr);
                curSqlSb.replace(startIndex + 1, endIndex + 1, resultStr);
            }
            sb.append((CharSequence)curSqlSb).append(";");
        }
        exportCardConfigSqlInfo.put("sql", sb.toString());
    }

    private static String invokeBOSService(String configJsonStr) {
        return (String)DispatchServiceHelper.invokeBOSService((String)"qing", (String)"QingService", (String)"switchHomepageCardIdToPath", (Object[])new Object[]{configJsonStr});
    }

    public static Document parseText(String text) throws Exception {
        SAXReader reader = AppPackageUtil.getInstance();
        String encoding = AppPackageUtil.getEncoding(text);
        InputSource source = new InputSource(new StringReader(text));
        source.setEncoding(encoding);
        Document result = reader.read(source);
        if (result.getXMLEncoding() == null) {
            result.setXMLEncoding(encoding);
        }
        return result;
    }

    private static SAXReader getInstance() throws SAXException {
        SAXReader reader = SAXReader.createDefault();
        reader.setFeature("http://xml.org/sax/features/external-general-entities", false);
        reader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        return reader;
    }

    private static String getEncoding(String text) {
        String result = null;
        String xml = text.trim();
        if (xml.startsWith("<?xml")) {
            int end = xml.indexOf("?>");
            String sub = xml.substring(0, end);
            StringTokenizer tokens = new StringTokenizer(sub, " =\"'");
            while (tokens.hasMoreTokens()) {
                String token = tokens.nextToken();
                if (!"encoding".equals(token)) continue;
                if (!tokens.hasMoreTokens()) break;
                result = tokens.nextToken();
                break;
            }
        }
        return result;
    }
}

