/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.workbench.util;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.TreeView;
import kd.bos.util.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class LeftTreeSearchUtil {
    private static final String SEARCH_TEXT_CACHE = "search_text_cache";
    private static final String CUR_NODE_POSITION = "cur_node_position";
    private static final String MATCHED_NODE_CACHE = "matched_node_cache";

    public static void searchNodeByTextInTree(String leftTreeId, TreeNode root, String searchText, IFormView formView) {
        if (root != null && root.getChildren().size() > 0) {
            List<TreeNode> searchNodes = LeftTreeSearchUtil.getSearchNodes(root, searchText, formView);
            if (CollectionUtils.isEmpty(searchNodes)) {
                formView.showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230\u7b26\u5408\u6761\u4ef6\u7684\u6570\u636e", (String)"LeftTreeSearchUtil_0", (String)"mpscmm-msbd-workbench", (Object[])new Object[0]));
                return;
            }
            LeftTreeSearchUtil.findAndClickMatchedNode(leftTreeId, root, formView, searchNodes, searchText);
        }
    }

    private static void findAndClickMatchedNode(String leftTreeId, TreeNode root, IFormView formView, List<TreeNode> searchNodes, String searchText) {
        int number;
        IPageCache pageCache = formView.getPageCache();
        String assignSearchNum = pageCache.get(CUR_NODE_POSITION);
        String num = "0";
        if (StringUtils.isNotEmpty((CharSequence)assignSearchNum)) {
            num = assignSearchNum;
        }
        if ((number = Integer.parseInt(num)) == searchNodes.size()) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\u641c\u7d22", (String)"LeftTreeSearchUtil_1", (String)"mpscmm-msbd-workbench", (Object[])new Object[0]));
        }
        for (int i = number; i < searchNodes.size(); ++i) {
            TreeNode matchedTreeNode = searchNodes.get(i);
            TreeNode treeNode = root.getTreeNode(matchedTreeNode.getId());
            if (null != treeNode) {
                TreeView treeView = (TreeView)formView.getControl(leftTreeId);
                treeView.focusNode(treeNode);
                treeView.treeNodeClick(treeNode.getParentid(), treeNode.getId());
                int curMatchedIndex = i + 1;
                pageCache.put(CUR_NODE_POSITION, curMatchedIndex + "");
                LeftTreeSearchUtil.checkLastNode(i, searchNodes, formView, searchText);
                break;
            }
            LeftTreeSearchUtil.checkLastNode(i, searchNodes, formView, searchText);
        }
    }

    private static void getAllChildren(List<TreeNode> children, List<TreeNode> allChildren) {
        if (children != null && children.size() > 0) {
            allChildren.addAll(children);
            for (TreeNode child : children) {
                LeftTreeSearchUtil.getAllChildren(child.getChildren(), allChildren);
            }
        }
    }

    private static void checkLastNode(int i, List<TreeNode> treeNodes, IFormView formView, String searchText) {
        IPageCache pageCache = formView.getPageCache();
        if (i == treeNodes.size() - 1) {
            Integer number = treeNodes.size();
            pageCache.put(CUR_NODE_POSITION, number + "");
            pageCache.remove(SEARCH_TEXT_CACHE);
            pageCache.removeBigObject(MATCHED_NODE_CACHE);
            formView.showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\u641c\u7d22", (String)"LeftTreeSearchUtil_1", (String)"mpscmm-msbd-workbench", (Object[])new Object[0]));
        }
    }

    private static List<TreeNode> getSearchNodes(TreeNode root, String searchText, IFormView formView) {
        IPageCache pageCache = formView.getPageCache();
        String searchTextCache = pageCache.get(SEARCH_TEXT_CACHE);
        String searchTreeNodesStr = pageCache.getBigObject(MATCHED_NODE_CACHE);
        if (StringUtils.isNotEmpty((CharSequence)searchTextCache) && searchText.equals(searchTextCache) && StringUtils.isNotEmpty((CharSequence)searchTreeNodesStr)) {
            return SerializationUtils.fromJsonStringToList((String)searchTreeNodesStr, TreeNode.class);
        }
        ArrayList<TreeNode> allChildren = new ArrayList<TreeNode>(32);
        LeftTreeSearchUtil.getAllChildren(root.getChildren(), allChildren);
        List<TreeNode> collect = allChildren.stream().filter(v -> v.getText().contains(searchText)).collect(Collectors.toList());
        pageCache.put(CUR_NODE_POSITION, "0");
        pageCache.put(SEARCH_TEXT_CACHE, searchText);
        pageCache.putBigObject(MATCHED_NODE_CACHE, SerializationUtils.toJsonString(collect));
        return collect;
    }
}

