/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.expense.business.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.mpscmm.msbd.business.helper.FieldMapHelper;
import kd.mpscmm.msbd.common.utils.BigDecimalUtil;
import kd.mpscmm.msbd.common.utils.CommonUtils;
import kd.mpscmm.msbd.expense.common.enums.ExpenseSourceEnum;

public class ExpenseBillHelper {
    private static final Log logger = LogFactory.getLog(ExpenseBillHelper.class);
    private static final BigDecimal ZERO = BigDecimal.ZERO;
    private static final String UNIT_PRECISION = "precision";
    private static final String UNIT_PRECISIONTYPE = "precisionaccount";
    private static final String CONV_NUMERATOR = "numerator";
    private static final String CONV_DENOMINATOR = "denominator";

    public static boolean isExistExpenseByBillId(Long billId) {
        if (CommonUtils.isNull((Object)billId) || billId == 0L) {
            return false;
        }
        boolean isExist = QueryServiceHelper.exists((String)"msbd_expensebill", (QFilter[])new QFilter[]{new QFilter("bizbillid", "=", (Object)billId)});
        return isExist;
    }

    public static Set<Long> isExistExpenseByBillIds(List<Long> billIds) {
        HashSet<Long> bizBillWithExps = new HashSet<Long>(8);
        if (!CommonUtils.isNull(billIds) && billIds.size() != 0) {
            DynamicObjectCollection expenseBills = QueryServiceHelper.query((String)"msbd_expensebill", (String)"id,bizbillid", (QFilter[])new QFilter[]{new QFilter("bizbillid", "in", billIds)});
            for (DynamicObject expensebill : expenseBills) {
                bizBillWithExps.add(expensebill.getLong("bizbillid"));
            }
        }
        return bizBillWithExps;
    }

    public static Map<Long, DynamicObject> getExpenseByBillIds(Set<Long> billIds) {
        DynamicObject[] expenseBillDOs;
        HashMap<Long, DynamicObject> expenseMap = new HashMap<Long, DynamicObject>(8);
        if (CommonUtils.isNull(billIds)) {
            return expenseMap;
        }
        DynamicObject[] expenseObjs = BusinessDataServiceHelper.load((String)"msbd_expensebill", (String)"id,bizbillid", (QFilter[])new QFilter[]{new QFilter("bizbillid", "in", billIds)});
        Object[] expsPks = new Object[expenseObjs.length];
        for (int i = 0; i < expenseObjs.length; ++i) {
            expsPks[i] = expenseObjs[i].getPkValue();
        }
        MainEntityType expsDOType = EntityMetadataCache.getDataEntityType((String)"msbd_expensebill");
        for (DynamicObject expenseBill : expenseBillDOs = BusinessDataServiceHelper.load((Object[])expsPks, (DynamicObjectType)expsDOType)) {
            Long bizBillId = expenseBill.getLong("bizbillid");
            ExpenseBillHelper.expandRowExpenseEntrys(expenseBill);
            expenseMap.put(bizBillId, expenseBill);
        }
        return expenseMap;
    }

    public static void expandRowExpenseEntrys(DynamicObject expenseBill) {
        DynamicObjectCollection billExpsEntryColl = expenseBill.getDynamicObjectCollection("billexpenseentry");
        DynamicObjectCollection rowExpsEntryColl = expenseBill.getDynamicObjectCollection("rowexpenseentry");
        if (rowExpsEntryColl.size() == 0) {
            EntryType rowExpEtryType = (EntryType)rowExpsEntryColl.getDynamicObjectType();
            for (DynamicObject billExpsEntry : billExpsEntryColl) {
                String rowJsonStr = billExpsEntry.getString("rowexpensejson_tag");
                ExpenseBillHelper.strToDynamicObjectColl(rowJsonStr, rowExpsEntryColl, rowExpEtryType);
            }
        }
    }

    public static Map<Long, DynamicObject> updateExpense(String bizBillEntity, Long[] bizBillIds) {
        HashMap<Long, DynamicObject> expenseRslt = new HashMap<Long, DynamicObject>(8);
        return expenseRslt;
    }

    public static DynamicObjectCollection rowExpsToBillEntry(DynamicObjectCollection billExpsEtrys, EntryType billExpEtryType, DynamicObjectCollection rowExpEntrys, Map<String, Map<String, Object>> rowExpMap) {
        DynamicObjectCollection billExpsColl = new DynamicObjectCollection();
        if (!CommonUtils.isNull(rowExpMap)) {
            HashMap<String, Map<String, Object>> rowExpMap_new = new HashMap<String, Map<String, Object>>(8);
            if (billExpsEtrys.size() > 0) {
                block0: for (Map.Entry<String, Map<String, Object>> row : rowExpMap.entrySet()) {
                    Iterator billExpsEtry2;
                    String key = row.getKey().toString();
                    Map<String, Object> expsInfoMap = row.getValue();
                    if (expsInfoMap == null) continue;
                    boolean delBillExp = expsInfoMap.get("delbillexp") == null ? false : (Boolean)expsInfoMap.get("delbillexp");
                    DynamicObject priceTypeObj = (DynamicObject)expsInfoMap.get("pricetypeobj");
                    DynamicObject currencyObj = (DynamicObject)expsInfoMap.get("currencyobj");
                    Long priceTypeId_row = priceTypeObj == null ? 0L : priceTypeObj.getLong("id");
                    Long currencyId_row = currencyObj == null ? 0L : currencyObj.getLong("id");
                    if (delBillExp) {
                        for (Iterator billExpsEtry2 : billExpsEtrys) {
                            DynamicObject priceType = billExpsEtry2.getDynamicObject("pricetype");
                            DynamicObject currency = billExpsEtry2.getDynamicObject("currency");
                            Long priceTypeId_bill = priceType == null ? 0L : priceType.getLong("id");
                            Long currencyId_bill = currency == null ? 0L : currency.getLong("id");
                            if (!priceTypeId_row.equals(priceTypeId_bill) || !currencyId_row.equals(currencyId_bill)) continue;
                            billExpsEtrys.remove((Object)billExpsEtry2);
                            continue block0;
                        }
                        continue;
                    }
                    if (priceTypeObj == null || currencyObj == null) continue;
                    boolean isExist = false;
                    billExpsEtry2 = billExpsEtrys.iterator();
                    while (billExpsEtry2.hasNext()) {
                        DynamicObject billExpsEtry3 = (DynamicObject)billExpsEtry2.next();
                        DynamicObject priceType = billExpsEtry3.getDynamicObject("pricetype");
                        DynamicObject currency = billExpsEtry3.getDynamicObject("currency");
                        if (CommonUtils.isNull((Object)priceType) || CommonUtils.isNull((Object)currency) || priceTypeId_row.longValue() != priceType.getLong("id") || currencyId_row.longValue() != currency.getLong("id")) continue;
                        billExpsEtry3.set("priceval", expsInfoMap.get("priceval"));
                        billExpsEtry3.set("caltypeval", expsInfoMap.get("caltypeval"));
                        billExpsEtry3.set("amount", expsInfoMap.get("amount"));
                        isExist = true;
                        break;
                    }
                    if (isExist) continue;
                    rowExpMap_new.put(key, expsInfoMap);
                }
            } else {
                rowExpMap_new.putAll(rowExpMap);
            }
            if (!CommonUtils.isNull(rowExpMap_new)) {
                int mapSize = rowExpMap_new.size();
                long beginrowtobilltime = System.currentTimeMillis();
                long[] ids = DBServiceHelper.genLongIds((String)"billexpenseentry", (int)mapSize);
                long endrowtobilltime = System.currentTimeMillis();
                int i = 0;
                for (Map.Entry row : rowExpMap_new.entrySet()) {
                    String key = row.getKey().toString();
                    Map expsInfoMap_new = (Map)row.getValue();
                    if (expsInfoMap_new == null) continue;
                    DynamicObject priceTypeObj = (DynamicObject)expsInfoMap_new.get("pricetypeobj");
                    DynamicObject currencyObj = (DynamicObject)expsInfoMap_new.get("currencyobj");
                    if (priceTypeObj == null || currencyObj == null) continue;
                    DynamicObject addBillExpsRow = new DynamicObject((DynamicObjectType)billExpEtryType);
                    addBillExpsRow.set("id", (Object)ids[i]);
                    addBillExpsRow.set("pricetype", (Object)priceTypeObj);
                    addBillExpsRow.set("currency", (Object)currencyObj);
                    addBillExpsRow.set("caltype", (Object)priceTypeObj.getDynamicObject("calctype"));
                    addBillExpsRow.set("priceval", expsInfoMap_new.get("priceval"));
                    addBillExpsRow.set("caltypeval", expsInfoMap_new.get("caltypeval"));
                    addBillExpsRow.set("amount", expsInfoMap_new.get("amount"));
                    addBillExpsRow.set("istax", priceTypeObj.get("istax"));
                    addBillExpsRow.set("source", (Object)"B");
                    billExpsColl.add((Object)addBillExpsRow);
                    ++i;
                }
            }
        }
        billExpsEtrys.addAll((Collection)billExpsColl);
        DynamicObjectCollection needRemove = new DynamicObjectCollection();
        for (int m = 0; m < billExpsEtrys.size(); ++m) {
            boolean isExist = false;
            DynamicObject priceType = ((DynamicObject)billExpsEtrys.get(m)).getDynamicObject("pricetype");
            DynamicObject currency = ((DynamicObject)billExpsEtrys.get(m)).getDynamicObject("currency");
            BigDecimal priceVal = ((DynamicObject)billExpsEtrys.get(m)).getBigDecimal("priceval");
            String source = ((DynamicObject)billExpsEtrys.get(m)).getString("source");
            if (priceType == null || currency == null || (priceVal == null || priceVal.compareTo(BigDecimal.ZERO) == 0) && ExpenseSourceEnum.MANUL.getValue().equals(source)) {
                isExist = true;
            } else {
                for (int n = 0; n < rowExpEntrys.size(); ++n) {
                    DynamicObject r_priceType = ((DynamicObject)rowExpEntrys.get(n)).getDynamicObject("r_pricetype");
                    DynamicObject r_currency = ((DynamicObject)rowExpEntrys.get(n)).getDynamicObject("r_currency");
                    if (r_priceType == null || r_currency == null) continue;
                    if (priceType.getLong("id") == r_priceType.getLong("id") && currency.getLong("id") == r_currency.getLong("id")) {
                        isExist = true;
                    }
                    if (isExist) break;
                }
            }
            if (isExist) continue;
            needRemove.add(billExpsEtrys.get(m));
        }
        billExpsEtrys.removeAll((Collection)needRemove);
        return billExpsEtrys;
    }

    public static Map<String, Map<String, Object>> rowExpsSumByAll(DynamicObjectCollection rowExpEntrys) {
        HashMap<String, Map<String, Object>> rowExpMap = new HashMap<String, Map<String, Object>>(8);
        for (int i = 0; i < rowExpEntrys.size(); ++i) {
            String calcBase;
            String rowExpMapKey;
            DynamicObject r_priceTypeObj = ((DynamicObject)rowExpEntrys.get(i)).getDynamicObject("r_pricetype");
            if (r_priceTypeObj == null) continue;
            String r_priceType = r_priceTypeObj.getPkValue().toString();
            DynamicObject r_currencyObj = ((DynamicObject)rowExpEntrys.get(i)).getDynamicObject("r_currency");
            String r_currency = "0";
            if (r_currencyObj != null) {
                r_currency = r_currencyObj.getPkValue().toString();
            }
            if (CommonUtils.isNull(rowExpMap.get(rowExpMapKey = r_priceType + "&" + r_currency))) {
                HashMap<String, BigDecimal> rowInfoMap = new HashMap<String, BigDecimal>(8);
                rowInfoMap.put("priceval", ((DynamicObject)rowExpEntrys.get(i)).getBigDecimal("r_priceval"));
                rowInfoMap.put("caltypeval", ((DynamicObject)rowExpEntrys.get(i)).getBigDecimal("r_caltypeval"));
                rowInfoMap.put("amount", ((DynamicObject)rowExpEntrys.get(i)).getBigDecimal("r_amount"));
                rowInfoMap.put("pricetypeobj", (BigDecimal)r_priceTypeObj);
                rowInfoMap.put("currencyobj", (BigDecimal)r_currencyObj);
                rowExpMap.put(rowExpMapKey, rowInfoMap);
                continue;
            }
            BigDecimal priceValInMap = (BigDecimal)((Map)rowExpMap.get(rowExpMapKey)).get("priceval");
            BigDecimal priceVal_row = ((DynamicObject)rowExpEntrys.get(i)).getBigDecimal("r_priceval");
            DynamicObject calType = ((DynamicObject)rowExpEntrys.get(i)).getDynamicObject("r_caltype");
            String string = calcBase = calType == null ? "" : calType.getString("calcbase");
            if (StringUtils.isEmpty((String)calcBase)) {
                ((Map)rowExpMap.get(rowExpMapKey)).put("priceval", priceValInMap.add(priceVal_row));
            } else if (priceValInMap.compareTo(priceVal_row) != 0) {
                ((Map)rowExpMap.get(rowExpMapKey)).put("priceval", BigDecimal.ZERO);
            }
            BigDecimal calTypeVal_sum = (BigDecimal)((Map)rowExpMap.get(rowExpMapKey)).get("caltypeval");
            BigDecimal r_calTypeVal = calTypeVal_sum.add(((DynamicObject)rowExpEntrys.get(i)).getBigDecimal("r_caltypeval"));
            ((Map)rowExpMap.get(rowExpMapKey)).put("caltypeval", r_calTypeVal);
            BigDecimal amount_sum = (BigDecimal)((Map)rowExpMap.get(rowExpMapKey)).get("amount");
            BigDecimal r_amount = amount_sum.add(((DynamicObject)rowExpEntrys.get(i)).getBigDecimal("r_amount"));
            ((Map)rowExpMap.get(rowExpMapKey)).put("amount", r_amount);
            ((Map)rowExpMap.get(rowExpMapKey)).put("pricetypeobj", r_priceTypeObj);
            ((Map)rowExpMap.get(rowExpMapKey)).put("currencyobj", r_currencyObj);
        }
        return rowExpMap;
    }

    public static Map<String, Map<String, Object>> rowExpsSumExcludeCurrent(DynamicObjectCollection rowExpEntrys, Long priceTypeId, Long currencyId, int rowIndex) {
        HashMap<String, Map<String, Object>> rowExpMap = new HashMap<String, Map<String, Object>>(8);
        String rowExpMapKey = priceTypeId + "&" + currencyId;
        for (int i = 0; i < rowExpEntrys.size(); ++i) {
            String calcBase;
            DynamicObject r_priceTypeObj = ((DynamicObject)rowExpEntrys.get(i)).getDynamicObject("r_pricetype");
            if (r_priceTypeObj == null) continue;
            String r_priceType = r_priceTypeObj.getPkValue().toString();
            DynamicObject r_currencyObj = ((DynamicObject)rowExpEntrys.get(i)).getDynamicObject("r_currency");
            String r_currency = "0";
            if (r_currencyObj != null) {
                r_currency = r_currencyObj.getPkValue().toString();
            }
            if (i == rowIndex || !priceTypeId.equals(Long.valueOf(r_priceType)) || !currencyId.equals(Long.valueOf(r_currency))) continue;
            if (CommonUtils.isNull(rowExpMap.get(rowExpMapKey))) {
                HashMap<String, BigDecimal> rowInfoMap = new HashMap<String, BigDecimal>(8);
                rowInfoMap.put("priceval", ((DynamicObject)rowExpEntrys.get(i)).getBigDecimal("r_priceval"));
                rowInfoMap.put("caltypeval", ((DynamicObject)rowExpEntrys.get(i)).getBigDecimal("r_caltypeval"));
                rowInfoMap.put("amount", ((DynamicObject)rowExpEntrys.get(i)).getBigDecimal("r_amount"));
                rowInfoMap.put("pricetypeobj", (BigDecimal)r_priceTypeObj);
                rowInfoMap.put("currencyobj", (BigDecimal)r_currencyObj);
                rowExpMap.put(rowExpMapKey, rowInfoMap);
                continue;
            }
            BigDecimal priceValInMap = (BigDecimal)((Map)rowExpMap.get(rowExpMapKey)).get("priceval");
            BigDecimal priceVal_row = ((DynamicObject)rowExpEntrys.get(i)).getBigDecimal("r_priceval");
            DynamicObject calType = ((DynamicObject)rowExpEntrys.get(i)).getDynamicObject("r_caltype");
            String string = calcBase = calType == null ? "" : calType.getString("calcbase");
            if (StringUtils.isEmpty((String)calcBase)) {
                ((Map)rowExpMap.get(rowExpMapKey)).put("priceval", priceValInMap.add(priceVal_row));
            } else if (priceValInMap.compareTo(priceVal_row) != 0) {
                ((Map)rowExpMap.get(rowExpMapKey)).put("priceval", BigDecimal.ZERO);
            }
            BigDecimal calTypeVal_sum = (BigDecimal)((Map)rowExpMap.get(rowExpMapKey)).get("caltypeval");
            BigDecimal r_calTypeVal = calTypeVal_sum.add(((DynamicObject)rowExpEntrys.get(i)).getBigDecimal("r_caltypeval"));
            ((Map)rowExpMap.get(rowExpMapKey)).put("caltypeval", r_calTypeVal);
            BigDecimal amount_sum = (BigDecimal)((Map)rowExpMap.get(rowExpMapKey)).get("amount");
            BigDecimal r_amount = amount_sum.add(((DynamicObject)rowExpEntrys.get(i)).getBigDecimal("r_amount"));
            ((Map)rowExpMap.get(rowExpMapKey)).put("amount", r_amount);
            ((Map)rowExpMap.get(rowExpMapKey)).put("pricetypeobj", r_priceTypeObj);
            ((Map)rowExpMap.get(rowExpMapKey)).put("currencyobj", r_currencyObj);
        }
        if (CommonUtils.isNull(rowExpMap.get(rowExpMapKey))) {
            HashMap<String, Boolean> rowInfoMap = new HashMap<String, Boolean>(8);
            rowInfoMap.put("delbillexp", Boolean.TRUE);
            rowExpMap.put(rowExpMapKey, rowInfoMap);
        }
        return rowExpMap;
    }

    public static Map<String, Map<String, Object>> rowExpsSumExcludeDelRows(DynamicObjectCollection rowExpEntrys, List<Integer> rowIndexs) {
        Long del_currencyId;
        Long del_priceTypeId;
        DynamicObject del_currencyObj;
        DynamicObject del_priceTypeObj;
        HashMap<String, Map<String, Object>> rowExpMap = new HashMap<String, Map<String, Object>>(8);
        for (Integer rowIndex : rowIndexs) {
            del_priceTypeObj = ((DynamicObject)rowExpEntrys.get(rowIndex.intValue())).getDynamicObject("r_pricetype");
            if (del_priceTypeObj == null || (del_currencyObj = ((DynamicObject)rowExpEntrys.get(rowIndex.intValue())).getDynamicObject("r_currency")) == null) continue;
            del_priceTypeId = Long.valueOf(del_priceTypeObj.getPkValue().toString());
            del_currencyId = Long.valueOf(del_currencyObj.getPkValue().toString());
            String delKey = del_priceTypeObj.getPkValue().toString() + "&" + del_currencyObj.getPkValue().toString();
            if (rowExpMap.get(delKey) != null) continue;
            for (int i = 0; i < rowExpEntrys.size(); ++i) {
                String calcBase;
                DynamicObject r_currencyObj;
                DynamicObject r_priceTypeObj = ((DynamicObject)rowExpEntrys.get(i)).getDynamicObject("r_pricetype");
                if (r_priceTypeObj == null || (r_currencyObj = ((DynamicObject)rowExpEntrys.get(i)).getDynamicObject("r_currency")) == null) continue;
                String r_priceType = r_priceTypeObj.getPkValue().toString();
                String r_currency = r_currencyObj.getPkValue().toString();
                String rowExpMapKey = r_priceType + "&" + r_currency;
                if (rowIndexs.contains(i) || !del_priceTypeId.equals(Long.valueOf(r_priceType)) || !del_currencyId.equals(Long.valueOf(r_currency))) continue;
                if (CommonUtils.isNull(rowExpMap.get(rowExpMapKey))) {
                    HashMap<String, BigDecimal> rowInfoMap = new HashMap<String, BigDecimal>(8);
                    rowInfoMap.put("priceval", ((DynamicObject)rowExpEntrys.get(i)).getBigDecimal("r_priceval"));
                    rowInfoMap.put("caltypeval", ((DynamicObject)rowExpEntrys.get(i)).getBigDecimal("r_caltypeval"));
                    rowInfoMap.put("amount", ((DynamicObject)rowExpEntrys.get(i)).getBigDecimal("r_amount"));
                    rowInfoMap.put("pricetypeobj", (BigDecimal)r_priceTypeObj);
                    rowInfoMap.put("currencyobj", (BigDecimal)r_currencyObj);
                    rowExpMap.put(rowExpMapKey, rowInfoMap);
                    continue;
                }
                BigDecimal priceValInMap = (BigDecimal)((Map)rowExpMap.get(rowExpMapKey)).get("priceval");
                BigDecimal priceVal_row = ((DynamicObject)rowExpEntrys.get(i)).getBigDecimal("r_priceval");
                DynamicObject calType = ((DynamicObject)rowExpEntrys.get(i)).getDynamicObject("r_caltype");
                String string = calcBase = calType == null ? "" : calType.getString("calcbase");
                if (StringUtils.isEmpty((String)calcBase)) {
                    ((Map)rowExpMap.get(rowExpMapKey)).put("priceval", priceValInMap.add(priceVal_row));
                } else if (priceValInMap.compareTo(priceVal_row) != 0) {
                    ((Map)rowExpMap.get(rowExpMapKey)).put("priceval", BigDecimal.ZERO);
                }
                BigDecimal calTypeVal_sum = (BigDecimal)((Map)rowExpMap.get(rowExpMapKey)).get("caltypeval");
                BigDecimal r_calTypeVal = calTypeVal_sum.add(((DynamicObject)rowExpEntrys.get(i)).getBigDecimal("r_caltypeval"));
                ((Map)rowExpMap.get(rowExpMapKey)).put("caltypeval", r_calTypeVal);
                BigDecimal amount_sum = (BigDecimal)((Map)rowExpMap.get(rowExpMapKey)).get("amount");
                BigDecimal r_amount = amount_sum.add(((DynamicObject)rowExpEntrys.get(i)).getBigDecimal("r_amount"));
                ((Map)rowExpMap.get(rowExpMapKey)).put("amount", r_amount);
                ((Map)rowExpMap.get(rowExpMapKey)).put("pricetypeobj", r_priceTypeObj);
                ((Map)rowExpMap.get(rowExpMapKey)).put("currencyobj", r_currencyObj);
            }
        }
        for (Integer rowIndex : rowIndexs) {
            del_priceTypeObj = ((DynamicObject)rowExpEntrys.get(rowIndex.intValue())).getDynamicObject("r_pricetype");
            if (del_priceTypeObj == null || (del_currencyObj = ((DynamicObject)rowExpEntrys.get(rowIndex.intValue())).getDynamicObject("r_currency")) == null) continue;
            del_priceTypeId = Long.valueOf(del_priceTypeObj.getPkValue().toString());
            del_currencyId = Long.valueOf(del_currencyObj.getPkValue().toString());
            String rowExpKey = del_priceTypeId + "&" + del_currencyId;
            if (!CommonUtils.isNull(rowExpMap.get(rowExpKey))) continue;
            HashMap<String, Boolean> rowInfoMap = new HashMap<String, Boolean>(8);
            rowInfoMap.put("delbillexp", Boolean.TRUE);
            rowInfoMap.put("pricetypeobj", (Boolean)del_priceTypeObj);
            rowInfoMap.put("currencyobj", (Boolean)del_currencyObj);
            rowExpMap.put(rowExpKey, rowInfoMap);
        }
        return rowExpMap;
    }

    public static Map<String, Map<String, Object>> rowExpsSumByDimension(DynamicObjectCollection rowExpEntrys, Long priceTypeId, Long currencyId) {
        HashMap<String, Map<String, Object>> rowExpMap = new HashMap<String, Map<String, Object>>(8);
        for (int i = 0; i < rowExpEntrys.size(); ++i) {
            String calcBase;
            DynamicObject r_priceTypeObj = ((DynamicObject)rowExpEntrys.get(i)).getDynamicObject("r_pricetype");
            if (r_priceTypeObj == null) continue;
            String r_priceType = r_priceTypeObj.getPkValue().toString();
            DynamicObject r_currencyObj = ((DynamicObject)rowExpEntrys.get(i)).getDynamicObject("r_currency");
            String r_currency = "0";
            if (r_currencyObj != null) {
                r_currency = r_currencyObj.getPkValue().toString();
            }
            String rowExpMapKey = r_priceType + "&" + r_currency;
            if (!priceTypeId.equals(Long.valueOf(r_priceType)) || !currencyId.equals(Long.valueOf(r_currency))) continue;
            if (CommonUtils.isNull(rowExpMap.get(rowExpMapKey))) {
                HashMap<String, BigDecimal> rowInfoMap = new HashMap<String, BigDecimal>(8);
                rowInfoMap.put("priceval", ((DynamicObject)rowExpEntrys.get(i)).getBigDecimal("r_priceval"));
                rowInfoMap.put("caltypeval", ((DynamicObject)rowExpEntrys.get(i)).getBigDecimal("r_caltypeval"));
                rowInfoMap.put("amount", ((DynamicObject)rowExpEntrys.get(i)).getBigDecimal("r_amount"));
                rowInfoMap.put("pricetypeobj", (BigDecimal)r_priceTypeObj);
                rowInfoMap.put("currencyobj", (BigDecimal)r_currencyObj);
                rowExpMap.put(rowExpMapKey, rowInfoMap);
                continue;
            }
            BigDecimal priceValInMap = (BigDecimal)((Map)rowExpMap.get(rowExpMapKey)).get("priceval");
            BigDecimal priceVal_row = ((DynamicObject)rowExpEntrys.get(i)).getBigDecimal("r_priceval");
            DynamicObject calType = ((DynamicObject)rowExpEntrys.get(i)).getDynamicObject("r_caltype");
            String string = calcBase = calType == null ? "" : calType.getString("calcbase");
            if (StringUtils.isEmpty((String)calcBase)) {
                ((Map)rowExpMap.get(rowExpMapKey)).put("priceval", priceValInMap.add(priceVal_row));
            } else if (priceValInMap.compareTo(priceVal_row) != 0) {
                ((Map)rowExpMap.get(rowExpMapKey)).put("priceval", BigDecimal.ZERO);
            }
            BigDecimal calTypeVal_sum = (BigDecimal)((Map)rowExpMap.get(rowExpMapKey)).get("caltypeval");
            BigDecimal r_calTypeVal = calTypeVal_sum.add(((DynamicObject)rowExpEntrys.get(i)).getBigDecimal("r_caltypeval"));
            ((Map)rowExpMap.get(rowExpMapKey)).put("caltypeval", r_calTypeVal);
            BigDecimal amount_sum = (BigDecimal)((Map)rowExpMap.get(rowExpMapKey)).get("amount");
            BigDecimal r_amount = amount_sum.add(((DynamicObject)rowExpEntrys.get(i)).getBigDecimal("r_amount"));
            ((Map)rowExpMap.get(rowExpMapKey)).put("amount", r_amount);
            ((Map)rowExpMap.get(rowExpMapKey)).put("pricetypeobj", r_priceTypeObj);
            ((Map)rowExpMap.get(rowExpMapKey)).put("currencyobj", r_currencyObj);
        }
        return rowExpMap;
    }

    public static Map<Object, DynamicObject> getDataObj(DynamicObjectType dataType, Set<Long> dataIds) {
        if (dataIds != null && dataIds.size() > 0) {
            Map dataObjs = BusinessDataServiceHelper.loadFromCache((DynamicObjectType)dataType, (QFilter[])new QFilter[]{new QFilter("id", "in", dataIds)});
            return dataObjs;
        }
        return null;
    }

    public static Map<String, String> getFieldMap(String sourceEntity) {
        DynamicObject fldMapObj = FieldMapHelper.getFieldMapObj((String)sourceEntity, (String)"msbd_pricetax_expenses");
        if (CommonUtils.isNull((Object)fldMapObj)) {
            return null;
        }
        return FieldMapHelper.getFieldMapByObj((DynamicObject)fldMapObj, (String)"target");
    }

    public static String getOriginalBillField(String sourceEntity, String modelField) {
        Map<String, String> fieldMap = ExpenseBillHelper.getFieldMap(sourceEntity);
        if (fieldMap != null) {
            return fieldMap.get(modelField);
        }
        return null;
    }

    public static String getSelectProps(String srcEntity) {
        if (CommonUtils.isNull((Object)srcEntity)) {
            return "";
        }
        Map<String, String> fldMap = ExpenseBillHelper.getFieldMap(srcEntity);
        if (CommonUtils.isNull(fldMap)) {
            return null;
        }
        StringBuilder selectPropsBuilder = new StringBuilder("id");
        boolean isExistEntryId = false;
        if (fldMap == null) {
            return "";
        }
        for (Map.Entry<String, String> fld : fldMap.entrySet()) {
            if (fld.getKey().equals("billentry")) continue;
            selectPropsBuilder.append(',');
            if (fld.getValue().toString().contains(fldMap.get("billentry") + ".")) {
                String selProp = fldMap.get("billentry") + "." + ExpenseBillHelper.getSplitStrs(fld.getValue().toString());
                selectPropsBuilder.append(selProp);
                if (isExistEntryId) continue;
                selectPropsBuilder.append(',');
                selectPropsBuilder.append(fldMap.get("billentry"));
                selectPropsBuilder.append('.');
                selectPropsBuilder.append("id");
                isExistEntryId = true;
                continue;
            }
            selectPropsBuilder.append((Object)fld.getValue());
        }
        return selectPropsBuilder.toString();
    }

    public static String getSelectPropsForDS(String srcEntity, Map<String, String> fldMap) {
        if (CommonUtils.isNull((Object)srcEntity) || fldMap == null || fldMap.size() == 0) {
            return "";
        }
        StringBuilder selectPropsBuilder = new StringBuilder("id");
        boolean isExistEntryId = false;
        if (fldMap == null) {
            return "";
        }
        for (Map.Entry<String, String> fld : fldMap.entrySet()) {
            if (fld.getKey().equals("billentry")) continue;
            selectPropsBuilder.append(',');
            if (fld.getValue().toString().contains(fldMap.get("billentry") + ".")) {
                String selProp = fldMap.get("billentry") + "." + ExpenseBillHelper.getSplitStrs(fld.getValue().toString());
                selectPropsBuilder.append(selProp);
                selectPropsBuilder.append(" as ");
                selectPropsBuilder.append(ExpenseBillHelper.getSplitStrs(fld.getValue().toString()));
                if (isExistEntryId) continue;
                selectPropsBuilder.append(',');
                selectPropsBuilder.append(fldMap.get("billentry"));
                selectPropsBuilder.append('.');
                selectPropsBuilder.append("id");
                isExistEntryId = true;
                continue;
            }
            selectPropsBuilder.append((Object)fld.getValue());
        }
        return selectPropsBuilder.toString();
    }

    public static List<String> getShowProps(String srcEntity) {
        if (CommonUtils.isNull((Object)srcEntity)) {
            return null;
        }
        Map<String, String> fldMap = ExpenseBillHelper.getFieldMap(srcEntity);
        if (fldMap == null) {
            return null;
        }
        ArrayList<String> showProps = new ArrayList<String>(8);
        boolean isExistEntryId = false;
        for (Map.Entry<String, String> fld : fldMap.entrySet()) {
            if (fld.getKey().equals("billentry")) continue;
            if (fld.getValue().toString().contains(fldMap.get("billentry") + ".")) {
                String selProp = fldMap.get("billentry") + "." + ExpenseBillHelper.getSplitStrs(fld.getValue().toString());
                showProps.add(selProp);
                if (isExistEntryId) continue;
                showProps.add(fldMap.get("billentry") + ".id");
                isExistEntryId = true;
                continue;
            }
            showProps.add(fld.getValue().toString());
        }
        return showProps;
    }

    public static String getBillFieldByMap(String srcEntity, String modelField, Map<String, String> fldMap) {
        String rsltField = "";
        if (fldMap == null) {
            fldMap = ExpenseBillHelper.getFieldMap(srcEntity);
        }
        if (fldMap == null) {
            return rsltField;
        }
        rsltField = fldMap.get(modelField);
        if (!"billentry".equals(modelField) && !CommonUtils.isNull((Object)rsltField) && rsltField.contains(fldMap.get("billentry") + ".")) {
            rsltField = ExpenseBillHelper.getSplitStrs(rsltField);
        }
        return rsltField;
    }

    public static String checkExist(String srcEntity, Set<String> modelFields, Map<String, String> fldMap) {
        String srcEntityName = ExpenseBillHelper.getEntityAlias(srcEntity);
        String srcEntityStr = srcEntity;
        if (!StringUtils.isEmpty((String)srcEntityName)) {
            srcEntityStr = srcEntityName;
        }
        if (fldMap == null && (fldMap = ExpenseBillHelper.getFieldMap(srcEntity)) == null) {
            return ResManager.loadKDString((String)"\u201c\u901a\u7528\u6620\u5c04\u914d\u7f6e\u201d\u4e2d\u6765\u6e90\u5355\u636e\u201c%1$s\u201d\u548c\u76ee\u6807\u4e1a\u52a1\u5b9e\u4f53\u201c\u4ef7\u683c\u6a21\u578b\u201d\u7684\u6709\u6548\u6620\u5c04\u4e0d\u5b58\u5728\u6216\u4e0d\u552f\u4e00\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ExpenseBillHelper_0", (String)"mpscmm-msbd-expense", (Object[])new Object[]{srcEntityStr});
        }
        StringBuilder msgStr = new StringBuilder();
        boolean isExist = true;
        for (String modelFld : modelFields) {
            if (!CommonUtils.isNull((Object)fldMap.get(modelFld))) continue;
            String modelFldPropName = ExpenseBillHelper.getPropertyAlias(modelFld);
            String modelFldPropStr = modelFld;
            if (!StringUtils.isEmpty((String)modelFldPropName)) {
                modelFldPropStr = modelFldPropName;
            }
            if (StringUtils.isEmpty((String)msgStr.toString())) {
                msgStr.append(modelFldPropStr);
            } else {
                msgStr.append(',');
                msgStr.append(modelFldPropStr);
            }
            isExist = false;
        }
        if (isExist) {
            return null;
        }
        String msg = ResManager.loadKDString((String)"\u201c\u901a\u7528\u6620\u5c04\u914d\u7f6e\u201d\u4e2d\u6765\u6e90\u5355\u636e\u201c%1$s\u201d\u548c\u76ee\u6807\u4e1a\u52a1\u5b9e\u4f53\u201c\u4ef7\u683c\u6a21\u578b\u201d\u7684\u5b57\u6bb5\u201c%2$s\u201d\u672a\u6620\u5c04\uff0c\u8bf7\u7ef4\u62a4\u3002", (String)"ExpenseBillHelper_1", (String)"mpscmm-msbd-expense", (Object[])new Object[]{srcEntityStr, msgStr});
        return msg;
    }

    public static Map<String, String> checkExistByFld(String srcEntity, String modelField) {
        Map<String, String> fldMap;
        HashMap<String, String> checkExistMap = new HashMap<String, String>(8);
        String srcEntityStr = srcEntity;
        String srcEntityName = ExpenseBillHelper.getEntityAlias(srcEntity);
        if (!StringUtils.isEmpty((String)srcEntityName)) {
            srcEntityStr = srcEntityName;
        }
        if ((fldMap = ExpenseBillHelper.getFieldMap(srcEntity)) == null) {
            String msg = ResManager.loadKDString((String)"\u201c\u901a\u7528\u6620\u5c04\u914d\u7f6e\u201d\u4e2d\u6765\u6e90\u5355\u636e\u201c%1$s\u201d\u548c\u76ee\u6807\u4e1a\u52a1\u5b9e\u4f53\u201c\u4ef7\u683c\u6a21\u578b\u201d\u7684\u6709\u6548\u6620\u5c04\u4e0d\u5b58\u5728\u6216\u4e0d\u552f\u4e00\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ExpenseBillHelper_0", (String)"mpscmm-msbd-expense", (Object[])new Object[]{srcEntityStr});
            checkExistMap.put("msg", msg);
        } else {
            String bizField = fldMap.get(modelField);
            if (StringUtils.isEmpty((String)bizField)) {
                String modelFieldStr = modelField;
                String modelFieldName = ExpenseBillHelper.getPropertyAlias(modelField);
                if (!StringUtils.isEmpty((String)modelFieldName)) {
                    modelFieldStr = modelFieldName;
                }
                String msg = ResManager.loadKDString((String)"\u201c\u901a\u7528\u6620\u5c04\u914d\u7f6e\u201d\u4e2d\u6765\u6e90\u5355\u636e\u201c%1$s\u201d\u548c\u76ee\u6807\u4e1a\u52a1\u5b9e\u4f53\u201c\u4ef7\u683c\u6a21\u578b\u201d\u7684\u5b57\u6bb5\u201c%2$s\u201d\u672a\u6620\u5c04\uff0c\u8bf7\u7ef4\u62a4\u3002", (String)"ExpenseBillHelper_1", (String)"mpscmm-msbd-expense", (Object[])new Object[]{srcEntityStr, modelFieldStr});
                checkExistMap.put("msg", msg);
            } else {
                if (!modelField.equalsIgnoreCase("billentry") && !CommonUtils.isNull((Object)bizField) && bizField.contains(fldMap.get("billentry") + ".")) {
                    bizField = ExpenseBillHelper.getSplitStrs(bizField);
                }
                checkExistMap.put("bizfield", bizField);
            }
        }
        return checkExistMap;
    }

    public static void expsCalculate(DynamicObject rowExpEntry) {
        BigDecimal r_priceVal = rowExpEntry.getBigDecimal("r_priceval") == null ? BigDecimalUtil.ZERO : rowExpEntry.getBigDecimal("r_priceval");
        BigDecimal r_caltypeval = rowExpEntry.getBigDecimal("r_caltypeval") == null ? BigDecimalUtil.ZERO : rowExpEntry.getBigDecimal("r_caltypeval");
        DynamicObject currencyObj = rowExpEntry.getDynamicObject("r_currency");
        int amtprecision = currencyObj.getInt("amtprecision");
        DynamicObject r_calType = rowExpEntry.getDynamicObject("r_caltype");
        if (r_calType == null) {
            return;
        }
        String calcbase = r_calType.getString("calcbase");
        if (calcbase.equals("amountandtax")) {
            BigDecimal r_amount = r_priceVal.multiply(r_caltypeval).divide(new BigDecimal(100));
            rowExpEntry.set("r_amount", (Object)r_amount.setScale(amtprecision, RoundingMode.HALF_UP));
        } else if (StringUtils.isEmpty((String)calcbase)) {
            rowExpEntry.set("r_amount", (Object)rowExpEntry.getBigDecimal("r_priceval").setScale(amtprecision, RoundingMode.HALF_UP));
        } else {
            BigDecimal r_amount = r_priceVal.multiply(r_caltypeval);
            rowExpEntry.set("r_amount", (Object)r_amount.setScale(amtprecision, RoundingMode.HALF_UP));
        }
    }

    public static BigDecimal getDesQtyConv(Long materialId, DynamicObject srcUnit, BigDecimal srcQty, DynamicObject desUnit) {
        BigDecimal desQty = ZERO;
        if (materialId != null && srcUnit != null && desUnit != null && srcQty != null && srcQty.compareTo(ZERO) != 0) {
            if (srcUnit.getPkValue().equals(desUnit.getPkValue())) {
                desQty = srcQty;
            } else {
                DynamicObject muConv = BaseDataServiceHelper.getMUConv((Long)materialId, (Long)((Long)srcUnit.getPkValue()), (Long)((Long)desUnit.getPkValue()));
                if (muConv != null) {
                    int numberator = muConv.getInt(CONV_NUMERATOR);
                    int denominator = muConv.getInt(CONV_DENOMINATOR);
                    if (denominator != 0) {
                        desQty = srcQty.multiply(new BigDecimal(denominator)).divide(new BigDecimal(numberator), 10, ExpenseBillHelper.getPrecisionType(desUnit));
                    }
                }
            }
        }
        return desQty;
    }

    public static int getPrecisionByUnit(DynamicObject unit) {
        int precision = 10;
        if (unit != null) {
            precision = unit.getInt(UNIT_PRECISION);
        }
        return precision;
    }

    public static int getPrecisionType(DynamicObject unit) {
        int precisionType = 4;
        if (unit != null && StringUtils.isEmpty((String)unit.getString(UNIT_PRECISIONTYPE))) {
            String precisionAccount;
            switch (precisionAccount = unit.getString(UNIT_PRECISIONTYPE)) {
                case "1": {
                    precisionType = 4;
                    break;
                }
                case "2": {
                    precisionType = 1;
                    break;
                }
                case "3": {
                    precisionType = 0;
                    break;
                }
            }
        }
        return precisionType;
    }

    public static int getPriceValPrecision(DynamicObject calType, DynamicObject currency) {
        int precision = 10;
        if (!(CommonUtils.isNull((Object)calType) || CommonUtils.isNull((Object)calType.getString("calcbase")) || calType.getString("calcbase").trim().equalsIgnoreCase("") || CommonUtils.isNull((Object)currency) || CommonUtils.isNull((Object)currency.getInt("priceprecision")))) {
            precision = currency.getInt("priceprecision");
        }
        if (!CommonUtils.isNull((Object)calType) && CommonUtils.isNull((Object)calType.getString("calcbase")) && calType.getString("calcbase").trim().equalsIgnoreCase("") && !CommonUtils.isNull((Object)currency) && !CommonUtils.isNull((Object)currency.getInt("amtprecision"))) {
            precision = currency.getInt("amtprecision");
        }
        return precision;
    }

    public static int getRowCalTypeValPrecision(DynamicObject unit, DynamicObject currency) {
        int precision = 10;
        if (!CommonUtils.isNull((Object)unit) && !CommonUtils.isNull((Object)unit.getInt(UNIT_PRECISION))) {
            precision = unit.getInt(UNIT_PRECISION);
        }
        if (CommonUtils.isNull((Object)unit) && !CommonUtils.isNull((Object)currency) && !CommonUtils.isNull((Object)currency.getInt("amtprecision"))) {
            precision = currency.getInt("amtprecision");
        }
        return precision;
    }

    public static String getSplitStrs(String flds) {
        String[] strs = flds.split("\\.");
        return strs[1];
    }

    public static String DOToStr(DynamicObjectCollection rowsToStr, EntryType etryType) {
        Map rowExpFieldMap = etryType.getFields();
        ArrayList priceExpsLst = new ArrayList(rowsToStr.size());
        for (int j = 0; j < rowsToStr.size(); ++j) {
            HashMap<String, Object> rowExpMap = new HashMap<String, Object>(8);
            rowExpMap.put("seq", ((DynamicObject)rowsToStr.get(j)).get("seq"));
            rowExpMap.put("id", ((DynamicObject)rowsToStr.get(j)).get("id"));
            for (Map.Entry entry : rowExpFieldMap.entrySet()) {
                if (rowExpFieldMap.get(entry.getKey()) instanceof BasedataProp) {
                    DynamicObject baseDataDO = (DynamicObject)((DynamicObject)rowsToStr.get(j)).get(entry.getKey().toString());
                    if (baseDataDO == null || baseDataDO.getPkValue() == null) continue;
                    rowExpMap.put(entry.getKey().toString(), baseDataDO.getPkValue().toString());
                    continue;
                }
                if (((DynamicObject)rowsToStr.get(j)).get(entry.getKey().toString()) == null) continue;
                rowExpMap.put(entry.getKey().toString(), ((DynamicObject)rowsToStr.get(j)).get(entry.getKey().toString()).toString());
            }
            priceExpsLst.add(rowExpMap);
        }
        if (!CommonUtils.isNull(priceExpsLst)) {
            long beginrowtoStrtime = System.currentTimeMillis();
            String rowtoStr = SerializationUtils.toJsonString(priceExpsLst);
            long endrowtoStrtime = System.currentTimeMillis();
            return rowtoStr;
        }
        return null;
    }

    public static DynamicObjectCollection strToDynamicObjectColl(String JsonStr, DynamicObjectCollection rowExpEntrys, EntryType rowExpEtryType) {
        Map rowExpFieldMap = rowExpEtryType.getFields();
        if (StringUtils.isEmpty((String)JsonStr)) {
            return rowExpEntrys;
        }
        long beginfromjsontime = System.currentTimeMillis();
        List strsLst = (List)SerializationUtils.fromJsonString((String)JsonStr, List.class);
        long endfromjsontime = System.currentTimeMillis();
        if (!CommonUtils.isNull((Object)strsLst) && strsLst.size() > 0) {
            HashMap dataObjMaps = new HashMap(8);
            HashMap dataInfos = new HashMap(8);
            HashMap<String, DynamicObjectType> objectTypeMap = new HashMap<String, DynamicObjectType>(8);
            for (int i = 0; i < strsLst.size(); ++i) {
                Map rowExpMap = (Map)strsLst.get(i);
                if (rowExpMap == null) continue;
                for (Map.Entry entry : rowExpFieldMap.entrySet()) {
                    if (CommonUtils.isNull(entry.getKey()) || CommonUtils.isNull(rowExpMap.get(entry.getKey())) || !(entry.getValue() instanceof BasedataProp)) continue;
                    String entityName = ((BasedataProp)entry.getValue()).getBaseEntityId();
                    if (objectTypeMap.get(entityName) == null) {
                        DynamicObjectType objType = (DynamicObjectType)((BasedataProp)entry.getValue()).getComplexType();
                        objectTypeMap.put(entityName, objType);
                    }
                    if (dataInfos.get(entityName) == null) {
                        HashSet<Long> idSet = new HashSet<Long>(8);
                        idSet.add(Long.valueOf(rowExpMap.get(entry.getKey()).toString()));
                        dataInfos.put(entityName, idSet);
                        continue;
                    }
                    ((Set)dataInfos.get(entityName)).add(Long.valueOf(rowExpMap.get(entry.getKey()).toString()));
                }
            }
            long begingetdataobjtime = System.currentTimeMillis();
            if (dataInfos != null && dataInfos.size() > 0) {
                for (Map.Entry info : dataInfos.entrySet()) {
                    String entity = info.getKey().toString();
                    Set ids = (Set)info.getValue();
                    DynamicObjectType dynamicObjectType = (DynamicObjectType)objectTypeMap.get(entity);
                }
            }
            long endgetdataobjtime = System.currentTimeMillis();
            for (int i = 0; i < strsLst.size(); ++i) {
                Map rowExpMap = (Map)strsLst.get(i);
                if (rowExpMap == null) continue;
                DynamicObject rowExpObj = CommonUtils.isNull((Object)rowExpEntrys) ? new DynamicObject((DynamicObjectType)rowExpEtryType) : rowExpEntrys.addNew();
                for (Map.Entry entry : rowExpFieldMap.entrySet()) {
                    if (CommonUtils.isNull(entry.getKey()) || CommonUtils.isNull(rowExpMap.get(entry.getKey()))) continue;
                    if (entry.getValue() instanceof BasedataProp) {
                        String entityName = ((BasedataProp)entry.getValue()).getBaseEntityId();
                        Map objs = (Map)dataObjMaps.get(entityName);
                        if (objs == null) continue;
                        Long obj = Long.valueOf(rowExpMap.get(entry.getKey().toString()).toString());
                        rowExpObj.set(entry.getKey().toString(), objs.get(obj));
                        continue;
                    }
                    rowExpObj.set(entry.getKey().toString(), rowExpMap.get(entry.getKey()));
                }
                rowExpObj.set("seq", rowExpMap.get("seq"));
                rowExpObj.set("id", rowExpMap.get("id"));
                if (!CommonUtils.isNull((Object)rowExpEntrys)) continue;
                rowExpEntrys.add((Object)rowExpObj);
            }
        }
        return rowExpEntrys;
    }

    public static String getPropertyAlias(String propertyName) {
        MainEntityType priceModelEntityDataType = MetadataServiceHelper.getDataEntityType((String)"msbd_pricetax_expenses");
        DataEntityPropertyCollection propertyColl = priceModelEntityDataType.getProperties();
        for (IDataEntityProperty dataEntityProp : propertyColl) {
            if (dataEntityProp instanceof EntryProp || !dataEntityProp.getName().equals(propertyName)) continue;
            return dataEntityProp.getDisplayName().getLocaleValue();
        }
        return null;
    }

    public static String getEntityAlias(String entityKey) {
        MainEntityType priceModelEntityDataType = MetadataServiceHelper.getDataEntityType((String)entityKey);
        if (priceModelEntityDataType != null) {
            return priceModelEntityDataType.getDisplayName().getLocaleValue();
        }
        return null;
    }

    public static Set<String> getModelExpsFlds() {
        HashSet<String> needChkFlds = new HashSet<String>(16);
        needChkFlds.add("bizorg");
        needChkFlds.add("currency");
        needChkFlds.add("bizbillno");
        needChkFlds.add("billstatus");
        needChkFlds.add("billentry");
        needChkFlds.add("material");
        needChkFlds.add("qty");
        needChkFlds.add("unit");
        needChkFlds.add("amountandtax");
        needChkFlds.add("settleorg");
        return needChkFlds;
    }
}

