/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.expense.formplugin;

import java.util.EventObject;
import java.util.List;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.metadata.treebuilder.PropTreeBuildOption;
import kd.bos.servicehelper.MetadataServiceHelper;

public class CalcTypePlugin
extends AbstractBasePlugIn {
    private static final String FORMID_SELECTFIELD = "botp_selectfield";
    private static final String SOURCETREENODES = "treenodes";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"calcbase"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        if ("calcbase".equalsIgnoreCase(c.getKey())) {
            this.showBillTree();
        }
    }

    public void showBillTree() {
        MainEntityType mainType = MetadataServiceHelper.getDataEntityType((String)"msbd_pricetax_expenses");
        PropTreeBuildOption option = new PropTreeBuildOption();
        option.setIncludePKField(true);
        option.setOnlyPhysicsField(false);
        TreeNode treeNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)mainType, (PropTreeBuildOption)option);
        this.arrangeTreeNode(treeNode);
        this.showSrcFieldForm(treeNode, "calcbase");
    }

    private void showSrcFieldForm(TreeNode billNode, String fieldKey) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(FORMID_SELECTFIELD);
        String nodesJson = SerializationUtils.toJsonString((Object)billNode);
        showParameter.getCustomParams().put(SOURCETREENODES, nodesJson);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, fieldKey));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private void arrangeTreeNode(TreeNode treeNode) {
        TreeNode parentNode;
        if (treeNode.getChildren() != null && treeNode.getChildren().size() > 0 && (parentNode = (TreeNode)treeNode.getChildren().get(0)) != null && parentNode.getChildren() != null && parentNode.getChildren().size() > 0) {
            parentNode.getChildren().remove(0);
            List leafNodes = parentNode.getChildren();
            if (leafNodes != null) {
                for (int i = leafNodes.size() - 1; i >= 0; --i) {
                    TreeNode leafNode = (TreeNode)leafNodes.get(i);
                    if (leafNode.getChildren() == null || leafNode.getChildren().size() <= 0) continue;
                    leafNode.setChildren(null);
                }
            }
            treeNode.getChildren().remove(0);
            treeNode.addChildren(leafNodes);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId = e.getActionId();
        Object returnData = e.getReturnData();
        if (StringUtils.isEmpty((CharSequence)actionId) || returnData == null) {
            return;
        }
        switch (actionId) {
            case "calcbase": {
                MainEntityType mainType;
                IDataEntityProperty prop;
                String returnDataStr;
                if (!(returnData instanceof String) || !StringUtils.isNotEmpty((CharSequence)(returnDataStr = (String)returnData)) || (prop = (IDataEntityProperty)(mainType = MetadataServiceHelper.getDataEntityType((String)"msbd_pricetax_expenses")).getAllFields().get(returnDataStr)) == null) break;
                this.getModel().setValue("calcbase", (Object)returnDataStr);
                this.getModel().setValue("calcbasename", (Object)prop.getDisplayName().getLocaleValue());
                break;
            }
        }
    }
}

