/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.expense.opplugin;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.mpscmm.msbd.expense.business.helper.ExpenseBillHelper;

public class ExpenseBillSaveValidator
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity data : this.dataEntities) {
            DynamicObject currencyObj;
            DynamicObject priceTypeObj;
            DynamicObject bill = data.getDataEntity();
            DynamicObjectCollection billExpsEntrys = bill.getDynamicObjectCollection("billexpenseentry");
            DynamicObjectCollection rowExpsEntrys = bill.getDynamicObjectCollection("rowexpenseentry");
            if (billExpsEntrys != null && billExpsEntrys.size() > 0) {
                for (int i = 0; i < billExpsEntrys.size(); ++i) {
                    BigDecimal amount = ((DynamicObject)billExpsEntrys.get(i)).getBigDecimal("amount");
                    if (amount.compareTo(BigDecimal.ZERO) != 0) continue;
                    this.addMessage(data, String.format(ResManager.loadKDString((String)"\u6574\u5355\u8d39\u7528\u9875\u7b7e\uff0c\u884c\u53f7\u201c%1$s\u201d\uff0c\u8d39\u7528\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u7ef4\u62a4\u3002", (String)"ExpenseBillSaveValidator_0", (String)"mpscmm-msbd-expense", (Object[])new Object[0]), i + 1), ErrorLevel.Error);
                }
            }
            if (rowExpsEntrys != null && rowExpsEntrys.size() > 0) {
                for (int j = 0; j < rowExpsEntrys.size(); ++j) {
                    BigDecimal r_amount = ((DynamicObject)rowExpsEntrys.get(j)).getBigDecimal("r_amount");
                    if (r_amount.compareTo(BigDecimal.ZERO) != 0) continue;
                    this.addMessage(data, String.format(ResManager.loadKDString((String)"\u884c\u8d39\u7528\u9875\u7b7e\uff0c\u884c\u53f7\u201c%1$s\u201d\uff0c\u8d39\u7528\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u7ef4\u62a4\u3002", (String)"ExpenseBillSaveValidator_1", (String)"mpscmm-msbd-expense", (Object[])new Object[0]), j + 1), ErrorLevel.Error);
                }
            }
            if (billExpsEntrys == null || billExpsEntrys.size() <= 0) continue;
            Map<Object, Object> rowExpMap = new HashMap(8);
            rowExpMap = ExpenseBillHelper.rowExpsSumByAll(rowExpsEntrys);
            for (int k = 0; k < billExpsEntrys.size() && (priceTypeObj = ((DynamicObject)billExpsEntrys.get(k)).getDynamicObject("pricetype")) != null && (currencyObj = ((DynamicObject)billExpsEntrys.get(k)).getDynamicObject("currency")) != null; ++k) {
                String priceType = priceTypeObj.getPkValue().toString();
                String currency = currencyObj.getPkValue().toString();
                String billExpMapKey = priceType + "&" + currency;
                BigDecimal amount = ((DynamicObject)billExpsEntrys.get(k)).getBigDecimal("amount");
                if (amount.compareTo(BigDecimal.ZERO) == 0) {
                    amount = BigDecimal.ZERO;
                }
                if (rowExpMap.get(billExpMapKey) == null) continue;
                BigDecimal r_amount = (BigDecimal)((Map)rowExpMap.get(billExpMapKey)).get("amount");
                if (r_amount.compareTo(BigDecimal.ZERO) == 0) {
                    r_amount = BigDecimal.ZERO;
                }
                if (amount.compareTo(r_amount) == 0) continue;
                this.addMessage(data, String.format(ResManager.loadKDString((String)"\u6574\u5355\u8d39\u7528\u9875\u7b7e\u884c\u53f7\u201c%1$s\u201d\uff0c\u4ef7\u683c\u7c7b\u578b+\u5e01\u79cd\u7684\u8d39\u7528\u91d1\u989d\uff08%2$s\uff09\u4e0e\u884c\u8d39\u7528\uff08%3$s\uff09\u4e0d\u76f8\u7b49\uff0c\u8bf7\u7ef4\u62a4\u3002", (String)"ExpenseBillSaveValidator_2", (String)"mpscmm-msbd-expense", (Object[])new Object[0]), k + 1, amount, r_amount), ErrorLevel.Error);
            }
        }
    }
}

