/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.datamanage.business.function.algoxreduce;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperateInfo;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.metadata.entity.validation.ConditionValidation;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.mpscmm.msbd.datamanage.business.helper.ConditionAnalysisHelper;
import kd.mpscmm.msbd.datamanage.business.helper.DmfSchemeExecuteHelper;
import kd.mpscmm.msbd.datamanage.common.util.ReflectUtils;

public class IuValidCalculateFunction
extends GroupReduceFunction {
    private String inspectEntity;
    private Long entryId;
    private DynamicObject inspectUnit;

    public IuValidCalculateFunction(String inspectEntity, Long entryId, DynamicObject inspectUnit) {
        this.inspectEntity = inspectEntity;
        this.entryId = entryId;
        this.inspectUnit = inspectUnit;
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        HashSet idSet = new HashSet(16);
        for (RowX next : iterable) {
            List batchList = SerializationUtils.fromJsonStringToList((String)((String)next.get(1)), Long.class);
            idSet.addAll(batchList);
        }
        DynamicObject[] bizData = BusinessDataServiceHelper.load((Object[])idSet.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)this.inspectEntity));
        List<OperateErrorInfo> operateErrorInfoList = this.executeDmfUnit(this.inspectEntity, this.inspectUnit, bizData);
        if (operateErrorInfoList.size() > 10000) {
            operateErrorInfoList = operateErrorInfoList.subList(0, 10000);
        }
        operateErrorInfoList.stream().sorted(Comparator.comparing(OperateInfo::getTitle));
        int subEntrySize = operateErrorInfoList.size();
        int indexSeq = 1;
        long[] detailPkIdList = DBServiceHelper.genLongIds((String)"t_msbd_inspectlogentry_e", (int)subEntrySize);
        for (int i = 0; i < subEntrySize; ++i) {
            OperateErrorInfo result = operateErrorInfoList.get(i);
            Object[] subEntry = new Object[8];
            subEntry[0] = detailPkIdList[i];
            subEntry[1] = this.entryId;
            subEntry[2] = indexSeq;
            subEntry[3] = result.getPkValue();
            Object[] reflectFieldsValue = ReflectUtils.reflectFieldsValue(result, "entryId");
            subEntry[4] = reflectFieldsValue[0] instanceof Long ? reflectFieldsValue[0] : Long.valueOf(0L);
            subEntry[5] = result.getEntityKey();
            String msg = "";
            msg = result.getMessage().length() > 512 ? result.getMessage().substring(0, 480) : result.getMessage();
            subEntry[6] = msg;
            String title = result.getTitle();
            if (title == null) {
                title = "";
            }
            subEntry[7] = title;
            collector.collect(new RowX(subEntry));
            ++indexSeq;
        }
    }

    public RowMeta getResultRowMeta() {
        Field fdetailid = new Field("fdetailid", (DataType)DataType.LongType);
        Field fentryid = new Field("fentryid", (DataType)DataType.LongType);
        Field fseq = new Field("fseq", (DataType)DataType.IntegerType);
        Field fobjid = new Field("fobjid", (DataType)DataType.LongType);
        Field fobjentryid = new Field("fobjentryid", (DataType)DataType.LongType);
        Field fobjtypeid = new Field("fobjtypeid", (DataType)DataType.StringType);
        Field fobjdes = new Field("fobjdes", (DataType)DataType.StringType);
        Field fbizuniquesympol = new Field("fbizuniquesympol", (DataType)DataType.StringType);
        RowMeta rowMeta = new RowMeta(new Field[]{fdetailid, fentryid, fseq, fobjid, fobjentryid, fobjtypeid, fobjdes, fbizuniquesympol});
        return rowMeta;
    }

    private List<OperateErrorInfo> executeDmfUnit(String inspectEntity, DynamicObject dmfUnit, DynamicObject[] bills) {
        DynamicObjectCollection validEntityRows = dmfUnit.getDynamicObjectCollection("validentity");
        List<Object> operateErrorInfoList = new ArrayList<OperateErrorInfo>(16);
        String fieldKey = "billno";
        boolean isFieldKeyFlag = this.judgeExistsField(inspectEntity, fieldKey);
        String billNo = "";
        for (DynamicObject bill : bills) {
            if (isFieldKeyFlag) {
                billNo = bill.getString(fieldKey);
            }
            for (DynamicObject conditionRow : validEntityRows) {
                boolean trueThrow;
                boolean validEnable = conditionRow.getBoolean("validenable");
                if (!validEnable) continue;
                String expressionEntity = (String)conditionRow.get("validjson_tag");
                ConditionValidation conditionValidation = DmfSchemeExecuteHelper.getConditionValidation(expressionEntity);
                String expression = conditionValidation.getExpression();
                String entityKey = conditionValidation.getEntityKey();
                CRCondition condition = new CRCondition();
                condition.setExpression(expression);
                condition.buildFullFormula(MetadataServiceHelper.getDataEntityType((String)inspectEntity));
                boolean exeResultFlag = ConditionAnalysisHelper.doExeCondition(inspectEntity, bill, condition, entityKey);
                if (exeResultFlag != (trueThrow = conditionValidation.isTrueThrow())) continue;
                OperateErrorInfo operateerrorinfo = new OperateErrorInfo("DmfUnitService.excuteDmfUnitValidExpression", ErrorLevel.Error, bill.getPkValue(), bill.getPkValue());
                operateerrorinfo.setTitle(billNo);
                operateerrorinfo.setEntityKey(inspectEntity);
                String msg = "";
                msg = isFieldKeyFlag ? String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\uff1a%1$s\uff0c\u5b58\u5728\u5982\u4e0b\u95ee\u9898\uff1a%2$s", (String)"IuValidCalculateFunction_0", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), billNo, conditionValidation.getMessage().getLocaleValue()) : String.format(ResManager.loadKDString((String)"\u5b58\u5728\u5982\u4e0b\u95ee\u9898\uff1a%s", (String)"IuValidCalculateFunction_1", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), conditionValidation.getMessage().getLocaleValue());
                operateerrorinfo.setMessage(msg);
                operateErrorInfoList.add(operateerrorinfo);
            }
            if (operateErrorInfoList.size() <= 10000) continue;
            operateErrorInfoList = operateErrorInfoList.subList(0, 10000);
            break;
        }
        bills = null;
        return operateErrorInfoList;
    }

    private boolean judgeExistsField(String inspectEntity, String fieldKey) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)inspectEntity);
        Set entries = dataEntityType.getAllEntities().entrySet();
        boolean flag = false;
        for (Map.Entry entry : entries) {
            IDataEntityProperty varLeft;
            EntityType value;
            if (((String)entry.getKey()).contains("_lk") || !((value = (EntityType)entry.getValue()) instanceof BillEntityType) || (varLeft = value.findProperty(fieldKey)) == null) continue;
            flag = true;
            break;
        }
        return flag;
    }
}

