/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.datamanage.business.helper;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.formula.FormulaEngine;
import kd.bos.formula.excel.Expr;
import kd.mpscmm.msbd.datamanage.common.pojo.ConditionCompilerInfo;

public class ConditionAnalysisHelper {
    public static boolean doExeCondition(String entityNumber, DynamicObject bill, CRCondition condition) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        String preCondition = condition.buildFullFormula(dataEntityType);
        String[] vars = FormulaEngine.extractVariables((String)preCondition);
        Expr expr = FormulaEngine.parseFormula((String)preCondition);
        EntityType entity = null;
        String entityName = null;
        Set entries = dataEntityType.getAllEntities().entrySet();
        block0: for (Map.Entry entry : entries) {
            String[] stringArray = vars;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String var = stringArray[i];
                EntityType value = (EntityType)entry.getValue();
                IDataEntityProperty varLeft = value.findProperty(var);
                if (varLeft == null) continue;
                entity = (EntityType)varLeft.getParent();
                entityName = entity.getName();
                continue block0;
            }
        }
        HashMap<String, Object> varValueMap = new HashMap<String, Object>();
        if (entity instanceof BillEntityType) {
            for (String var : vars) {
                String[] o = bill.get(var);
                varValueMap.put(var, o);
            }
            return (Boolean)FormulaEngine.execExcelFormula((Expr)expr, varValueMap);
        }
        DynamicObjectCollection dynamicObjectCollection = bill.getDynamicObjectCollection(entityName);
        boolean flag = true;
        for (DynamicObject entry : dynamicObjectCollection) {
            for (String var : vars) {
                Object o = entry.get(var);
                varValueMap.put(var, o);
            }
            Boolean result = (Boolean)FormulaEngine.execExcelFormula((Expr)expr, varValueMap);
            if (result.booleanValue()) continue;
            flag = false;
        }
        return flag;
    }

    public static boolean doExeCondition(CRCondition condition, String entityNumber, DynamicObject bill) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        String preCondition = condition.buildFullFormula(dataEntityType);
        if (preCondition == null) {
            return false;
        }
        String[] vars = FormulaEngine.extractVariables((String)preCondition);
        BillEntityType billEntityType = (BillEntityType)EntityMetadataCache.getDataEntityType((String)entityNumber);
        Set entries = billEntityType.getAllEntities().entrySet();
        String entrySymbol = null;
        String billSymbol = null;
        boolean entryFlag = false;
        for (Map.Entry entry : entries) {
            EntityType value = (EntityType)entry.getValue();
            if (((String)entry.getKey()).contains("_lk")) continue;
            if (value instanceof BillEntityType) {
                billSymbol = (String)entry.getKey();
            }
            if (value instanceof EntryType) {
                entrySymbol = (String)entry.getKey();
                for (String var : vars) {
                    IDataEntityProperty varLeft = value.findProperty(var);
                    if (varLeft == null) continue;
                    entryFlag = true;
                    break;
                }
            }
            if (!entryFlag) continue;
            break;
        }
        ConditionCompilerInfo conditionCompilerInfo = new ConditionCompilerInfo(condition, entityNumber);
        if (entryFlag) {
            DynamicObjectCollection billEntry = bill.getDynamicObjectCollection(entrySymbol);
            boolean flag = true;
            for (DynamicObject row : billEntry) {
                RowDataModel rowDataModel = new RowDataModel(entrySymbol, (MainEntityType)billEntityType);
                rowDataModel.setRowContext(row);
                boolean result = conditionCompilerInfo.doExeContion(rowDataModel);
                if (result) continue;
                flag = false;
                break;
            }
            return flag;
        }
        RowDataModel rowDataModel = new RowDataModel(billSymbol, (MainEntityType)billEntityType);
        rowDataModel.setRowContext(bill);
        return conditionCompilerInfo.doExeContion(rowDataModel);
    }

    public static boolean doExeCondition(String entityNumber, DynamicObject bill, CRCondition condition, String billSymbol) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        String preCondition = condition.buildFullFormula(dataEntityType);
        if (preCondition == null) {
            return false;
        }
        BillEntityType billEntityType = (BillEntityType)EntityMetadataCache.getDataEntityType((String)entityNumber);
        ConditionCompilerInfo conditionCompilerInfo = new ConditionCompilerInfo(condition, entityNumber);
        Set entries = billEntityType.getAllEntities().entrySet();
        String entitySymbol = null;
        for (Map.Entry entry : entries) {
            EntityType value = (EntityType)entry.getValue();
            if (((String)entry.getKey()).contains("_lk") || !(value instanceof BillEntityType)) continue;
            entitySymbol = (String)entry.getKey();
        }
        if (billSymbol == null || "billhead".equals(billSymbol)) {
            RowDataModel rowDataModel = new RowDataModel(entitySymbol, (MainEntityType)billEntityType);
            rowDataModel.setRowContext(bill);
            return conditionCompilerInfo.doExeContion(rowDataModel);
        }
        DynamicObjectCollection billEntry = bill.getDynamicObjectCollection(billSymbol);
        boolean flag = true;
        for (DynamicObject row : billEntry) {
            RowDataModel rowDataModel = new RowDataModel(billSymbol, (MainEntityType)billEntityType);
            rowDataModel.setRowContext(row);
            boolean result = conditionCompilerInfo.doExeContion(rowDataModel);
            if (result) continue;
            flag = false;
            break;
        }
        return flag;
    }

    public static boolean doExeCondition(CRCondition condition, String entityNumber, DynamicObject[] bills) {
        return true;
    }

    private ConditionAnalysisHelper() {
    }
}

