/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.datamanage.business.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.ListDcxmlBinder;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.designer.botp.EntityParseHelper;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.instance.Instance;
import kd.bos.metadata.entity.validation.ConditionValidation;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.msbd.common.utils.AppCacheUtils;

public class DmfSchemeExecuteHelper {
    public static ConditionValidation getConditionValidation(String expressionEntity) {
        ArrayList<IDataEntityType> dTypes = new ArrayList<IDataEntityType>(16);
        dTypes.add(DataEntityType.getDataEntityType(ConditionValidation.class));
        ListDcxmlBinder binder = new ListDcxmlBinder(false, dTypes);
        Map parameter = (Map)SerializationUtils.fromJsonString((String)expressionEntity, Map.class);
        return (ConditionValidation)new DcJsonSerializer((DcBinder)binder).deserializeFromMap(parameter, null);
    }

    public static Map<String, String> getFieldName(String entityNumber, String ... fieldSympolList) {
        MainEntityType srcBillMainType = MetadataServiceHelper.getDataEntityType((String)entityNumber);
        HashMap<String, String> fieldName = new HashMap<String, String>(16);
        for (String fieldSympol : fieldSympolList) {
            fieldName.put(fieldSympol, EntityParseHelper.buildPropFullCaption((EntityType)srcBillMainType, (String)fieldSympol));
        }
        return fieldName;
    }

    public static boolean getRunningInspectPlan(Long inspectPlanId) {
        QFilter qFilter = new QFilter("inspectplan", "=", (Object)inspectPlanId);
        QFilter runningPlanQFilter = new QFilter("exestatus", "=", (Object)"A");
        runningPlanQFilter.or(new QFilter("entryentity.runingstatus", "in", Arrays.asList("A", "B")));
        boolean inspectLog = QueryServiceHelper.exists((String)"msbd_inspectlog", (QFilter[])qFilter.and(runningPlanQFilter).toArray());
        return inspectLog;
    }

    public static boolean getMulTermination(Long unitId) {
        boolean flag = false;
        String instanceId = Instance.getInstanceId();
        String mulCloseKey = instanceId.concat("_mulclose_").concat("msbd");
        String mulCloseValue = (String)AppCacheUtils.get((String)mulCloseKey, String.class);
        if (mulCloseValue == null) {
            return flag;
        }
        List mulCloseValueList = SerializationUtils.fromJsonStringToList((String)mulCloseValue, Long.class);
        return mulCloseValueList.contains(unitId);
    }

    public static void setMulTermination(Set<String> mulCloseValue) {
        String instanceId = Instance.getInstanceId();
        String mulCloseKey = instanceId.concat("_mulclose_").concat("msbd");
        AppCacheUtils.put((String)mulCloseKey, (Object)SerializationUtils.toJsonString(mulCloseValue));
    }

    public static Long getOrgId(String orgNumber) {
        QFilter qFilter = new QFilter("number", "=", (Object)orgNumber);
        List orgIdList = QueryServiceHelper.queryPrimaryKeys((String)"bos_org", (QFilter[])qFilter.toArray(), null, (int)1);
        Long orgId = 0L;
        if (orgIdList != null && orgIdList.size() > 0) {
            orgId = (Long)orgIdList.get(0);
        }
        return orgId;
    }

    public static List<ConditionValidation> getConditionValidation(String entityNumber, String opKey) {
        return new ArrayList<ConditionValidation>();
    }

    public static QFilter[] getQFilter(FilterCondition filterCondition, String entityNumber) {
        FilterBuilder fb = new FilterBuilder(EntityMetadataCache.getDataEntityType((String)entityNumber), filterCondition);
        fb.buildFilter();
        return fb.getQFilters().toArray(new QFilter[0]);
    }

    public static List<QFilter> getQFilterList(String filterJSON, String entityNumber) {
        FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterJSON, FilterCondition.class);
        FilterBuilder fb = new FilterBuilder(EntityMetadataCache.getDataEntityType((String)entityNumber), filterCondition);
        fb.buildFilter();
        return fb.getQFilters();
    }

    public static QFilter[] getQFilter(String filterJSON, String entityNumber) {
        FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterJSON, FilterCondition.class);
        return DmfSchemeExecuteHelper.getQFilter(filterCondition, entityNumber);
    }

    public static <T> List<List<T>> partition(List<T> originalList, int batchSize) {
        ArrayList<List<T>> result = new ArrayList<List<T>>(16);
        if (originalList == null) {
            return result;
        }
        int remainder = originalList.size() % batchSize;
        int number = originalList.size() / batchSize;
        for (int i = 0; i < number; ++i) {
            List<T> value = originalList.subList(i * batchSize, (i + 1) * batchSize);
            result.add(value);
        }
        if (remainder > 0) {
            result.add(originalList.subList(number * batchSize, originalList.size()));
        }
        return result;
    }

    public static String getRandomNum() {
        return String.valueOf(System.currentTimeMillis());
    }

    public static List<String> getEntityId(List<Object> inspectUnitIdList) {
        DynamicObjectCollection inspectUnitCollection = DmfSchemeExecuteHelper.getInspectUnit(inspectUnitIdList);
        List<String> inspectEntityIdList = inspectUnitCollection.stream().map(inspectUnit -> inspectUnit.getString("entity.id")).collect(Collectors.toList());
        return inspectEntityIdList;
    }

    public static Map<Long, String> getUnitIdEntityId(List<?> inspectUnitIdList) {
        HashMap<Long, String> unitIdEntityId = new HashMap<Long, String>(16);
        DynamicObjectCollection inspectUnitCollection = DmfSchemeExecuteHelper.getInspectUnit(inspectUnitIdList);
        inspectUnitCollection.stream().forEach(inspectUnit -> unitIdEntityId.put(inspectUnit.getLong("id"), inspectUnit.getString("entity.id")));
        return unitIdEntityId;
    }

    public static DynamicObjectCollection getInspectUnit(List<?> inspectUnitIdList) {
        DynamicObjectCollection inspectUnitCollection = QueryServiceHelper.query((String)"msbd_inspectunit", (String)"id,entity.id", (QFilter[])new QFilter("id", "in", inspectUnitIdList).toArray());
        return inspectUnitCollection;
    }

    public static String getSuccessTips(Long countBizNum) {
        Long bizNum = 0L;
        if (countBizNum != null) {
            bizNum = countBizNum;
        }
        return String.format(ResManager.loadKDString((String)"\u672c\u6b21\u5171\u5de1\u68c0\u4e86%s\u6761\u4e1a\u52a1\u6570\u636e\uff0c\u5de1\u68c0\u6210\u529f\uff0c\u65e0\u5f02\u5e38\u6570\u636e\u3002", (String)"DmfSchemeExecuteHelper_0", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), bizNum);
    }

    public static String getErrorTips(Long countBizNum) {
        Long bizNum = 0L;
        if (countBizNum != null) {
            bizNum = countBizNum;
        }
        return String.format(ResManager.loadKDString((String)"\u672c\u6b21\u5171\u5de1\u68c0\u4e86%s\u6761\u4e1a\u52a1\u6570\u636e\uff0c\u5de1\u68c0\u5b58\u5728\u5f02\u5e38\u6570\u636e\u3002\u8bf7\u7559\u610f\u5f02\u5e38\u6570\u636e\u5206\u5f55\u3002", (String)"DmfSchemeExecuteHelper_1", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), bizNum);
    }

    private DmfSchemeExecuteHelper() {
    }
}

