/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.datamanage.business.helper.im;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.formula.BOSExpression;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.mpscmm.msbd.datamanage.business.helper.im.LogisticsBillMatch;
import kd.mpscmm.msbd.datamanage.common.pojo.DmfExpMsgInfo;
import kd.mpscmm.msbd.datamanage.common.pojo.InvBillEntryModel;
import kd.mpscmm.msbd.datamanage.common.pojo.InvBillModel;

public class LogisticsBillModel {
    private Map<String, Collection<DynamicObject>> settleCfgMap = new HashMap<String, Collection<DynamicObject>>(16);

    private LogisticsBillModel() {
    }

    public static LogisticsBillModel getInstance() {
        return new LogisticsBillModel();
    }

    private void updateLogisticsMap(Collection<DynamicObject> cfgs, Map<Object, LogisticsBillMatch> logisticsMap, InvBillModel bill) {
        for (DynamicObject cfg : cfgs) {
            LogisticsBillMatch match = LogisticsBillMatch.getInstance(cfg, bill);
            if (!match.isLogistcsBill()) continue;
            Long pkValue = bill.getPkValue();
            LogisticsBillMatch oldMatch = logisticsMap.get(pkValue);
            if (oldMatch == null) {
                logisticsMap.put(pkValue, match);
                continue;
            }
            if (match.getPriority() >= oldMatch.getPriority()) continue;
            logisticsMap.put(pkValue, match);
        }
    }

    private Collection<DynamicObject> getSettleCfgs(String formId) {
        Collection<Object> cfgs = this.settleCfgMap.get(formId);
        if (cfgs != null) {
            return cfgs;
        }
        QFilter billf = new QFilter("bill", "=", (Object)formId);
        QFilter enablef = new QFilter("enable", "=", (Object)Boolean.TRUE);
        Map cfgMap = BusinessDataServiceHelper.loadFromCache((String)"ism_interorgsettlecfg", (String)"billfilterstr_tag,priority,balanceorg,ownerorg,bill", (QFilter[])billf.and(enablef).toArray());
        cfgs = cfgMap.values();
        if (!cfgMap.isEmpty()) {
            this.settleCfgMap.put(formId, cfgs);
        }
        return cfgs;
    }

    public Set<String> getKeySet(String formId) {
        Collection<DynamicObject> cfgs = this.getSettleCfgs(formId);
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)formId);
        HashSet<String> keySet = new HashSet<String>(16);
        keySet.add("billentry.seq");
        keySet.add("billentry.id");
        keySet.add("billno");
        keySet.add("billentry.logisticsbill");
        keySet.add("isvirtualbill");
        keySet.add("ischargeoff");
        for (DynamicObject cfg : cfgs) {
            FilterCondition condition;
            FilterBuilder fb;
            String[] script;
            BOSExpression expr;
            Set vars;
            String filterstr;
            String balanceorg = cfg.getString("balanceorg");
            String ownerorg = cfg.getString("ownerorg");
            if (StringUtils.isNotBlank((CharSequence)balanceorg)) {
                keySet.add(balanceorg);
            }
            if (StringUtils.isNotBlank((CharSequence)ownerorg)) {
                keySet.add(ownerorg);
            }
            if (StringUtils.isEmpty((CharSequence)(filterstr = cfg.getString("billfilterstr_tag"))) || (vars = (expr = new BOSExpression((script = (fb = new FilterBuilder(entityType, condition = (FilterCondition)SerializationUtils.fromJsonString((String)filterstr, FilterCondition.class))).buildFilterScript())[0])).getVars()).isEmpty()) continue;
            for (String var : vars) {
                keySet.add(var);
            }
        }
        return keySet;
    }

    public List<DmfExpMsgInfo> matchLogisticsBill(String formId, List<InvBillModel> billModels) {
        Collection<DynamicObject> cfgs = this.getSettleCfgs(formId);
        return this.match(cfgs, billModels, formId);
    }

    private List<DmfExpMsgInfo> match(Collection<DynamicObject> cfgs, List<InvBillModel> billModels, String formId) {
        ArrayList<DmfExpMsgInfo> dmfExpMsgInfos = new ArrayList<DmfExpMsgInfo>(16);
        HashMap<Object, LogisticsBillMatch> logisticsMap = new HashMap<Object, LogisticsBillMatch>(billModels.size());
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)formId);
        IDataEntityProperty findIsVirtualBill = dataEntityType.findProperty("isvirtualbill");
        IDataEntityProperty findIsChargeOff = dataEntityType.findProperty("ischargeoff");
        for (InvBillModel billModel : billModels) {
            boolean isVirt;
            boolean isCharge = findIsChargeOff != null && billModel.isChargeOff();
            boolean bl = isVirt = findIsVirtualBill != null && billModel.isVirtual();
            if (isCharge || isVirt) continue;
            this.updateLogisticsMap(cfgs, logisticsMap, billModel);
            LogisticsBillMatch match = (LogisticsBillMatch)logisticsMap.get(billModel.getPkValue());
            if (match != null) {
                dmfExpMsgInfos.addAll(match.execute());
                continue;
            }
            List<InvBillEntryModel> entrys = billModel.getBillEntrys();
            String msg = ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\u201c\u7269\u6d41\u6807\u8bc6\u201d\u9519\u8bef\u3002", (String)"LogisticsBillMatch_0", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]);
            for (InvBillEntryModel entry : entrys) {
                if (!entry.isIslogisticsBill()) continue;
                dmfExpMsgInfos.add(DmfExpMsgInfo.getInstance(this.getClass().getSimpleName(), String.format(msg, entry.getSeq()), billModel.getPkValue(), entry.getEntryId(), billModel.getBillNo()));
            }
        }
        return dmfExpMsgInfos;
    }
}

