/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.datamanage.business.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.mpscmm.msbd.datamanage.business.helper.DmfSchemeExecuteHelper;
import kd.mpscmm.msbd.datamanage.business.logicsexecutor.IIuUnitLogic;
import kd.mpscmm.msbd.datamanage.business.logicsexecutor.IuPluginExecutor;
import kd.mpscmm.msbd.datamanage.business.logicsexecutor.IuValidExecutor;
import kd.mpscmm.msbd.datamanage.business.service.IDmfUnitService;
import kd.mpscmm.msbd.datamanage.common.pojo.DmfUnitResultInfo;
import kd.mpscmm.msbd.datamanage.common.util.InspectUnitContext;

public class DmfUnitService
implements IDmfUnitService {
    private static final Log logger = LogFactory.getLog(DmfUnitService.class);
    private List<IIuUnitLogic> LogicsExecutor = new ArrayList<IIuUnitLogic>();

    protected DmfUnitService(InspectUnitContext inspectUnitContext) {
        this.LogicsExecutor.addAll(IIuUnitLogic.create(inspectUnitContext));
    }

    protected DmfUnitService() {
    }

    @Override
    public DmfUnitResultInfo executeDmfUnit(DynamicObject inspectUnit) {
        Long inspectUnitId = (Long)inspectUnit.getPkValue();
        String number = inspectUnit.getString("number");
        try {
            String areaJSON = inspectUnit.getString("areajson_tag");
            String entity = (String)inspectUnit.getDynamicObject("entity").getPkValue();
            List<QFilter> inspectUnitQFilter = DmfSchemeExecuteHelper.getQFilterList(areaJSON, entity);
            List<Object> inspectUnitExpList = new ArrayList<OperateErrorInfo>(16);
            for (IIuUnitLogic logicsExecutor : this.LogicsExecutor) {
                int size;
                boolean mulTermination = DmfSchemeExecuteHelper.getMulTermination(inspectUnitId);
                if (mulTermination) {
                    return DmfUnitResultInfo.acceptExceptionStackTrace(ResManager.loadKDString((String)"\u8be5\u5de1\u68c0\u6a21\u578b\u5df2\u7ecf\u88ab\u7ec8\u6b62\uff0c\u7ec8\u6b62\u671f\u95f4\u5185\uff0c\u4e0d\u5141\u8bb8\u518d\u6b21\u88ab\u6267\u884c\u3002", (String)"DmfUnitService_0", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), inspectUnitId, number);
                }
                if (logicsExecutor instanceof IuValidExecutor ? (size = inspectUnit.getDynamicObjectCollection("validentity").size()) <= 0 : (logicsExecutor instanceof IuPluginExecutor ? (size = inspectUnit.getDynamicObjectCollection("pluginentry").size()) <= 0 : (size = inspectUnit.getDynamicObjectCollection("msentry").size()) <= 0)) continue;
                List<OperateErrorInfo> operateErrorInfoList = logicsExecutor.executeUnitLogic(inspectUnit, inspectUnitQFilter);
                inspectUnitExpList.addAll(operateErrorInfoList);
            }
            if (inspectUnitExpList.size() > 20100) {
                inspectUnitExpList = inspectUnitExpList.subList(0, 20100);
            }
            inspectUnitQFilter = null;
            return DmfUnitResultInfo.acceptAuditResult(inspectUnitExpList, inspectUnitId, number);
        }
        catch (Throwable e) {
            String mainMsg = e.toString();
            String stackTrace = Arrays.toString(e.getStackTrace());
            logger.error(ResManager.loadKDString((String)"\u7f16\u7801\uff1a{}\u7684\u4e1a\u52a1\u5904\u7406\u5355\u5143\u6267\u884c\u65f6\u51fa\u73b0\u4e86\u5f02\u5e38\u4fe1\u606f\u5982\u4e0b\uff1a{}", (String)"DmfUnitService_2", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), (Object)number, (Object)stackTrace);
            return DmfUnitResultInfo.acceptExceptionStackTrace(mainMsg.concat(stackTrace), inspectUnitId, number);
        }
    }
}

