/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.datamanage.common.pojo;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperateInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mpscmm.msbd.datamanage.business.helper.DmfSchemeExecuteHelper;
import kd.mpscmm.msbd.datamanage.common.util.ReflectUtils;

public class InspectLogToolsInfo {
    protected static final Log logger = LogFactory.getLog(InspectLogToolsInfo.class);
    private DynamicObject result = BusinessDataServiceHelper.newDynamicObject((String)"msbd_inspectlog");

    public InspectLogToolsInfo(Long planId, Long jobId, List<Object> inspectUnitIdList, Object bizAppId, Long orgId) {
        long[] pkId = DBServiceHelper.genLongIds((String)"t_msbd_inspectlog", (int)1);
        this.result.set("id", (Object)pkId[0]);
        this.result.set("inspectplan", (Object)planId);
        this.result.set("inspectjob", (Object)jobId);
        this.result.set("exeuser", (Object)RequestContext.get().getCurrUserId());
        this.result.set("exetime", (Object)new Date(System.currentTimeMillis()));
        this.result.set("exestatus", (Object)"A");
        this.result.set("bizappid", bizAppId);
        this.result.set("org", (Object)orgId);
        DynamicObjectCollection rows = this.result.getDynamicObjectCollection("entryentity");
        int index = 1;
        for (Object inspectUnitId : inspectUnitIdList) {
            DynamicObject row = rows.addNew();
            row.set("seq", (Object)index);
            row.set("inspectunit", inspectUnitId);
            row.set("runingstatus", (Object)"A");
            ++index;
        }
        this.saveInspectLog();
    }

    public DynamicObject getResult() {
        return this.result;
    }

    public void beginRun(Long inspectUnitId) {
        this.result.getDynamicObjectCollection("entryentity").forEach(row -> {
            if (inspectUnitId.equals(row.getLong("inspectunit"))) {
                row.set("runingstatus", (Object)"B");
            }
        });
        this.saveInspectLog();
    }

    public void collectExtExcpMsg(Long inspectUnitId, String excpstacktrace, boolean isLastItem) {
        for (DynamicObject resultEntry : this.result.getDynamicObjectCollection("entryentity")) {
            if (!inspectUnitId.equals(resultEntry.getLong("inspectunit"))) continue;
            resultEntry.set("entrystatus", (Object)"B");
            resultEntry.set("runingstatus", (Object)"C");
            resultEntry.set("description", (Object)ResManager.loadKDString((String)"\u5de1\u68c0\u6a21\u578b\u5b58\u5728\u5f02\u5e38\u4e2d\u65ad\u4fe1\u606f\uff0c\u8bf7\u6ce8\u610f\u67e5\u770b\u8be6\u60c5\u4fe1\u606f\u3002", (String)"InspectLogToolsInfo_0", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
            resultEntry.set("excpstacktrace_tag", (Object)excpstacktrace);
        }
        if (isLastItem) {
            this.result.set("exestatus", (Object)"B");
            this.result.set("endtime", (Object)new Date());
        }
        this.saveInspectLog();
    }

    public void endRun(Long inspectUnitId, Long inspectUnitCountNum, List<OperateErrorInfo> errorDataList, boolean isLastItem) {
        String inspectUnitResultStatus = errorDataList.isEmpty() ? "D" : "C";
        this.updateJobLog(inspectUnitId, inspectUnitResultStatus, "C", inspectUnitCountNum, errorDataList, isLastItem);
    }

    private void updateJobLog(Long inspectUnitId, String inspectUnitResultStatus, String inspectUnitRunStatus, Long inspectUnitCountNum, List<OperateErrorInfo> errorDataList, boolean isLastItem) {
        for (DynamicObject resultEntry : this.result.getDynamicObjectCollection("entryentity")) {
            if (!inspectUnitId.equals(resultEntry.getLong("inspectunit"))) continue;
            resultEntry.set("entrystatus", (Object)inspectUnitResultStatus);
            resultEntry.set("runingstatus", (Object)inspectUnitRunStatus);
            if ("D".equals(inspectUnitResultStatus)) {
                resultEntry.set("description", (Object)DmfSchemeExecuteHelper.getSuccessTips(inspectUnitCountNum));
            } else {
                resultEntry.set("description", (Object)DmfSchemeExecuteHelper.getErrorTips(inspectUnitCountNum));
            }
            HashMap<String, Long> inspectDetail = new HashMap<String, Long>(16);
            inspectDetail.put("inspect_unit_totalnum", inspectUnitCountNum);
            Object entryId = resultEntry.getPkValue();
            if (errorDataList == null || errorDataList.isEmpty()) {
                inspectDetail.put("inspect_unit_expnum", 0L);
                resultEntry.set("inspectdetail", (Object)SerializationUtils.toJsonString(inspectDetail));
                continue;
            }
            long count = errorDataList.stream().map(OperateInfo::getTitle).distinct().count();
            inspectDetail.put("inspect_unit_expnum", count);
            resultEntry.set("inspectdetail", (Object)SerializationUtils.toJsonString(inspectDetail));
            this.asynSaveSubEntry(errorDataList, entryId);
        }
        if (isLastItem) {
            this.result.set("exestatus", (Object)"B");
            this.result.set("endtime", (Object)new Date());
        }
        this.saveInspectLog();
    }

    /*
     * WARNING - void declaration
     */
    public void asynSaveSubEntry(List<OperateErrorInfo> errorDataList, Object entryId) {
        errorDataList.stream().sorted(Comparator.comparing(OperateInfo::getTitle));
        int indexSeq = 1;
        int subEntrySize = errorDataList.size();
        ArrayList<Object[]> subEntryValues = new ArrayList<Object[]>(subEntrySize);
        long[] detailPkIdList = DBServiceHelper.genLongIds((String)"t_msbd_inspectlogentry_e", (int)subEntrySize);
        for (int i = 0; i < subEntrySize; ++i) {
            void var11_12;
            OperateErrorInfo result = errorDataList.get(i);
            Object[] subEntry = new Object[8];
            subEntry[0] = indexSeq;
            subEntry[1] = detailPkIdList[i];
            subEntry[2] = entryId;
            subEntry[3] = result.getPkValue();
            Object[] reflectFieldsValue = ReflectUtils.reflectFieldsValue(result, "entryId");
            subEntry[4] = reflectFieldsValue[0] instanceof Long ? reflectFieldsValue[0] : Long.valueOf(0L);
            subEntry[5] = result.getEntityKey();
            String string = "";
            if (result.getMessage().length() > 512) {
                String string2 = result.getMessage().substring(0, 480);
            } else {
                String string3 = result.getMessage();
            }
            subEntry[6] = var11_12;
            String title = result.getTitle();
            if (title == null) {
                title = "";
            }
            subEntry[7] = title;
            subEntryValues.add(subEntry);
            ++indexSeq;
        }
        DBRoute currentDBRoute = this.getCurrentDBRoute();
        String insertSubEntrySql = this.invokeInsertSubEntrySql();
        if (subEntrySize > 5000) {
            List partitionList = DmfSchemeExecuteHelper.partition(subEntryValues, 5000);
            for (List<Object[]> list : partitionList) {
                this.saveSubEntry(currentDBRoute, insertSubEntrySql, list);
            }
        } else {
            this.saveSubEntry(currentDBRoute, insertSubEntrySql, subEntryValues);
        }
    }

    private void saveSubEntry(DBRoute currentDBRoute, String insertSubEntrySql, List<Object[]> partition) {
        try (TXHandle tx = TX.requiresNew((String)InspectLogToolsInfo.class.getName());){
            try {
                DB.executeBatch((DBRoute)currentDBRoute, (String)insertSubEntrySql, partition);
            }
            catch (Exception e) {
                tx.markRollback();
                logger.error("\u6301\u4e45\u5316\u65e5\u5fd7\u51fa\u73b0\u4e86\u5f02\u5e38:{}", (Object)Arrays.toString(e.getStackTrace()));
            }
        }
    }

    private String invokeInsertSubEntrySql() {
        StringBuilder str = new StringBuilder("insert into t_msbd_inspectlogentry_e ");
        str.append("(fseq,fdetailid,fentryid,fobjid,fobjentryid,fobjtypeid,fobjdes,fbizuniquesympol)");
        str.append("values(?,?,?,?,?,?,?,?)");
        String exeSql = str.toString();
        str.setLength(0);
        return exeSql;
    }

    private DBRoute getCurrentDBRoute() {
        return DBRoute.of((String)"scm");
    }

    private void saveInspectLog() {
        try (TXHandle tx = TX.requiresNew((String)InspectLogToolsInfo.class.getName());){
            try {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.result});
            }
            catch (Exception e) {
                tx.markRollback();
                logger.error("\u6301\u4e45\u5316\u65e5\u5fd7\u51fa\u73b0\u4e86\u5f02\u5e38:{}", (Object)Arrays.toString(e.getStackTrace()));
            }
        }
    }
}

