/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.datamanage.formplugin;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dataentity.utils.Uuid16;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.RouteMode;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.mpscmm.msbd.datamanage.business.AbstractDmfPlugin;

public class DmfInspectLogPlugin
extends AbstractFormPlugin
implements RowClickEventListener,
HyperLinkClickListener {
    private static final Log logger = LogFactory.getLog(DmfInspectLogPlugin.class);

    public void registerListener(EventObject e) {
        EntryGrid billList;
        super.registerListener(e);
        EntryGrid entryEntity = (EntryGrid)this.getView().getControl("entryentity");
        if (entryEntity != null) {
            entryEntity.addRowClickListener((RowClickEventListener)this);
        }
        if ((billList = (EntryGrid)this.getControl("subentryentity")) != null) {
            billList.addHyperClickListener((HyperLinkClickListener)this);
        }
    }

    public void afterBindData(EventObject e) {
        int index = this.getModel().getEntryCurrentRowIndex("entryentity");
        DynamicObject inspectUnit = (DynamicObject)this.getModel().getValue("inspectunit", index);
        this.setOperateItemsColumn(inspectUnit);
    }

    public void entryRowClick(RowClickEvent evt) {
        EntryGrid entry = (EntryGrid)evt.getSource();
        String entryKey = entry.getEntryKey();
        if ("entryentity".equals(entryKey)) {
            AbstractGrid grid = (AbstractGrid)this.getView().getControl("entryentity");
            int rowKey = grid.getEntryState().getFocusRow();
            if (rowKey <= -1) {
                return;
            }
            DynamicObject inspectUnit = (DynamicObject)this.getModel().getValue("inspectunit", rowKey);
            this.setOperateItemsColumn(inspectUnit);
        }
    }

    private void setOperateItemsColumn(DynamicObject inspectUnit) {
        if (inspectUnit != null) {
            boolean bizLink = inspectUnit.getBoolean("bizlink");
            if (!bizLink) {
                EntryGrid subGrid = (EntryGrid)this.getControl("subentryentity");
                subGrid.setColumnProperty("looklink", "visible", (Object)Boolean.FALSE);
            } else {
                EntryGrid subGrid = (EntryGrid)this.getControl("subentryentity");
                subGrid.setColumnProperty("looklink", "visible", (Object)Boolean.TRUE);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key = ((FormOperate)args.getSource()).getOperateKey();
        IDataModel model = this.getModel();
        if ("showdetail".equals(key) || "fixdata".equals(key) || "fixlog".equals(key) || "looklink".equals(key)) {
            AbstractGrid grid = (AbstractGrid)this.getView().getControl("entryentity");
            int index = grid.getEntryState().getFocusRow();
            if (index <= -1) {
                index = this.getModel().getEntryCurrentRowIndex("entryentity");
            }
            DynamicObject result = model.getDataEntity(true);
            DynamicObject resultEntry = (DynamicObject)result.getDynamicObjectCollection("entryentity").get(index);
            String entryStatus = resultEntry.getString("entrystatus");
            DynamicObject inspectUnitTemp = resultEntry.getDynamicObject("inspectunit");
            if ("looklink".equals(key)) {
                DynamicObjectCollection pluginEntry = inspectUnitTemp.getDynamicObjectCollection("pluginentry");
                AbstractGrid subGrid = (AbstractGrid)this.getView().getControl("subentryentity");
                int subIndex = subGrid.getEntryState().getFocusRow();
                DynamicObjectCollection subEntryEntity = resultEntry.getDynamicObjectCollection("subentryentity");
                DynamicObject subRow = (DynamicObject)subEntryEntity.get(subIndex);
                Object objId = subRow.get("objid");
                Object bizUniqueSympol = subRow.get("bizuniquesympol");
                int pluginSize = pluginEntry.size();
                if (pluginSize <= 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6ce8\u518c\u4e1a\u52a1\u63a7\u5236\u63d2\u4ef6\u3002", (String)"DmfInspectLogPlugin_7", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                for (DynamicObject plugin : pluginEntry) {
                    Object pluginClassObj;
                    String pluginClassUrl;
                    boolean pluginEnable = plugin.getBoolean("pluginenable");
                    if (!pluginEnable || StringUtils.isBlank((CharSequence)(pluginClassUrl = plugin.getString("pluginclassurl"))) || !((pluginClassObj = TypesContainer.createInstance((String)pluginClassUrl)) instanceof AbstractDmfPlugin)) continue;
                    AbstractDmfPlugin pluginService = (AbstractDmfPlugin)pluginClassObj;
                    String simpleClassName = pluginService.getClass().getName();
                    if (!simpleClassName.contains("kd.mpscmm.msbd.datamanage.inspect")) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u6269\u5c55\u63d2\u4ef6\u7684\u8def\u5f84\uff0c\u4e0d\u652f\u6301\u5f02\u5e38\u7ed3\u679c\u7684\u67e5\u770b\u64cd\u4f5c\u3002", (String)"DmfInspectLogPlugin_8", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
                        args.setCancel(true);
                        return;
                    }
                    HashMap<String, Object> extParameter = new HashMap<String, Object>(16);
                    extParameter.put("bizid", objId);
                    extParameter.put("biznumber", bizUniqueSympol);
                    extParameter.put("pageId", this.getView().getPageId());
                    extParameter.put("entryId", subRow.getPkValue());
                    extParameter.put("id", result.getPkValue());
                    try {
                        boolean flag = pluginService.extExpDataBizLink(extParameter);
                        if (flag) continue;
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u63d2\u4ef6\u5b9e\u73b0\u65e0\u6548\uff0c\u8bf7\u8c03\u6574\u63d2\u4ef6\u540e\u91cd\u8bd5\u3002", (String)"DmfInspectLogPlugin_10", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
                        args.setCancel(true);
                        return;
                    }
                    catch (Exception exp) {
                        logger.error("looklink exist exception", (Throwable)exp);
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ce8\u518c\u4e1a\u52a1\u63a7\u5236\u63d2\u4ef6\u6709\u8bef\uff0c\u8bf7\u91cd\u65b0\u8c03\u6574\u3002", (String)"DmfInspectLogPlugin_9", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
                        args.setCancel(true);
                        return;
                    }
                }
            }
            if ("showdetail".equals(key)) {
                if ("D".equals(entryStatus) || "C".equals(entryStatus)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5de1\u68c0\u6a21\u578b\u672a\u5931\u8d25\u3002", (String)"DmfInspectLogPlugin_0", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                if ("B".equals(entryStatus)) {
                    DynamicObject inspectUnit = BusinessDataServiceHelper.loadSingle((Object)inspectUnitTemp.getPkValue(), (String)"msbd_inspectunit");
                    String inspectUnitName = inspectUnit.getLocaleString("name").getLocaleValue();
                    Object stacktraceTag = resultEntry.get("excpstacktrace_tag");
                    FormShowParameter microService = this.getExcpTips(inspectUnitName, stacktraceTag);
                    this.getView().showForm(microService);
                    args.setCancel(true);
                    return;
                }
            }
            if ("fixdata".equals(key)) {
                if ("C".equals(entryStatus)) {
                    DynamicObjectCollection subEntryEntity = resultEntry.getDynamicObjectCollection("subentryentity");
                    String fixeddatadetail = resultEntry.getString("fixeddatadetail_tag");
                    if (fixeddatadetail != null && !"".equals(fixeddatadetail)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u7ecf\u8fdb\u884c\u8fc7\u4fee\u590d\uff0c\u8bf7\u518d\u6b21\u5de1\u68c0\u4e4b\u540e\uff0c\u8fdb\u884c\u4fee\u590d\u64cd\u4f5c\u3002", (String)"DmfInspectLogPlugin_1", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
                        args.setCancel(true);
                        return;
                    }
                    int size = subEntryEntity.size();
                    if (size <= 0) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5de1\u68c0\u7ed3\u679c\uff0c\u4e0d\u5b58\u5728\u5f02\u5e38\u4fe1\u606f\uff0c\u4e0d\u652f\u6301\u6570\u636e\u4fee\u590d\u64cd\u4f5c\u3002", (String)"DmfInspectLogPlugin_3", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
                    }
                    Set<Object> expBillIdSet = subEntryEntity.stream().map(row -> row.get("objid")).collect(Collectors.toSet());
                    Set<Object> expEntryIdSet = subEntryEntity.stream().map(row -> row.get("objentryid")).collect(Collectors.toSet());
                    JobInfo jobInfo = this.createJobInfo(expBillIdSet, expEntryIdSet, resultEntry.getPkValue(), inspectUnitTemp.getPkValue());
                    String dispatchResult = ScheduleServiceHelper.dispatch((JobInfo)jobInfo);
                    return;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5de1\u68c0\u7ed3\u679c\uff0c\u4e0d\u652f\u6301\u4fee\u590d\u6570\u636e\u64cd\u4f5c\u3002", (String)"DmfInspectLogPlugin_2", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if ("fixlog".equals(key)) {
                QFilter qFilter = new QFilter("entryentity.id", "=", resultEntry.getPkValue());
                DataSet inspectLog = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"msbd_inspectlog", (String)"entryentity.fixeddatadetail_tag fixtag", (QFilter[])qFilter.toArray(), null);
                String logId = ((Row)inspectLog.iterator().next()).getString("fixtag");
                if ("".equals(logId)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u8fdb\u884c\u6570\u636e\u4fee\u590d\u6216\u6570\u636e\u4fee\u590d\u672a\u5b8c\u6210\uff0c\u8bf7\u60a8\u6838\u5b9e\u3002", (String)"DmfInspectLogPlugin_5", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                boolean flag = kd.bos.util.StringUtils.isNumeric((String)logId);
                if (!flag) {
                    DynamicObject inspectUnit = resultEntry.getDynamicObject("inspectunit");
                    ILocaleString inspectUnitName = inspectUnit.getLocaleString("name");
                    FormShowParameter microService = this.getExcpTips(inspectUnitName.getLocaleValue(), logId);
                    this.getView().showForm(microService);
                    args.setCancel(true);
                    return;
                }
                BillShowParameter fsp = new BillShowParameter();
                fsp.setFormId("msbd_fixdatalog");
                fsp.setStatus(OperationStatus.EDIT);
                fsp.setPkId((Object)logId);
                fsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm((FormShowParameter)fsp);
                this.getView().invokeOperation("refresh");
                args.setCancel(true);
                return;
            }
        }
    }

    private JobInfo createJobInfo(Set<Object> expBillIdSet, Set<Object> expEntryIdSet, Object logEntryId, Object inspectUnitId) {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setAppId("msbd");
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setJobPrincipal(RequestContext.get().getCurrUserId());
        jobInfo.setNumber("fix_number");
        jobInfo.setName("fix_name");
        jobInfo.setId(Uuid16.create().toString());
        jobInfo.setRunByUserId(RequestContext.get().getCurrUserId());
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("expBillIdSet", expBillIdSet);
        params.put("expEntryIdSet", expEntryIdSet);
        params.put("logEntryId", logEntryId);
        params.put("inspectUnitId", inspectUnitId);
        jobInfo.setParams(params);
        jobInfo.setRouteMode(RouteMode.RAMDOM);
        jobInfo.setTaskClassname("kd.mpscmm.msbd.algox.mservice.InspectFixTaskServiceImpl");
        jobInfo.setRunByLang(Lang.get());
        return jobInfo;
    }

    private FormShowParameter getExcpTips(String inspectUnitName, Object stacktraceTag) {
        FormShowParameter microservice = new FormShowParameter();
        microservice.getOpenStyle().setShowType(ShowType.Modal);
        microservice.setFormId("msbd_unitexcpmsg");
        HashMap<String, Object> logParameter = new HashMap<String, Object>();
        logParameter.put("inspectunit", inspectUnitName);
        logParameter.put("excpstacktrace", stacktraceTag);
        microservice.setCustomParam("logparamter", logParameter);
        return microservice;
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        AbstractGrid grid = (AbstractGrid)this.getView().getControl("entryentity");
        int index = grid.getEntryState().getFocusRow();
        if (index <= -1) {
            index = this.getModel().getEntryCurrentRowIndex("entryentity");
        }
        DynamicObject result = this.getModel().getDataEntity(true);
        DynamicObject resultEntry = (DynamicObject)result.getDynamicObjectCollection("entryentity").get(index);
        DynamicObject inspectUnit = resultEntry.getDynamicObject("inspectunit");
        DynamicObject entity = inspectUnit.getDynamicObject("entity");
        String number = entity.getString("number");
        AbstractGrid subGrid = (AbstractGrid)this.getView().getControl("subentryentity");
        int subIndex = subGrid.getEntryState().getFocusRow();
        DynamicObjectCollection subEntryEntity = resultEntry.getDynamicObjectCollection("subentryentity");
        DynamicObject subRow = (DynamicObject)subEntryEntity.get(subIndex);
        Object objId = subRow.get("objid");
        BillShowParameter fsp = new BillShowParameter();
        fsp.setFormId(number);
        fsp.setStatus(OperationStatus.VIEW);
        fsp.setPkId(objId);
        fsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)fsp);
    }
}

