/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.datamanage.formplugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.ReflectionUtils;
import kd.mpscmm.msbd.common.pojo.MethodParameter;

public class DmfInspectMsPlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(DmfInspectMsPlugin.class);

    public void initialize() {
        Button btn = (Button)this.getView().getControl("btnok");
        btn.addClickListener((ClickListener)this);
    }

    public void click(EventObject evt) {
        Button btn = (Button)evt.getSource();
        String key = btn.getKey();
        if (!"btnok".equalsIgnoreCase(key)) {
            return;
        }
        this.getView().returnDataToParent(this.getMsObj());
        this.getView().close();
    }

    public void afterCreateNewData(EventObject e) {
        Object ms = this.getView().getFormShowParameter().getCustomParam("ms");
        IDataModel model = this.getModel();
        if (!(ms instanceof Map)) {
            return;
        }
        Map msObj = (Map)ms;
        model.setValue("bizapp", msObj.get("bizapp"));
        String msName = (String)msObj.get("msname");
        model.setValue("msname", (Object)msName);
        model.setValue("methodName", msObj.get("msmethodname"));
        String msParameterArray = (String)msObj.get("msparameterarray");
        JSONArray parseArray = JSONObject.parseArray((String)msParameterArray);
        if (parseArray == null) {
            return;
        }
        for (int i = 0; i < parseArray.size(); ++i) {
            int rowId = model.createNewEntryRow("params");
            Map parameter = (Map)parseArray.get(i);
            model.setValue("parametername", parameter.get("name"), rowId);
            model.setValue("parametertype", parameter.get("type"), rowId);
            model.setValue("parameterval", parameter.get("val"), rowId);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Object ms = this.getView().getFormShowParameter().getCustomParam("ms");
        if (ms instanceof Map) {
            Map msObj = (Map)ms;
            String msName = (String)msObj.get("msname");
            this.initMsName(this.queryMs());
            this.initMsMethodName(msName);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        Object newValue = changeSet[0].getNewValue();
        IDataModel model = this.getModel();
        if (newValue == null || "".equals(newValue)) {
            return;
        }
        switch (fieldKey) {
            case "bizapp": {
                model.setValue("methodname", (Object)"");
                model.setValue("msname", (Object)"");
                model.deleteEntryData("params");
                this.initMsName(this.queryMs());
                break;
            }
            case "msname": {
                String implClassName = (String)newValue;
                this.initMsMethodName(implClassName);
                model.deleteEntryData("params");
                model.setValue("methodname", null);
                break;
            }
            case "methodname": {
                String implClazzName = (String)model.getValue("msname");
                Class implClazz = TypesContainer.getOrRegister((String)implClazzName);
                for (Method method : implClazz.getDeclaredMethods()) {
                    if (!newValue.equals(method.getName())) continue;
                    model.deleteEntryData("params");
                    Parameter[] parameters = method.getParameters();
                    for (int i = 0; i < parameters.length; ++i) {
                        int rowId = model.createNewEntryRow("params");
                        Parameter parameter = parameters[i];
                        String name = parameter.getName();
                        model.setValue("parametername", (Object)name, rowId);
                        String typeName = parameter.getType().getName();
                        String subStr = typeName.substring(typeName.lastIndexOf(46) + 1);
                        model.setValue("parametertype", (Object)subStr.toLowerCase(), rowId);
                    }
                }
                break;
            }
        }
    }

    private void initMsMethodName(String implClassName) {
        Class implClass = TypesContainer.getOrRegister((String)implClassName);
        ComboEdit methodNameComboEdit = (ComboEdit)this.getControl("methodname");
        ArrayList<ComboItem> methodNameList = new ArrayList<ComboItem>(16);
        for (Method method : implClass.getDeclaredMethods()) {
            if (!Modifier.isPublic(method.getModifiers())) continue;
            methodNameList.add(new ComboItem(new LocaleString(method.getName()), method.getName()));
        }
        methodNameComboEdit.setComboItems(methodNameList);
    }

    private void initMsName(Map<String, String> serviceMap) {
        ComboEdit comboEdit = (ComboEdit)this.getControl("msname");
        ArrayList data = new ArrayList(16);
        serviceMap.forEach((key, value) -> data.add(new ComboItem(new LocaleString(key), value)));
        comboEdit.setComboItems(data);
    }

    private Map<String, String> queryMs() {
        IDataModel model = this.getModel();
        Map<String, String> msMap = new HashMap<String, String>(16);
        DynamicObject bizapp = (DynamicObject)model.getValue("bizapp");
        if (bizapp == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u5e94\u7528\u3002", (String)"DmfInspectMsPlugin_0", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
            return msMap;
        }
        String appId = bizapp.getString("number");
        String cloudId = bizapp.getDynamicObject("bizcloud").getString("number");
        String serviceFactory = String.format("kd.%s.%s.servicehelper.ServiceFactory", cloudId.toLowerCase(), appId.toLowerCase());
        try {
            Class factory = TypesContainer.getOrRegister((String)serviceFactory);
            Field field = factory.getDeclaredField("serviceMap");
            if (field == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u5fae\u670d\u52a1", (String)"DmfInspectMsPlugin_1", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
                return msMap;
            }
            ReflectionUtils.makeAccessible((Field)field);
            msMap = (Map)field.get(factory.newInstance());
            return msMap;
        }
        catch (Exception e) {
            logger.error("get servicefactory microservice is exist:{}", (Object)e.getMessage());
            String tips = String.format(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5e94\u7528\u7f16\u7801\u4e3a%s\u7684\u670d\u52a1\u5de5\u5382\u7c7b\u3002", (String)"DmfInspectMsPlugin_2", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), appId);
            this.getView().showTipNotification(tips);
            return msMap;
        }
    }

    private Map<String, Object> getMsObj() {
        HashMap<String, Object> msObj = new HashMap<String, Object>();
        IDataModel model = this.getModel();
        DynamicObject bizApp = (DynamicObject)model.getValue("bizapp");
        String bizCloud = bizApp.getDynamicObject("bizcloud").getString("number").toLowerCase();
        String methodName = (String)model.getValue("methodname");
        String serviceNameImpl = (String)model.getValue("msname");
        Map<String, String> queryMs = this.queryMs();
        String serviceName = queryMs.entrySet().stream().filter(map -> ((String)map.getValue()).equals(serviceNameImpl)).map(map -> (String)map.getKey()).collect(Collectors.joining());
        DynamicObjectCollection paramEntry = this.getModel().getEntryEntity("params");
        ArrayList entryList = new ArrayList(16);
        paramEntry.forEach(row -> entryList.add(new MethodParameter(row.getString("parametername"), row.getString("parametertype"), row.getString("parameterval"), "")));
        msObj.put("bizappid", bizApp.getPkValue());
        msObj.put("msname", serviceName);
        msObj.put("bizcloud", bizCloud);
        msObj.put("msimplclass", serviceNameImpl);
        msObj.put("msmethodname", methodName);
        msObj.put("msparameterarray", SerializationUtils.toJsonString(entryList));
        return msObj;
    }
}

