/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.datamanage.formplugin;

import com.cronutils.model.Cron;
import com.cronutils.model.CronType;
import com.cronutils.model.definition.CronDefinitionBuilder;
import com.cronutils.parser.CronParser;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.form.FormConfig;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.formplugin.CronStruct;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import org.quartz.TriggerUtils;
import org.quartz.impl.triggers.CronTriggerImpl;
import org.quartz.spi.OperableTrigger;

public class DmfInspectPlanPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static CronParser parser = new CronParser(CronDefinitionBuilder.instanceDefinitionFor((CronType)CronType.QUARTZ));
    private static final String[] CKMONTH = new String[]{"ckjan", "ckfeb", "ckmar", "ckapr", "ckmay", "ckjun", "ckjul", "ckaug", "cksep", "ckoct", "cknov", "ckdec"};

    public void registerListener(EventObject e) {
        BasedataEdit f7Entity;
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"tbmain"});
        Tab tab = (Tab)this.getControl("tabap1");
        tab.addTabSelectListener(tabselectevent -> {
            String key = tabselectevent.getTabKey();
            if ("tabdatepage".equals(key)) {
                this.getModel().setValue("combdorw", (Object)"d");
            } else if ("tabweekpage".equals(key)) {
                this.getModel().setValue("combdorw", (Object)"w");
            }
        });
        IFormView view = this.getView();
        BasedataEdit f7InspectJob = (BasedataEdit)view.getControl("inspectjob");
        if (f7InspectJob != null) {
            f7InspectJob.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((f7Entity = (BasedataEdit)view.getControl("entity")) != null) {
            f7Entity.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterCopyData(EventObject e) {
        String repeatMode = (String)this.getModel().getValue("repeatmode");
        if ("n".equals(repeatMode)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"cyclenum"});
        }
        if (!"def".equals(repeatMode)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"plan"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"cyclenum"});
        }
        this.genDesc();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String repeatMode = (String)this.getModel().getValue("repeatmode");
        if ("n".equals(repeatMode)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"cyclenum"});
            this.genDesc();
        }
        if (!"def".equals(repeatMode)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"plan"});
        }
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("areafilter");
        filterGrid.setFilterColumns(Collections.emptyList());
        this.getView().updateView("areafilter");
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if ("looklog".equals(key)) {
            ListShowParameter param = new ListShowParameter();
            param.setFormId("bos_list");
            param.setBillFormId("msbd_inspectlog");
            param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            param.setCustomParam("planids", (Object)new Object[]{this.getModel().getValue("id")});
            param.setCustomParam("appid", (Object)"msbd");
            this.getView().showForm((FormShowParameter)param);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        if ("entity".equals(key)) {
            String srcBillId = MetadataDao.getIdByNumber((String)"msbd_inspectqfilter", (MetaCategory)MetaCategory.Entity);
            QFilter qFilter1 = new QFilter("inheritpath", "ftlike", (Object)srcBillId);
            QFilter qFilter2 = new QFilter("istemplate", "=", (Object)Boolean.FALSE);
            DynamicObjectCollection numberList = QueryServiceHelper.query((String)"bos_formmeta", (String)"number", (QFilter[])new QFilter[]{qFilter1, qFilter2});
            ListFilterParameter listFilterParameter = ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter();
            if (numberList != null && numberList.size() > 0) {
                Set numberIds = numberList.stream().map(row -> row.getString("number")).collect(Collectors.toSet());
                numberIds.add("msbd_inspectqfilter");
                listFilterParameter.getQFilters().add(new QFilter("id", "in", numberIds));
            } else {
                listFilterParameter.getQFilters().add(new QFilter("id", "=", (Object)"msbd_inspectqfilter"));
            }
        } else if ("inspectjob".equals(key)) {
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            FormConfig formConfig = formShowParameter.getFormConfig();
            e.getFormShowParameter().getCustomParams().put("appid", formConfig.getAppId());
        }
    }

    public void beforeBindData(EventObject e) {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("areafilter");
        Set<String> entityNumberColl = this.getEntityNumber();
        if (entityNumberColl.size() == 1) {
            MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)entityNumberColl.iterator().next());
            EntityTypeUtil helper = new EntityTypeUtil();
            List cols = helper.getFilterColumns((IDataEntityType)dataEntityType);
            filterGrid.setEntityNumber(dataEntityType.getName());
            filterGrid.setFilterColumns(cols);
        } else {
            DynamicObject bizBill = (DynamicObject)this.getModel().getValue("entity");
            if (bizBill == null) {
                filterGrid.setFilterColumns(Collections.emptyList());
                return;
            }
            MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)bizBill.getString("number"));
            EntityTypeUtil helper = new EntityTypeUtil();
            List cols = helper.getFilterColumns((IDataEntityType)dataEntityType);
            filterGrid.setEntityNumber(dataEntityType.getName());
            filterGrid.setFilterColumns(cols);
        }
        this.getView().updateView("areafilter");
        String palnQFilterStr = (String)this.getModel().getValue("areajson_tag");
        FilterGrid filterFilter = (FilterGrid)this.getControl("areafilter");
        if (org.apache.commons.lang.StringUtils.isBlank((String)palnQFilterStr)) {
            filterFilter.SetValue(new FilterCondition());
        } else {
            String entityNumber = filterFilter.getEntityNumber();
            FilterCondition condition = (FilterCondition)SerializationUtils.fromJsonString((String)palnQFilterStr, FilterCondition.class);
            if ("msbd_inspectqfilter".equals(entityNumber)) {
                List<String> defaultFilter = Arrays.asList("biztime", "org.number", "org.name", "billno");
                List filterRow = condition.getFilterRow();
                boolean flag = false;
                for (SimpleFilterRow simpleFilterRow : filterRow) {
                    if (defaultFilter.contains(simpleFilterRow.getFieldName())) continue;
                    flag = true;
                }
                if (flag) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5de1\u68c0\u8ba1\u5212\u4e0a\uff0c\u6570\u636e\u8303\u56f4\u4e0d\u5728\u9ed8\u8ba4\u7684\u6570\u636e\u8303\u56f4\u5185\u3002", (String)"DmfInspectPlanPlugin_86", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
                    return;
                }
            }
            filterFilter.SetValue(condition);
        }
    }

    private Set<String> getEntityNumber() {
        DynamicObject inspectJob = (DynamicObject)this.getModel().getValue("inspectjob");
        if (inspectJob == null) {
            return new HashSet<String>(16);
        }
        Set insUnitSet = inspectJob.getDynamicObjectCollection("entry").stream().map(row -> (Long)row.getDynamicObject("inspectunit").getPkValue()).collect(Collectors.toSet());
        QFilter qFilter = new QFilter("id", "in", insUnitSet);
        DataSet inspectUnit = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"msbd_inspectunit", (String)"entity.number", (QFilter[])qFilter.toArray(), null);
        HashSet<String> entityNumberSet = new HashSet<String>();
        inspectUnit.forEach(row -> entityNumberSet.add(row.getString("entity.number")));
        return entityNumberSet;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        boolean dataChanged;
        super.beforeDoOperation(e);
        IDataModel model = this.getModel();
        String key = ((AbstractOperate)e.getSource()).getOperateKey();
        if ("save".equals(key)) {
            FilterGrid grid = (FilterGrid)this.getControl("areafilter");
            if (grid == null) {
                return;
            }
            FilterCondition condition = grid.getFilterGridState().getFilterCondition();
            model.setValue("areajson_tag", (Object)SerializationUtils.toJsonString((Object)condition));
        }
        if ("btnrun".equals(key) && (dataChanged = this.getModel().getDataChanged())) {
            String tipMsg = ResManager.loadKDString((String)"\u6570\u636e\u5de1\u68c0\u8ba1\u5212\u5df2\u7ecf\u53d1\u751f\u6539\u53d8\uff0c\u8bf7\u5148\u4fdd\u5b58\u518d\u624b\u52a8\u8fd0\u884c\u3002", (String)"InspectPlanRunValidator_0", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]);
            this.getView().showTipNotification(tipMsg);
            e.setCancel(true);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (status != OperationStatus.ADDNEW) {
            Object repeatmode;
            this.adjustByRepeatMode();
            String fromBiz = (String)this.getView().getFormShowParameter().getCustomParam("frombiz");
            if (fromBiz != null && fromBiz.equals("true")) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"job"});
            }
            Object comno = this.getModel().getValue("comno");
            Object comweek = this.getModel().getValue("comweek");
            this.getPageCache().put("loadData", "true");
            Tab tab = (Tab)this.getControl("tabap1");
            Object combdorw = this.getModel().getValue("combdorw");
            if (combdorw != null && "w".equals(combdorw.toString())) {
                tab.activeTab("tabweekpage");
            }
            if ("m".equals((repeatmode = this.getModel().getValue("repeatmode")).toString().trim())) {
                this.getModel().setValue("comnobyweek", comno);
                this.getModel().setValue("comweekbyweek", comweek);
            } else if ("y".equals(repeatmode.toString().trim())) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"comnobymonth", "comweekbymonth"});
                this.getModel().setValue("comnobymonth", comno);
                this.getModel().setValue("comweekbymonth", comweek);
            }
            this.getPageCache().remove("loadData");
            this.getModel().setValue("txtdesc", (Object)this.genDesc());
            this.getModel().setValue("repeatmode", (Object)repeatmode.toString().trim());
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String repeatMode;
        boolean flag;
        super.propertyChanged(e);
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        IDataEntityProperty property = e.getProperty();
        String name = property.getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        if (name.equals("endtime")) {
            Date startTime = (Date)model.getValue("starttime");
            Date endTime = (Date)newValue;
            if (endTime == null || startTime == null) {
                return;
            }
            flag = endTime.before(startTime);
            if (flag) {
                view.showTipNotification(ResManager.loadKDString((String)"\u5931\u6548\u65f6\u95f4\u5e94\u8be5\u4e0d\u5c0f\u4e8e\u751f\u6548\u65f6\u95f4\u3002", (String)"DmfInspectPlanPlugin_73", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
                model.setValue("endtime", null);
                return;
            }
        }
        if (name.equals("starttime")) {
            Date endTime = (Date)model.getValue("endtime");
            Date startTime = (Date)newValue;
            if (endTime == null || startTime == null) {
                return;
            }
            flag = endTime.before(startTime);
            if (flag) {
                view.showTipNotification(ResManager.loadKDString((String)"\u5931\u6548\u65f6\u95f4\u5e94\u8be5\u4e0d\u5c0f\u4e8e\u751f\u6548\u65f6\u95f4\u3002", (String)"DmfInspectPlanPlugin_73", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
                model.setValue("starttime", null);
                return;
            }
        }
        if (name.equals("inspectjob")) {
            Set<String> entityNumber = this.getEntityNumber();
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl("areafilter");
            MainEntityType dataEntityType = null;
            EntityTypeUtil helper = new EntityTypeUtil();
            if (entityNumber.size() == 1) {
                dataEntityType = MetadataServiceHelper.getDataEntityType((String)entityNumber.iterator().next());
            } else {
                DynamicObject bizBill = (DynamicObject)this.getModel().getValue("entity");
                String number = bizBill.getString("number");
                dataEntityType = MetadataServiceHelper.getDataEntityType((String)number);
            }
            List cols = helper.getFilterColumns((IDataEntityType)dataEntityType);
            filterGrid.setEntityNumber(dataEntityType.getName());
            filterGrid.setFilterColumns(cols);
            filterGrid.SetValue(new FilterCondition());
            this.getView().updateView("areafilter");
            return;
        }
        if (name.equals("plan")) {
            this.getModel().setValue("txtdesc", (Object)this.genDefDesc("def"));
            return;
        }
        if (name.equals("txtdesc")) {
            return;
        }
        if (newValue != null && "entity".equals(name)) {
            DynamicObject entity = (DynamicObject)newValue;
            this.updateAreaFilter(entity);
            return;
        }
        if ((name.startsWith("comnoby") || name.startsWith("comweekby")) && this.getPageCache().get("loadData") == null) {
            model.setValue("comno", model.getValue(name.replace("comweek", "comno")));
            model.setValue("comweek", model.getValue(name.replace("comno", "comweek")));
            Object commo = model.getValue("comno");
            Object comweek = model.getValue("comweek");
            if (name.endsWith("bymonth")) {
                if (commo != null && comweek != null && StringUtils.isNotBlank((CharSequence)commo.toString()) && StringUtils.isNotBlank((CharSequence)comweek.toString())) {
                    model.setValue("ckbyweek", (Object)Boolean.TRUE);
                } else {
                    model.setValue("ckbyweek", (Object)Boolean.FALSE);
                }
            }
        }
        if (name.equals("repeatmode")) {
            this.adjustByRepeatMode();
        }
        boolean isMonth = false;
        for (String propMonth : CKMONTH) {
            if (!name.equals(propMonth)) continue;
            isMonth = true;
            break;
        }
        if (isMonth) {
            boolean changeMonth = false;
            for (String month : CKMONTH) {
                boolean b = Boolean.parseBoolean(model.getValue(month).toString());
                if (!b) continue;
                changeMonth = b;
                break;
            }
            view.setVisible(Boolean.valueOf(changeMonth), new String[]{"comnobymonth"});
            view.setVisible(Boolean.valueOf(changeMonth), new String[]{"comweekbymonth"});
        }
        if (!(repeatMode = ((String)this.getModel().getValue("repeatmode")).trim()).equals("def")) {
            model.setValue("txtdesc", (Object)this.genDesc());
        }
    }

    private void updateAreaFilter(DynamicObject srcBill) {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("areafilter");
        if (srcBill == null) {
            filterGrid.setFilterColumns(Collections.emptyList());
        } else {
            filterGrid.SetValue(new FilterCondition());
            filterGrid.setEntityNumber(srcBill.getString("number"));
        }
        this.getView().updateView("areafilter");
    }

    private String getFilterGridCondition(String gridName) {
        FilterGrid grid = (FilterGrid)this.getControl(gridName);
        if (grid == null) {
            return "";
        }
        FilterCondition condition = grid.getFilterGridState().getFilterCondition();
        return SerializationUtils.toJsonString((Object)condition);
    }

    private void adjustByDayOrWeek() {
        IFormView formView = this.getView();
        String byDayOrWeek = (String)this.getModel().getValue("combdorw");
        if (byDayOrWeek.equals("w")) {
            formView.setVisible(Boolean.FALSE, new String[]{"flexpdays"});
            formView.setVisible(Boolean.TRUE, new String[]{"flexpbyweek"});
        } else {
            formView.setVisible(Boolean.TRUE, new String[]{"flexpdays"});
            formView.setVisible(Boolean.FALSE, new String[]{"flexpbyweek"});
        }
    }

    private void adjustByRepeatMode() {
        String repeatMode;
        IFormView formView = this.getView();
        formView.setVisible(Boolean.FALSE, new String[]{"flexpweek", "flexpworday", "flexpmonths", "flexpdays", "flexpbyweek", "plan"});
        formView.setEnable(Boolean.TRUE, new String[]{"cyclenum"});
        formView.setVisible(Boolean.TRUE, new String[]{"cyclenum"});
        switch (repeatMode = ((String)this.getModel().getValue("repeatmode")).trim()) {
            case "w": {
                formView.setVisible(Boolean.TRUE, new String[]{"flexpweek"});
                this.getModel().setValue("cyclenum", (Object)1);
                formView.setVisible(Boolean.TRUE, new String[]{"cyclenum"});
                formView.setEnable(Boolean.FALSE, new String[]{"cyclenum"});
                break;
            }
            case "m": {
                formView.setVisible(Boolean.TRUE, new String[]{"flexpworday", "flexpdays"});
                this.adjustByDayOrWeek();
                break;
            }
            case "y": {
                this.getModel().setValue("cyclenum", (Object)1);
                formView.setEnable(Boolean.FALSE, new String[]{"cyclenum"});
                formView.setVisible(Boolean.TRUE, new String[]{"flexpmonths"});
                this.adjustByWeek();
                break;
            }
            case "n": {
                formView.setEnable(Boolean.FALSE, new String[]{"cyclenum"});
                break;
            }
            case "def": {
                formView.setVisible(Boolean.FALSE, new String[]{"cyclenum"});
                formView.setVisible(Boolean.TRUE, new String[]{"plan"});
                this.getModel().setValue("txtdesc", (Object)this.genDefDesc("def"));
            }
        }
    }

    private String genDefDesc(String operateType) {
        String cron = (String)this.getModel().getValue("plan");
        Calendar crStartTime = this.getStartTime();
        StringBuilder descBuilder = new StringBuilder();
        String startWords = ResManager.loadKDString((String)"\u4e8b\u4ef6\u5c06\u4e8e", (String)"DmfInspectPlanPlugin_2", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]);
        descBuilder.append(startWords);
        String startTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(crStartTime.getTime());
        descBuilder.append(startTime);
        String endWords = ResManager.loadKDString((String)"\u8d77", (String)"DmfInspectPlanPlugin_74", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]);
        descBuilder.append(endWords);
        descBuilder.append("\uff0c");
        String property = System.getProperty("line.separator");
        descBuilder.append(property);
        String nextTimes = ResManager.loadKDString((String)"\u9884\u8ba1\u6700\u8fd1\u5341\u6b21\u6267\u884c\u65f6\u95f4\uff1a", (String)"DmfInspectPlanPlugin_75", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]);
        descBuilder.append(nextTimes);
        descBuilder.append(property);
        if (StringUtils.isBlank((CharSequence)cron) && "def".equals(operateType)) {
            return descBuilder.toString();
        }
        if ("plan".equals(operateType)) {
            this.checkCron(cron);
        }
        String recents = this.computeFireTimes(cron, crStartTime.getTime(), 10);
        descBuilder.append(recents);
        return descBuilder.toString();
    }

    private boolean checkCron(String cron) {
        try {
            parser.parse(cron);
            CronTriggerImpl cronTriggerImpl = new CronTriggerImpl();
            cronTriggerImpl.setCronExpression(cron);
            List dates = TriggerUtils.computeFireTimes((OperableTrigger)cronTriggerImpl, (org.quartz.Calendar)null, (int)2);
            long leadTime = Math.abs(((Date)dates.get(1)).getTime() - ((Date)dates.get(0)).getTime());
            if (leadTime < 60000L) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201ccron\u8868\u8fbe\u5f0f\u201d\u7684\u5468\u671f\u8bbe\u7f6e\u6709\u8bef\uff0c\u53ea\u652f\u6301\u5206\u949f\u7ea7\u522b\u7684\u5468\u671f\u3002", (String)"DmfInspectPlanPlugin_76", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
                return false;
            }
            return true;
        }
        catch (Exception var6) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\"cron\u8868\u8fbe\u5f0f\"\u8bbe\u7f6e\u9519\u8bef\uff0c\u8bf7\u4fee\u6539\u3002", (String)"DmfInspectPlanPlugin_77", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
            return false;
        }
    }

    private void adjustByWeek() {
        boolean byWeek = (Boolean)this.getModel().getValue("ckbyweek");
        this.getView().setVisible(Boolean.valueOf(byWeek), new String[]{"flexpbyweek"});
    }

    private String genDesc() {
        Object cyclenumObj = this.getView().getModel().getValue("cyclenum");
        if (StringUtils.isBlank((Object)cyclenumObj) || Long.parseLong(cyclenumObj.toString()) == 0L) {
            return "";
        }
        CronStruct cron = new CronStruct();
        Calendar crStartTime = this.getStartTime();
        cron.setSeconds("0");
        cron.setMinutes(String.valueOf(crStartTime.get(12)));
        cron.setHours(String.valueOf(crStartTime.get(11)));
        cron.setDayOfMonth(String.valueOf(crStartTime.get(5)));
        cron.setMonth(String.valueOf(crStartTime.get(2) + 1));
        cron.setDayOfWeek("?");
        cron.setYear(String.valueOf(crStartTime.get(1)));
        String repeatMode = (String)this.getView().getModel().getValue("repeatmode");
        int cyclenum = (Integer)this.getView().getModel().getValue("cyclenum");
        cron.getDescBuf().append(ResManager.loadKDString((String)"\u4e8b\u4ef6\u5c06\u4e8e", (String)"DmfInspectPlanPlugin_2", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
        String startTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(crStartTime.getTime());
        cron.getDescBuf().append(startTime).append(ResManager.loadKDString((String)"\u8d77", (String)"DmfInspectPlanPlugin_74", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0])).append("\uff0c");
        switch (repeatMode = repeatMode.trim()) {
            case "n": {
                cron.getDescBuf().setLength(0);
                cron.getDescBuf().append(ResManager.loadKDString((String)"\u4e8b\u4ef6\u4e0d\u91cd\u590d\u3002", (String)"DmfInspectPlanPlugin_78", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
                break;
            }
            case "mi": {
                cron.getDescBuf().append(ResManager.loadKDString((String)"\u6bcf", (String)"DmfInspectPlanPlugin_4", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0])).append(cyclenum).append(ResManager.loadKDString((String)"\u5206\u949f\u91cd\u590d", (String)"DmfInspectPlanPlugin_5", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
                if (cyclenum > 1) {
                    cron.setMinutes("0/" + cyclenum);
                } else {
                    cron.setMinutes("*");
                }
                cron.setHours("*");
                cron.setDayOfMonth("*");
                cron.setMonth("*");
                cron.setDayOfWeek("?");
                cron.setYear(null);
                break;
            }
            case "h": {
                cron.getDescBuf().append(ResManager.loadKDString((String)"\u6bcf", (String)"DmfInspectPlanPlugin_4", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0])).append(cyclenum).append(ResManager.loadKDString((String)"\u5c0f\u65f6\u91cd\u590d\u3002", (String)"DmfInspectPlanPlugin_79", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
                if (cyclenum > 1) {
                    if (cyclenum > 23) {
                        cyclenum = 23;
                        this.getModel().setValue("cyclenum", (Object)23);
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6700\u591a\u53ea\u80fd\u6bcf23\u5c0f\u65f6\u91cd\u590d\u3002", (String)"DmfInspectPlanPlugin_80", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
                    }
                    cron.setHours("0/" + cyclenum);
                } else {
                    cron.setHours("*");
                }
                cron.setDayOfMonth("*");
                cron.setMonth("*");
                cron.setDayOfWeek("?");
                cron.setYear(null);
                break;
            }
            case "d": {
                if (cyclenum > 1) {
                    cron.setDayOfMonth("1/" + cyclenum);
                    String day = String.valueOf(crStartTime.get(5));
                    cron.getDescBuf().append(ResManager.loadKDString((String)"\u6bcf\u6708", (String)"DmfInspectPlanPlugin_81", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0])).append(day).append(ResManager.loadKDString((String)"\u65e5\u5f00\u59cb", (String)"DmfInspectPlanPlugin_82", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
                } else {
                    cron.setDayOfMonth("*");
                }
                cron.setMonth("*");
                cron.setDayOfWeek("?");
                cron.setYear(null);
                cron.getDescBuf().append(ResManager.loadKDString((String)"\u6bcf", (String)"DmfInspectPlanPlugin_4", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0])).append(cyclenum).append(ResManager.loadKDString((String)"\u5929\u91cd\u590d\u3002", (String)"DmfInspectPlanPlugin_83", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
                break;
            }
            case "w": {
                cron.getDescBuf().append(ResManager.loadKDString((String)"\u6bcf", (String)"DmfInspectPlanPlugin_4", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0])).append(cyclenum).append(ResManager.loadKDString((String)"\u5468", (String)"DmfInspectPlanPlugin_9", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
                cron.setDayOfMonth("*");
                cron.setMonth("*");
                cron.setYear(null);
                cron = this.repeatByWeek(cron);
                cron.getDescBuf().append(ResManager.loadKDString((String)"\u91cd\u590d\u3002", (String)"DmfInspectPlanPlugin_84", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
                break;
            }
            case "m": {
                cron.getDescBuf().append(ResManager.loadKDString((String)"\u6bcf", (String)"DmfInspectPlanPlugin_4", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0])).append(cyclenum).append(ResManager.loadKDString((String)"\u6708", (String)"DmfInspectPlanPlugin_11", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
                if (cyclenum > 1) {
                    String month = String.valueOf(crStartTime.get(2) + 1);
                    cron.setMonth(month + "/" + cyclenum);
                } else {
                    cron.setMonth("*");
                }
                cron.setYear(null);
                cron = this.repeatByMonthDay(cron);
                cron.getDescBuf().append(ResManager.loadKDString((String)"\u91cd\u590d\u3002", (String)"DmfInspectPlanPlugin_84", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
                break;
            }
            case "y": {
                cron.getDescBuf().append(ResManager.loadKDString((String)"\u6bcf", (String)"DmfInspectPlanPlugin_4", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0])).append(cyclenum).append(ResManager.loadKDString((String)"\u5e74", (String)"DmfInspectPlanPlugin_12", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
                cron.setYear(null);
                cron = this.repeatByMonthly(cron);
                cron.getDescBuf().append(ResManager.loadKDString((String)"\u91cd\u590d\u3002", (String)"DmfInspectPlanPlugin_84", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
            }
        }
        String cornExpress = cron.toString();
        try {
            Cron cron2 = parser.parse(cornExpress);
        }
        catch (Exception e) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8ba1\u5212\u65f6\u95f4\u8bbe\u7f6e\u9519\u8bef\u3002", (String)"DmfInspectPlanPlugin_13", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
        }
        this.getModel().setValue("plan", (Object)cornExpress);
        if (!"n".equals(repeatMode)) {
            String property = System.getProperty("line.separator");
            cron.getDescBuf().append(property);
            String latestTenTime = ResManager.loadKDString((String)"\u9884\u8ba1\u6700\u8fd1\u5341\u6b21\u6267\u884c\u65f6\u95f4\uff1a", (String)"DmfInspectPlanPlugin_75", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]);
            cron.getDescBuf().append(latestTenTime);
            cron.getDescBuf().append(property);
            cron.getDescBuf().append(this.computeFireTimes(cornExpress, crStartTime.getTime(), 10));
        }
        return cron.getDescBuf().toString();
    }

    private String computeFireTimes(String cronExp, Date startDate, Integer numTimes) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            CronTriggerImpl cronTriggerImpl = new CronTriggerImpl();
            cronTriggerImpl.setCronExpression(cronExp);
            cronTriggerImpl.setStartTime(startDate);
            List dateList = TriggerUtils.computeFireTimes((OperableTrigger)cronTriggerImpl, null, (int)numTimes);
            ArrayList<String> dateStr = new ArrayList<String>(10);
            for (Date date : dateList) {
                dateStr.add(dateFormat.format(date));
            }
            return dateStr.stream().collect(Collectors.joining(System.getProperty("line.separator")));
        }
        catch (ParseException e) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201ccron\u8868\u8fbe\u5f0f\u201d\u8bbe\u7f6e\u9519\u8bef\u3002", (String)"DmfInspectPlanPlugin_85", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
            return "";
        }
    }

    private Calendar getStartTime() {
        Date startTime = (Date)this.getView().getModel().getValue("starttime");
        Calendar crStartTime = Calendar.getInstance();
        if (startTime != null) {
            crStartTime.setTimeInMillis(startTime.getTime());
        } else {
            this.getView().getModel().setValue("starttime", (Object)crStartTime.getTime());
        }
        return crStartTime;
    }

    private CronStruct repeatByMonthDay(CronStruct cron) {
        IDataModel dataModel = this.getView().getModel();
        String byDayOrWeek = (String)dataModel.getValue("combdorw");
        if (byDayOrWeek.equals("d")) {
            String conStr = ResManager.loadKDString((String)"\u7684", (String)"DmfInspectPlanPlugin_14", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]);
            String days = "";
            if (((Boolean)dataModel.getValue("ckone")).booleanValue()) {
                cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"1\u65e5", (String)"DmfInspectPlanPlugin_15", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
                conStr = ",";
                days = days + "1,";
            }
            if (((Boolean)dataModel.getValue("cktwo")).booleanValue()) {
                cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"2\u65e5", (String)"DmfInspectPlanPlugin_16", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
                conStr = ",";
                days = days + "2,";
            }
            if (((Boolean)dataModel.getValue("ckthree")).booleanValue()) {
                cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"3\u65e5", (String)"DmfInspectPlanPlugin_17", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
                conStr = ",";
                days = days + "3,";
            }
            if (((Boolean)dataModel.getValue("ckfour")).booleanValue()) {
                cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"4\u65e5", (String)"DmfInspectPlanPlugin_18", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
                conStr = ",";
                days = days + "4,";
            }
            if (((Boolean)dataModel.getValue("ckfive")).booleanValue()) {
                cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"5\u65e5", (String)"DmfInspectPlanPlugin_19", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
                conStr = ",";
                days = days + "5,";
            }
            if (((Boolean)dataModel.getValue("cksix")).booleanValue()) {
                cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"6\u65e5", (String)"DmfInspectPlanPlugin_20", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
                conStr = ",";
                days = days + "6,";
            }
            if (((Boolean)dataModel.getValue("ckseven")).booleanValue()) {
                cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"7\u65e5", (String)"DmfInspectPlanPlugin_21", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
                conStr = ",";
                days = days + "7,";
            }
            if (((Boolean)dataModel.getValue("ckeight")).booleanValue()) {
                cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"8\u65e5", (String)"DmfInspectPlanPlugin_22", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
                conStr = ",";
                days = days + "8,";
            }
            if (((Boolean)dataModel.getValue("cknine")).booleanValue()) {
                cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"9\u65e5", (String)"DmfInspectPlanPlugin_23", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
                conStr = ",";
                days = days + "9,";
            }
            if (((Boolean)dataModel.getValue("ckten")).booleanValue()) {
                cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"10\u65e5", (String)"DmfInspectPlanPlugin_24", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
                conStr = ",";
                days = days + "10,";
            }
            if (((Boolean)dataModel.getValue("ckeleven")).booleanValue()) {
                cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"11\u65e5", (String)"DmfInspectPlanPlugin_25", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
                conStr = ",";
                days = days + "11,";
            }
            if (((Boolean)dataModel.getValue("cktwelve")).booleanValue()) {
                cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"12\u65e5", (String)"DmfInspectPlanPlugin_26", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
                conStr = ",";
                days = days + "12,";
            }
            if (((Boolean)dataModel.getValue("ckthirteen")).booleanValue()) {
                cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"13\u65e5", (String)"DmfInspectPlanPlugin_27", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
                conStr = ",";
                days = days + "13,";
            }
            if (((Boolean)dataModel.getValue("ckfourteen")).booleanValue()) {
                cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"14\u65e5", (String)"DmfInspectPlanPlugin_28", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
                conStr = ",";
                days = days + "14,";
            }
            if (((Boolean)dataModel.getValue("ckfifteen")).booleanValue()) {
                cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"15\u65e5", (String)"DmfInspectPlanPlugin_29", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
                conStr = ",";
                days = days + "15,";
            }
            if (((Boolean)dataModel.getValue("cksixteen")).booleanValue()) {
                cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"16\u65e5", (String)"DmfInspectPlanPlugin_30", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
                conStr = ",";
                days = days + "16,";
            }
            if (((Boolean)dataModel.getValue("ckseventeen")).booleanValue()) {
                cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"17\u65e5", (String)"DmfInspectPlanPlugin_31", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
                conStr = ",";
                days = days + "17,";
            }
            if (((Boolean)dataModel.getValue("ckeighteen")).booleanValue()) {
                cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"18\u65e5", (String)"DmfInspectPlanPlugin_32", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
                conStr = ",";
                days = days + "18,";
            }
            if (((Boolean)dataModel.getValue("cknineteen")).booleanValue()) {
                cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"19\u65e5", (String)"DmfInspectPlanPlugin_33", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
                conStr = ",";
                days = days + "19,";
            }
            if (((Boolean)dataModel.getValue("cktwenty")).booleanValue()) {
                cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"20\u65e5", (String)"DmfInspectPlanPlugin_34", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
                conStr = ",";
                days = days + "20,";
            }
            if (((Boolean)dataModel.getValue("cktwentyone")).booleanValue()) {
                cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"21\u65e5", (String)"DmfInspectPlanPlugin_35", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
                conStr = ",";
                days = days + "21,";
            }
            if (((Boolean)dataModel.getValue("cktwentytwo")).booleanValue()) {
                cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"22\u65e5", (String)"DmfInspectPlanPlugin_36", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
                conStr = ",";
                days = days + "22,";
            }
            if (((Boolean)dataModel.getValue("cktwentythree")).booleanValue()) {
                cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"23\u65e5", (String)"DmfInspectPlanPlugin_37", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
                conStr = ",";
                days = days + "23,";
            }
            if (((Boolean)dataModel.getValue("cktwentyfour")).booleanValue()) {
                cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"24\u65e5", (String)"DmfInspectPlanPlugin_38", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
                conStr = ",";
                days = days + "24,";
            }
            if (((Boolean)dataModel.getValue("cktwentyfive")).booleanValue()) {
                cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"25\u65e5", (String)"DmfInspectPlanPlugin_39", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
                conStr = ",";
                days = days + "25,";
            }
            if (((Boolean)dataModel.getValue("cktwentysix")).booleanValue()) {
                cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"26\u65e5", (String)"DmfInspectPlanPlugin_40", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
                conStr = ",";
                days = days + "26,";
            }
            if (((Boolean)dataModel.getValue("cktwentyseven")).booleanValue()) {
                cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"27\u65e5", (String)"DmfInspectPlanPlugin_41", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
                conStr = ",";
                days = days + "27,";
            }
            if (((Boolean)dataModel.getValue("cktwentyeight")).booleanValue()) {
                cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"28\u65e5", (String)"DmfInspectPlanPlugin_42", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
                conStr = ",";
                days = days + "28,";
            }
            if (((Boolean)dataModel.getValue("cktwentynine")).booleanValue()) {
                cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"29\u65e5", (String)"DmfInspectPlanPlugin_43", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
                conStr = ",";
                days = days + "29,";
            }
            if (((Boolean)dataModel.getValue("ckthirty")).booleanValue()) {
                cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"30\u65e5", (String)"DmfInspectPlanPlugin_44", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
                conStr = ",";
                days = days + "30,";
            }
            if (((Boolean)dataModel.getValue("ckthirtyone")).booleanValue()) {
                cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"31\u65e5", (String)"DmfInspectPlanPlugin_45", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
                conStr = ",";
                days = days + "31,";
            }
            days = days.length() == 0 ? String.valueOf(this.getStartTime().get(5)) : days.substring(0, days.length() - 1);
            cron.setDayOfMonth(days);
        } else if (byDayOrWeek.equals("w")) {
            cron = this.repeatByNoWeek(cron);
        }
        return cron;
    }

    private CronStruct repeatByWeek(CronStruct cron) {
        IDataModel dataModel = this.getView().getModel();
        String conStr = ResManager.loadKDString((String)"\u7684", (String)"DmfInspectPlanPlugin_14", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]);
        String weekDays = "";
        if (((Boolean)dataModel.getValue("cksun")).booleanValue()) {
            cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"\u661f\u671f\u65e5", (String)"DmfInspectPlanPlugin_46", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
            conStr = ",";
            weekDays = "1,";
        }
        if (((Boolean)dataModel.getValue("ckmon")).booleanValue()) {
            cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"\u661f\u671f\u4e00", (String)"DmfInspectPlanPlugin_47", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
            conStr = ",";
            weekDays = weekDays + "2,";
        }
        if (((Boolean)dataModel.getValue("cktues")).booleanValue()) {
            cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"\u661f\u671f\u4e8c", (String)"DmfInspectPlanPlugin_48", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
            conStr = ",";
            weekDays = weekDays + "3,";
        }
        if (((Boolean)dataModel.getValue("ckwed")).booleanValue()) {
            cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"\u661f\u671f\u4e09", (String)"DmfInspectPlanPlugin_49", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
            conStr = ",";
            weekDays = weekDays + "4,";
        }
        if (((Boolean)dataModel.getValue("ckthur")).booleanValue()) {
            cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"\u661f\u671f\u56db", (String)"DmfInspectPlanPlugin_50", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
            conStr = ",";
            weekDays = weekDays + "5,";
        }
        if (((Boolean)dataModel.getValue("ckfri")).booleanValue()) {
            cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"\u661f\u671f\u4e94", (String)"DmfInspectPlanPlugin_51", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
            conStr = ",";
            weekDays = weekDays + "6,";
        }
        if (((Boolean)dataModel.getValue("cksat")).booleanValue()) {
            cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"\u661f\u671f\u516d", (String)"DmfInspectPlanPlugin_52", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
            weekDays = weekDays + "7,";
        }
        weekDays = weekDays.length() == 0 ? String.valueOf(this.getStartTime().get(7)) : weekDays.substring(0, weekDays.length() - 1);
        cron.setDayOfMonth("?");
        cron.setDayOfWeek(weekDays);
        return cron;
    }

    private CronStruct repeatByMonthly(CronStruct cron) {
        IDataModel dataModel = this.getView().getModel();
        String conStr = ResManager.loadKDString((String)"\u7684", (String)"DmfInspectPlanPlugin_14", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]);
        String months = "";
        if (((Boolean)dataModel.getValue("ckjan")).booleanValue()) {
            cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"\u4e00\u6708", (String)"DmfInspectPlanPlugin_53", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
            conStr = ",";
            months = months + "1,";
        }
        if (((Boolean)dataModel.getValue("ckfeb")).booleanValue()) {
            cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"\u4e8c\u6708", (String)"DmfInspectPlanPlugin_54", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
            conStr = ",";
            months = months + "2,";
        }
        if (((Boolean)dataModel.getValue("ckmar")).booleanValue()) {
            cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"\u4e09\u6708", (String)"DmfInspectPlanPlugin_55", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
            conStr = ",";
            months = months + "3,";
        }
        if (((Boolean)dataModel.getValue("ckapr")).booleanValue()) {
            cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"\u56db\u6708", (String)"DmfInspectPlanPlugin_56", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
            conStr = ",";
            months = months + "4,";
        }
        if (((Boolean)dataModel.getValue("ckmay")).booleanValue()) {
            cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"\u4e94\u6708", (String)"DmfInspectPlanPlugin_57", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
            conStr = ",";
            months = months + "5,";
        }
        if (((Boolean)dataModel.getValue("ckjun")).booleanValue()) {
            cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"\u516d\u6708", (String)"DmfInspectPlanPlugin_58", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
            conStr = ",";
            months = months + "6,";
        }
        if (((Boolean)dataModel.getValue("ckjul")).booleanValue()) {
            cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"\u4e03\u6708", (String)"DmfInspectPlanPlugin_59", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
            conStr = ",";
            months = months + "7,";
        }
        if (((Boolean)dataModel.getValue("ckaug")).booleanValue()) {
            cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"\u516b\u6708", (String)"DmfInspectPlanPlugin_60", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
            conStr = ",";
            months = months + "8,";
        }
        if (((Boolean)dataModel.getValue("cksep")).booleanValue()) {
            cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"\u4e5d\u6708", (String)"DmfInspectPlanPlugin_61", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
            conStr = ",";
            months = months + "9,";
        }
        if (((Boolean)dataModel.getValue("ckoct")).booleanValue()) {
            cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"\u5341\u6708", (String)"DmfInspectPlanPlugin_62", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
            conStr = ",";
            months = months + "10,";
        }
        if (((Boolean)dataModel.getValue("cknov")).booleanValue()) {
            cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"\u5341\u4e00\u6708", (String)"DmfInspectPlanPlugin_63", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
            conStr = ",";
            months = months + "11,";
        }
        if (((Boolean)dataModel.getValue("ckdec")).booleanValue()) {
            cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"\u5341\u4e8c\u6708", (String)"DmfInspectPlanPlugin_64", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
            conStr = ",";
            months = months + "12,";
        }
        months = months.length() == 0 ? String.valueOf(this.getStartTime().get(2) + 1) : months.substring(0, months.length() - 1);
        cron.setMonth(months);
        if (((Boolean)dataModel.getValue("ckbyweek")).booleanValue()) {
            cron = this.repeatByNoWeek(cron);
        }
        return cron;
    }

    private CronStruct repeatByNoWeek(CronStruct cron) {
        IDataModel dataModel = this.getView().getModel();
        String no = (String)dataModel.getValue("comno");
        String noWeek = (String)dataModel.getValue("comweek");
        switch (no == null ? "" : no) {
            case "1": {
                cron.getDescBuf().append(ResManager.loadKDString((String)"\u7b2c\u4e00\u4e2a", (String)"DmfInspectPlanPlugin_65", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
                break;
            }
            case "2": {
                cron.getDescBuf().append(ResManager.loadKDString((String)"\u7b2c\u4e8c\u4e2a", (String)"DmfInspectPlanPlugin_66", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
                break;
            }
            case "3": {
                cron.getDescBuf().append(ResManager.loadKDString((String)"\u7b2c\u4e09\u4e2a", (String)"DmfInspectPlanPlugin_67", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
                break;
            }
            case "4": {
                cron.getDescBuf().append(ResManager.loadKDString((String)"\u7b2c\u56db\u4e2a", (String)"DmfInspectPlanPlugin_68", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
                break;
            }
            case "5": {
                cron.getDescBuf().append(ResManager.loadKDString((String)"\u7b2c\u4e94\u4e2a", (String)"DmfInspectPlanPlugin_69", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
                break;
            }
            case "L": {
                cron.getDescBuf().append(ResManager.loadKDString((String)"\u6700\u540e\u4e00\u4e2a", (String)"DmfInspectPlanPlugin_70", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
            }
        }
        switch (noWeek == null ? "" : noWeek) {
            case "1": {
                cron.getDescBuf().append(ResManager.loadKDString((String)"\u661f\u671f\u65e5", (String)"DmfInspectPlanPlugin_46", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
                break;
            }
            case "2": {
                cron.getDescBuf().append(ResManager.loadKDString((String)"\u661f\u671f\u4e00", (String)"DmfInspectPlanPlugin_47", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
                break;
            }
            case "3": {
                cron.getDescBuf().append(ResManager.loadKDString((String)"\u661f\u671f\u4e8c", (String)"DmfInspectPlanPlugin_48", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
                break;
            }
            case "4": {
                cron.getDescBuf().append(ResManager.loadKDString((String)"\u661f\u671f\u4e09", (String)"DmfInspectPlanPlugin_49", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
                break;
            }
            case "5": {
                cron.getDescBuf().append(ResManager.loadKDString((String)"\u661f\u671f\u56db", (String)"DmfInspectPlanPlugin_50", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
                break;
            }
            case "6": {
                cron.getDescBuf().append(ResManager.loadKDString((String)"\u661f\u671f\u4e94", (String)"DmfInspectPlanPlugin_51", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
                break;
            }
            case "7": {
                cron.getDescBuf().append(ResManager.loadKDString((String)"\u661f\u671f\u516d", (String)"DmfInspectPlanPlugin_52", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
                break;
            }
            case "8": {
                cron.getDescBuf().append(ResManager.loadKDString((String)"\u81ea\u7136\u65e5", (String)"DmfInspectPlanPlugin_71", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
                break;
            }
            case "9": {
                cron.getDescBuf().append(ResManager.loadKDString((String)"\u5de5\u4f5c\u65e5", (String)"DmfInspectPlanPlugin_72", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
            }
        }
        if (no != null && noWeek != null) {
            if (noWeek.compareTo("1") >= 0 && noWeek.compareTo("8") < 0) {
                if (no.compareTo("1") >= 0 && no.compareTo("5") <= 0) {
                    cron.setDayOfWeek(noWeek + "#" + no);
                } else if (no.compareTo("L") == 0) {
                    cron.setDayOfWeek(noWeek + "L");
                }
                cron.setDayOfMonth("?");
            } else if (noWeek.equals("8")) {
                if (no.compareTo("1") >= 0 && no.compareTo("5") <= 0) {
                    cron.setDayOfMonth(no);
                } else if (no.compareTo("L") == 0) {
                    cron.setDayOfMonth("1L");
                }
                cron.setDayOfWeek("?");
            } else if (noWeek.equals("9")) {
                if (no.compareTo("1") >= 0 && no.compareTo("5") <= 0) {
                    String workday = String.valueOf(Integer.parseInt(no) + 1);
                    cron.setDayOfWeek(workday + "#" + no);
                } else if (no.compareTo("L") == 0) {
                    cron.setDayOfWeek("6L");
                }
                cron.setDayOfMonth("?");
            }
        }
        return cron;
    }
}

