/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.datamanage.formplugin;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.PKFieldProp;
import kd.bos.entity.property.TextProp;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Button;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.impl.ORMUtil;
import kd.bos.util.StringUtils;

public class InspectPartitionSqlPlugin
extends AbstractFormPlugin
implements RowClickEventListener {
    private static final String btn_OK = "btnok";
    private static final String ENTRY_COUNT = "entry_count";
    private static final String SELECT_INDICES = "selectIndices";
    private static final String FIELDS = "fields";
    private static final String INDICES = "indices";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{btn_OK});
        EntryGrid eg = (EntryGrid)this.getControl("entryentity");
        eg.addRowClickListener((RowClickEventListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        IFormView view = this.getView();
        JSONObject shardEntityInfoMap = (JSONObject)view.getFormShowParameter().getCustomParam("shardSqlFields");
        IPageCache pageCache = this.getPageCache();
        pageCache.put(SELECT_INDICES, shardEntityInfoMap.getString(SELECT_INDICES));
        this.listShardingFields(shardEntityInfoMap);
        this.showSelectedShardingFields(shardEntityInfoMap);
    }

    private void showSelectedShardingFields(JSONObject shardEntityInfoMap) {
        if (shardEntityInfoMap != null) {
            String selectedFields;
            boolean selectIndices = Boolean.parseBoolean(shardEntityInfoMap.getString(SELECT_INDICES));
            if (selectIndices) {
                selectedFields = (String)shardEntityInfoMap.get((Object)SELECT_INDICES);
                this.getPageCache().put(INDICES, selectedFields);
            } else {
                selectedFields = (String)shardEntityInfoMap.get((Object)SELECT_INDICES);
                this.getPageCache().put(FIELDS, selectedFields);
            }
            if (StringUtils.isNotEmpty((String)selectedFields)) {
                String[] fields = selectedFields.split(",");
                IDataModel model = this.getModel();
                DynamicObjectCollection entryEntity = model.getEntryEntity("entryentity");
                for (int i = 0; i < entryEntity.size(); ++i) {
                    for (String field : fields) {
                        if (!field.equals(((DynamicObject)entryEntity.get(i)).getString("fieldnumber"))) continue;
                        model.setValue("fieldchoose", (Object)Boolean.TRUE, i);
                    }
                }
            }
        }
    }

    private void listShardingFields(JSONObject shardEntityInfoMap) {
        IDataModel model = this.getModel();
        model.deleteEntryData("entryentity");
        if (shardEntityInfoMap != null) {
            String formId = shardEntityInfoMap.getString("number");
            boolean selectIndices = Boolean.parseBoolean(shardEntityInfoMap.getString(SELECT_INDICES));
            List<IDataEntityProperty> dps = InspectPartitionSqlPlugin.getPropertiesForPartitionSql(formId, selectIndices);
            if (selectIndices) {
                String shardingFields = shardEntityInfoMap.getString(SELECT_INDICES);
                String[] fields = shardingFields.split(",");
                if (Objects.nonNull(shardingFields)) {
                    ListIterator<IDataEntityProperty> it = dps.listIterator();
                    block0: while (it.hasNext()) {
                        IDataEntityProperty dp = it.next();
                        if (dp instanceof PKFieldProp) {
                            it.remove();
                            continue;
                        }
                        for (String field : fields) {
                            if (!field.equals(dp.getName())) continue;
                            it.remove();
                            continue block0;
                        }
                    }
                }
            }
            for (IDataEntityProperty dp : dps) {
                int rowIndex = model.createNewEntryRow("entryentity");
                model.setValue("fieldnumber", (Object)dp.getName(), rowIndex);
                model.setValue("fieldname", (Object)Optional.ofNullable(dp.getDisplayName()).orElseGet(() -> new LocaleString(dp.getName().toUpperCase())), rowIndex);
                model.setValue("fieldchoose", (Object)Boolean.FALSE, rowIndex);
            }
            this.getPageCache().put(ENTRY_COUNT, String.valueOf(dps.size()));
        }
    }

    public static List<IDataEntityProperty> getPropertiesForPartitionSql(String formId, boolean forIndices) {
        ArrayList<IDataEntityProperty> dps = new ArrayList<IDataEntityProperty>();
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)formId);
        DataEntityPropertyCollection ps = dt.getProperties();
        int n = ps.size();
        for (int i = 0; i < n; ++i) {
            BasedataProp basedataProp;
            String baseEntityId;
            FieldProp fp;
            IDataEntityProperty dp = (IDataEntityProperty)ps.get(i);
            if (ORMUtil.isDbIgnoreRefBaseData((IDataEntityProperty)dp) || dp.getName().endsWith("_id") || !(dp instanceof DateTimeProp) && !(dp instanceof BasedataProp) || dp.getTableGroup() != null && !forIndices || dp instanceof TextProp && dp instanceof FieldProp && (fp = (FieldProp)dp).isSysField() || dp instanceof BasedataProp && !"bos_org".equals(baseEntityId = (basedataProp = (BasedataProp)dp).getBaseEntityId())) continue;
            if (dp instanceof DateTimeProp) {
                DateTimeProp dateTimeProp = (DateTimeProp)dp;
                String string = dateTimeProp.getName();
            }
            dps.add(dp);
        }
        dps.stream().sorted();
        return dps;
    }

    public void entryRowClick(RowClickEvent evt) {
        IDataModel model = this.getModel();
        int row = evt.getRow();
        DynamicObjectCollection entryEntity = model.getEntryEntity("entryentity");
        String selectFieldName = ((DynamicObject)entryEntity.get(row)).getString("fieldnumber");
        boolean selected = (Boolean)model.getValue("fieldchoose");
        if (selected) {
            model.setValue("fieldchoose", (Object)Boolean.FALSE, row);
            this.buildFields(selectFieldName, false);
        } else {
            model.setValue("fieldchoose", (Object)Boolean.TRUE, row);
            this.buildFields(selectFieldName, true);
        }
    }

    private void buildFields(String selectFieldName, boolean toSelected) {
        IPageCache pageCache = this.getPageCache();
        boolean selectIndices = Boolean.parseBoolean(pageCache.get(SELECT_INDICES));
        String cacheFields = selectIndices ? pageCache.get(INDICES) : pageCache.get(FIELDS);
        StringBuilder fields = new StringBuilder(cacheFields);
        if (toSelected) {
            if (fields.length() > 0) {
                fields.append(',');
            }
            fields.append(selectFieldName);
        } else {
            List<String> fieldsList = Arrays.stream(cacheFields.split(",")).filter(field -> !selectFieldName.equals(field)).collect(Collectors.toList());
            String[] afterFieldArray = fieldsList.toArray(new String[fieldsList.size()]);
            fields.setLength(0);
            fields.append(InspectPartitionSqlPlugin.joinArray(afterFieldArray, ","));
        }
        if (selectIndices) {
            pageCache.put(INDICES, fields.toString());
        } else {
            pageCache.put(FIELDS, fields.toString());
        }
    }

    public static String joinArray(String[] array, String delim) {
        StringBuilder sb = new StringBuilder();
        int n = array.length;
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                sb.append(delim);
            }
            sb.append(array[i]);
        }
        return sb.toString();
    }

    public void click(EventObject evt) {
        DynamicObjectCollection entryEntity;
        Button btn = (Button)evt.getSource();
        String key = btn.getKey();
        String retData = null;
        if (btn_OK.equals(key) && (entryEntity = this.getModel().getEntryEntity("entryentity")).size() > 0) {
            List dynamicObjectList = entryEntity.stream().filter(dy -> dy.getBoolean("fieldchoose")).collect(Collectors.toList());
            if (dynamicObjectList.size() == 0) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u52fe\u9009\u4e00\u4e2a\u5c5e\u6027\u3002", (String)"InspectPartitionSqlPlugin_0", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
                return;
            }
            if (dynamicObjectList.size() > 1) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u6700\u591a\u9009\u62e9\u4e00\u4e2a\u5c5e\u6027\u3002", (String)"InspectPartitionSqlPlugin_1", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
                return;
            }
            IPageCache pageCache = this.getPageCache();
            boolean selectIndices = Boolean.parseBoolean(pageCache.get(SELECT_INDICES));
            retData = selectIndices ? pageCache.get(INDICES) : pageCache.get(FIELDS);
        }
        this.getView().returnDataToParent(retData);
        this.getView().close();
    }

    private String getReturnData(List<DynamicObject> dynamicObjectList) {
        StringBuilder sbd = new StringBuilder(dynamicObjectList.size() * 50);
        for (int i = 0; i < dynamicObjectList.size(); ++i) {
            if (i > 0) {
                sbd.append(',');
            }
            sbd.append(dynamicObjectList.get(i).getString("fieldnumber"));
        }
        return sbd.toString();
    }
}

