/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.datamanage.formplugin.echart;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.CustomChart;
import kd.bos.form.chart.Label;
import kd.bos.form.chart.LineSeries;
import kd.bos.form.chart.Position;
import kd.bos.form.chart.XAlign;
import kd.bos.form.chart.YAlign;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.msbd.datamanage.common.pojo.InspectAnalysisInfo;
import kd.mpscmm.msbd.datamanage.common.util.DateUtils;
import kd.mpscmm.msbd.datamanage.formplugin.echart.InspectCommonChartPlugin;

public class InspectBarAnalysisPlugin
extends InspectCommonChartPlugin {
    public void afterCreateNewData(EventObject e) {
        this.initBar();
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if ("refresh".equals(itemKey)) {
            this.initBar();
        }
    }

    private void initBar() {
        CustomChart customchart = (CustomChart)this.getControl("customchartap");
        customchart.addTooltip("trigger", (Object)"axis");
        HashMap<String, String> axisPointType = new HashMap<String, String>();
        axisPointType.put("type", "shadow");
        customchart.addTooltip("axisPointer", axisPointType);
        customchart.clearData();
        this.setHandlechartXaxisTick(customchart);
        this.setHandleChartData(customchart);
        customchart.setMargin(Position.right, "2%");
        customchart.setMargin(Position.left, "2%");
        customchart.setMargin(Position.top, "10%");
        customchart.setLegendPropValue("itemWidth", (Object)10);
        customchart.setLegendPropValue("itemHeight", (Object)10);
        customchart.setLegendAlign(XAlign.center, YAlign.top);
        customchart.setShowTitle(true);
        customchart.setShowTooltip(true);
        customchart.setShowLegend(true);
        customchart.setLegendVertical(false);
        customchart.refresh();
    }

    private Axis setHandlechartXaxisTick(CustomChart customchart) {
        Axis axis = customchart.createXAxis("", AxisType.category);
        ArrayList<String> xDimensions = new ArrayList<String>(16);
        for (int i = 0; i < 14; ++i) {
            xDimensions.add(DateUtils.getCurrentDayStr(i));
        }
        axis.setCategorys(xDimensions);
        axis.setPosition(Position.bottom);
        axis.setPropValue("nameGap", (Object)"10");
        HashMap<String, Object> axisTick = new HashMap<String, Object>();
        axisTick.put("interval", "0");
        axisTick.put("show", Boolean.TRUE);
        axis.setPropValue("axisTick", axisTick);
        HashMap<String, Comparable<Boolean>> axisLabel = new HashMap<String, Comparable<Boolean>>();
        axisLabel.put("show", Boolean.TRUE);
        axisLabel.put("interval", Integer.valueOf(0));
        axis.setPropValue("axisLabel", axisLabel);
        this.setLineColor(axis, "#999999");
        return axis;
    }

    private void setHandleChartData(CustomChart customchart) {
        Axis barY = customchart.createYAxis("", AxisType.value);
        barY.setPropValue("nameGap", (Object)"8");
        barY.setName(ResManager.loadKDString((String)"\u5355\u4f4d(\u6761)", (String)"InspectBarAnalysisPlugin_0", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
        Map<String, Long[]> handleTaskData = this.getHandleChartData();
        int index = 0;
        Number[] normal = null;
        Number[] exp = null;
        for (Map.Entry<String, Long[]> entry : handleTaskData.entrySet()) {
            String materialTypeName = entry.getKey();
            BarSeries expireSeries = customchart.createBarSeries(materialTypeName);
            expireSeries.setBarWidth("20px");
            Number[] temp = entry.getValue();
            if (ResManager.loadKDString((String)"\u6b63\u5e38", (String)"InspectBarAnalysisPlugin_1", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]).equals(materialTypeName)) {
                normal = temp;
            } else {
                exp = temp;
            }
            expireSeries.setStack("Ad");
            expireSeries.setData(temp);
            expireSeries.setColor(this.getColorList().get(index));
            Label label = new Label();
            label.setShow(false);
            expireSeries.setLabel(label);
            ++index;
        }
        HashMap<String, Boolean> axisTick = new HashMap<String, Boolean>();
        axisTick.put("show", Boolean.TRUE);
        barY.setPropValue("axisTick", axisTick);
        HashMap splitLine = new HashMap();
        HashMap<String, String> lineStyle = new HashMap<String, String>();
        lineStyle.put("type", "dotted");
        lineStyle.put("color", "#8A8B99");
        splitLine.put("lineStyle", lineStyle);
        barY.setPropValue("splitLine", splitLine);
        this.setLineColor(barY, "#8A8B99");
        HashMap<String, String> barAxisLabel = new HashMap<String, String>();
        barAxisLabel.put("formatter", "{value}");
        barY.setPropValue("axisLabel", barAxisLabel);
        Axis lineY = customchart.createYAxis("", AxisType.value);
        lineY.setPropValue("nameGap", (Object)"8");
        lineY.setName(ResManager.loadKDString((String)"\u5f02\u5e38\u7387", (String)"InspectBarAnalysisPlugin_2", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
        lineY.setPropValue("show", (Object)Boolean.TRUE);
        lineY.setPropValue("axisTick", axisTick);
        lineY.setPropValue("splitLine", splitLine);
        this.setLineColor(lineY, "#8A8B99");
        HashMap<String, String> lineAxisLabel = new HashMap<String, String>();
        lineAxisLabel.put("formatter", "{value}%");
        lineY.setPropValue("axisLabel", lineAxisLabel);
        LineSeries lineSeries = customchart.createLineSeries(ResManager.loadKDString((String)"\u5f02\u5e38\u7387", (String)"InspectBarAnalysisPlugin_2", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
        Number[] number = new Double[14];
        for (int i = 0; i < 14; ++i) {
            BigDecimal total;
            Number normal_i = 0L;
            if (normal != null) {
                normal_i = normal[i];
            }
            Number exp_i = 0L;
            if (exp != null) {
                exp_i = exp[i];
            }
            if (BigDecimal.ZERO.compareTo(total = BigDecimal.valueOf((Long)normal_i).add(BigDecimal.valueOf((Long)exp_i))) == 0) {
                number[i] = 0.0;
                continue;
            }
            BigDecimal multiply = BigDecimal.valueOf((Long)exp_i).divide(total, 4, RoundingMode.HALF_UP).multiply(new BigDecimal("100"));
            number[i] = multiply.doubleValue();
        }
        lineSeries.setLineColor("#45DAD1");
        lineSeries.setData(number);
        lineSeries.setYAxisIndex(1);
    }

    private List<String> getColorList() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("#1890FF");
        list.add("#FFA940");
        return list;
    }

    private Map<String, Long[]> getHandleChartData() {
        HashMap<String, Long[]> map = new HashMap<String, Long[]>(16);
        Long[] normal = new Long[14];
        Long[] exp = new Long[14];
        QFilter logQFilter = this.getQFilter();
        DataSet inspectLog = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"msbd_inspectlog", (String)"exetime,entryentity.inspectdetail", (QFilter[])logQFilter.toArray(), null);
        ArrayList<InspectAnalysisInfo> analysisInfoList = new ArrayList<InspectAnalysisInfo>(16);
        for (Row row : inspectLog) {
            Date exeTime = row.getDate("exetime");
            String inspectDetailStr = row.getString("entryentity.inspectdetail");
            if (inspectDetailStr == null || "".equals(inspectDetailStr)) continue;
            Map inspectDetail = (Map)SerializationUtils.fromJsonString((String)inspectDetailStr, Map.class);
            String bizDate = DateUtils.dateFormat(exeTime, "yyyy-MM-dd");
            Object totalNumObj = inspectDetail.get("inspect_unit_totalnum");
            if (totalNumObj == null) continue;
            Long totalNum = (long)((Integer)totalNumObj);
            Long expNum = (long)((Integer)inspectDetail.get("inspect_unit_expnum"));
            long normalNum = totalNum - expNum;
            analysisInfoList.add(new InspectAnalysisInfo(bizDate, totalNum, expNum, normalNum));
        }
        Map<String, Long> normalMap = analysisInfoList.stream().collect(Collectors.groupingBy(InspectAnalysisInfo::getInspectDate, Collectors.summingLong(InspectAnalysisInfo::getNormalNum)));
        for (int i = 0; i < 14; ++i) {
            String currentDateStr = DateUtils.getCurrentDayStr(i);
            Long num = normalMap.get(currentDateStr);
            normal[i] = num == null ? Long.valueOf(0L) : num;
        }
        map.put(ResManager.loadKDString((String)"\u6b63\u5e38", (String)"InspectBarAnalysisPlugin_1", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), normal);
        Map<String, Long> expMap = analysisInfoList.stream().collect(Collectors.groupingBy(InspectAnalysisInfo::getInspectDate, Collectors.summingLong(InspectAnalysisInfo::getExpNum)));
        for (int i = 0; i < 14; ++i) {
            String currentDateStr = DateUtils.getCurrentDayStr(i);
            Long num = expMap.get(currentDateStr);
            exp[i] = num == null ? Long.valueOf(0L) : num;
        }
        map.put(ResManager.loadKDString((String)"\u5f02\u5e38", (String)"InspectBarAnalysisPlugin_3", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), exp);
        return map;
    }

    private void setLineColor(Axis axix, String color) {
        HashMap axisLineMap = new HashMap();
        HashMap<String, String> lineStyleMap = new HashMap<String, String>();
        lineStyleMap.put("color", color);
        axisLineMap.put("lineStyle", lineStyleMap);
        axix.setPropValue("axisLine", axisLineMap);
    }
}

