/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.datamanage.formplugin.echart;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.msbd.datamanage.common.util.DateUtils;
import kd.mpscmm.msbd.datamanage.formplugin.echart.InspectCommonChartPlugin;

public class InspectBoardPlugin
extends InspectCommonChartPlugin
implements ProgresssListener {
    public void registerListener(EventObject event) {
        ProgressBar bar = (ProgressBar)this.getView().getControl("progressbarap");
        bar.addProgressListener((ProgresssListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        IDataModel model = this.getModel();
        LocalDateTime todayStart = LocalDateTime.of(LocalDate.now().minusDays(13L), LocalTime.MIN);
        LocalDateTime todayEnd = LocalDateTime.of(LocalDate.now(), LocalTime.MAX);
        model.setValue("startdate", (Object)todayStart);
        model.setValue("enddate", (Object)todayEnd);
        ProgressBar bar = (ProgressBar)this.getView().getControl("progressbarap");
        bar.start();
        this.initMainNum();
        this.initFixedNum();
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if ("refresh".equals(itemKey)) {
            this.initMainNum();
            this.initFixedNum();
            ProgressBar bar = (ProgressBar)this.getView().getControl("progressbarap");
            bar.start();
        }
    }

    private void initMainNum() {
        String userName = RequestContext.get().getUserName();
        String userTitle = userName.concat(" ").concat(DateUtils.getCurrentDateStr1());
        this.setLabelApText("username", userTitle);
        QFilter qFilter = this.getQFilter();
        DataSet inspectUnit = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"msbd_inspectlog", (String)"entryentity.inspectunit inspectunit", (QFilter[])qFilter.toArray(), null);
        int unitNum = inspectUnit.distinct().count("inspectunit", true);
        this.setLabelApText("unitnum", unitNum);
        DataSet inspectUnitEntity = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"msbd_inspectlog", (String)"entryentity.inspectunit.entity  entity", (QFilter[])qFilter.toArray(), null);
        int billNum = inspectUnitEntity.distinct().count("entity", true);
        this.setLabelApText("entirynum", billNum);
        DataSet inspectApp = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"msbd_inspectlog", (String)"bizappid", (QFilter[])qFilter.toArray(), null);
        int bizAppIdNum = inspectApp.distinct().count("bizappid", true);
        this.setLabelApText("bizappidnum", bizAppIdNum);
    }

    private void initFixedNum() {
        DynamicObject[] inspectLogList;
        QFilter logQFilter = this.getQFilter();
        DataSet inspectUnit = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"msbd_inspectlog", (String)"entryentity.inspectunit inspectunit", (QFilter[])logQFilter.toArray(), null);
        DataSet distinctInspectUnit = inspectUnit.distinct();
        ArrayList<Long> inspectUnitIdList = new ArrayList<Long>(16);
        for (Row row2 : distinctInspectUnit) {
            Long inspectUnitId = row2.getLong("inspectunit");
            inspectUnitIdList.add(inspectUnitId);
        }
        QFilter inspectUnitQFilter = new QFilter("id", "in", inspectUnitIdList);
        DynamicObject[] inspectUnitList = BusinessDataServiceHelper.load((String)"msbd_inspectunit", (String)"id,enable,validentity.id,pluginentry.id,msentry.id", (QFilter[])inspectUnitQFilter.toArray());
        int totalRuleNum = 0;
        int disableRuleNum = 0;
        for (DynamicObject unit : inspectUnitList) {
            int msEntryNum;
            int pluginEntryNum;
            int validEntityNum;
            boolean enable = unit.getBoolean("enable");
            if (enable) {
                validEntityNum = unit.getDynamicObjectCollection("validentity").size();
                pluginEntryNum = unit.getDynamicObjectCollection("pluginentry").size();
                msEntryNum = unit.getDynamicObjectCollection("msentry").size();
                totalRuleNum = totalRuleNum + validEntityNum + pluginEntryNum + msEntryNum;
                continue;
            }
            validEntityNum = unit.getDynamicObjectCollection("validentity").size();
            pluginEntryNum = unit.getDynamicObjectCollection("pluginentry").size();
            msEntryNum = unit.getDynamicObjectCollection("msentry").size();
            disableRuleNum = disableRuleNum + validEntityNum + pluginEntryNum + msEntryNum;
        }
        this.setLabelApText("totalrulenum", totalRuleNum);
        this.setLabelApText("disablerulenum", disableRuleNum);
        int runningRuleNum = 0;
        int failureRuleNum = 0;
        for (DynamicObject inspectLog : inspectLogList = BusinessDataServiceHelper.load((String)"msbd_inspectlog", (String)"id,exestatus,entryentity.entrystatus", (QFilter[])logQFilter.toArray())) {
            String exeStatus = inspectLog.getString("exestatus");
            if ("A".equals(exeStatus)) {
                DynamicObjectCollection entryEntity = inspectLog.getDynamicObjectCollection("entryentity");
                runningRuleNum += entryEntity.size();
            }
            List entryStatus = inspectLog.getDynamicObjectCollection("entryentity").stream().filter(row -> "C".equals(row.getString("entrystatus"))).collect(Collectors.toList());
            failureRuleNum += entryStatus.size();
        }
        this.setLabelApText("runingrulenum", runningRuleNum);
        this.setLabelApText("failurerulenum", failureRuleNum);
    }

    public void onProgress(ProgressEvent progressEvent) {
        QFilter logQFilter = this.getQFilter();
        DataSet logObj = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"msbd_inspectlog", (String)"entryentity.inspectdetail inspectdetail,entryentity.id  id", (QFilter[])logQFilter.toArray(), null);
        BigDecimal expBillNum = new BigDecimal("0");
        BigDecimal totalBillNum = new BigDecimal("0");
        for (Row row : logObj) {
            Map inspectDetailMap;
            Integer total;
            String inspectDetail = row.getString("inspectdetail");
            if (inspectDetail == null || "".equals(inspectDetail) || (total = (Integer)(inspectDetailMap = (Map)SerializationUtils.fromJsonString((String)inspectDetail, Map.class)).get("inspect_unit_totalnum")) == null) continue;
            totalBillNum = totalBillNum.add(BigDecimal.valueOf(total.intValue()));
            Integer exp = (Integer)inspectDetailMap.get("inspect_unit_expnum");
            expBillNum = expBillNum.add(BigDecimal.valueOf(exp.intValue()));
        }
        BigDecimal normalNum = totalBillNum.subtract(expBillNum);
        BigDecimal percent = new BigDecimal("0");
        if (totalBillNum.compareTo(BigDecimal.ZERO) != 0) {
            percent = normalNum.divide(totalBillNum, 4, RoundingMode.HALF_UP).multiply(new BigDecimal("100"));
        }
        int v = percent.intValue();
        progressEvent.setProgress(v);
        String str = String.valueOf(v).concat("%");
        this.setLabelApText("normalpercent", str);
        String str1 = ResManager.loadKDString((String)"\u6b63\u5e38", (String)"InspectBoardPlugin_0", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]).concat(":").concat(String.valueOf(normalNum));
        this.setLabelApText("normalcount", str1);
        String str2 = ResManager.loadKDString((String)"\u5f02\u5e38", (String)"InspectBoardPlugin_1", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]).concat(":").concat(String.valueOf(expBillNum));
        this.setLabelApText("expcount", str2);
        ProgressBar bar = (ProgressBar)this.getView().getControl("progressbarap");
        bar.stop();
    }
}

