/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.datamanage.inspect.ap;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.msbd.datamanage.business.AbstractDmfPlugin;
import kd.mpscmm.msbd.datamanage.common.pojo.InspectOptionInfo;

public class FinApPremiumPlugin
extends AbstractDmfPlugin {
    private static final Log logger = LogFactory.getLog(FinApPremiumPlugin.class);

    @Override
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("sourcebillid");
        InspectOptionInfo inspectOptionInfo = this.getInspectOptionInfo();
        inspectOptionInfo.setBizDataType(1);
    }

    @Override
    public List<OperateErrorInfo> exeInspectUnitExtPlugin(DataSet args) {
        logger.info("FinApPremiumPlugin:\u63d2\u4ef6\u5de1\u68c0\u6267\u884c\u5f00\u59cb\u65f6\u95f4\uff1a{}", (Object)FORMATTER.format(LocalDateTime.now()));
        ArrayList<OperateErrorInfo> errorInfo = new ArrayList<OperateErrorInfo>(10);
        HashSet<Long> sourceBillIds = new HashSet<Long>(10);
        for (Row row : args) {
            sourceBillIds.add(row.getLong("sourcebillid"));
        }
        QFilter idFilter = new QFilter("id", "in", sourceBillIds);
        QFilter isnotPremiumFilter = new QFilter("ispremium", "=", (Object)Boolean.FALSE);
        DataSet finBills = QueryServiceHelper.queryDataSet((String)"FinApPremiumPlugin.queryFin", (String)"ap_finapbill", (String)"id,billno,premiumamt", (QFilter[])new QFilter[]{idFilter, isnotPremiumFilter}, null);
        HashSet<Long> billIds = new HashSet<Long>(10);
        for (Row row : finBills.copy()) {
            billIds.add(row.getLong("id"));
        }
        QFilter sourceBillIdFilter = new QFilter("sourcebillid", "in", billIds);
        QFilter isPremiumFilter = new QFilter("ispremium", "=", (Object)Boolean.TRUE);
        DataSet premiumBills = QueryServiceHelper.queryDataSet((String)"FinApPremiumPlugin.queryPremium", (String)"ap_finapbill", (String)"sourcebillid,pricetaxtotal", (QFilter[])new QFilter[]{sourceBillIdFilter, isPremiumFilter}, null);
        premiumBills = premiumBills.groupBy(new String[]{"sourcebillid"}).sum("pricetaxtotal").finish();
        DataSet finish = premiumBills.leftJoin(finBills).on("sourcebillid", "id").select(new String[]{"id", "billno", "premiumamt", "pricetaxtotal"}).finish();
        for (Row row : finish) {
            BigDecimal premiumPriceTaxTotal;
            BigDecimal sourceBillPremiumAmt = row.getBigDecimal("premiumamt");
            if (0 == sourceBillPremiumAmt.compareTo(premiumPriceTaxTotal = row.getBigDecimal("pricetaxtotal"))) continue;
            String template = ResManager.loadKDString((String)"\u8d22\u52a1\u5e94\u4ed8\u5355%s\u7684\u8d28\u4fdd\u91d1\u91d1\u989d\u4e0e\u4e0b\u6e38\u8d28\u4fdd\u91d1\u5355\u636e\u5e94\u4ed8\u91d1\u989d\u6c47\u603b\u4e0d\u4e00\u81f4\u3002", (String)"FinApPremiumPlugin_0", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]);
            String billNo = row.getString("billno");
            String msg = String.format(template, billNo);
            errorInfo.add(this.getExpMsg(this.getClass().getSimpleName(), msg, row.getLong("id"), 0L, billNo));
        }
        logger.info("FinApPremiumPlugin:\u672c\u6279\u6b21\u5de1\u68c0\u6267\u884c\u7ed3\u675f\u65f6\u95f4\uff1a{},\u6570\u636e\u5f02\u5e38\u7684\u6570\u91cf\u662f{}", (Object)FORMATTER.format(LocalDateTime.now()), (Object)errorInfo.size());
        return errorInfo;
    }
}

