/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.datamanage.inspect.ap;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.mpscmm.msbd.datamanage.business.AbstractDmfPlugin;
import kd.mpscmm.msbd.datamanage.common.pojo.InspectOptionInfo;

public class PayApplyAmountCheckPlugin
extends AbstractDmfPlugin {
    private static final Log logger = LogFactory.getLog(PayApplyAmountCheckPlugin.class);

    @Override
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("id");
        fieldKeys.add("billno");
        fieldKeys.add("entry.e_applyamount");
        fieldKeys.add("entry.e_approvedamt");
        fieldKeys.add("applyamount");
        fieldKeys.add("approvalamount");
        fieldKeys.add("entry.lockedamt");
        fieldKeys.add("entry.e_paidamt");
        fieldKeys.add("entry.id");
        InspectOptionInfo inspectOptionInfo = this.getInspectOptionInfo();
        inspectOptionInfo.setBizDataType(1);
    }

    @Override
    public List<OperateErrorInfo> exeInspectUnitExtPlugin(DataSet args) {
        logger.info("ApplyPayAmountCheckPlugin:\u63d2\u4ef6\u5de1\u68c0\u6267\u884c\u5f00\u59cb\u65f6\u95f4\uff1a{}", (Object)FORMATTER.format(LocalDateTime.now()));
        ArrayList<OperateErrorInfo> errorInfo = new ArrayList<OperateErrorInfo>(10);
        HashSet<Long> isChecked = new HashSet<Long>();
        HashMap idAmountMap = new HashMap(2);
        DataSet temp = args.copy();
        DataSet entryAmountSum = temp.groupBy(new String[]{"id"}).sum("entry.e_applyamount").sum("entry.e_approvedamt").finish();
        for (Row billAmounts : entryAmountSum) {
            Long id = billAmounts.getLong("id");
            BigDecimal entryApplyAmount = billAmounts.getBigDecimal("entry.e_applyamount");
            BigDecimal entryApprovedAmt = billAmounts.getBigDecimal("entry.e_approvedamt");
            HashMap<String, BigDecimal> amountMap = new HashMap<String, BigDecimal>(2);
            amountMap.put("entryapplyamount", entryApplyAmount);
            amountMap.put("entryapprovedamt", entryApprovedAmt);
            idAmountMap.put(id, amountMap);
        }
        for (Row row : args) {
            String billno = row.getString("billno");
            Long billId = row.getLong("id");
            if (isChecked.add(billId)) {
                this.compare(billno, row, "applyamount", "approvalamount", ResManager.loadKDString((String)"\u5355\u636e\u5934\u6838\u51c6\u91d1\u989d\u987b\u540c\u7533\u8bf7\u91d1\u989d\u65b9\u5411\u4e00\u81f4\u4e14\u4e0d\u80fd\u5927\u4e8e\u7533\u8bf7\u91d1\u989d\u3002", (String)"PayApplyAmountCheckPlugin_0", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), errorInfo, billId, 0L);
                Map amountMap = (Map)idAmountMap.get(billId);
                BigDecimal entryApplyAmount = (BigDecimal)amountMap.get("entryapplyamount");
                BigDecimal entryApprovedAmt = (BigDecimal)amountMap.get("entryapprovedamt");
                this.compare(billno, entryApplyAmount, row.getBigDecimal("applyamount"), ResManager.loadKDString((String)"\u660e\u7ec6\u7533\u8bf7\u91d1\u989d\u5408\u8ba1\u4e0e\u5355\u636e\u5934\u7533\u8bf7\u91d1\u989d\u4e0d\u4e00\u81f4\u3002", (String)"PayApplyAmountCheckPlugin_1", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), errorInfo, billId, 0L);
                this.compare(billno, entryApprovedAmt, row.getBigDecimal("approvalamount"), ResManager.loadKDString((String)"\u660e\u7ec6\u6838\u51c6\u91d1\u989d\u5408\u8ba1\u4e0e\u5355\u636e\u5934\u6838\u51c6\u91d1\u989d\u5408\u8ba1\u4e0d\u4e00\u81f4\u3002", (String)"PayApplyAmountCheckPlugin_2", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), errorInfo, billId, 0L);
            }
            Long entryId = row.getLong("entry.id");
            this.compare(billno, row, "entry.e_applyamount", "entry.e_approvedamt", ResManager.loadKDString((String)"\u660e\u7ec6\u5206\u5f55\u6838\u51c6\u91d1\u989d\u987b\u540c\u7533\u8bf7\u91d1\u989d\u65b9\u5411\u4e00\u81f4\u4e14\u4e0d\u80fd\u5927\u4e8e\u7533\u8bf7\u91d1\u989d\u3002", (String)"PayApplyAmountCheckPlugin_3", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), errorInfo, billId, entryId);
            this.compare(billno, row, "entry.e_approvedamt", "entry.lockedamt", ResManager.loadKDString((String)"\u660e\u7ec6\u5206\u5f55\u5df2\u9501\u5b9a\u91d1\u989d\u987b\u540c\u6838\u51c6\u91d1\u989d\u65b9\u5411\u4e00\u81f4\u4e14\u4e0d\u80fd\u5927\u4e8e\u6838\u51c6\u91d1\u989d\u3002", (String)"PayApplyAmountCheckPlugin_4", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), errorInfo, billId, entryId);
            this.compare(billno, row, "entry.lockedamt", "entry.e_paidamt", ResManager.loadKDString((String)"\u660e\u7ec6\u5206\u5f55\u5df2\u4ed8\u91d1\u989d\u987b\u540c\u5df2\u9501\u5b9a\u91d1\u989d\u65b9\u5411\u4e00\u81f4\u4e14\u4e0d\u80fd\u5927\u4e8e\u5df2\u9501\u5b9a\u91d1\u989d\u3002", (String)"PayApplyAmountCheckPlugin_5", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), errorInfo, billId, entryId);
        }
        logger.info("ApplyPayAmountCheckPlugin\uff1a\u672c\u6279\u6b21\u5de1\u68c0\u6267\u884c\u7ed3\u675f\u65f6\u95f4\uff1a{}\uff0c\u6570\u636e\u5f02\u5e38\u7684\u6570\u91cf\u662f{}", (Object)FORMATTER.format(LocalDateTime.now()), (Object)errorInfo.size());
        return errorInfo;
    }

    private void compare(String billNo, Row row, String amountKey1, String amountKey2, String msg, List<OperateErrorInfo> errorInfo, Long billId, Long entryId) {
        BigDecimal amount2;
        BigDecimal amount1 = row.getBigDecimal(amountKey1);
        if (amount1.multiply(amount2 = row.getBigDecimal(amountKey2)).compareTo(BigDecimal.ZERO) >= 0) {
            if (amount1.abs().compareTo(amount2.abs()) < 0 && amount2.abs().subtract(amount1.abs()).abs().compareTo(BigDecimal.valueOf(0.1)) >= 0) {
                errorInfo.add(this.getExpMsg(this.getClass().getSimpleName(), msg, billId, entryId, billNo));
            }
        } else if (amount2.abs().compareTo(BigDecimal.valueOf(0.1)) > 0) {
            errorInfo.add(this.getExpMsg(this.getClass().getSimpleName(), msg, billId, entryId, billNo));
        }
    }

    private void compare(String billNo, BigDecimal amount1, BigDecimal amount2, String msg, List<OperateErrorInfo> errorInfo, Long billId, Long entryId) {
        BigDecimal subtract = amount1.abs().subtract(amount2.abs());
        if (amount1.multiply(amount2).compareTo(BigDecimal.ZERO) < 0 || subtract.abs().subtract(new BigDecimal("0.1")).compareTo(BigDecimal.ZERO) > 0) {
            errorInfo.add(this.getExpMsg(this.getClass().getSimpleName(), msg, billId, entryId, billNo));
        }
    }
}

