/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.datamanage.inspect.common;

import java.lang.constant.Constable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.mpscmm.msbd.common.utils.CommonUtils;
import kd.mpscmm.msbd.datamanage.business.AbstractDmfPlugin;
import kd.mpscmm.msbd.datamanage.business.helper.DmfSchemeExecuteHelper;
import kd.mpscmm.msbd.datamanage.common.pojo.FixLogInfo;
import kd.mpscmm.msbd.datamanage.inspect.common.ArWriteBackScmcHelper;

public class ArWriteBackSalOrderHelper {
    private static final Log logger = LogFactory.getLog(ArWriteBackSalOrderHelper.class);

    public static List<Map<String, Object>> getWbData(DataSet args, Map<Long, Map<String, Object>> salOrderBillDataMap, String type) {
        ArrayList<Map<String, Object>> paramList = new ArrayList<Map<String, Object>>(16);
        if (args == null) {
            return paramList;
        }
        for (Row row : args) {
            HashMap<String, Constable> param = new HashMap<String, Constable>(16);
            param.put("mainbillid", row.getLong("id"));
            param.put("asstid", row.getLong("customer"));
            boolean internal_company = false;
            Long company = row.getLong("internal_company");
            if (company != null && company != 0L) {
                internal_company = true;
            }
            param.put("internal_company", Boolean.valueOf(internal_company));
            param.put("mainbillentryid", row.getLong("entryid"));
            param.put("unit", row.getLong("unit"));
            param.put("settleorgid", row.getLong("org"));
            paramList.add(param);
            HashMap<String, Object> map = new HashMap<String, Object>(8);
            map.put("billno", row.getString("billno"));
            map.put("id", row.getLong("id"));
            map.put("seq", row.getInteger("seq"));
            map.put("sobaseqty", row.getBigDecimal("sobaseqty"));
            map.put("soqty", row.getBigDecimal("soqty"));
            map.put("soamount", row.getBigDecimal("soamount"));
            salOrderBillDataMap.put(row.getLong("entryid"), map);
        }
        logger.info("\u8c03\u7528\u5e94\u6536\u53cd\u5199\u91d1\u989d\u6570\u91cf\u65b9\u6cd5\u53c2\u6570paramList:" + SerializationUtils.toJsonString(paramList));
        ArrayList<Map<String, Object>> wbResult = new ArrayList(4);
        if ("ar".equals(type)) {
            wbResult = ArWriteBackScmcHelper.constructReceivableData(paramList);
        }
        if ("revCfm".equals(type)) {
            wbResult = ArWriteBackScmcHelper.constructConfirmData(paramList);
        }
        logger.info("\u8c03\u7528\u5e94\u6536\u53cd\u5199\u91d1\u989d\u6570\u91cf\u65b9\u6cd5\u8fd4\u56de\u503cwbResult:" + SerializationUtils.toJsonString(wbResult));
        return wbResult;
    }

    public static List<OperateErrorInfo> checkErrorData(List<Map<String, Object>> wbResult, Map<Long, Map<String, Object>> amountAndQtyMap, AbstractDmfPlugin inpectPlugin, String type) {
        ArrayList<OperateErrorInfo> errorInfo = new ArrayList<OperateErrorInfo>(16);
        if (wbResult != null && wbResult.size() > 0) {
            for (Map<String, Object> resultMap : wbResult) {
                Long mainbillentryid = (Long)resultMap.get("mainbillentryid");
                BigDecimal qty = (BigDecimal)resultMap.get("qty");
                BigDecimal baseqty = (BigDecimal)resultMap.get("baseqty");
                BigDecimal amount = (BigDecimal)resultMap.get("amount");
                Map<String, Object> soMap = amountAndQtyMap.get(mainbillentryid);
                BigDecimal soAmount = (BigDecimal)soMap.get("soamount");
                BigDecimal soQty = (BigDecimal)soMap.get("soqty");
                BigDecimal soBaseQty = (BigDecimal)soMap.get("sobaseqty");
                boolean isError = false;
                if (soAmount == null || soBaseQty == null || amount == null || baseqty == null) continue;
                String msg = String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c", (String)"PurOrderReceiveQtyAmountPlugin_10", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), soMap.get("seq"));
                msg = msg + "\uff0c";
                if (soAmount.compareTo(amount) != 0) {
                    String amountMsg;
                    isError = true;
                    if ("ar".equals(type)) {
                        amountMsg = String.format(ResManager.loadKDString((String)"\u5b58\u5728\u95ee\u9898\u4e00\uff1a\u5e94\u6536\u91d1\u989d\uff08%1$s\uff09\u4e0e\u8ba1\u7b97\u51fa\u6765\u7684\u5e94\u6536\u91d1\u989d\uff08%2$s\uff09\u4e0d\u4e00\u81f4\u3002", (String)"ArWriteBackSalOrderHelper_0", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), soAmount, amount);
                        msg = msg + amountMsg;
                    }
                    if ("revCfm".equals(type)) {
                        amountMsg = String.format(ResManager.loadKDString((String)"\u5b58\u5728\u95ee\u9898\u4e00\uff1a\u5df2\u786e\u8ba4\u91d1\u989d\uff08%1$s\uff09\u4e0e\u8ba1\u7b97\u51fa\u6765\u7684\u5df2\u786e\u8ba4\u91d1\u989d\uff08%2$s\uff09\u4e0d\u4e00\u81f4\u3002", (String)"ArWriteBackSalOrderHelper_1", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), soAmount, amount);
                        msg = msg + amountMsg;
                    }
                }
                if (soBaseQty.compareTo(baseqty) != 0) {
                    String baseqtyMsg;
                    isError = true;
                    if ("ar".equals(type)) {
                        baseqtyMsg = String.format(ResManager.loadKDString((String)"\u5b58\u5728\u95ee\u9898\u4e8c\uff1a\u5e94\u6536\u57fa\u672c\u6570\u91cf\uff08%1$s\uff09\u4e0e\u8ba1\u7b97\u51fa\u6765\u7684\u5e94\u6536\u57fa\u672c\u6570\u91cf\uff08%2$s\uff09\u4e0d\u4e00\u81f4\u3002", (String)"ArWriteBackSalOrderHelper_2", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), soBaseQty, baseqty);
                        msg = msg + baseqtyMsg;
                    }
                    if ("revCfm".equals(type)) {
                        baseqtyMsg = String.format(ResManager.loadKDString((String)"\u5b58\u5728\u95ee\u9898\u4e8c\uff1a\u5df2\u786e\u8ba4\u57fa\u672c\u6570\u91cf\uff08%1$s\uff09\u4e0e\u8ba1\u7b97\u51fa\u6765\u7684\u5df2\u786e\u8ba4\u57fa\u672c\u6570\u91cf\uff08%2$s\uff09\u4e0d\u4e00\u81f4\u3002", (String)"ArWriteBackSalOrderHelper_3", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), soBaseQty, baseqty);
                        msg = msg + baseqtyMsg;
                    }
                }
                if (soQty.compareTo(qty) != 0) {
                    String qtyMsg;
                    isError = true;
                    if ("ar".equals(type)) {
                        qtyMsg = String.format(ResManager.loadKDString((String)"\u5b58\u5728\u95ee\u9898\u4e09\uff1a\u5e94\u6536\u6570\u91cf\uff08%1$s\uff09\u4e0e\u8ba1\u7b97\u51fa\u6765\u7684\u5e94\u6536\u6570\u91cf\uff08%2$s\uff09\u4e0d\u4e00\u81f4\u3002", (String)"ArWriteBackSalOrderHelper_4", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), soQty, qty);
                        msg = msg + qtyMsg;
                    }
                    if ("revCfm".equals(type)) {
                        qtyMsg = String.format(ResManager.loadKDString((String)"\u5b58\u5728\u95ee\u9898\u4e09\uff1a\u5df2\u786e\u8ba4\u6570\u91cf\uff08%1$s\uff09\u4e0e\u8ba1\u7b97\u51fa\u6765\u7684\u5df2\u786e\u8ba4\u6570\u91cf\uff08%2$s\uff09\u4e0d\u4e00\u81f4\u3002", (String)"ArWriteBackSalOrderHelper_5", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), soQty, qty);
                        msg = msg + qtyMsg;
                    }
                }
                if (!isError) continue;
                errorInfo.add(inpectPlugin.getExpMsg(inpectPlugin.getClass().getName(), msg, soMap.get("id"), mainbillentryid, (String)soMap.get("billno")));
            }
        }
        return errorInfo;
    }

    public static List<FixLogInfo> fixBizDataBySql(List<Map<String, Object>> wbResult, Map<Long, Map<String, Object>> salOrderBillDataMap, String type) {
        ArrayList<FixLogInfo> fixLogCol = new ArrayList<FixLogInfo>(16);
        ArrayList<Object[]> parameterList = new ArrayList<Object[]>();
        if (wbResult != null && wbResult.size() > 0) {
            int updateDataNum;
            for (Map<String, Object> resultMap : wbResult) {
                Object[] parameter = new Object[]{resultMap.get("baseqty"), resultMap.get("qty"), resultMap.get("amount"), resultMap.get("mainbillentryid")};
                parameterList.add(parameter);
                Map<String, Object> soMap = salOrderBillDataMap.get(parameter[3]);
                if ("ar".equals(type)) {
                    fixLogCol.add(new FixLogInfo((Long)resultMap.get("mainbillid"), (String)soMap.get("billno"), (Integer)soMap.get("seq"), (Long)resultMap.get("mainbillentryid"), "basearqty", ResManager.loadKDString((String)"\u5e94\u6536\u57fa\u672c\u6570\u91cf", (String)"ArWriteBackSalOrderHelper_6", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), soMap.get("sobaseqty").toString(), parameter[0].toString()));
                    fixLogCol.add(new FixLogInfo((Long)resultMap.get("mainbillid"), (String)soMap.get("billno"), (Integer)soMap.get("seq"), (Long)resultMap.get("mainbillentryid"), "basearqty", ResManager.loadKDString((String)"\u5e94\u6536\u6570\u91cf", (String)"ArWriteBackSalOrderHelper_7", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), soMap.get("soqty").toString(), parameter[1].toString()));
                    fixLogCol.add(new FixLogInfo((Long)resultMap.get("mainbillid"), (String)soMap.get("billno"), (Integer)soMap.get("seq"), (Long)resultMap.get("mainbillentryid"), "aramount", ResManager.loadKDString((String)"\u5e94\u6536\u91d1\u989d", (String)"ArWriteBackSalOrderHelper_8", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), soMap.get("soamount").toString(), parameter[2].toString()));
                }
                if (!"revCfm".equals(type)) continue;
                fixLogCol.add(new FixLogInfo((Long)resultMap.get("mainbillid"), (String)soMap.get("billno"), (Integer)soMap.get("seq"), (Long)resultMap.get("mainbillentryid"), "confirmbaseqty", ResManager.loadKDString((String)"\u5df2\u786e\u8ba4\u57fa\u672c\u6570\u91cf", (String)"ArWriteBackSalOrderHelper_9", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), soMap.get("sobaseqty").toString(), parameter[0].toString()));
                fixLogCol.add(new FixLogInfo((Long)resultMap.get("mainbillid"), (String)soMap.get("billno"), (Integer)soMap.get("seq"), (Long)resultMap.get("mainbillentryid"), "confirmqty", ResManager.loadKDString((String)"\u5df2\u786e\u8ba4\u6570\u91cf", (String)"ArWriteBackSalOrderHelper_10", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), soMap.get("soqty").toString(), parameter[1].toString()));
                fixLogCol.add(new FixLogInfo((Long)resultMap.get("mainbillid"), (String)soMap.get("billno"), (Integer)soMap.get("seq"), (Long)resultMap.get("mainbillentryid"), "confirmamount", ResManager.loadKDString((String)"\u5df2\u786e\u8ba4\u91d1\u989d", (String)"ArWriteBackSalOrderHelper_11", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), soMap.get("soamount").toString(), parameter[2].toString()));
            }
            String updateSql = "";
            if ("ar".equals(type)) {
                updateSql = "update T_SM_SALORDERENTRY_R set fbasearqty=? , fjoinpriceqty=?, faramount=? where fentryid=?";
            }
            if ("revCfm".equals(type)) {
                updateSql = "update T_SM_SALORDERENTRY_R set fconfirmbaseqty=? , fconfirmqty=? , fconfirmamount=? where fentryid=?";
            }
            if ((updateDataNum = parameterList.size()) > 0 && !CommonUtils.isNull((Object)updateSql)) {
                if (updateDataNum > 1000) {
                    List partition = DmfSchemeExecuteHelper.partition(parameterList, 1000);
                    String finalUpdateSql = updateSql;
                    partition.forEach(row -> DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)finalUpdateSql, (List)row));
                } else {
                    DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)updateSql, parameterList);
                }
            }
        }
        return fixLogCol;
    }
}

