/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.datamanage.inspect.common;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mpscmm.msbd.business.helper.MaterialHelper;
import kd.mpscmm.msbd.common.utils.AppCacheUtils;
import kd.mpscmm.msbd.datamanage.business.AbstractDmfPlugin;
import kd.mpscmm.msbd.datamanage.business.helper.DmfSchemeExecuteHelper;
import kd.mpscmm.msbd.datamanage.common.pojo.FixLogInfo;
import kd.mpscmm.msbd.datamanage.common.pojo.InspectOptionInfo;

public class BaseUnitInspectPlugin
extends AbstractDmfPlugin {
    public static final Log logger = LogFactory.getLog(BaseUnitInspectPlugin.class);

    @Override
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        String customParameter = this.getExeDmfUnitInfo().getCustomParameter();
        if (customParameter == null || "".equals(customParameter)) {
            Collections.addAll(e.getFieldKeys(), "id", "billno", "billentry.id", "billentry.seq", "billentry.material", "billentry.material.masterid", "billentry.baseunit", "billentry.baseqty", "billentry.unit", "billentry.qty");
        } else {
            List<String> queryFields = this.getQueryFields();
            e.getFieldKeys().addAll(queryFields);
        }
        InspectOptionInfo inspectOptionInfo = this.getInspectOptionInfo();
        if (inspectOptionInfo != null) {
            inspectOptionInfo.setBillEntrySympol("billentry");
            inspectOptionInfo.setBizDataType(1);
        }
    }

    @Override
    public List<OperateErrorInfo> exeInspectUnitExtPlugin(DataSet args) {
        logger.info("\u63d2\u4ef6\u5de1\u68c0\u6267\u884c\u5f00\u59cb\u65f6\u95f4\uff1a{}", (Object)FORMATTER.format(LocalDateTime.now()));
        ArrayList<OperateErrorInfo> errorInfo = new ArrayList<OperateErrorInfo>();
        String customParameter = this.getExeDmfUnitInfo().getCustomParameter();
        String simpleName = "BaseUnitInspectPlugin";
        try {
            if (customParameter == null || "".equals(customParameter)) {
                for (Row row : args) {
                    BigDecimal unitQty;
                    Long unit;
                    Long materialMasterId;
                    BigDecimal baseQty;
                    String billNo = row.getString("billno");
                    Long baseUnit = row.getLong("billentry.baseunit");
                    if (baseUnit == null || baseUnit.equals(0L)) {
                        String msg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%1$s\u201d\u7684\u884c\u53f7\u201c%2$s\u201d\u5b58\u5728\u57fa\u672c\u8ba1\u91cf\u5355\u4f4d\u4e3a\u7a7a\u3002", (String)"BaseUnitInspectPlugin_0", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), billNo, row.get("billentry.seq"));
                        errorInfo.add(this.getExpMsg(simpleName, msg, row.getLong("id"), row.getLong("billentry.id"), billNo));
                    }
                    if ((baseQty = row.getBigDecimal("billentry.baseqty")) == null || baseQty.compareTo(BigDecimal.ZERO) == 0) {
                        String msg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%1$s\u201d\u7684\u884c\u53f7\u201c%2$s\u201d\u5b58\u5728\u57fa\u672c\u6570\u91cf\u4e3a\u7a7a\u3002", (String)"BaseUnitInspectPlugin_1", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), billNo, row.get("billentry.seq"));
                        errorInfo.add(this.getExpMsg(simpleName, msg, row.getLong("id"), row.getLong("billentry.id"), billNo));
                    }
                    if (baseQty == null || baseUnit == null || baseUnit == 0L || baseQty.compareTo(BigDecimal.ZERO) == 0 || (materialMasterId = row.getLong("billentry.material.masterid")) == null || materialMasterId == 0L || (unit = row.getLong("billentry.unit")) == null || unit == 0L || (unitQty = row.getBigDecimal("billentry.qty")) == null) continue;
                    if (unit.equals(baseUnit)) {
                        if (baseQty.compareTo(unitQty) == 0) continue;
                        String msg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%1$s\u201d\u7684\u884c\u53f7\u201c%2$s\u201d\u5b58\u5728\u8ba1\u91cf\u5355\u4f4d\u6570\u91cf\u4e0e\u57fa\u672c\u8ba1\u91cf\u5355\u4f4d\u6570\u91cf\u8f6c\u6362\u4e0e\u5f53\u524d\u6570\u636e\u4e0d\u4e00\u81f4\u3002", (String)"BaseUnitInspectPlugin_3", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), billNo, row.get("billentry.seq"));
                        errorInfo.add(this.getExpMsg(simpleName, msg, row.getLong("id"), row.getLong("billentry.id"), billNo));
                        continue;
                    }
                    BigDecimal muConvRate = this.getMUConvRate(materialMasterId, unit, baseUnit, true);
                    if (muConvRate.compareTo(BigDecimal.ZERO) == 0) {
                        String msg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%1$s\u201d\u7684\u884c\u53f7\u201c%2$s\u201d\u5b58\u5728\u8ba1\u91cf\u5355\u4f4d\u4e0e\u57fa\u672c\u8ba1\u91cf\u5355\u4f4d\u65e0\u8f6c\u6362\u5173\u7cfb\u3002", (String)"BaseUnitInspectPlugin_2", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), billNo, row.get("billentry.seq"));
                        errorInfo.add(this.getExpMsg(simpleName, msg, row.getLong("id"), row.getLong("billentry.id"), billNo));
                        continue;
                    }
                    BigDecimal baseUnitQty = this.getDesQtyConv(materialMasterId, unit, unitQty, baseUnit, true);
                    if (baseQty.compareTo(baseUnitQty) == 0) continue;
                    String msg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%1$s\u201d\u7684\u884c\u53f7\u201c%2$s\u201d\u5b58\u5728\u8ba1\u91cf\u5355\u4f4d\u6570\u91cf\u4e0e\u57fa\u672c\u8ba1\u91cf\u5355\u4f4d\u6570\u91cf\u8f6c\u6362\u4e0e\u5f53\u524d\u6570\u636e\u4e0d\u4e00\u81f4\u3002", (String)"BaseUnitInspectPlugin_3", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), billNo, row.get("billentry.seq"));
                    errorInfo.add(this.getExpMsg(simpleName, msg, row.getLong("id"), row.getLong("billentry.id"), billNo));
                }
            } else {
                BaseUnitInfo baseUnitInfo = this.getBaseUnitInfo();
                String billentrySympol = baseUnitInfo.getBillentry();
                String billnoSympol = baseUnitInfo.getBillno();
                String baseunitSympol = baseUnitInfo.getBaseunit();
                String baseqtySympol = baseUnitInfo.getBaseqty();
                String unitSympol = baseUnitInfo.getUnit();
                String qtySympol = baseUnitInfo.getQty();
                String materialSympol = baseUnitInfo.getMaterial();
                String masteridSympol = baseUnitInfo.getMasterid();
                String billentryId = billentrySympol.concat(".id");
                String billentrySeq = billentrySympol.concat(".seq");
                String material_masterid = null;
                material_masterid = masteridSympol == null || "".equals(masteridSympol) ? billentrySympol + "." + materialSympol : billentrySympol + "." + materialSympol + "." + masteridSympol;
                for (Row row : args) {
                    BigDecimal unitQty;
                    Long unit;
                    Long materialMasterId;
                    BigDecimal baseQty;
                    String billNo = row.getString(billnoSympol);
                    Long baseUnit = row.getLong(billentrySympol.concat(".").concat(baseunitSympol));
                    if (baseUnit == null || baseUnit.equals(0L)) {
                        String msg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%1$s\u201d\u7684\u884c\u53f7\u201c%2$s\u201d\u5b58\u5728\u57fa\u672c\u8ba1\u91cf\u5355\u4f4d\u4e3a\u7a7a\u3002", (String)"BaseUnitInspectPlugin_0", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), billNo, row.get(billentrySeq));
                        errorInfo.add(this.getExpMsg(this.getClass().getSimpleName(), msg, row.getLong("id"), row.getLong(billentryId), billNo));
                    }
                    if ((baseQty = row.getBigDecimal(billentrySympol.concat(".").concat(baseqtySympol))) == null || baseQty.compareTo(BigDecimal.ZERO) == 0) {
                        String msg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%1$s\u201d\u7684\u884c\u53f7\u201c%2$s\u201d\u5b58\u5728\u57fa\u672c\u6570\u91cf\u4e3a\u7a7a\u3002", (String)"BaseUnitInspectPlugin_1", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), billNo, row.get(billentrySeq));
                        errorInfo.add(this.getExpMsg(this.getClass().getSimpleName(), msg, row.getLong("id"), row.getLong(billentryId), billNo));
                    }
                    if (baseQty == null || baseUnit == null || baseUnit == 0L || baseQty.compareTo(BigDecimal.ZERO) == 0 || (materialMasterId = row.getLong(material_masterid)) == null || materialMasterId == 0L || (unit = row.getLong(billentrySympol + "." + unitSympol)) == null || unit == 0L || (unitQty = row.getBigDecimal(billentrySympol + "." + qtySympol)) == null) continue;
                    if (unit.equals(baseUnit)) {
                        if (baseQty.compareTo(unitQty) == 0) continue;
                        String msg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%1$s\u201d\u7684\u884c\u53f7\u201c%2$s\u201d\u5b58\u5728\u8ba1\u91cf\u5355\u4f4d\u6570\u91cf\u4e0e\u57fa\u672c\u8ba1\u91cf\u5355\u4f4d\u6570\u91cf\u8f6c\u6362\u4e0e\u5f53\u524d\u6570\u636e\u4e0d\u4e00\u81f4\u3002", (String)"BaseUnitInspectPlugin_3", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), billNo, row.get(billentrySeq));
                        errorInfo.add(this.getExpMsg(this.getClass().getSimpleName(), msg, row.getLong("id"), row.getLong(billentryId), billNo));
                        continue;
                    }
                    BigDecimal muConvRate = this.getMUConvRate(materialMasterId, unit, baseUnit, true);
                    if (muConvRate.compareTo(BigDecimal.ZERO) == 0) {
                        String msg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%1$s\u201d\u7684\u884c\u53f7\u201c%2$s\u201d\u5b58\u5728\u8ba1\u91cf\u5355\u4f4d\u4e0e\u57fa\u672c\u8ba1\u91cf\u5355\u4f4d\u65e0\u8f6c\u6362\u5173\u7cfb\u3002", (String)"BaseUnitInspectPlugin_2", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), billNo, row.get(billentrySeq));
                        errorInfo.add(this.getExpMsg(this.getClass().getSimpleName(), msg, row.getLong("id"), row.getLong(billentryId), billNo));
                        continue;
                    }
                    BigDecimal baseUnitQty = this.getDesQtyConv(materialMasterId, unit, unitQty, baseUnit, true);
                    if (baseQty.compareTo(baseUnitQty) == 0) continue;
                    String msg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%1$s\u201d\u7684\u884c\u53f7\u201c%2$s\u201d\u5b58\u5728\u8ba1\u91cf\u5355\u4f4d\u6570\u91cf\u4e0e\u57fa\u672c\u8ba1\u91cf\u5355\u4f4d\u6570\u91cf\u8f6c\u6362\u4e0e\u5f53\u524d\u6570\u636e\u4e0d\u4e00\u81f4\u3002", (String)"BaseUnitInspectPlugin_3", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), billNo, row.get(billentrySeq));
                    errorInfo.add(this.getExpMsg(this.getClass().getSimpleName(), msg, row.getLong("id"), row.getLong(billentryId), billNo));
                }
            }
        }
        catch (Exception e) {
            String expMsg = e.toString().concat(Arrays.toString(e.getStackTrace()));
            logger.error("\u57fa\u672c\u8ba1\u91cf\u5355\u4f4d\u4e0e\u6570\u91cf\u7684\u63d2\u4ef6\u5728\u6267\u884c\u65f6\uff0c\u51fa\u73b0\u4e86\u5f02\u5e38:{}", (Object)e.toString().concat(Arrays.toString(e.getStackTrace())));
            throw new KDBizException(expMsg);
        }
        finally {
            args.close();
        }
        logger.info("\u672c\u6279\u6b21\u5de1\u68c0\u6267\u884c\u7ed3\u675f\u65f6\u95f4\uff1a{},\u6570\u636e\u5f02\u5e38\u7684\u6570\u91cf\u662f{}", (Object)FORMATTER.format(LocalDateTime.now()), (Object)errorInfo.size());
        return errorInfo;
    }

    private BigDecimal getDesQtyConv(Long materialId, Long srcUnitId, BigDecimal srcQty, Long desUnitId, boolean fromCache) {
        BigDecimal desQty = BigDecimal.ZERO;
        if (materialId != null && srcUnitId != null && desUnitId != null && srcQty != null && srcQty.compareTo(BigDecimal.ZERO) != 0) {
            if (srcUnitId.equals(desUnitId)) {
                desQty = srcQty;
            } else {
                Map<String, Integer> timelyMuConv = this.getTimelyMuConv(materialId, srcUnitId, desUnitId, fromCache);
                if (timelyMuConv != null && timelyMuConv.get("denominator") != 0) {
                    BigDecimal numberator = BigDecimal.valueOf(timelyMuConv.get("numerator").intValue());
                    BigDecimal denominator = BigDecimal.valueOf(timelyMuConv.get("denominator").intValue());
                    DynamicObject desMeasureUnits = BusinessDataServiceHelper.loadSingleFromCache((Object)desUnitId, (String)"bd_measureunits", (String)"id,precision,precisionaccount");
                    int precision = desMeasureUnits.getInt("precision") == 0 ? 10 : desMeasureUnits.getInt("precision");
                    desQty = srcQty.multiply(numberator).divide(denominator, precision, this.getPrecisionType(desMeasureUnits));
                }
            }
        }
        return desQty;
    }

    private BigDecimal getMUConvRate(Long materialId, Long srcUnitId, Long desUnitId, boolean fromCache) {
        BigDecimal rate = BigDecimal.ZERO;
        if (materialId != null && srcUnitId != null && desUnitId != null) {
            if (srcUnitId.equals(desUnitId)) {
                rate = BigDecimal.ONE;
            } else {
                Map<String, Integer> timelyMuConv = this.getTimelyMuConv(materialId, srcUnitId, desUnitId, fromCache);
                if (timelyMuConv != null && timelyMuConv.get("denominator") != 0) {
                    BigDecimal numberator = BigDecimal.valueOf(timelyMuConv.get("numerator").intValue());
                    BigDecimal denominator = BigDecimal.valueOf(timelyMuConv.get("denominator").intValue());
                    DynamicObject desMeasureUnits = BusinessDataServiceHelper.loadSingleFromCache((Object)desUnitId, (String)"bd_measureunits", (String)"id,precision,precisionaccount");
                    int precision = desMeasureUnits.getInt("precision") == 0 ? 10 : desMeasureUnits.getInt("precision");
                    rate = numberator.divide(denominator, precision, this.getPrecisionType(desMeasureUnits));
                }
            }
        }
        return rate;
    }

    private Map<String, Integer> getTimelyMuConv(Long materialId, Long srcUnitId, Long desUnitId, boolean fromCache) {
        Map<String, Integer> timelyMuConv = null;
        if (fromCache) {
            String cacheKey = "getMUConv_" + materialId + "_" + srcUnitId + "_" + desUnitId;
            Object temp = AppCacheUtils.get((String)cacheKey, Map.class);
            if (temp instanceof Map) {
                timelyMuConv = (Map)temp;
            } else {
                DynamicObject muConv = BaseDataServiceHelper.getMUConv((Long)materialId, (Long)srcUnitId, (Long)desUnitId);
                if (muConv != null && muConv.isInitialized()) {
                    timelyMuConv = new HashMap(16);
                    timelyMuConv.put("numerator", muConv.getInt("numerator"));
                    timelyMuConv.put("denominator", muConv.getInt("denominator"));
                    long timeOut = this.getExeDmfUnitInfo().getTimeOut();
                    if (timeOut < 5L || timeOut > 15L) {
                        timeOut = 5L;
                    }
                    AppCacheUtils.put((String)cacheKey, timelyMuConv, (int)((int)(timeOut * 60L)));
                }
            }
        } else {
            DynamicObject muConv = BaseDataServiceHelper.getMUConv((Long)materialId, (Long)srcUnitId, (Long)desUnitId);
            if (muConv != null) {
                timelyMuConv = new HashMap<String, Integer>(16);
                timelyMuConv.put("numerator", muConv.getInt("numerator"));
                timelyMuConv.put("denominator", muConv.getInt("denominator"));
            }
        }
        return timelyMuConv;
    }

    private int getPrecisionType(DynamicObject unit) {
        int precisionType = 4;
        if (unit != null && StringUtils.isNotBlank((Object)unit.get("precisionaccount"))) {
            String precisionAccount;
            switch (precisionAccount = unit.getString("precisionaccount")) {
                case "1": {
                    precisionType = 4;
                    break;
                }
                case "2": {
                    precisionType = 1;
                    break;
                }
                case "3": {
                    precisionType = 0;
                    break;
                }
            }
        }
        return precisionType;
    }

    private BaseUnitInfo getBaseUnitInfo() {
        List customParameterColl = SerializationUtils.fromJsonStringToList((String)this.getExeDmfUnitInfo().getCustomParameter(), Map.class);
        String parameter = (String)((Map)customParameterColl.get(0)).get("val");
        BaseUnitInfo baseUnitInfo = (BaseUnitInfo)SerializationUtils.fromJsonString((String)parameter, BaseUnitInfo.class);
        String billno = baseUnitInfo.getBillno();
        String unit = baseUnitInfo.getUnit();
        String qty = baseUnitInfo.getQty();
        String material = baseUnitInfo.getMaterial();
        String baseqty = baseUnitInfo.getBaseqty();
        String baseunit = baseUnitInfo.getBaseunit();
        String billentry = baseUnitInfo.getBillentry();
        if (billno == null || unit == null || qty == null || material == null || baseqty == null || baseunit == null || billentry == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u53c2\u6570\u7f3a\u5c11\u5fc5\u8981\u7684\u53c2\u6570\u3002\u8bf7\u6838\u5b9e\u3002", (String)"BaseUnitInspectPlugin_4", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
        }
        if ("".equals(billno) || "".equals(unit) || "".equals(qty) || "".equals(material) || "".equals(baseqty) || "".equals(baseunit) || "".equals(billentry)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u53c2\u6570\u7f3a\u5c11\u5fc5\u8981\u7684\u53c2\u6570\u3002\u8bf7\u6838\u5b9e\u3002", (String)"BaseUnitInspectPlugin_4", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
        }
        return baseUnitInfo;
    }

    private List<String> getQueryFields() {
        BaseUnitInfo baseUnitInfo = this.getBaseUnitInfo();
        ArrayList<String> fieldKeys = new ArrayList<String>(16);
        fieldKeys.add("id");
        String billEntry = baseUnitInfo.getBillentry();
        fieldKeys.add(billEntry.concat(".seq"));
        fieldKeys.add(baseUnitInfo.getBillno());
        fieldKeys.add(billEntry.concat(".id"));
        String baseConcat = billEntry.concat(".");
        String material = baseUnitInfo.getMaterial();
        fieldKeys.add(baseConcat.concat(material));
        fieldKeys.add(baseConcat.concat(material).concat(".").concat(baseUnitInfo.getMasterid()));
        fieldKeys.add(baseConcat.concat(baseUnitInfo.getUnit()));
        fieldKeys.add(baseConcat.concat(baseUnitInfo.getQty()));
        fieldKeys.add(baseConcat.concat(baseUnitInfo.getBaseunit()));
        fieldKeys.add(baseConcat.concat(baseUnitInfo.getBaseqty()));
        return fieldKeys;
    }

    @Override
    public List<FixLogInfo> fixDynamicObject(DynamicObject[] bizData) {
        logger.info("\u5f02\u5e38\u6570\u636e\u4fee\u590d\u5f00\u59cb\u65f6\u95f4\uff1a{},\u672c\u6279\u6b21\u5f85\u4fee\u590d\u7684\u6570\u636e\u91cf\u662f\uff1a{}", (Object)FORMATTER.format(LocalDateTime.now()), (Object)bizData.length);
        HashSet<DynamicObject> updateSet = new HashSet<DynamicObject>(16);
        ArrayList<FixLogInfo> fixLogInfoList = new ArrayList<FixLogInfo>(16);
        Map<String, String> fieldName = DmfSchemeExecuteHelper.getFieldName(this.getExeDmfUnitInfo().getEntityNumber(), "baseqty", "baseunit");
        for (DynamicObject bill : bizData) {
            DynamicObjectCollection billEntry = bill.getDynamicObjectCollection("billentry");
            Long id = (Long)bill.getPkValue();
            String billNo = bill.getString("billno");
            for (DynamicObject row : billEntry) {
                DynamicObject master;
                DynamicObject material;
                DynamicObject baseUnit = row.getDynamicObject("baseunit");
                BigDecimal baseQty = row.getBigDecimal("baseqty");
                boolean flag = true;
                Long entryId = (Long)row.getPkValue();
                if (baseQty == null || baseQty.compareTo(BigDecimal.ZERO) == 0) {
                    material = row.getDynamicObject("material");
                    if (material == null || (master = material.getDynamicObject("masterid")) == null) continue;
                    if (baseUnit == null) {
                        flag = false;
                        baseUnit = master.getDynamicObject("baseunit");
                    }
                    Long materialMasterId = (Long)master.getPkValue();
                    DynamicObject unit = row.getDynamicObject("unit");
                    BigDecimal unitQty = row.getBigDecimal("qty");
                    if (unit == null || unitQty == null || unitQty.compareTo(BigDecimal.ZERO) == 0) continue;
                    BigDecimal baseUnitQty = MaterialHelper.getDesQtyConv((Long)materialMasterId, (DynamicObject)unit, (BigDecimal)unitQty, (DynamicObject)baseUnit, (boolean)true);
                    if (baseUnitQty.compareTo(BigDecimal.ZERO) != 0) {
                        row.set("baseqty", (Object)baseUnitQty);
                        fixLogInfoList.add(new FixLogInfo(id, billNo, row.getInt("seq"), entryId, "baseqty", fieldName.get("baseqty"), "0", String.valueOf(baseUnitQty)));
                        if (!flag) {
                            row.set("baseunit", (Object)baseUnit);
                            String number = baseUnit.getString("number");
                            String name = baseUnit.getString("name");
                            String afterValue = String.format("%s(%s_%s)", baseUnit.getPkValue(), number, name);
                            fixLogInfoList.add(new FixLogInfo(id, billNo, row.getInt("seq"), entryId, "baseunit", fieldName.get("baseunit"), "0", afterValue));
                        }
                        updateSet.add(bill);
                    }
                }
                if (baseUnit != null || (material = row.getDynamicObject("material")) == null || (master = material.getDynamicObject("masterid")) == null) continue;
                baseUnit = master.getDynamicObject("baseunit");
                row.set("baseunit", (Object)baseUnit);
                String number = baseUnit.getString("number");
                String name = baseUnit.getString("name");
                String afterValue = String.format("%s(%s_%s)", baseUnit.getPkValue(), number, name);
                fixLogInfoList.add(new FixLogInfo(id, billNo, row.getInt("seq"), entryId, "baseunit", fieldName.get("baseunit"), "0", afterValue));
                updateSet.add(bill);
            }
        }
        if (updateSet.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])updateSet.toArray(new DynamicObject[0]));
        }
        logger.info("\u672c\u6279\u6b21\u5f02\u5e38\u6570\u636e\u4fee\u590d\u7ed3\u675f\u65f6\u95f4\uff1a{},\u4fee\u590d\u7684\u6570\u636e\u91cf\u662f\uff1a{}", (Object)FORMATTER.format(LocalDateTime.now()), (Object)updateSet.size());
        updateSet.clear();
        updateSet = null;
        return fixLogInfoList;
    }

    static class BaseUnitInfo {
        private String billno;
        private String unit;
        private String material;
        private String baseunit;
        private String qty;
        private String baseqty;
        private String billentry;
        private String masterid;

        BaseUnitInfo() {
        }

        public String getBillno() {
            return this.billno;
        }

        public void setBillno(String billno) {
            this.billno = billno;
        }

        public String getUnit() {
            return this.unit;
        }

        public void setUnit(String unit) {
            this.unit = unit;
        }

        public String getMaterial() {
            return this.material;
        }

        public void setMaterial(String material) {
            this.material = material;
        }

        public String getBaseunit() {
            return this.baseunit;
        }

        public void setBaseunit(String baseunit) {
            this.baseunit = baseunit;
        }

        public String getQty() {
            return this.qty;
        }

        public void setQty(String qty) {
            this.qty = qty;
        }

        public String getBaseqty() {
            return this.baseqty;
        }

        public void setBaseqty(String baseqty) {
            this.baseqty = baseqty;
        }

        public String getBillentry() {
            return this.billentry;
        }

        public void setBillentry(String billentry) {
            this.billentry = billentry;
        }

        public String getMasterid() {
            return this.masterid;
        }

        public void setMasterid(String masterid) {
            this.masterid = masterid;
        }

        public String toString() {
            return "BaseUnitInfo{billno='" + this.billno + '\'' + ", unit='" + this.unit + '\'' + ", material='" + this.material + '\'' + ", baseunit='" + this.baseunit + '\'' + ", qty='" + this.qty + '\'' + ", baseqty='" + this.baseqty + '\'' + '}';
        }
    }
}

