/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.datamanage.inspect.common;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algox.DataSetX;
import kd.bos.algox.MapFunction;
import kd.bos.algox.RowX;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mpscmm.msbd.datamanage.business.AbstractDmfPlugin;
import kd.mpscmm.msbd.datamanage.business.helper.DmfSchemeExecuteHelper;
import kd.mpscmm.msbd.datamanage.common.pojo.FixLogInfo;
import kd.mpscmm.msbd.datamanage.common.pojo.InspectOptionInfo;

public class SumQtyInspectPlugin
extends AbstractDmfPlugin {
    public static final Log logger = LogFactory.getLog(SumQtyInspectPlugin.class);

    @Override
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        String customParameter = this.getExeDmfUnitInfo().getCustomParameter();
        if (customParameter == null || "".equals(customParameter)) {
            Collections.addAll(e.getFieldKeys(), "id", "billno", "totalallamount", "totaltaxamount", "totalamount", "billentry.amountandtax", "billentry.amount", "billentry.taxamount");
        } else {
            List<String> queryFields = this.getQueryFields();
            e.getFieldKeys().addAll(queryFields);
        }
        InspectOptionInfo inspectOptionInfo = this.getInspectOptionInfo();
        if (inspectOptionInfo != null) {
            inspectOptionInfo.setBillEntrySympol("billentry");
            inspectOptionInfo.setBizDataType(1);
        }
    }

    @Override
    public List<OperateErrorInfo> exeInspectUnitExtPlugin(DataSet args) {
        ArrayList<OperateErrorInfo> errorInfo;
        block47: {
            errorInfo = new ArrayList<OperateErrorInfo>();
            String customParameter = this.getExeDmfUnitInfo().getCustomParameter();
            try {
                if (customParameter == null || "".equals(customParameter)) {
                    String msg;
                    String billNo;
                    try (DataSet totalAllAmount = args.copy().select(new String[]{"id", "billno", "totalallamount", "billentry.amountandtax"});){
                        DataSet cleanOutTotalAllAmount = totalAllAmount.groupBy(new String[]{"id", "billno", "totalallamount"}).sum("billentry.amountandtax").finish().filter("totalallamount!=billentry.amountandtax");
                        for (Row row : cleanOutTotalAllAmount) {
                            billNo = row.getString("billno");
                            msg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\uff1a%1$s,\u5b58\u5728\u5982\u4e0b\u95ee\u9898\uff1a%2$s", (String)"SumQtyInspectPlugin_0", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), billNo, ResManager.loadKDString((String)"\u5355\u5934\u4ef7\u7a0e\u5408\u8ba1\u4e0e\u5206\u5f55\u8ba1\u91cf\u5355\u4f4d\u7684\u4ef7\u7a0e\u5408\u8ba1\u4e0d\u4e00\u81f4\u3002", (String)"SumQtyInspectPlugin_4", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
                            errorInfo.add(this.getExpMsg(this.getClass().getSimpleName(), msg, row.getLong("id"), row.getLong("id"), billNo));
                        }
                        cleanOutTotalAllAmount.close();
                    }
                    var5_7 = null;
                    try (DataSet totalTaxAmount = args.copy().select(new String[]{"id", "billno", "totaltaxamount", "billentry.taxamount"});){
                        DataSet cleanOutTotalTaxAmount = totalTaxAmount.groupBy(new String[]{"id", "billno", "totaltaxamount"}).sum("billentry.taxamount").finish().filter("totaltaxamount!=billentry.taxamount");
                        for (Row row : cleanOutTotalTaxAmount) {
                            billNo = row.getString("billno");
                            msg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\uff1a%1$s,\u5b58\u5728\u5982\u4e0b\u95ee\u9898\uff1a%2$s", (String)"SumQtyInspectPlugin_0", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), billNo, ResManager.loadKDString((String)"\u5355\u5934\u7a0e\u989d\u4e0e\u5206\u5f55\u7a0e\u989d\u6c42\u548c\u4e0d\u4e00\u81f4\u3002", (String)"SumQtyInspectPlugin_3", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
                            errorInfo.add(this.getExpMsg(this.getClass().getSimpleName(), msg, row.getLong("id"), row.getLong("id"), billNo));
                        }
                        cleanOutTotalTaxAmount.close();
                    }
                    catch (Throwable cleanOutTotalTaxAmount) {
                        var5_7 = cleanOutTotalTaxAmount;
                        throw cleanOutTotalTaxAmount;
                    }
                    var5_7 = null;
                    try (DataSet totalAmount = args.select(new String[]{"id", "billno", "totalamount", "billentry.amount"});){
                        DataSet cleanOutTotalAmount = totalAmount.groupBy(new String[]{"id", "billno", "totalamount"}).sum("billentry.amount").finish().filter("totalamount!=billentry.amount");
                        for (Row row : cleanOutTotalAmount) {
                            billNo = row.getString("billno");
                            msg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\uff1a%1$s,\u5b58\u5728\u5982\u4e0b\u95ee\u9898\uff1a%2$s", (String)"SumQtyInspectPlugin_0", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), billNo, ResManager.loadKDString((String)"\u5355\u5934\u91d1\u989d\u4e0e\u5206\u5f55\u91d1\u989d\u6c42\u548c\u4e0d\u4e00\u81f4\u3002", (String)"SumQtyInspectPlugin_2", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
                            errorInfo.add(this.getExpMsg(this.getClass().getSimpleName(), msg, row.getLong("id"), row.getLong("id"), billNo));
                        }
                        cleanOutTotalAmount.close();
                        break block47;
                    }
                    catch (Throwable cleanOutTotalAmount) {
                        var5_7 = cleanOutTotalAmount;
                        throw cleanOutTotalAmount;
                    }
                }
                SumQtyInfo sumQtyInfo = this.getSumQtyInfo();
                String billentry = sumQtyInfo.getBillentry();
                String billentryConcat = billentry.concat(".");
                String amountandtax = billentryConcat.concat(sumQtyInfo.getAmountandtax());
                String amount = billentryConcat.concat(sumQtyInfo.getAmount());
                String taxamount = billentryConcat.concat(sumQtyInfo.getTaxamount());
                DataSet cleanResult = args.groupBy(new String[]{"id", sumQtyInfo.getBillno(), sumQtyInfo.getTotalallamount(), sumQtyInfo.getTotaltaxamount(), sumQtyInfo.getTotalamount()}).sum(amountandtax).sum(amount).sum(taxamount).finish();
                for (Row row : cleanResult) {
                    String billNo = row.getString(sumQtyInfo.getBillno());
                    BigDecimal totalAllAmount = row.getBigDecimal(sumQtyInfo.getTotalallamount());
                    BigDecimal sumAllAmount = row.getBigDecimal(amountandtax);
                    if (sumAllAmount == null || totalAllAmount.compareTo(sumAllAmount) != 0) {
                        String msg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\uff1a%1$s,\u5b58\u5728\u5982\u4e0b\u95ee\u9898\uff1a%2$s", (String)"SumQtyInspectPlugin_0", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), billNo, ResManager.loadKDString((String)"\u5355\u5934\u4ef7\u7a0e\u5408\u8ba1\u4e0e\u5206\u5f55\u8ba1\u91cf\u5355\u4f4d\u7684\u4ef7\u7a0e\u5408\u8ba1\u4e0d\u4e00\u81f4\u3002", (String)"SumQtyInspectPlugin_4", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
                        errorInfo.add(this.getExpMsg(this.getClass().getSimpleName(), msg, row.getLong("id"), row.getLong("id"), billNo));
                    }
                    BigDecimal totalTaxAmount = row.getBigDecimal(sumQtyInfo.getTotaltaxamount());
                    BigDecimal sumTaxAmount = row.getBigDecimal(taxamount);
                    if (sumTaxAmount == null || totalTaxAmount.compareTo(sumTaxAmount) != 0) {
                        String msg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\uff1a%1$s,\u5b58\u5728\u5982\u4e0b\u95ee\u9898\uff1a%2$s", (String)"SumQtyInspectPlugin_0", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), billNo, ResManager.loadKDString((String)"\u5355\u5934\u7a0e\u989d\u4e0e\u5206\u5f55\u7a0e\u989d\u6c42\u548c\u4e0d\u4e00\u81f4\u3002", (String)"SumQtyInspectPlugin_3", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
                        errorInfo.add(this.getExpMsg(this.getClass().getSimpleName(), msg, row.getLong("id"), row.getLong("id"), billNo));
                    }
                    BigDecimal totalAmount = row.getBigDecimal(sumQtyInfo.getTotalamount());
                    BigDecimal sumAmount = row.getBigDecimal(amount);
                    if (sumAmount != null && totalAmount.compareTo(sumAmount) == 0) continue;
                    String msg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\uff1a%1$s,\u5b58\u5728\u5982\u4e0b\u95ee\u9898\uff1a%2$s", (String)"SumQtyInspectPlugin_0", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), billNo, ResManager.loadKDString((String)"\u5355\u5934\u91d1\u989d\u4e0e\u5206\u5f55\u91d1\u989d\u6c42\u548c\u4e0d\u4e00\u81f4\u3002", (String)"SumQtyInspectPlugin_2", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
                    errorInfo.add(this.getExpMsg(this.getClass().getSimpleName(), msg, row.getLong("id"), row.getLong("id"), billNo));
                }
            }
            catch (Exception e) {
                String expMsg = e.toString().concat(Arrays.toString(e.getStackTrace()));
                logger.error("\u5355\u5934\u91d1\u989d\u4e0e\u5206\u5f55\u91d1\u989d\u7684\u63d2\u4ef6\u5728\u6267\u884c\u65f6\uff0c\u51fa\u73b0\u4e86\u5f02\u5e38:{}", (Object)e.toString().concat(Arrays.toString(e.getStackTrace())));
                throw new KDBizException(expMsg);
            }
        }
        logger.info("\u672c\u6279\u6b21\u5de1\u68c0\u6267\u884c\u7ed3\u675f\u65f6\u95f4\uff1a{},\u6570\u636e\u5f02\u5e38\u7684\u6570\u91cf\u662f{}", (Object)FORMATTER.format(LocalDateTime.now()), (Object)errorInfo.size());
        return errorInfo;
    }

    @Override
    public DataSetX exeInspectUnitExtPlugin(DataSetX args) {
        RowMeta resultMsg = this.getResultMsg();
        DataSetX totalAllAmount = args.select(new String[]{"id", "billno", "totalallamount", "billentry.amountandtax"});
        DataSetX cleanOutTotalAllAmount = totalAllAmount.groupBy(new String[]{"id", "billno", "totalallamount"}).sum("billentry.amountandtax");
        cleanOutTotalAllAmount = cleanOutTotalAllAmount.filter("totalallamount!=billentry.amountandtax");
        DataSetX totalAllAmountResult = cleanOutTotalAllAmount.map((MapFunction)new SumQtyInspectMapFunction(this.getExeDmfUnitInfo().getEntityNumber(), "all", resultMsg));
        DataSetX totalTaxAmount = args.select(new String[]{"id", "billno", "totaltaxamount", "billentry.taxamount"});
        DataSetX cleanOutTotalTaxAmount = totalTaxAmount.groupBy(new String[]{"id", "billno", "totaltaxamount"}).sum("billentry.taxamount");
        cleanOutTotalTaxAmount = cleanOutTotalTaxAmount.filter("totaltaxamount!=billentry.taxamount");
        DataSetX totalTaxAmountResult = cleanOutTotalTaxAmount.map((MapFunction)new SumQtyInspectMapFunction(this.getExeDmfUnitInfo().getEntityNumber(), "tax", resultMsg));
        DataSetX totalAmount = args.select(new String[]{"id", "billno", "totalamount", "billentry.amount"});
        DataSetX cleanOutTotalAmount = totalAmount.groupBy(new String[]{"id", "billno", "totalamount"}).sum("billentry.amount");
        cleanOutTotalAmount = cleanOutTotalAmount.filter("totalamount!=billentry.amount");
        DataSetX totalAmountResult = cleanOutTotalAmount.map((MapFunction)new SumQtyInspectMapFunction(this.getExeDmfUnitInfo().getEntityNumber(), "amount", resultMsg));
        DataSetX allResult = totalAllAmountResult.union(totalTaxAmountResult).union(totalAmountResult);
        return allResult;
    }

    private SumQtyInfo getSumQtyInfo() {
        List customParameterColl = SerializationUtils.fromJsonStringToList((String)this.getExeDmfUnitInfo().getCustomParameter(), Map.class);
        String parameter = (String)((Map)customParameterColl.get(0)).get("val");
        SumQtyInfo sumQtyInfo = (SumQtyInfo)SerializationUtils.fromJsonString((String)parameter, SumQtyInfo.class);
        return sumQtyInfo;
    }

    private List<String> getQueryFields() {
        SumQtyInfo sumQtyInfo = this.getSumQtyInfo();
        ArrayList<String> fieldKeys = new ArrayList<String>(16);
        fieldKeys.add("id");
        fieldKeys.add(sumQtyInfo.getBillno());
        fieldKeys.add(sumQtyInfo.getTotalallamount());
        fieldKeys.add(sumQtyInfo.getTotalamount());
        fieldKeys.add(sumQtyInfo.getTotaltaxamount());
        String billEntry = sumQtyInfo.getBillentry();
        fieldKeys.add(billEntry.concat(".").concat(sumQtyInfo.getAmountandtax()));
        fieldKeys.add(billEntry.concat(".").concat(sumQtyInfo.getAmount()));
        fieldKeys.add(billEntry.concat(".").concat(sumQtyInfo.getTaxamount()));
        return fieldKeys;
    }

    @Override
    public List<FixLogInfo> fixDynamicObject(DynamicObject[] bizData) {
        HashSet<DynamicObject> updateList = new HashSet<DynamicObject>(16);
        ArrayList<FixLogInfo> fixLogInfoList = new ArrayList<FixLogInfo>(16);
        Map<String, String> fieldName = DmfSchemeExecuteHelper.getFieldName(this.getExeDmfUnitInfo().getEntityNumber(), "totalallamount");
        for (DynamicObject bill : bizData) {
            BigDecimal totalAllAmount = bill.getBigDecimal("totalallamount");
            DynamicObjectCollection billEntry = bill.getDynamicObjectCollection("billentry");
            BigDecimal sumAllAmount = BigDecimal.ZERO;
            for (DynamicObject row : billEntry) {
                sumAllAmount = sumAllAmount.add(row.getBigDecimal("amountandtax"));
            }
            if (sumAllAmount.compareTo(BigDecimal.ZERO) == 0 || sumAllAmount.compareTo(totalAllAmount) == 0) continue;
            bill.set("totalallamount", (Object)sumAllAmount);
            updateList.add(bill);
            long id = bill.getLong("id");
            String billNo = bill.getString("billno");
            fixLogInfoList.add(new FixLogInfo(id, billNo, 0, id, "totalallamount", fieldName.get("totalallamount"), String.valueOf(totalAllAmount), String.valueOf(sumAllAmount)));
        }
        if (updateList.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])updateList.toArray(new DynamicObject[0]));
        }
        updateList.clear();
        return fixLogInfoList;
    }

    static class SumQtyInspectMapFunction
    extends MapFunction {
        private String fieldSympol;
        private String entityNumber;
        private RowMeta rowMeta;

        public SumQtyInspectMapFunction(String entityNumber, String fieldSympol, RowMeta rowMeta) {
            this.entityNumber = entityNumber;
            this.fieldSympol = fieldSympol;
            this.rowMeta = rowMeta;
        }

        public RowX map(RowX rowX) {
            RowX newRowX = new RowX(5);
            newRowX.set(0, (Object)rowX.getLong(0));
            newRowX.set(1, (Object)rowX.getLong(0));
            newRowX.set(2, (Object)this.entityNumber);
            String msg = null;
            if ("all".equals(this.fieldSympol)) {
                msg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\uff1a%1$s,\u5b58\u5728\u5982\u4e0b\u95ee\u9898\uff1a%2$s", (String)"SumQtyInspectPlugin_0", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), rowX.get(1), ResManager.loadKDString((String)"\u5355\u5934\u4ef7\u7a0e\u5408\u8ba1\u4e0e\u5206\u5f55\u8ba1\u91cf\u5355\u4f4d\u7684\u4ef7\u7a0e\u5408\u8ba1\u4e0d\u4e00\u81f4\u3002", (String)"SumQtyInspectPlugin_4", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
            }
            if ("tax".equals(this.fieldSympol)) {
                msg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\uff1a%1$s,\u5b58\u5728\u5982\u4e0b\u95ee\u9898\uff1a%2$s", (String)"SumQtyInspectPlugin_0", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), rowX.get(1), ResManager.loadKDString((String)"\u5355\u5934\u7a0e\u989d\u4e0e\u5206\u5f55\u7a0e\u989d\u6c42\u548c\u4e0d\u4e00\u81f4\u3002", (String)"SumQtyInspectPlugin_3", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
            }
            if ("amount".equals(this.fieldSympol)) {
                msg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\uff1a%1$s,\u5b58\u5728\u5982\u4e0b\u95ee\u9898\uff1a%2$s", (String)"SumQtyInspectPlugin_0", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), rowX.get(1), ResManager.loadKDString((String)"\u5355\u5934\u91d1\u989d\u4e0e\u5206\u5f55\u91d1\u989d\u6c42\u548c\u4e0d\u4e00\u81f4\u3002", (String)"SumQtyInspectPlugin_2", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
            }
            newRowX.set(3, msg);
            newRowX.set(4, rowX.get(1));
            return newRowX;
        }

        public RowMeta getResultRowMeta() {
            return this.rowMeta;
        }
    }

    static class SumQtyInfo {
        private String billno;
        private String totalamount;
        private String totaltaxamount;
        private String totalallamount;
        private String amount;
        private String taxamount;
        private String amountandtax;
        private String billentry;

        SumQtyInfo() {
        }

        public String getBillno() {
            return this.billno;
        }

        public void setBillno(String billno) {
            this.billno = billno;
        }

        public String getTotalamount() {
            return this.totalamount;
        }

        public void setTotalamount(String totalamount) {
            this.totalamount = totalamount;
        }

        public String getTotaltaxamount() {
            return this.totaltaxamount;
        }

        public void setTotaltaxamount(String totaltaxamount) {
            this.totaltaxamount = totaltaxamount;
        }

        public String getTotalallamount() {
            return this.totalallamount;
        }

        public void setTotalallamount(String totalallamount) {
            this.totalallamount = totalallamount;
        }

        public String getAmount() {
            return this.amount;
        }

        public void setAmount(String amount) {
            this.amount = amount;
        }

        public String getTaxamount() {
            return this.taxamount;
        }

        public void setTaxamount(String taxamount) {
            this.taxamount = taxamount;
        }

        public String getAmountandtax() {
            return this.amountandtax;
        }

        public void setAmountandtax(String amountandtax) {
            this.amountandtax = amountandtax;
        }

        public String getBillentry() {
            return this.billentry;
        }

        public void setBillentry(String billentry) {
            this.billentry = billentry;
        }

        public String toString() {
            return "SumQtyInfo{billno='" + this.billno + '\'' + ", totalamount='" + this.totalamount + '\'' + ", totaltaxamount='" + this.totaltaxamount + '\'' + ", totalallamount='" + this.totalallamount + '\'' + ", amount='" + this.amount + '\'' + ", taxamount='" + this.taxamount + '\'' + ", amountandtax='" + this.amountandtax + '\'' + ", billentry='" + this.billentry + '\'' + '}';
        }
    }
}

