/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.datamanage.inspect.conm;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.mpscmm.msbd.business.service.TrackLogService;
import kd.mpscmm.msbd.datamanage.business.helper.DmfSchemeExecuteHelper;
import kd.mpscmm.msbd.datamanage.common.pojo.FixLogInfo;
import kd.mpscmm.msbd.datamanage.inspect.common.ApWriteBackScmcHelper;
import kd.mpscmm.msbd.datamanage.inspect.conm.ArApQtyAndAmountPlugin;
import kd.mpscmm.msbd.datamanage.inspect.conm.pojo.InspectData;

public class PurContractApQtyAndAmountPlugin
extends ArApQtyAndAmountPlugin {
    public static final TrackLogService logger = new TrackLogService(PurContractApQtyAndAmountPlugin.class, "conm");

    @Override
    public String getOrderEntity() {
        return "pm_purorderbill";
    }

    @Override
    public List<String> getContractSelectFields() {
        ArrayList<String> list = new ArrayList<String>(13);
        list.add("id as cid");
        list.add("billno as cbillno");
        list.add("billentry.id as centryid");
        list.add("billentry.seq as cseq");
        list.add("billentry.material.masterid as material");
        list.add("billentry.unit as cunit");
        list.add("billentry.baseunit as cbaseunit");
        list.add("billentry.entrysettleorg as csettleorg");
        list.add("supplier as cbizpartner");
        list.add("supplier.internal_company as cinorg");
        list.add("billentry.payablepriceqty as cqty");
        list.add("billentry.payablebaseqty as cbaseqty");
        list.add("billentry.payableamount as camount");
        return list;
    }

    @Override
    public List<String> getOrderSelectFields() {
        ArrayList<String> list = new ArrayList<String>(11);
        list.add("id as oid");
        list.add("billno as obillno");
        list.add("supplier as obizpartner");
        list.add("supplier.internal_company as oinorg");
        list.add("billentry.id as oentryid");
        list.add("billentry.seq as oseq");
        list.add("billentry.unit as ounit");
        list.add("billentry.entrysettleorg as osettleorg");
        list.add("billentry.conbillentity as conbillentity");
        list.add("billentry.conbillid as conbillid");
        list.add("billentry.conbillentryid as conbillentryid");
        return list;
    }

    @Override
    public List<Map<String, Object>> calculate(List<Map<String, Object>> paramList) {
        logger.info("before invoke contract ApCalculate params:" + JSON.toJSONString(paramList));
        List<Map<String, Object>> writeBackPurParam = ApWriteBackScmcHelper.constructWriteBackScmcParam(paramList);
        logger.info("after invoke contract ApCalculate returns:" + JSON.toJSONString(writeBackPurParam));
        return writeBackPurParam;
    }

    @Override
    public String inspect(InspectData data) {
        boolean flag = true;
        String msg = String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c", (String)"PurContractApQtyAndAmountPlugin_4", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), data.getSeq());
        msg = msg + "\uff0c";
        BigDecimal calQty = data.getCalQty();
        BigDecimal curQty = data.getCurQty();
        if (calQty != null && curQty != null && calQty.compareTo(curQty) != 0) {
            msg = msg + String.format(ResManager.loadKDString((String)"\u5b58\u5728\u95ee\u9898\u4e00: \u5e94\u4ed8\u6570\u91cf\uff08%1$s\uff09\u4e0e\u8ba1\u7b97\u51fa\u6765\u7684\u5e94\u4ed8\u6570\u91cf\uff08%2$s\uff09\u4e0d\u4e00\u81f4\u3002", (String)"PurContractApQtyAndAmountPlugin_0", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), curQty.toPlainString(), calQty.toPlainString());
            flag = false;
        }
        BigDecimal calBaseQty = data.getCalBaseQty();
        BigDecimal curBaseQty = data.getCurBaseQty();
        if (calBaseQty != null && curBaseQty != null && calBaseQty.compareTo(curBaseQty) != 0) {
            msg = msg + String.format(ResManager.loadKDString((String)"\u5b58\u5728\u95ee\u9898\u4e8c: \u5e94\u4ed8\u57fa\u672c\u6570\u91cf\uff08%1$s\uff09\u4e0e\u8ba1\u7b97\u51fa\u6765\u7684\u5e94\u4ed8\u57fa\u672c\u6570\u91cf\uff08%2$s\uff09\u4e0d\u4e00\u81f4\u3002", (String)"PurContractApQtyAndAmountPlugin_1", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), curBaseQty.toPlainString(), calBaseQty.toPlainString());
            flag = false;
        }
        BigDecimal calAmount = data.getCalAmount();
        BigDecimal curAmount = data.getCurAmount();
        if (calAmount != null && curAmount != null && calAmount.compareTo(curAmount) != 0) {
            msg = msg + String.format(ResManager.loadKDString((String)"\u5b58\u5728\u95ee\u9898\u4e09: \u5e94\u4ed8\u91d1\u989d\uff08%1$s\uff09\u4e0e\u8ba1\u7b97\u51fa\u6765\u7684\u5e94\u4ed8\u91d1\u989d\uff08%2$s\uff09\u4e0d\u4e00\u81f4\u3002", (String)"PurContractApQtyAndAmountPlugin_2", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), curAmount.toPlainString(), calAmount.toPlainString());
            flag = false;
        }
        return flag ? null : msg;
    }

    @Override
    public String updateSql() {
        return "update t_conm_purcontractentry_r set fpayablepriceqty=?,fpayablebaseqty=?,fpayableamount=? where fentryid=?";
    }

    @Override
    public List<FixLogInfo> log(InspectData value) {
        Map<String, String> fieldName = DmfSchemeExecuteHelper.getFieldName(this.getExeDmfUnitInfo().getEntityNumber(), "payablepriceqty", "payablebaseqty", "payableamount");
        ArrayList<FixLogInfo> list = new ArrayList<FixLogInfo>();
        list.add(new FixLogInfo(value.getBillId(), value.getBillNo(), value.getSeq(), value.getBillentryId(), "payablepriceqty", fieldName.get("payablepriceqty"), value.getCurQty().toPlainString(), value.getCalQty().toPlainString()));
        list.add(new FixLogInfo(value.getBillId(), value.getBillNo(), value.getSeq(), value.getBillentryId(), "payablebaseqty", fieldName.get("payablebaseqty"), value.getCurBaseQty().toPlainString(), value.getCalBaseQty().toPlainString()));
        list.add(new FixLogInfo(value.getBillId(), value.getBillNo(), value.getSeq(), value.getBillentryId(), "payableamount", fieldName.get("payableamount"), value.getCurAmount().toPlainString(), value.getCalAmount().toPlainString()));
        return list;
    }
}

