/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.datamanage.inspect.im;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.mpscmm.msbd.datamanage.business.AbstractDmfPlugin;
import kd.mpscmm.msbd.datamanage.business.helper.im.InvAddFieldsUnit;
import kd.mpscmm.msbd.datamanage.common.consts.im.InvBillEntryConst;
import kd.mpscmm.msbd.datamanage.common.pojo.DmfExpMsgInfo;
import kd.mpscmm.msbd.datamanage.common.pojo.InspectOptionInfo;
import kd.mpscmm.msbd.datamanage.common.pojo.InvBillEntryModel;
import kd.mpscmm.msbd.datamanage.common.pojo.InvBillModel;

public class InvBillCalFormulaPlugin
extends AbstractDmfPlugin {
    private static final long serialVersionUID = -8869888543351128887L;

    @Override
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        String formId = this.getExeDmfUnitInfo().getEntityNumber();
        e.getFieldKeys().addAll(InvAddFieldsUnit.getCalFormulaFields(formId));
        InspectOptionInfo inspectOptionInfo = this.getInspectOptionInfo();
        if (inspectOptionInfo != null) {
            inspectOptionInfo.setBillEntrySympol("billentry");
            inspectOptionInfo.setBizDataType(1);
        }
    }

    @Override
    public List<OperateErrorInfo> exeInspectUnitExtPlugin(DataSet data) {
        List<OperateErrorInfo> inspectUnitExtPlugin = super.exeInspectUnitExtPlugin(data);
        List<InvBillModel> invBills = this.buildBillModel(data);
        List<DmfExpMsgInfo> dmfExpMsgInfos = this.checkAmountAndTax(invBills);
        dmfExpMsgInfos.forEach(v -> inspectUnitExtPlugin.add(this.getExpMsg(v.getClassName(), v.getMsg(), v.getPkValue(), v.getEntryId(), v.getBillno())));
        return inspectUnitExtPlugin;
    }

    private List<DmfExpMsgInfo> checkAmountAndTax(List<InvBillModel> invBills) {
        ArrayList<DmfExpMsgInfo> dmfExpMsgInfos = new ArrayList<DmfExpMsgInfo>(16);
        for (InvBillModel invBillModel : invBills) {
            Long pkValue = invBillModel.getPkValue();
            String billNo = invBillModel.getBillNo();
            boolean isTax = invBillModel.isTax();
            if (!isTax) continue;
            List<InvBillEntryModel> billEntrys = invBillModel.getBillEntrys();
            for (InvBillEntryModel entry : billEntrys) {
                BigDecimal amount = entry.getAmount();
                amount = amount == null ? BigDecimal.ZERO : amount;
                BigDecimal taxAmount = entry.getTaxAmount();
                taxAmount = taxAmount == null ? BigDecimal.ZERO : taxAmount;
                BigDecimal amountAndTax = entry.getAmountAndTax();
                BigDecimal bigDecimal = amountAndTax = amountAndTax == null ? BigDecimal.ZERO : amountAndTax;
                if (amount.add(taxAmount).compareTo(amountAndTax) == 0) continue;
                dmfExpMsgInfos.add(DmfExpMsgInfo.getInstance(this.getClass().getSimpleName(), String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\u201c\u91d1\u989d+\u7a0e\u989d\u201d\u4e0d\u7b49\u4e8e\u4ef7\u7a0e\u5408\u8ba1\u3002", (String)"InvBillCalFormulaPlugin_0", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), entry.getSeq()), pkValue, entry.getEntryId(), billNo));
            }
        }
        return dmfExpMsgInfos;
    }

    private List<InvBillModel> buildBillModel(DataSet data) {
        ArrayList<InvBillModel> invBills = new ArrayList<InvBillModel>(16);
        HashMap<Long, InvBillModel> invBillModeMap = new HashMap<Long, InvBillModel>(16);
        while (data.hasNext()) {
            Row row = data.next();
            Long id = row.getLong("id");
            InvBillModel billModel = (InvBillModel)invBillModeMap.get(id);
            if (billModel == null) {
                billModel = InvBillModel.getInstance();
                billModel.setPkValue(id);
                invBillModeMap.put(id, billModel);
            }
            billModel.setBillNo(row.getString("billno"));
            billModel.setTax(row.getBoolean("istax"));
            InvBillEntryModel entry = billModel.addNewEntry();
            entry.setEntryId(row.getLong(InvBillEntryConst.getEntryField("id")));
            entry.setSeq(row.getInteger(InvBillEntryConst.getEntryField("seq")));
            entry.setAmount(row.getBigDecimal(InvBillEntryConst.getEntryField("amount")));
            entry.setAmountAndTax(row.getBigDecimal(InvBillEntryConst.getEntryField("amountandtax")));
            entry.setTaxAmount(row.getBigDecimal(InvBillEntryConst.getEntryField("taxamount")));
        }
        invBills.addAll(invBillModeMap.values());
        return invBills;
    }
}

