/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.datamanage.inspect.im;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.mpscmm.msbd.datamanage.business.AbstractDmfPlugin;
import kd.mpscmm.msbd.datamanage.business.helper.im.InvAddFieldsUnit;
import kd.mpscmm.msbd.datamanage.common.consts.im.InvBillEntryConst;
import kd.mpscmm.msbd.datamanage.common.pojo.DmfExpMsgInfo;
import kd.mpscmm.msbd.datamanage.common.pojo.InspectOptionInfo;
import kd.mpscmm.msbd.datamanage.common.pojo.InvBillEntryModel;
import kd.mpscmm.msbd.datamanage.common.pojo.InvBillModel;

public class InvBillLotnumPlugin
extends AbstractDmfPlugin {
    private static final long serialVersionUID = -2881480514488540696L;

    @Override
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        String formId = this.getExeDmfUnitInfo().getEntityNumber();
        e.getFieldKeys().addAll(InvAddFieldsUnit.getLotNumFields(formId));
        InspectOptionInfo inspectOptionInfo = this.getInspectOptionInfo();
        if (inspectOptionInfo != null) {
            inspectOptionInfo.setBillEntrySympol("billentry");
            inspectOptionInfo.setBizDataType(1);
        }
    }

    @Override
    public List<OperateErrorInfo> exeInspectUnitExtPlugin(DataSet data) {
        List<OperateErrorInfo> inspectUnitExtPlugin = super.exeInspectUnitExtPlugin(data);
        List<InvBillModel> invBills = this.buildBillModel(data);
        List<DmfExpMsgInfo> dmfExpMsgInfos = this.checkInvByLotNum(invBills);
        dmfExpMsgInfos.forEach(v -> inspectUnitExtPlugin.add(this.getExpMsg(v.getClassName(), v.getMsg(), v.getPkValue(), v.getEntryId(), v.getBillno())));
        return inspectUnitExtPlugin;
    }

    private List<DmfExpMsgInfo> checkInvByLotNum(List<InvBillModel> invBills) {
        ArrayList<DmfExpMsgInfo> dmfExpMsgInfos = new ArrayList<DmfExpMsgInfo>(16);
        for (InvBillModel invBillModel : invBills) {
            Long pkValue = invBillModel.getPkValue();
            String billNo = invBillModel.getBillNo();
            List<InvBillEntryModel> billEntrys = invBillModel.getBillEntrys();
            for (InvBillEntryModel entry : billEntrys) {
                String lotNum = entry.getLotNum();
                if (StringUtils.isBlank((CharSequence)lotNum) || lotNum.length() == lotNum.trim().length()) continue;
                dmfExpMsgInfos.add(DmfExpMsgInfo.getInstance(this.getClass().getSimpleName(), String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\u6279\u53f7\u5b57\u6bb5\u5b58\u5728\u7a7a\u683c\u3002", (String)"InvBillLotnumPlugin_0", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), entry.getSeq()), pkValue, entry.getEntryId(), billNo));
            }
        }
        return dmfExpMsgInfos;
    }

    private List<InvBillModel> buildBillModel(DataSet data) {
        ArrayList<InvBillModel> invBills = new ArrayList<InvBillModel>(16);
        HashMap<Long, InvBillModel> invBillModeMap = new HashMap<Long, InvBillModel>(16);
        while (data.hasNext()) {
            Row row = data.next();
            Long id = row.getLong("id");
            InvBillModel billModel = (InvBillModel)invBillModeMap.get(id);
            if (billModel == null) {
                billModel = InvBillModel.getInstance();
                billModel.setPkValue(id);
                invBillModeMap.put(id, billModel);
            }
            billModel.setBillNo(row.getString("billno"));
            InvBillEntryModel entry = billModel.addNewEntry();
            entry.setEntryId(row.getLong(InvBillEntryConst.getEntryField("id")));
            entry.setSeq(row.getInteger(InvBillEntryConst.getEntryField("seq")));
            entry.setLotNum(row.getString(InvBillEntryConst.getEntryField("lotnumber")));
        }
        invBills.addAll(invBillModeMap.values());
        return invBills;
    }
}

