/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.datamanage.inspect.im;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mpscmm.msbd.datamanage.business.AbstractDmfPlugin;
import kd.mpscmm.msbd.datamanage.business.helper.im.InvAddFieldsUnit;
import kd.mpscmm.msbd.datamanage.common.consts.im.InvBillEntryConst;
import kd.mpscmm.msbd.datamanage.common.pojo.DmfExpMsgInfo;
import kd.mpscmm.msbd.datamanage.common.pojo.InspectOptionInfo;
import kd.mpscmm.msbd.datamanage.common.pojo.InvBillEntryModel;
import kd.mpscmm.msbd.datamanage.common.pojo.InvBillModel;

public class InvStatusAndTypePlugin
extends AbstractDmfPlugin {
    private static final long serialVersionUID = -5752919564991725640L;
    public static final String INVS_TRANSTYPE_TRAN_RECEIPT = "0";
    public static final String INVS_TRANSTYPE_TRAN_DELIVERY = "1";
    public static final String INVS_TRANSTYPE_TRAN_RECEIPTDELIVERY = "2";

    @Override
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        String formId = this.getExeDmfUnitInfo().getEntityNumber();
        e.getFieldKeys().addAll(InvAddFieldsUnit.getInvStatusAndTypeFields(formId));
        InspectOptionInfo inspectOptionInfo = this.getInspectOptionInfo();
        if (inspectOptionInfo != null) {
            inspectOptionInfo.setBillEntrySympol("billentry");
            inspectOptionInfo.setBizDataType(1);
        }
    }

    @Override
    public List<OperateErrorInfo> exeInspectUnitExtPlugin(DataSet data) {
        List<OperateErrorInfo> inspectUnitExtPlugin = super.exeInspectUnitExtPlugin(data);
        List<InvBillModel> invBills = this.buildBillModel(data);
        List<DmfExpMsgInfo> dmfExpMsgInfos = this.checkInvStatusAndType(invBills);
        dmfExpMsgInfos.forEach(v -> inspectUnitExtPlugin.add(this.getExpMsg(v.getClassName(), v.getMsg(), v.getPkValue(), v.getEntryId(), v.getBillno())));
        return inspectUnitExtPlugin;
    }

    private List<DmfExpMsgInfo> checkInvStatusAndType(List<InvBillModel> invBills) {
        ArrayList<DmfExpMsgInfo> dmfExpMsgInfos = new ArrayList<DmfExpMsgInfo>(16);
        for (InvBillModel invBillModel : invBills) {
            DynamicObject invScheme = invBillModel.getInvScheme();
            Long pkValue = invBillModel.getPkValue();
            String billNo = invBillModel.getBillNo();
            String transCeiver = invScheme.getString("transceiver");
            if (StringUtils.isBlank((CharSequence)transCeiver)) continue;
            switch (transCeiver) {
                case "0": {
                    dmfExpMsgInfos.addAll(this.checkEntryByReceipt(invBillModel, pkValue, billNo));
                    break;
                }
                case "1": {
                    dmfExpMsgInfos.addAll(this.checkEntryByDelivery(invBillModel, pkValue, billNo));
                    break;
                }
                case "2": {
                    dmfExpMsgInfos.addAll(this.checkEntryByReceiptDelivery(invBillModel, pkValue, billNo));
                    break;
                }
            }
        }
        return dmfExpMsgInfos;
    }

    private List<DmfExpMsgInfo> checkEntryByReceipt(InvBillModel invBillModel, Long pkValue, String billNo) {
        List<InvBillEntryModel> billEntrys = invBillModel.getBillEntrys();
        ArrayList<DmfExpMsgInfo> dmfExpMsgInfos = new ArrayList<DmfExpMsgInfo>(billEntrys.size());
        for (InvBillEntryModel billEntry : billEntrys) {
            Long invStatusId = billEntry.getInvStatusId();
            Long entryId = billEntry.getEntryId();
            Long invTypesId = billEntry.getInvTypesId();
            if (invStatusId == null || invStatusId.equals(0L)) {
                dmfExpMsgInfos.add(DmfExpMsgInfo.getInstance(this.getClass().getSimpleName(), String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\u201c\u5e93\u5b58\u4e8b\u52a1\u201d\u7684\u5165\u5e93\u65b9\u5411\u8bbe\u7f6e\u5f00\u542f\uff0c\u5165\u5e93\u5e93\u5b58\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InvStatusAndTypePlugin_0", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), billEntry.getSeq()), pkValue, entryId, billNo));
            }
            if (invTypesId != null && !invTypesId.equals(0L)) continue;
            dmfExpMsgInfos.add(DmfExpMsgInfo.getInstance(this.getClass().getSimpleName(), String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\u201c\u5e93\u5b58\u4e8b\u52a1\u201d\u7684\u5165\u5e93\u65b9\u5411\u8bbe\u7f6e\u5f00\u542f\uff0c\u5165\u5e93\u5e93\u5b58\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InvStatusAndTypePlugin_1", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), billEntry.getSeq()), pkValue, entryId, billNo));
        }
        return dmfExpMsgInfos;
    }

    private List<DmfExpMsgInfo> checkEntryByDelivery(InvBillModel invBillModel, Long pkValue, String billNo) {
        List<InvBillEntryModel> billEntrys = invBillModel.getBillEntrys();
        ArrayList<DmfExpMsgInfo> dmfExpMsgInfos = new ArrayList<DmfExpMsgInfo>(billEntrys.size());
        for (InvBillEntryModel billEntry : billEntrys) {
            Long outInvStatusId = billEntry.getOutInvStatusId();
            Long outInvTypesId = billEntry.getOutInvTypesId();
            Long entryId = billEntry.getEntryId();
            if (outInvStatusId == null || outInvStatusId.equals(0L)) {
                dmfExpMsgInfos.add(DmfExpMsgInfo.getInstance(this.getClass().getSimpleName(), String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\u201c\u5e93\u5b58\u4e8b\u52a1\u201d\u7684\u51fa\u5e93\u65b9\u5411\u8bbe\u7f6e\u5f00\u542f\uff0c\u51fa\u5e93\u5e93\u5b58\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InvStatusAndTypePlugin_2", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), billEntry.getSeq()), pkValue, entryId, billNo));
            }
            if (outInvTypesId != null && !outInvTypesId.equals(0L)) continue;
            dmfExpMsgInfos.add(DmfExpMsgInfo.getInstance(this.getClass().getSimpleName(), String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\u201c\u5e93\u5b58\u4e8b\u52a1\u201d\u7684\u51fa\u5e93\u65b9\u5411\u8bbe\u7f6e\u5f00\u542f\uff0c\u51fa\u5e93\u5e93\u5b58\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InvStatusAndTypePlugin_3", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), billEntry.getSeq()), pkValue, entryId, billNo));
        }
        return dmfExpMsgInfos;
    }

    private List<DmfExpMsgInfo> checkEntryByReceiptDelivery(InvBillModel invBillModel, Long pkValue, String billNo) {
        List<InvBillEntryModel> billEntrys = invBillModel.getBillEntrys();
        ArrayList<DmfExpMsgInfo> dmfExpMsgInfos = new ArrayList<DmfExpMsgInfo>(billEntrys.size());
        for (InvBillEntryModel billEntry : billEntrys) {
            Long entryId = billEntry.getEntryId();
            Long invStatusId = billEntry.getInvStatusId();
            Long invTypesId = billEntry.getInvTypesId();
            Long outInvStatusId = billEntry.getOutInvStatusId();
            Long outInvTypesId = billEntry.getOutInvTypesId();
            if (invStatusId == null || invStatusId.equals(0L)) {
                dmfExpMsgInfos.add(DmfExpMsgInfo.getInstance(this.getClass().getSimpleName(), String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\u201c\u5e93\u5b58\u4e8b\u52a1\u201d\u7684\u5165\u5e93\u65b9\u5411\u8bbe\u7f6e\u5f00\u542f\uff0c\u5165\u5e93\u5e93\u5b58\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InvStatusAndTypePlugin_0", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), billEntry.getSeq()), pkValue, entryId, billNo));
            }
            if (invTypesId == null || invTypesId.equals(0L)) {
                dmfExpMsgInfos.add(DmfExpMsgInfo.getInstance(this.getClass().getSimpleName(), String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\u201c\u5e93\u5b58\u4e8b\u52a1\u201d\u7684\u5165\u5e93\u65b9\u5411\u8bbe\u7f6e\u5f00\u542f\uff0c\u5165\u5e93\u5e93\u5b58\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InvStatusAndTypePlugin_1", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), billEntry.getSeq()), pkValue, entryId, billNo));
            }
            if (outInvStatusId == null || outInvStatusId.equals(0L)) {
                dmfExpMsgInfos.add(DmfExpMsgInfo.getInstance(this.getClass().getSimpleName(), String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\u201c\u5e93\u5b58\u4e8b\u52a1\u201d\u7684\u51fa\u5e93\u65b9\u5411\u8bbe\u7f6e\u5f00\u542f\uff0c\u51fa\u5e93\u5e93\u5b58\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InvStatusAndTypePlugin_2", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), billEntry.getSeq()), pkValue, entryId, billNo));
            }
            if (outInvTypesId != null && !outInvTypesId.equals(0L)) continue;
            dmfExpMsgInfos.add(DmfExpMsgInfo.getInstance(this.getClass().getSimpleName(), String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\u201c\u5e93\u5b58\u4e8b\u52a1\u201d\u7684\u51fa\u5e93\u65b9\u5411\u8bbe\u7f6e\u5f00\u542f\uff0c\u51fa\u5e93\u5e93\u5b58\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InvStatusAndTypePlugin_3", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), billEntry.getSeq()), pkValue, entryId, billNo));
        }
        return dmfExpMsgInfos;
    }

    private List<InvBillModel> buildBillModel(DataSet data) {
        ArrayList<InvBillModel> invBills = new ArrayList<InvBillModel>(16);
        HashMap<Long, InvBillModel> invBillModeMap = new HashMap<Long, InvBillModel>(16);
        HashSet<Long> invSchemeIds = new HashSet<Long>(16);
        while (data.hasNext()) {
            Row row = data.next();
            Long id = row.getLong("id");
            Long invSchemeId = row.getLong("invscheme");
            invSchemeIds.add(invSchemeId);
            InvBillModel billModel = (InvBillModel)invBillModeMap.get(id);
            if (billModel == null) {
                billModel = InvBillModel.getInstance();
                billModel.setPkValue(id);
                invBillModeMap.put(id, billModel);
            }
            billModel.setBillNo(row.getString("billno"));
            billModel.setInvSchemeId(invSchemeId);
            InvBillEntryModel entry = billModel.addNewEntry();
            entry.setEntryId(row.getLong(InvBillEntryConst.getEntryField("id")));
            entry.setSeq(row.getInteger(InvBillEntryConst.getEntryField("seq")));
            entry.setInvStatusId(row.getLong(InvBillEntryConst.getEntryField("invstatus")));
            entry.setInvTypesId(row.getLong(InvBillEntryConst.getEntryField("invtype")));
            entry.setOutInvStatusId(row.getLong(InvBillEntryConst.getEntryField("outinvstatus")));
            entry.setOutInvTypesId(row.getLong(InvBillEntryConst.getEntryField("outinvtype")));
        }
        if (invSchemeIds.isEmpty()) {
            return invBills;
        }
        invBills.addAll(invBillModeMap.values());
        Map invSchemes = BusinessDataServiceHelper.loadFromCache((String)"im_invscheme", (String)"transceiver", (QFilter[])new QFilter("id", "in", invSchemeIds).toArray());
        for (InvBillModel invBill : invBills) {
            invBill.setInvScheme((DynamicObject)invSchemes.get(invBill.getInvSchemeId()));
        }
        return invBills;
    }
}

