/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.datamanage.inspect.im;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.mpscmm.msbd.datamanage.business.AbstractDmfPlugin;
import kd.mpscmm.msbd.datamanage.business.helper.im.InvAddFieldsUnit;
import kd.mpscmm.msbd.datamanage.common.pojo.InspectOptionInfo;
import kd.mpscmm.msbd.datamanage.common.pojo.InvBillModel;

public class InvVirtualBillPlugin
extends AbstractDmfPlugin {
    private static final long serialVersionUID = 7921806589366463204L;
    private static final String SETTLE_FAIL = "settlefail";
    private static final String NO_SETTLE = "nosettle";

    @Override
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        String formId = this.getExeDmfUnitInfo().getEntityNumber();
        e.getFieldKeys().addAll(InvAddFieldsUnit.getInvVirtualFields(formId));
        InspectOptionInfo inspectOptionInfo = this.getInspectOptionInfo();
        if (inspectOptionInfo != null) {
            inspectOptionInfo.setBillEntrySympol("billentry");
            inspectOptionInfo.setBizDataType(1);
        }
    }

    @Override
    public List<OperateErrorInfo> exeInspectUnitExtPlugin(DataSet data) {
        List<OperateErrorInfo> inspectUnitExtPlugin = super.exeInspectUnitExtPlugin(data);
        List<InvBillModel> invBills = this.buildBillModel(data);
        String formId = this.getExeDmfUnitInfo().getEntityNumber();
        Set ids = invBills.stream().map(InvBillModel::getPkValue).collect(Collectors.toSet());
        Map resultMap = (Map)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"ism", (String)"SettleBillService", (String)"validateSettle", (Object[])new Object[]{formId, ids});
        Set settleFailIds = resultMap.getOrDefault(SETTLE_FAIL, new HashSet(0));
        Set noSettleIds = resultMap.getOrDefault(NO_SETTLE, new HashSet(0));
        for (InvBillModel billModel : invBills) {
            Long pkValue = billModel.getPkValue();
            String billNo = billModel.getBillNo();
            if (noSettleIds.contains(pkValue)) {
                inspectUnitExtPlugin.add(this.getExpMsg(formId, ResManager.loadKDString((String)"\u7b26\u5408\u7ec4\u7ec7\u95f4\u7ed3\u7b97\u5224\u5b9a\u4f46\u672a\u751f\u6210\u865a\u5355\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"InvVirtualBillPlugin_0", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), pkValue, null, billNo));
            }
            if (!settleFailIds.contains(pkValue)) continue;
            inspectUnitExtPlugin.add(this.getExpMsg(formId, ResManager.loadKDString((String)"\u5355\u636e\u6267\u884c\u7ec4\u7ec7\u95f4\u7ed3\u7b97\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"InvVirtualBillPlugin_1", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), pkValue, null, billNo));
        }
        return inspectUnitExtPlugin;
    }

    private List<InvBillModel> buildBillModel(DataSet data) {
        ArrayList<InvBillModel> invBills = new ArrayList<InvBillModel>(16);
        HashMap<Long, InvBillModel> invBillModeMap = new HashMap<Long, InvBillModel>(16);
        while (data.hasNext()) {
            Row row = data.next();
            Long id = row.getLong("id");
            InvBillModel billModel = (InvBillModel)invBillModeMap.get(id);
            if (billModel == null) {
                billModel = InvBillModel.getInstance();
                billModel.setPkValue(id);
                invBillModeMap.put(id, billModel);
            }
            billModel.setBillNo(row.getString("billno"));
        }
        invBills.addAll(invBillModeMap.values());
        return invBills;
    }
}

