/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.datamanage.inspect.macc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.mpscmm.msbd.datamanage.business.AbstractDmfPlugin;
import kd.mpscmm.msbd.datamanage.common.pojo.InspectOptionInfo;

public class MatCostInfoKeyColCheckPlugin
extends AbstractDmfPlugin {
    public static final Log logger = LogFactory.getLog(MatCostInfoKeyColCheckPlugin.class);

    @Override
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        Collections.addAll(e.getFieldKeys(), "id", "costtype", "costtype.name", "material", "material.number", "material.name", "keycolid");
    }

    @Override
    public void beginInspectOperation(InspectOptionInfo inspectOptionInfo) {
        if (inspectOptionInfo != null) {
            inspectOptionInfo.setBizDataType(1);
        }
    }

    @Override
    public List<OperateErrorInfo> exeInspectUnitExtPlugin(DataSet args) {
        ArrayList<OperateErrorInfo> errorInfo = new ArrayList<OperateErrorInfo>();
        args = args.filter("keycolid <= 0");
        for (Row row : args) {
            String costTypeName = row.getString("costtype.name");
            String materialName = row.getString("material.name");
            String materialNumber = row.getString("material.number");
            String msg = String.format(ResManager.loadKDString((String)"\u6210\u672c\u7c7b\u578b\uff1a%1$s\uff0c\u7269\u6599\uff1a%2$s\uff0c\u7269\u6599\u6210\u672c\u4fe1\u606f\u5377\u7b97\u7ef4\u5ea6\u6570\u636e\u4e3a\u7a7a\u3002", (String)"MatCostInfoKeyColCheckPlugin_0", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), costTypeName, materialName);
            errorInfo.add(this.getExpMsg(this.getClass().getSimpleName(), msg, row.getLong("id"), row.getLong("id"), materialNumber));
        }
        return errorInfo;
    }
}

