/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.datamanage.inspect.pm.purorder;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.mpscmm.msbd.datamanage.business.AbstractDmfPlugin;
import kd.mpscmm.msbd.datamanage.common.pojo.InspectOptionInfo;

public class PurOrderAccuracyPlugin
extends AbstractDmfPlugin {
    public static final Log logger = LogFactory.getLog(PurOrderAccuracyPlugin.class);

    @Override
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        Collections.addAll(e.getFieldKeys(), "id", "billno", "totalallamount", "paidallamount", "billentry.seq", "billentry.id", "billentry.payablepriceqty", "billentry.qty", "billentry.payableamount", "billentry.amountandtax");
        InspectOptionInfo inspectOptionInfo = this.getInspectOptionInfo();
        inspectOptionInfo.setBillEntrySympol("billentry");
    }

    @Override
    public List<OperateErrorInfo> exeInspectUnitExtPlugin(DataSet args) {
        Long id;
        String billNo;
        logger.info("PurOrderAccuracyPlugin:\u63d2\u4ef6\u5de1\u68c0\u6267\u884c\u5f00\u59cb\u65f6\u95f4\uff1a{},\u6267\u884c\u6570\u91cf\u662f{}", (Object)FORMATTER.format(LocalDateTime.now()));
        ArrayList<OperateErrorInfo> errorInfo = new ArrayList<OperateErrorInfo>();
        try (DataSet head = args.copy().select(new String[]{"billno", "id", "totalallamount", "paidallamount"}).distinct();){
            for (Row row : head) {
                billNo = row.getString("billno");
                id = row.getLong("id");
                BigDecimal totalAllAmount = row.getBigDecimal("totalallamount");
                totalAllAmount = totalAllAmount.multiply(new BigDecimal("2"));
                BigDecimal paidAllAmount = row.getBigDecimal("paidallamount");
                if (paidAllAmount.compareTo(totalAllAmount) < 0) continue;
                String msg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\uff1a%1$s,\u5b58\u5728\u5982\u4e0b\u95ee\u9898\uff1a%2$s", (String)"PurOrderAccuracyPlugin_0", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), billNo, ResManager.loadKDString((String)"\u5355\u5934\u7d2f\u8ba1\u4ed8\u6b3e\u91d1\u989d\u5927\u4e8e\u7b49\u4e8e\u4ef7\u7a0e\u5408\u8ba1\u7684\u4e8c\u500d\u3002", (String)"PurOrderAccuracyPlugin_1", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
                errorInfo.add(this.getExpMsg(this.getClass().getSimpleName(), msg, id, id, billNo));
            }
        }
        var4_4 = null;
        try (DataSet entry = args.copy().select(new String[]{"id", "billno", "billentry.payablepriceqty", "billentry.qty", "billentry.payableamount", "billentry.amountandtax", "billentry.id"});){
            for (Row row : entry) {
                billNo = row.getString("billno");
                id = row.getLong("id");
                Long entryId = row.getLong("billentry.id");
                BigDecimal payablepriceqty = row.getBigDecimal("payablepriceqty");
                BigDecimal qty = row.getBigDecimal("qty");
                if (payablepriceqty.compareTo(qty = qty.multiply(new BigDecimal("2"))) >= 0) {
                    String msg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%1$s\u201d\u7684\u884c\u53f7\u201c%2$s\u201d\u5b58\u5728\u5206\u5f55\u7d2f\u8ba1\u5e94\u4ed8\u6570\u91cf\u5927\u4e8e\u7b49\u4e8e\u6570\u91cf2\u500d\u7684\u5f02\u5e38\u3002", (String)"PurOrderAccuracyPlugin_2", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), billNo, row.get("seq"));
                    errorInfo.add(this.getExpMsg(this.getClass().getSimpleName(), msg, id, entryId, billNo));
                }
                BigDecimal payableamount = row.getBigDecimal("payableamount");
                BigDecimal amountandtax = row.getBigDecimal("amountandtax");
                if (payableamount.compareTo(amountandtax = amountandtax.multiply(new BigDecimal("2"))) < 0) continue;
                String msg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%1$s\u201d\u7684\u884c\u53f7\u201c%2$s\u201d\u5b58\u5728\u5206\u5f55\u7d2f\u8ba1\u5e94\u4ed8\u6b3e\u91d1\u989d\u5927\u4e8e\u7b49\u4e8e\u4ef7\u7a0e\u5408\u8ba12\u500d\u7684\u5f02\u5e38\u3002", (String)"PurOrderAccuracyPlugin_3", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), billNo, row.get("seq"));
                errorInfo.add(this.getExpMsg(this.getClass().getSimpleName(), msg, id, entryId, billNo));
            }
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        logger.info("PurOrderAccuracyPlugin:\u672c\u6279\u6b21\u5de1\u68c0\u6267\u884c\u7ed3\u675f\u65f6\u95f4\uff1a{},\u6570\u636e\u5f02\u5e38\u7684\u6570\u91cf\u662f{}", (Object)FORMATTER.format(LocalDateTime.now()), (Object)errorInfo.size());
        return errorInfo;
    }
}

