/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.datamanage.inspect.pm.purorder;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.mpscmm.msbd.common.utils.BigDecimalUtil;
import kd.mpscmm.msbd.datamanage.business.AbstractDmfPlugin;
import kd.mpscmm.msbd.datamanage.common.pojo.InspectOptionInfo;

public class PurOrderIsHasTaxPlugin
extends AbstractDmfPlugin {
    public static final Log logger = LogFactory.getLog(PurOrderIsHasTaxPlugin.class);

    @Override
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        Collections.addAll(e.getFieldKeys(), "id", "billno", "istax", "billentry.id", "billentry.seq", "billentry.ispresent", "billentry.price", "billentry.taxrate", "billentry.priceandtax");
    }

    @Override
    public void beginInspectOperation(InspectOptionInfo inspectOptionInfo) {
        if (inspectOptionInfo != null) {
            inspectOptionInfo.setBillEntrySympol("billentry");
            inspectOptionInfo.setBizDataType(1);
        }
    }

    @Override
    public List<OperateErrorInfo> exeInspectUnitExtPlugin(DataSet args) {
        ArrayList<OperateErrorInfo> errorInfo = new ArrayList<OperateErrorInfo>();
        int settlePricePrecision = 10;
        for (Row row : args) {
            BigDecimal calPriceAndTax;
            String msg;
            String msg2;
            BigDecimal taxRate;
            String billNo = row.getString("billno");
            Boolean isTax = row.getBoolean("istax");
            Boolean isPresent = row.getBoolean("billentry.ispresent");
            if (Boolean.TRUE.equals(isTax) && Boolean.FALSE.equals(isPresent)) {
                BigDecimal price = row.getBigDecimal("billentry.price");
                taxRate = BigDecimalUtil.div100((BigDecimal)row.getBigDecimal("billentry.taxrate"));
                if (price == null) continue;
                if (price.compareTo(BigDecimal.ZERO) == 0) {
                    msg2 = String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\uff1a%1$s,\u5355\u636e\u4f53\u884c\u53f7\uff1a%2$s\u5355\u4ef7\u6570\u636e\u5f02\u5e38\u3002", (String)"PurOrderIsHasTaxPlugin_0", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), billNo, row.get("billentry.seq"));
                    errorInfo.add(this.getExpMsg(this.getClass().getSimpleName(), msg2, row.getLong("id"), row.getLong("billentry.id"), billNo));
                } else {
                    BigDecimal priceAndTax = row.getBigDecimal("billentry.priceandtax");
                    if (priceAndTax == null) continue;
                    BigDecimal calPrice = priceAndTax.divide(BigDecimalUtil.ONE.add(taxRate), settlePricePrecision, RoundingMode.HALF_UP);
                    if (price.compareTo(calPrice) != 0) {
                        msg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\uff1a%1$s,\u5355\u636e\u4f53\u884c\u53f7\uff1a%2$s\u5355\u4ef7\u6570\u636e\u5f02\u5e38\u3002", (String)"PurOrderIsHasTaxPlugin_0", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), billNo, row.get("billentry.seq"));
                        errorInfo.add(this.getExpMsg(this.getClass().getSimpleName(), msg, row.getLong("id"), row.getLong("billentry.id"), billNo));
                    }
                }
            }
            if (!Boolean.FALSE.equals(isTax) || !Boolean.FALSE.equals(isPresent)) continue;
            BigDecimal priceAndTax = row.getBigDecimal("billentry.priceandtax");
            taxRate = BigDecimalUtil.div100((BigDecimal)row.getBigDecimal("billentry.taxrate"));
            if (priceAndTax == null) continue;
            if (priceAndTax.compareTo(BigDecimal.ZERO) == 0) {
                msg2 = String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\uff1a%1$s,\u5355\u636e\u4f53\u884c\u53f7\uff1a%2$s\u542b\u7a0e\u5355\u4ef7\u6570\u636e\u5f02\u5e38\u3002", (String)"PurOrderIsHasTaxPlugin_1", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), billNo, row.get("billentry.seq"));
                errorInfo.add(this.getExpMsg(this.getClass().getSimpleName(), msg2, row.getLong("id"), row.getLong("billentry.id"), billNo));
                continue;
            }
            BigDecimal price = row.getBigDecimal("billentry.price");
            if (price == null || priceAndTax.compareTo(calPriceAndTax = price.multiply(BigDecimalUtil.ONE.add(taxRate)).setScale(settlePricePrecision, RoundingMode.HALF_UP)) == 0) continue;
            msg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\uff1a%1$s,\u5355\u636e\u4f53\u884c\u53f7\uff1a%2$s\u542b\u7a0e\u5355\u4ef7\u6570\u636e\u5f02\u5e38\u3002", (String)"PurOrderIsHasTaxPlugin_2", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), billNo, row.get("billentry.seq"));
            errorInfo.add(this.getExpMsg(this.getClass().getSimpleName(), msg, row.getLong("id"), row.getLong("billentry.id"), billNo));
        }
        return errorInfo;
    }
}

